/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.outline;

import com.aptana.ide.editor.html.parsing.nodes.HTMLElementNode;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.ParseNodeUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class HTMLLabelDecorator
implements ILabelDecorator {
    private static final Image SCRIPT_ICON = JaxerPlugin.getImage("icons/script.png");
    private static final Map<String, Image> ICONS;

    static {
        Image SCRIPT_SERVER_ICON = JaxerPlugin.getImage("icons/script-server.png");
        Image SCRIPT_BOTH_ICON = JaxerPlugin.getImage("icons/script-both.png");
        ICONS = new HashMap<String, Image>();
        ICONS.put("client", SCRIPT_ICON);
        ICONS.put("server-nocache", SCRIPT_SERVER_ICON);
        ICONS.put("server", SCRIPT_SERVER_ICON);
        ICONS.put("server-proxy", SCRIPT_SERVER_ICON);
        ICONS.put("both-nocache", SCRIPT_BOTH_ICON);
        ICONS.put("both", SCRIPT_BOTH_ICON);
        ICONS.put("both-proxy", SCRIPT_BOTH_ICON);
    }

    public Image decorateImage(Image image, Object element) {
        Image result = null;
        if (element instanceof HTMLElementNode) {
            HTMLElementNode scriptElement = (HTMLElementNode)element;
            String runat = ParseNodeUtils.getRunatValue(scriptElement);
            result = ICONS.containsKey(runat) ? ICONS.get(runat) : SCRIPT_ICON;
        }
        return result;
    }

    public String decorateText(String text, Object element) {
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

