/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.preferences;

import com.aptana.ide.editors.preferences.PreferenceMastHead;
import com.aptana.ide.editors.unified.colorizer.LanguageColorizer;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.preferences.Messages;
import com.aptana.ide.views.outline.UnifiedOutlineProvider;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JaxerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Composite displayArea;
    private PreferenceMastHead header;
    private Group editorColors;
    private Button enableJaxerColoring;
    private Button enableAdvancedColoring;
    private Label serverBackgroundLabel;
    private ColorSelector serverBackgroundColor;
    private Label bothBackgroundLabel;
    private ColorSelector bothBackgroundColor;
    private Label serverForegroundColorLabel;
    private ColorSelector serverForegroundColor;
    private Label bothForegroundColorLabel;
    private ColorSelector bothForegroundColor;
    private Label disablingJaxer;
    private Label nocacheForegroundStyleLabel;
    private Button nocacheForegroundItalic;
    private Button nocacheForegroundBold;
    private Label proxyForegroundStyleLabel;
    private Button proxyForegroundItalic;
    private Button proxyForegroundBold;

    protected Control createContents(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        final Composite buffer = new Composite(this.displayArea, 0);
        this.header = new PreferenceMastHead(buffer, Messages.JaxerPreferencePage_JaxerPreferences, 3, JaxerPlugin.getImageDescriptor("images/js_file.png"));
        buffer.setLayoutData((Object)new GridData(4, 4, true, false));
        buffer.setBackground(PreferenceMastHead.HEADER_BG_COLOR);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 10;
        this.displayArea.setLayout((Layout)layout);
        buffer.setLayout((Layout)layout);
        buffer.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = new GC((Drawable)buffer);
                gc.setBackground(PreferenceMastHead.FOOTER_BG_COLOR);
                if (buffer.getSize().y - 4 >= 0) {
                    gc.fillRectangle(0, buffer.getSize().y - 5, buffer.getSize().x, 5);
                }
            }
        });
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.disablingJaxer = new Label(this.displayArea, 16384);
        this.disablingJaxer.setText(Messages.JaxerPreferencePage_DisableJaxer);
        GridData enableData = new GridData(4, 4, true, false);
        enableData.verticalIndent = 10;
        enableData.horizontalIndent = 10;
        this.enableJaxerColoring = new Button(this.displayArea, 32);
        this.enableJaxerColoring.setText(Messages.JaxerPreferencePage_EnableJaxerColorizer);
        this.enableJaxerColoring.setLayoutData((Object)enableData);
        this.enableJaxerColoring.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JaxerPreferencePage.this.updateColorEnablement(JaxerPreferencePage.this.enableJaxerColoring.getSelection());
            }
        });
        boolean enabled = this.getPreferenceStore().getBoolean("com.aptana.ide.framework.jaxer.preferences.ENABLE_JAXER_COLORING");
        this.enableJaxerColoring.setSelection(enabled);
        this.editorColors = new Group(this.displayArea, 0);
        this.editorColors.setText(Messages.JaxerPreferencePage_EditorColorization);
        this.editorColors.setLayout((Layout)new GridLayout(2, false));
        GridData ecData = new GridData(4, 4, true, false);
        ecData.horizontalIndent = 30;
        ecData.verticalIndent = 5;
        this.editorColors.setLayoutData((Object)ecData);
        this.enableAdvancedColoring = new Button((Composite)this.editorColors, 32);
        this.enableAdvancedColoring.setText(Messages.JaxerPreferencePage_EnableAdvancedColoring);
        GridData eacData = new GridData(4, 4, true, false);
        eacData.horizontalSpan = 2;
        this.enableAdvancedColoring.setLayoutData((Object)eacData);
        this.enableAdvancedColoring.setSelection(this.getPreferenceStore().getBoolean("com.aptana.ide.framework.jaxer.preferences.ENABLE_ADVANCED_JAXER_COLORING"));
        this.serverBackgroundLabel = new Label((Composite)this.editorColors, 131072);
        this.serverBackgroundLabel.setText(Messages.JaxerPreferencePage_ServerBackgroundColor);
        this.serverBackgroundColor = new ColorSelector((Composite)this.editorColors);
        this.serverBackgroundColor.setColorValue(PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"com.aptana.ide.framework.jaxer.preferences.SERVER_BACKGROUND_COLOR"));
        this.serverForegroundColorLabel = new Label((Composite)this.editorColors, 131072);
        this.serverForegroundColorLabel.setText(Messages.JaxerPreferencePage_ServerForegroundColor);
        this.serverForegroundColor = new ColorSelector((Composite)this.editorColors);
        this.serverForegroundColor.setColorValue(PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"com.aptana.ide.framework.jaxer.preferences.SERVER_FOREGROUND_COLOR"));
        this.bothBackgroundLabel = new Label((Composite)this.editorColors, 131072);
        this.bothBackgroundLabel.setText(Messages.JaxerPreferencePage_BothBackgroundColor);
        this.bothBackgroundColor = new ColorSelector((Composite)this.editorColors);
        this.bothBackgroundColor.setColorValue(PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"com.aptana.ide.framework.jaxer.preferences.BOTH_BACKGROUND_COLOR"));
        this.bothForegroundColorLabel = new Label((Composite)this.editorColors, 131072);
        this.bothForegroundColorLabel.setText(Messages.JaxerPreferencePage_BothForegroundColor);
        this.bothForegroundColor = new ColorSelector((Composite)this.editorColors);
        this.bothForegroundColor.setColorValue(PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"com.aptana.ide.framework.jaxer.preferences.BOTH_FOREGROUND_COLOR"));
        this.nocacheForegroundStyleLabel = new Label((Composite)this.editorColors, 131072);
        this.nocacheForegroundStyleLabel.setText(Messages.JaxerPreferencePage_NocacheForegroundStyle);
        Composite serverStyleButtons = new Composite((Composite)this.editorColors, 0);
        serverStyleButtons.setLayout((Layout)new GridLayout(2, false));
        serverStyleButtons.setLayoutData((Object)new GridData(4, 4, true, false));
        int nocacheStyle = this.getPreferenceStore().getInt("com.aptana.ide.framework.jaxer.preferences.NO_CACHE_FOREGROUND_STYLE");
        this.nocacheForegroundBold = new Button(serverStyleButtons, 32);
        this.nocacheForegroundBold.setText(Messages.JaxerPreferencePage_Bold);
        this.nocacheForegroundBold.setSelection((nocacheStyle & 1) != 0);
        this.nocacheForegroundItalic = new Button(serverStyleButtons, 32);
        this.nocacheForegroundItalic.setText(Messages.JaxerPreferencePage_Italic);
        this.nocacheForegroundItalic.setSelection((nocacheStyle & 2) != 0);
        this.proxyForegroundStyleLabel = new Label((Composite)this.editorColors, 131072);
        this.proxyForegroundStyleLabel.setText(Messages.JaxerPreferencePage_ProxyForegroundStyle);
        Composite bothStyleButtons = new Composite((Composite)this.editorColors, 0);
        bothStyleButtons.setLayout((Layout)new GridLayout(2, false));
        bothStyleButtons.setLayoutData((Object)new GridData(4, 4, true, false));
        int proxyStyle = this.getPreferenceStore().getInt("com.aptana.ide.framework.jaxer.preferences.PROXY_FOREGROUND_STYLE");
        this.proxyForegroundBold = new Button(bothStyleButtons, 32);
        this.proxyForegroundBold.setText(Messages.JaxerPreferencePage_Bold);
        this.proxyForegroundBold.setSelection((proxyStyle & 1) != 0);
        this.proxyForegroundItalic = new Button(bothStyleButtons, 32);
        this.proxyForegroundItalic.setText(Messages.JaxerPreferencePage_Italic);
        this.proxyForegroundItalic.setSelection((proxyStyle & 2) != 0);
        this.updateColorEnablement(enabled);
        return this.displayArea;
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("com.aptana.ide.framework.jaxer.preferences.ENABLE_JAXER_COLORING", this.enableJaxerColoring.getSelection());
        if (this.enableJaxerColoring.getSelection()) {
            this.getPreferenceStore().setValue("com.aptana.ide.framework.jaxer.preferences.ENABLE_ADVANCED_JAXER_COLORING", this.enableAdvancedColoring.getSelection());
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)"com.aptana.ide.framework.jaxer.preferences.SERVER_BACKGROUND_COLOR", (RGB)this.serverBackgroundColor.getColorValue());
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)"com.aptana.ide.framework.jaxer.preferences.BOTH_BACKGROUND_COLOR", (RGB)this.bothBackgroundColor.getColorValue());
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)"com.aptana.ide.framework.jaxer.preferences.BOTH_FOREGROUND_COLOR", (RGB)this.bothForegroundColor.getColorValue());
            PreferenceConverter.setValue((IPreferenceStore)this.getPreferenceStore(), (String)"com.aptana.ide.framework.jaxer.preferences.SERVER_FOREGROUND_COLOR", (RGB)this.serverForegroundColor.getColorValue());
            int nocacheStyle = 0;
            if (this.nocacheForegroundBold.getSelection()) {
                nocacheStyle |= 1;
            }
            if (this.nocacheForegroundItalic.getSelection()) {
                nocacheStyle |= 2;
            }
            this.getPreferenceStore().setValue("com.aptana.ide.framework.jaxer.preferences.NO_CACHE_FOREGROUND_STYLE", nocacheStyle);
            int proxyStyle = 0;
            if (this.proxyForegroundBold.getSelection()) {
                proxyStyle |= 1;
            }
            if (this.proxyForegroundItalic.getSelection()) {
                proxyStyle |= 2;
            }
            this.getPreferenceStore().setValue("com.aptana.ide.framework.jaxer.preferences.PROXY_FOREGROUND_STYLE", proxyStyle);
        }
        LanguageColorizer.fireColorizationEvent();
        UnifiedOutlineProvider.getInstance().refresh();
        return super.performOk();
    }

    private void updateColorEnablement(boolean enabled) {
        this.serverForegroundColor.setEnabled(enabled);
        this.serverBackgroundColor.setEnabled(enabled);
        this.bothBackgroundColor.setEnabled(enabled);
        this.bothForegroundColor.setEnabled(enabled);
        this.nocacheForegroundBold.setEnabled(enabled);
        this.nocacheForegroundItalic.setEnabled(enabled);
        this.proxyForegroundBold.setEnabled(enabled);
        this.proxyForegroundItalic.setEnabled(enabled);
        this.enableAdvancedColoring.setEnabled(enabled);
    }

    protected void performDefaults() {
        this.serverBackgroundColor.setColorValue(PreferenceConverter.getDefaultColor((IPreferenceStore)this.getPreferenceStore(), (String)"com.aptana.ide.framework.jaxer.preferences.SERVER_BACKGROUND_COLOR"));
        this.bothBackgroundColor.setColorValue(PreferenceConverter.getDefaultColor((IPreferenceStore)this.getPreferenceStore(), (String)"com.aptana.ide.framework.jaxer.preferences.BOTH_BACKGROUND_COLOR"));
        this.serverForegroundColor.setColorValue(PreferenceConverter.getDefaultColor((IPreferenceStore)this.getPreferenceStore(), (String)"com.aptana.ide.framework.jaxer.preferences.SERVER_FOREGROUND_COLOR"));
        this.bothForegroundColor.setColorValue(PreferenceConverter.getDefaultColor((IPreferenceStore)this.getPreferenceStore(), (String)"com.aptana.ide.framework.jaxer.preferences.BOTH_FOREGROUND_COLOR"));
        int nocacheStyle = this.getPreferenceStore().getDefaultInt("com.aptana.ide.framework.jaxer.preferences.NO_CACHE_FOREGROUND_STYLE");
        this.nocacheForegroundBold.setSelection((nocacheStyle & 1) != 0);
        this.nocacheForegroundItalic.setSelection((nocacheStyle & 2) != 0);
        int proxyStyle = this.getPreferenceStore().getDefaultInt("com.aptana.ide.framework.jaxer.preferences.PROXY_FOREGROUND_STYLE");
        this.proxyForegroundBold.setSelection((proxyStyle & 1) != 0);
        this.proxyForegroundItalic.setSelection((proxyStyle & 2) != 0);
        this.enableAdvancedColoring.setSelection(this.getPreferenceStore().getDefaultBoolean("com.aptana.ide.framework.jaxer.preferences.ENABLE_ADVANCED_JAXER_COLORING"));
        this.enableJaxerColoring.setSelection(this.getPreferenceStore().getDefaultBoolean("com.aptana.ide.framework.jaxer.preferences.ENABLE_JAXER_COLORING"));
        this.updateColorEnablement(this.enableJaxerColoring.getSelection());
    }

    public void setVisible(boolean visible) {
        if (this.header != null) {
            this.header.setVisible(visible);
        }
        super.setVisible(visible);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(JaxerPlugin.getDefault().getPreferenceStore());
    }
}

