/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.project;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.project.Messages;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class JaxerIgnorePropertyPage
extends PropertyPage {
    public static final String JAXER_INCLUDE = "jaxer-include";
    public static final String IGNORE_FILES = "com.aptana.ide.framework.jaxer.project.IGNORE_FILES";
    public static final String IGNORE_DELIMITER = "___IGNORE___";
    private IProject project;
    private ContainerCheckedTreeViewer projectFilesViewer;
    private ITreeContentProvider contentProvider = new ITreeContentProvider(){

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IProject) {
                try {
                    return ((IProject)inputElement).members();
                }
                catch (CoreException coreException) {}
            }
            return new Object[0];
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object getParent(Object element) {
            if (element instanceof IResource) {
                return ((IResource)element).getParent();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IFolder) {
                try {
                    return ((IFolder)parentElement).members();
                }
                catch (CoreException coreException) {}
            }
            return new Object[0];
        }
    };

    protected Control createContents(Composite parent) {
        Tree tree;
        Composite displayArea;
        block11: {
            displayArea = new Composite(parent, 0);
            GridLayout daLayout = new GridLayout();
            daLayout.marginHeight = 0;
            daLayout.marginWidth = 0;
            displayArea.setLayout((Layout)daLayout);
            GridData daData = new GridData(4, 4, true, true);
            displayArea.setLayoutData((Object)daData);
            Label description = new Label(displayArea, 16448);
            description.setLayoutData((Object)new GridData(4, 4, true, false));
            description.setText(Messages.JaxerIgnorePropertyPage_SelectFilesAndFoldersToIgnore);
            Label noteLabel = new Label(displayArea, 16384);
            noteLabel.setLayoutData((Object)new GridData(4, 4, true, false));
            noteLabel.setText(Messages.JaxerIgnorePropertyPage_NoteJaxerInclude);
            Label note1 = new Label(displayArea, 16448);
            note1.setLayoutData((Object)new GridData(4, 4, true, false));
            note1.setText("  " + Messages.JaxerIgnorePropertyPage_Note1);
            Label note2 = new Label(displayArea, 16448);
            note2.setLayoutData((Object)new GridData(4, 4, true, false));
            note2.setText("  " + Messages.JaxerIgnorePropertyPage_Note2);
            this.projectFilesViewer = new ContainerCheckedTreeViewer(displayArea, 2084);
            this.projectFilesViewer.setContentProvider((IContentProvider)this.contentProvider);
            this.projectFilesViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), JaxerPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
            this.projectFilesViewer.setAutoExpandLevel(2);
            this.project = (IProject)this.getElement();
            this.projectFilesViewer.setInput((Object)this.project);
            tree = this.projectFilesViewer.getTree();
            tree.setLayoutData((Object)new GridData(4, 4, true, true));
            try {
                String ignores = this.project.getPersistentProperty(new QualifiedName("", IGNORE_FILES));
                if (ignores == null) break block11;
                String[] splits = ignores.split(IGNORE_DELIMITER);
                int i = 0;
                while (i < splits.length) {
                    try {
                        IFolder folder = this.project.getFolder((IPath)new Path(splits[i]));
                        if (folder.exists()) {
                            this.projectFilesViewer.setChecked((Object)folder, true);
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        IFile candidate = this.project.getFile((IPath)new Path(splits[i]));
                        if (candidate.exists()) {
                            this.projectFilesViewer.setChecked((Object)candidate, true);
                        }
                    }
                    catch (Exception exception) {}
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
        this.checkJaxerIncludeFolders();
        this.projectFilesViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                JaxerIgnorePropertyPage.this.checkJaxerIncludeFolders();
            }
        });
        if (tree.getItemCount() > 0) {
            tree.showItem(tree.getItem(0));
        }
        if (tree.getColumnCount() > 0) {
            tree.showColumn(tree.getColumn(0));
        }
        return displayArea;
    }

    private void checkJaxerIncludeFolders() {
        TreeItem[] items = this.projectFilesViewer.getTree().getItems();
        int i = 0;
        while (i < items.length) {
            IFolder folder;
            if (items[i].getData() != null && items[i].getData() instanceof IFolder && (folder = (IFolder)items[i].getData()).getName().equals(JAXER_INCLUDE)) {
                this.projectFilesViewer.setChecked((Object)folder, true);
            }
            ++i;
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.projectFilesViewer.setAllChecked(false);
        this.checkJaxerIncludeFolders();
    }

    public boolean performOk() {
        Object[] resources = this.projectFilesViewer.getCheckedElements();
        ArrayList<IResource> folders = new ArrayList<IResource>();
        StringBuilder list = new StringBuilder();
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof IResource && !this.projectFilesViewer.getGrayed(resources[i])) {
                IFolder folder;
                int f;
                boolean inAlready;
                IResource resource = (IResource)resources[i];
                if (resource instanceof IFolder) {
                    inAlready = false;
                    f = 0;
                    while (f < folders.size()) {
                        folder = (IFolder)folders.get(f);
                        if (resource.getParent().equals((Object)folder)) {
                            inAlready = true;
                            break;
                        }
                        ++f;
                    }
                    folders.add(resource);
                    if (!inAlready) {
                        list.append(resource.getProjectRelativePath().toString());
                        list.append(IGNORE_DELIMITER);
                    }
                } else if (resource instanceof IFile) {
                    inAlready = false;
                    f = 0;
                    while (f < folders.size()) {
                        folder = (IFolder)folders.get(f);
                        if (resource.getParent().equals((Object)folder)) {
                            inAlready = true;
                            break;
                        }
                        ++f;
                    }
                    if (!inAlready) {
                        list.append(resource.getProjectRelativePath().toString());
                        list.append(IGNORE_DELIMITER);
                    }
                }
            }
            ++i;
        }
        try {
            this.project.setPersistentProperty(new QualifiedName("", IGNORE_FILES), list.toString());
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Error saving jaxer ignore file list", (Throwable)e);
        }
        return super.performOk();
    }
}

