/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.server;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.server.JaxerManagerJob;
import com.aptana.ide.framework.jaxer.server.Messages;
import com.aptana.ide.framework.jaxer.server.dialogs.JaxerStatisticsDialog;
import com.aptana.ide.framework.jaxer.server.manager.BaseCommand;
import com.aptana.ide.framework.jaxer.server.manager.ICommand;
import com.aptana.ide.framework.jaxer.server.manager.IManagerListener;
import com.aptana.ide.framework.jaxer.server.manager.JaxerManager;
import com.aptana.ide.framework.jaxer.server.manager.ServerManager;
import com.aptana.ide.framework.jaxer.views.console.JaxerConsoleView;
import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.IModule;
import com.aptana.ide.server.core.IOperationListener;
import com.aptana.ide.server.core.IPausableServer;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerManagerListener;
import com.aptana.ide.server.core.IServerType;
import com.aptana.ide.server.core.ServerManagerEvent;
import com.aptana.ide.server.core.impl.Configuration;
import com.aptana.ide.server.core.impl.servers.AbstractServer;
import com.aptana.ide.server.ui.views.actions.ICanOpenConsole;
import com.aptana.jaxer.connectors.servlet.interfaces.IStatisticsProvider;
import java.io.File;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class JaxerServer
extends AbstractServer
implements IManagerListener,
IPausableServer {
    private IAbstractConfiguration configuration;
    private JaxerManager jaxerManager;
    private JaxerManagerJob managerJob;
    private String hostname;
    private int adminPort;
    private int webPort;
    private int minProcesses;
    private int maxProcesses;
    private int timeout;
    private boolean isLocal;
    private boolean useTraceLogging;
    private String path;
    private String jettyServerName;
    private long lastHeartbeat = -1L;
    private String extensionsDirectory;
    private String dataDirectory;
    private String configDirectory;
    private String configFile;
    private String configRoutesFile;
    private String configLogFile;
    private String tempDirectory;
    private String jaxerManagerCfg;
    private int requestsFromJaxer;
    private int requestsToJaxer;
    private int callbacksMade;
    private String[] configs = new String[0];
    private boolean processStop = false;

    public IStatus canDelete() {
        if (this.getId().equals("jaxerInternalServer")) {
            return new Status(4, "com.aptana.ide.server.jetty", 4, Messages.JaxerServer_InternalServersCantBeDeleted, null);
        }
        return super.canDelete();
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public JaxerServer(IServerType type, IAbstractConfiguration configuration) {
        super(type, configuration);
        this.configuration = configuration;
        com.aptana.ide.server.core.impl.servers.ServerManager.getInstance().addServerManagerListener(new IServerManagerListener(){

            public void serversChanged(ServerManagerEvent event) {
                if (event.getKind() == 1 && event.getServer() == JaxerServer.this && JaxerServer.this.jaxerManager != null) {
                    JaxerServer.this.jaxerManager.stopHeartbeating();
                    com.aptana.ide.server.core.impl.servers.ServerManager.getInstance().removeServerManagerListener((IServerManagerListener)this);
                }
            }
        });
    }

    public JaxerServer(IServerType type, int state, IAbstractConfiguration configuration) {
        this(type, configuration);
        this.setServerState(state);
    }

    protected IStatus restart(String mode, IProgressMonitor monitor) {
        IStatus status = null;
        if (this.isLocal) {
            status = this.stop(true, monitor);
            if (status == Status.OK_STATUS) {
                this.serverChanged();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    IdeLog.log((Plugin)JaxerPlugin.getDefault(), (int)2, (String)"interrupted while sleeping", (Throwable)e);
                }
                status = this.start(mode, monitor);
            }
        } else {
            try {
                if (this.configuration != null) {
                    BaseCommand cmd = new BaseCommand("restart");
                    ServerManager.getInstance().runCommand(this.jaxerManager, cmd, 10000, false, true);
                    if (this.isResponseOk(cmd.getResponse())) {
                        this.setServerState(2);
                    } else {
                        this.setServerState(4);
                    }
                    this.serverChanged();
                    status = Status.OK_STATUS;
                }
            }
            catch (Exception e) {
                status = new Status(4, "com.aptana.ide.server.jetty", 4, e.getMessage(), (Throwable)e);
            }
        }
        return status;
    }

    public synchronized IStatus canRestart(String mode) {
        if (!this.isLocal) {
            return new Status(4, "com.aptana.ide.server", 4, Messages.JaxerServer_OnlyLocalJaxersCanBeRestarted, null);
        }
        if (this.getServerState() == 5) {
            return Status.OK_STATUS;
        }
        return super.canRestart(mode);
    }

    public synchronized IStatus canStop() {
        if (this.getServerState() == 5) {
            return Status.OK_STATUS;
        }
        return super.canStop();
    }

    protected void showConnectionCouldNotBeEstablished() {
        UIJob dialog = new UIJob(Messages.JaxerServer_HeartbeatFailed){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                MessageDialog.openError((Shell)this.getDisplay().getActiveShell(), (String)StringUtils.format((String)Messages.JaxerServer_ConnectionFailedTitle, (String)JaxerServer.this.getName()), (String)StringUtils.format((String)Messages.JaxerServer_ConnectionFailedMessage, (Object[])new String[]{JaxerServer.this.getName(), JaxerServer.this.getHost()}));
                return Status.OK_STATUS;
            }
        };
        dialog.schedule();
    }

    public void start() throws Exception {
        if (this.isLocal) {
            if (this.managerJob != null) {
                if (this.jaxerManager != null) {
                    this.jaxerManager.stopHeartbeating();
                }
                this.managerJob.stop();
                this.managerJob = null;
            }
            this.setServerState(1);
            this.serverChanged();
            this.managerJob = new JaxerManagerJob(this.path, this.getName(), this.adminPort, this.webPort, this, this.getConfigOptions(), this.getLogFilePath().toFile().getAbsolutePath(), this.getTempDirectory(), this.minProcesses, this.maxProcesses, this.timeout, this.useTraceLogging);
            this.managerJob.setCfgFilePath(this.getJaxerManagerCfg());
            this.managerJob.start();
        }
    }

    protected IStatus start(String mode, IProgressMonitor monitor) {
        try {
            this.start();
        }
        catch (Exception e) {
            return new Status(4, "com.aptana.ide.server.jetty", 4, e.getMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    protected IStatus stop(boolean force, IProgressMonitor monitor) {
        try {
            if (this.configuration != null) {
                this.processStop = true;
                if (!this.isLocal) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            JaxerServer.this.processStop = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.JaxerServer_ConfirmStoppingRemoteJaxerTitle, (String)Messages.JaxerServer_ConfirmStoppingRemoteJaxerMessage);
                        }
                    });
                }
                if (this.processStop) {
                    if (this.jaxerManager != null) {
                        if (this.isLocal) {
                            this.jaxerManager.stopHeartbeating();
                        }
                        BaseCommand cmd = new BaseCommand("exit");
                        ServerManager.getInstance().runCommand(this.jaxerManager, cmd, 10000, false, true);
                        this.setServerState(3);
                        if (this.isLocal && (this.isResponseOk(cmd.getResponse()) || 1 == cmd.getStatus() || cmd.getStatus() == 0)) {
                            this.setServerState(4);
                            this.managerJob = null;
                        }
                    } else if (this.isLocal) {
                        this.setServerState(4);
                        this.managerJob = null;
                    }
                }
            }
        }
        catch (Exception e) {
            return new Status(4, "com.aptana.ide.server.jetty", 4, e.getMessage() != null ? e.getMessage() : Messages.JaxerServer_ERROR_STOPPING_JAXER, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public void storeConfiguration(IAbstractConfiguration config) {
        config.setBooleanAttribute("JAXER_IS_LOCAL_SERVER_KEY", this.isLocal);
        config.setStringAttribute("JAXER_SERVER_REMOTE_HOSTNAME_KEY", this.hostname);
        config.setStringAttribute("JAXER_JETTY_ASSOCIATION", this.jettyServerName);
        config.setIntAttribute("JAXER_SERVER_ADMIN_PORT_KEY", this.adminPort);
        config.setIntAttribute("JAXER_SERVER_WEB_PORT_KEY", this.webPort);
        if (this.isLocal) {
            config.setIntAttribute("JAXER_MIN_PROCESSES", this.minProcesses);
            config.setIntAttribute("JAXER_MAX_PROCESSES", this.maxProcesses);
            config.setIntAttribute("JAXER_TIMEOUT", this.timeout);
            config.setStringAttribute("JAXER_SERVER_LOCAL_PATH_KEY", this.path);
            config.setIntAttribute("JAXER_REQUEST_FROM_WEB_SERVER", this.requestsToJaxer);
            config.setIntAttribute("JAXER_REQUEST_TO_WEB_SERVER", this.requestsFromJaxer);
            config.setIntAttribute("JAXER_CALLBACK_TO_WEB_SERVER", this.callbacksMade);
            config.setBooleanAttribute("VERBOSE_LOGGING", this.useTraceLogging);
        }
        super.storeConfiguration(config);
    }

    protected void installConfig(IAbstractConfiguration configuration) {
        this.hostname = configuration.getStringAttribute("JAXER_SERVER_REMOTE_HOSTNAME_KEY");
        this.isLocal = configuration.getBooleanAttribute("JAXER_IS_LOCAL_SERVER_KEY");
        this.jettyServerName = configuration.getStringAttribute("JAXER_JETTY_ASSOCIATION");
        this.adminPort = configuration.getIntAttribute("JAXER_SERVER_ADMIN_PORT_KEY");
        this.webPort = configuration.getIntAttribute("JAXER_SERVER_WEB_PORT_KEY");
        this.minProcesses = configuration.getIntAttribute("JAXER_MIN_PROCESSES");
        this.maxProcesses = configuration.getIntAttribute("JAXER_MAX_PROCESSES");
        this.timeout = configuration.getIntAttribute("JAXER_TIMEOUT");
        this.useTraceLogging = configuration.getBooleanAttribute("VERBOSE_LOGGING");
        this.requestsFromJaxer = configuration.getIntAttribute("JAXER_REQUEST_TO_WEB_SERVER");
        this.requestsToJaxer = configuration.getIntAttribute("JAXER_REQUEST_FROM_WEB_SERVER");
        this.callbacksMade = configuration.getIntAttribute("JAXER_CALLBACK_TO_WEB_SERVER");
        if (this.jaxerManager != null) {
            this.jaxerManager.stopHeartbeating();
            this.jaxerManager.removeListener(this);
            this.jaxerManager = null;
        }
        this.jaxerManager = new JaxerManager(this.hostname, this.adminPort);
        this.jaxerManager.addListener(this);
        if (this.managerJob != null) {
            this.managerJob.stop();
            this.managerJob = null;
        }
        if (this.isLocal) {
            this.path = configuration.getStringAttribute("JAXER_SERVER_LOCAL_PATH_KEY");
        } else {
            if (!this.jaxerManager.isHeartbeating()) {
                this.jaxerManager.enableHeartbeating();
                ServerManager.getInstance().addHeartbeat(this.jaxerManager, 10000, 10000);
            }
            this.setServerState(0);
        }
        if (this.jettyServerName != null && this.jettyServerName.length() > 0) {
            this.restartAssociation(configuration);
        }
        super.installConfig(configuration);
    }

    protected void setStatisticsForAssociation(IStatisticsProvider provider) {
    }

    protected void restartAssociation(final IAbstractConfiguration config) {
        Job restartJob = new Job(Messages.JaxerServer_RestartAssotiatedServer){

            protected IStatus run(IProgressMonitor monitor) {
                IServer[] servers;
                IServer[] iServerArray = servers = com.aptana.ide.server.core.impl.servers.ServerManager.getInstance().getServers();
                int n = 0;
                int n2 = iServerArray.length;
                while (n < n2) {
                    Configuration cf;
                    IServer s = iServerArray[n];
                    if (JaxerServer.this.jettyServerName.equals(s.getName())) {
                        cf = new Configuration();
                        s.storeConfiguration((IAbstractConfiguration)cf);
                        cf.setStringAttribute("type", s.getServerType().getId());
                        cf.setStringAttribute("association_id", config.getStringAttribute("id"));
                        try {
                            s.reconfigure((IAbstractConfiguration)cf);
                            if (s.getServerState() == 2 || s.getServerState() == 1) {
                                s.restart("run", null, null);
                            }
                            if (s instanceof IStatisticsProvider) {
                                JaxerServer.this.setStatisticsForAssociation((IStatisticsProvider)s);
                            }
                        }
                        catch (CoreException coreException) {}
                    } else {
                        cf = new Configuration();
                        s.storeConfiguration((IAbstractConfiguration)cf);
                        String id = cf.getStringAttribute("association_id");
                        if (config.getStringAttribute("id").equals(id)) {
                            cf.setStringAttribute("association_id", "");
                            try {
                                s.reconfigure((IAbstractConfiguration)cf);
                                if (s.getServerState() == 2 || s.getServerState() == 1) {
                                    s.restart("run", null, null);
                                }
                            }
                            catch (CoreException coreException) {}
                        }
                    }
                    ++n;
                }
                return Status.OK_STATUS;
            }
        };
        restartJob.setPriority(20);
        restartJob.setSystem(true);
        restartJob.schedule();
    }

    public String getJettyServerName() {
        return this.jettyServerName;
    }

    public IStatus canHaveModule(IModule module) {
        return null;
    }

    public String getConfigurationDescription() {
        return "";
    }

    protected IPath getDefaultLogPath() {
        if (this.isLocal()) {
            File pathToJaxer = new File(this.path);
            File upOneLevel = pathToJaxer.getParentFile();
            File logs = new File(upOneLevel, "logs");
            return new Path(new File(logs, "jaxer.log").getAbsolutePath());
        }
        return null;
    }

    public String getHost() {
        return String.valueOf(this.hostname) + ":" + this.adminPort;
    }

    public String getConsoleAddress() {
        IServer[] servers;
        String host = null;
        IServer[] iServerArray = servers = ServerCore.getServerManager().getServers();
        int n = 0;
        int n2 = iServerArray.length;
        while (n < n2) {
            IServer[] associations;
            IServer server = iServerArray[n];
            IServer[] iServerArray2 = associations = server.getAssociatedServers();
            int n3 = 0;
            int n4 = iServerArray2.length;
            while (n3 < n4) {
                IServer association = iServerArray2[n3];
                if (this == association && server.isWebServer()) {
                    host = server.getHost();
                    break;
                }
                ++n3;
            }
            ++n;
        }
        if (host != null) {
            return "http://" + host + "/aptana/tools/shell-studio/index.html";
        }
        return null;
    }

    public void commandCompleted(ICommand command) {
    }

    public synchronized void heartbeatFailed(String response) {
        if (this.isLocal && (this.managerJob == null || !this.managerJob.isEnded())) {
            if (this.jaxerManager != null) {
                this.jaxerManager.stopHeartbeating();
            }
            UIJob dialog = new UIJob(Messages.JaxerServer_HeartbeatFailed){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    MessageDialog.openError((Shell)this.getDisplay().getActiveShell(), (String)StringUtils.format((String)Messages.JaxerServer_ConnectionLostTitle, (String)JaxerServer.this.getName()), (String)StringUtils.format((String)Messages.JaxerServer_ConnectionLostMessage, (Object[])new String[]{JaxerServer.this.getName(), JaxerServer.this.getHost()}));
                    return Status.OK_STATUS;
                }
            };
            dialog.schedule();
        }
        if (this.managerJob != null && !this.managerJob.isRunning()) {
            IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Forcibly stopping JaxerManager due to heartbeat failure");
            this.managerJob.stop();
            this.managerJob = null;
        }
        if (!this.isLocal) {
            this.setServerState(0);
            this.serverChanged();
        }
    }

    public synchronized IStatus canStart(String launchMode) {
        if (!this.isLocal) {
            return new Status(4, "com.aptana.ide.server", 4, Messages.JaxerServer_OnlyLocalJaxerServersCanBeStarted, null);
        }
        if (this.path == null || this.path.length() == 0) {
            return new Status(4, "com.aptana.ide.server", 4, Messages.JaxerServer_ServerPathIsNotSpecified, null);
        }
        if (this.getServerState() == 0) {
            return this.getServerType().supportsLaunchMode(launchMode) ? Status.OK_STATUS : new Status(4, "com.aptana.ide.server", 4, StringUtils.format((String)SERVER_DOES_NOT_SUPPORTS_STARTING_IN_MODE, (Object[])new Object[]{this.getName(), launchMode}), null);
        }
        return super.canStart(launchMode);
    }

    private boolean isResponseOk(String response) {
        int lastSpace;
        boolean ok = false;
        if (response != null && (lastSpace = (response = response.trim()).lastIndexOf(32)) > -1 && lastSpace + 1 < response.length() && "ok".equals(response = response.substring(lastSpace + 1))) {
            ok = true;
        }
        return ok;
    }

    public synchronized void heartbeatSucceeded(String response) {
        if (response != null) {
            this.lastHeartbeat = System.currentTimeMillis();
            int lastSpace = (response = response.trim()).lastIndexOf(32);
            if (lastSpace > -1 && lastSpace + 1 < response.length()) {
                response = response.substring(lastSpace + 1);
                int currentState = this.getServerState();
                boolean isLocal = this.configuration.getBooleanAttribute("JAXER_IS_LOCAL_SERVER_KEY");
                boolean shouldUpdate = true;
                if (isLocal) {
                    boolean bl = shouldUpdate = this.managerJob != null && this.managerJob.isRunning();
                }
                if (shouldUpdate) {
                    if ("running".equals(response) && currentState != 2) {
                        this.setServerState(2);
                        this.serverChanged();
                    } else if ("paused".equals(response) && currentState != 5) {
                        this.setServerState(5);
                        this.serverChanged();
                    }
                }
            }
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.webPort;
    }

    public IPath getDocumentRoot() {
        return null;
    }

    public IStatus canPause() {
        if (this.getServerState() == 0) {
            return new Status(4, "com.aptana.ide.server", 4, Messages.JaxerServer_UnknownStateCanNotBePaused, null);
        }
        if (this.getServerState() == 4 || this.getServerState() == 3) {
            return new Status(4, "com.aptana.ide.server", 4, Messages.JaxerServer_StoppedServerCantBePaused, null);
        }
        return Status.OK_STATUS;
    }

    public IStatus canResume() {
        return Status.OK_STATUS;
    }

    public void pause(IOperationListener listener, IProgressMonitor monitor) {
        try {
            if (this.configuration != null) {
                BaseCommand cmd = new BaseCommand("pause");
                ServerManager.getInstance().runCommand(this.jaxerManager, cmd, 10000, false, true);
                if (this.isResponseOk(cmd.getResponse())) {
                    this.setServerState(5);
                    this.serverChanged();
                }
            }
        }
        catch (Exception exception) {}
    }

    public void resume(IOperationListener listener, IProgressMonitor monitor) {
        try {
            if (this.configuration != null) {
                BaseCommand cmd = new BaseCommand("resume");
                ServerManager.getInstance().runCommand(this.jaxerManager, cmd, 10000, false, true);
                if (this.isResponseOk(cmd.getResponse())) {
                    this.setServerState(2);
                    this.serverChanged();
                }
            }
        }
        catch (Exception exception) {}
    }

    public void localJaxerCreated() {
        if (!this.jaxerManager.isHeartbeating() && this.managerJob != null && this.managerJob.isRunning()) {
            this.jaxerManager.enableHeartbeating();
            ServerManager.getInstance().addHeartbeat(this.jaxerManager, 10000, 5000);
        } else if (!this.managerJob.isRunning()) {
            this.managerJob = null;
        }
    }

    public void localJaxerFailed(Exception e) {
        if (this.jaxerManager != null && this.jaxerManager.isHeartbeating()) {
            this.jaxerManager.stopHeartbeating();
        }
        this.managerJob = null;
        this.setServerState(4);
        this.serverChanged();
    }

    public boolean suppliesStatistics() {
        return this.suppliesStatisticsInterface();
    }

    private String getLastHeartbeatMessage() {
        if (this.lastHeartbeat != -1L) {
            DateFormat df = DateFormat.getDateTimeInstance(1, 1);
            Calendar expirationCal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            expirationCal.setTimeInMillis(this.lastHeartbeat);
            return df.format(expirationCal.getTime());
        }
        return null;
    }

    public void showStatisticsInterface() {
        String minString = this.isLocal ? Integer.toString(this.minProcesses) : null;
        String maxString = this.isLocal ? Integer.toString(this.maxProcesses) : null;
        String toString = this.isLocal ? Integer.toString(this.timeout) : null;
        String fromJaxerString = this.isLocal ? Integer.toString(this.requestsFromJaxer) : null;
        String toJaxerString = this.isLocal ? Integer.toString(this.requestsToJaxer) : null;
        String callbackString = this.isLocal ? Integer.toString(this.callbacksMade) : null;
        IPath logFilePath = this.getLogFilePath();
        String logString = this.isLocal ? (logFilePath != null ? logFilePath.toOSString() : null) : null;
        JaxerStatisticsDialog dialog = new JaxerStatisticsDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), this.extensionsDirectory, this.configDirectory, this.dataDirectory, logString, StringUtils.format((String)Messages.JaxerServer_Statistics, (String)this.getName()), this.getLastHeartbeatMessage(), this.getVersionNumberMessage(), minString, maxString, toString, fromJaxerString, toJaxerString, callbackString);
        dialog.setJaxerServer(this);
        dialog.open();
    }

    public boolean suppliesStatisticsInterface() {
        if (this.isLocal) {
            return true;
        }
        return this.getVersionNumberMessage() != null || this.getLastHeartbeatMessage() != null;
    }

    private String getVersionNumberMessage() {
        String version = null;
        if (this.getServerState() == 2) {
            String newStats;
            BaseCommand cmd = new BaseCommand("get version");
            ServerManager.getInstance().runCommand(this.jaxerManager, cmd, 10000, false, true);
            if (cmd.getStatus() == 2 && (newStats = cmd.getResponse()) != null) {
                version = newStats.substring(newStats.lastIndexOf(32) + 1);
            }
        }
        if (this.isLocal) {
            try {
                File versionFile = new File(this.path, "version.txt");
                if (versionFile.exists()) {
                    String wholeVersion = FileUtils.readContent((File)versionFile);
                    int firstQuote = wholeVersion.indexOf(34) + 1;
                    int lastQuote = wholeVersion.lastIndexOf(34);
                    if (firstQuote > -1 && lastQuote > -1 && firstQuote < wholeVersion.length()) {
                        version = wholeVersion.substring(firstQuote, lastQuote);
                    }
                }
            }
            catch (Exception e) {
                IdeLog.logInfo((Plugin)JaxerPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
            }
        }
        return version;
    }

    public void setConfigOptions(String[] options) {
        this.configs = options;
    }

    public String[] getConfigOptions() {
        return this.configs;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ICanOpenConsole.class) {
            return new ICanOpenConsole(){

                public void openConsole() {
                    try {
                        JaxerConsoleView vv = (JaxerConsoleView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.aptana.ide.framework.jaxer.interactiveConsole");
                        vv.connectToServer(JaxerServer.this);
                    }
                    catch (PartInitException e) {
                        IdeLog.logError((Plugin)JaxerPlugin.getDefault(), (String)"Error while opening console", (Throwable)e);
                    }
                }
            };
        }
        return super.getAdapter(adapter);
    }

    public String getConfigDirectory() {
        return this.configDirectory;
    }

    public void setConfigDirectory(String configDirectory) {
        this.configDirectory = configDirectory;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public void setDataDirectory(String dataDirectory) {
        this.dataDirectory = dataDirectory;
    }

    public String getExtensionsDirectory() {
        return this.extensionsDirectory;
    }

    public void setExtensionsDirectory(String extensionsDirectory) {
        this.extensionsDirectory = extensionsDirectory;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getPreferencesFile() {
        File pathToJaxer;
        File targetPrefs;
        if (this.isLocal && (targetPrefs = new File(pathToJaxer = new File(this.path), "defaults")).exists() && targetPrefs.isDirectory() && (targetPrefs = new File(targetPrefs, "pref")).exists() && targetPrefs.isDirectory() && (targetPrefs = new File(targetPrefs, "Jaxer_prefs.js")).exists() && targetPrefs.isFile()) {
            return targetPrefs.getAbsolutePath();
        }
        return null;
    }

    public String getConfigLogFile() {
        return this.configLogFile;
    }

    public void setConfigLogFile(String configLogFile) {
        this.configLogFile = configLogFile;
    }

    public String getConfigRoutesFile() {
        return this.configRoutesFile;
    }

    public void setConfigRoutesFile(String configRoutesFile) {
        this.configRoutesFile = configRoutesFile;
    }

    public void requestSentToJaxer() {
        ++this.requestsToJaxer;
        this.serverChanged();
    }

    public void clearRequestsSentToJaxer() {
        this.requestsToJaxer = 0;
        this.serverChanged();
    }

    public void requestSentFromJaxer() {
        ++this.requestsFromJaxer;
        this.serverChanged();
    }

    public void clearRequestsSentFromJaxer() {
        this.requestsFromJaxer = 0;
        this.serverChanged();
    }

    public void callbackSentFromJaxer() {
        ++this.callbacksMade;
        this.serverChanged();
    }

    public void clearCallbacksSentFromJaxer() {
        this.callbacksMade = 0;
        this.serverChanged();
    }

    public int getCallbacksMade() {
        return this.callbacksMade;
    }

    public int getRequestsFromJaxer() {
        return this.requestsFromJaxer;
    }

    public int getRequestsToJaxer() {
        return this.requestsToJaxer;
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public void setTempDirectory(String tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public String getJaxerManagerCfg() {
        return this.jaxerManagerCfg;
    }

    public void setJaxerManagerCfg(String jaxerManagerCfg) {
        this.jaxerManagerCfg = jaxerManagerCfg;
    }
}

