/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.server.manager;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.server.manager.ICommand;
import com.aptana.ide.framework.jaxer.server.manager.IManagerListener;
import com.aptana.ide.framework.jaxer.server.manager.IServerManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;

public class JaxerManager
implements IServerManager {
    public static final String RESUME_COMMAND = "resume";
    public static final String RUNNING_STATE = "running";
    public static final String STOP_COMMAND = "stop";
    public static final String EXIT_COMMAND = "exit";
    public static final String RESTART_COMMAND = "restart";
    public static final String PAUSE_COMMAND = "pause";
    public static final String PAUSE_STATE = "paused";
    public static final String PING_COMMAND = "ping";
    public static final String GET_VERSION_COMMAND = "get version";
    public static final String OK_RESPONSE = "ok";
    public static final int ADMIN_PORT_START = 5375;
    public static final int ADMIN_PORT_END = 5383;
    public static final int ADMIN_PORT_DEFAULT = 4328;
    public static final int WEB_PORT = 4327;
    private String hostname;
    private int port;
    private boolean isHeartbeating;
    private boolean stopHeartbeating;
    private List<IManagerListener> listeners = new ArrayList<IManagerListener>();

    public void addListener(IManagerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IManagerListener listener) {
        this.listeners.remove(listener);
    }

    public JaxerManager(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
        this.isHeartbeating = false;
        this.stopHeartbeating = false;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isHeartbeating() {
        return this.isHeartbeating;
    }

    public synchronized void stopHeartbeating() {
        this.stopHeartbeating = true;
        this.isHeartbeating = false;
    }

    public synchronized void enableHeartbeating() {
        this.stopHeartbeating = false;
    }

    public void commandCallback(ICommand command) {
        if (!this.getPingData().equals(command.getRequest())) {
            IdeLog.logInfo((Plugin)JaxerPlugin.getDefault(), (String)("Server:" + this.hostname + " Request:" + command.getRequest() + " replied with:" + command.getResponse()));
        }
    }

    public synchronized boolean heartbeatCallback(boolean success, String response) {
        block3: {
            block2: {
                boolean bl = this.isHeartbeating = !this.stopHeartbeating;
                if (success || this.stopHeartbeating) break block2;
                IdeLog.logInfo((Plugin)JaxerPlugin.getDefault(), (String)("Heartbeat ping failed for server:" + this.hostname + ":" + this.port));
                for (IManagerListener listener : this.listeners) {
                    listener.heartbeatFailed(response);
                }
                break block3;
            }
            if (!success) break block3;
            for (IManagerListener listener : this.listeners) {
                listener.heartbeatSucceeded(response);
            }
        }
        return this.isHeartbeating;
    }

    public String getPingData() {
        return PING_COMMAND;
    }
}

