/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.views.activity;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.server.JaxerServer;
import com.aptana.ide.server.core.impl.servers.ServerManager;
import com.aptana.ide.server.jetty.ResourceBaseServlet;
import java.io.File;
import java.net.URL;
import javax.servlet.Servlet;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.osgi.framework.Bundle;

public class JaxerActivityMonitor
extends ViewPart {
    public static final String ID = "com.aptana.ide.framework.jaxer.monitor";
    private Composite displayArea;
    private Browser graphs;
    private static File graphFolder;
    private Server server;
    private boolean originalSet = false;

    public void createPartControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        final JaxerServer jaxerServer = (JaxerServer)ServerManager.getInstance().findServer("jaxerInternalServer");
        this.graphs = new Browser(this.displayArea, 0);
        this.graphs.setLayoutData((Object)new GridData(4, 4, true, true));
        if (jaxerServer != null) {
            int endPort = ServerManager.findFreePort((int)8400, (int)8500);
            this.server = null;
            try {
                Bundle bundle = Platform.getBundle((String)"com.aptana.ide.libraries");
                URL graph = bundle.getEntry("resources/graph");
                graph = FileLocator.toFileURL((URL)graph);
                Bundle jaxerBundle = Platform.getBundle((String)"com.aptana.ide.framework.jaxer");
                URL index = jaxerBundle.getEntry("resources/graph/index.html");
                index = FileLocator.toFileURL((URL)index);
                if (graphFolder == null) {
                    String temp = FileUtils.systemTempDir;
                    graphFolder = new File(temp, "aptana_jaxer_activity_monitor");
                    graphFolder.deleteOnExit();
                    FileUtils.copy((File)new File(graph.getFile()), (File)graphFolder);
                    FileUtils.copy((File)new File(index.getFile()), (File)new File(graphFolder, "index.html"));
                }
                this.server = new Server(endPort);
                this.server.getConnectors()[0].setHost("127.0.0.1");
                Context context = new Context((HandlerContainer)this.server, "/", 1);
                ResourceBaseServlet servlet = new ResourceBaseServlet(graphFolder.getAbsolutePath());
                context.addServlet(new ServletHolder((Servlet)servlet), "/");
                this.server.setStopAtShutdown(true);
                this.server.start();
            }
            catch (Exception exception) {
                this.server = null;
            }
            String url = "http://127.0.0.1:" + endPort + "/index.html";
            this.graphs.setUrl(url);
            this.graphs.addProgressListener(new ProgressListener(){

                public void completed(ProgressEvent event) {
                    if (jaxerServer != null) {
                        String js = "try {setOrigFromRequests(" + jaxerServer.getRequestsFromJaxer() + ");setOrigToRequests(" + jaxerServer.getRequestsToJaxer() + ");setOrigCallbacks(" + jaxerServer.getCallbacksMade() + ");}catch(e){}";
                        JaxerActivityMonitor.this.graphs.execute(js);
                        JaxerActivityMonitor.this.originalSet = true;
                    }
                }

                public void changed(ProgressEvent event) {
                }
            });
            this.graphs.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (JaxerActivityMonitor.this.server != null) {
                        try {
                            JaxerActivityMonitor.this.server.stop();
                            JaxerActivityMonitor.this.server.destroy();
                        }
                        catch (Exception e1) {
                            IdeLog.logInfo((Plugin)JaxerPlugin.getDefault(), (String)"Error stopping jaxer activity monitor server", (Throwable)e1);
                        }
                    }
                }
            });
            Job job = new Job("Checking jaxer activity"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (jaxerServer != null) {
                        final String exec = "try {setFromRequests(" + jaxerServer.getRequestsFromJaxer() + ");setToRequests(" + jaxerServer.getRequestsToJaxer() + ");setCallbacks(" + jaxerServer.getCallbacksMade() + ");}catch(e){}";
                        if (!JaxerActivityMonitor.this.graphs.isDisposed()) {
                            if (JaxerActivityMonitor.this.originalSet) {
                                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                                    public void run() {
                                        if (!JaxerActivityMonitor.this.graphs.isDisposed()) {
                                            JaxerActivityMonitor.this.graphs.execute(exec);
                                        }
                                    }
                                });
                            }
                            this.schedule(1000L);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.setPriority(40);
            job.schedule(5000L);
        } else {
            this.graphs.setText("<h2>Internal Jaxer server required to view activity.</h2>");
        }
    }

    public void setFocus() {
        this.displayArea.setFocus();
    }
}

