/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.framework.jaxer.views.console;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editor.js.JSEditor;
import com.aptana.ide.editor.js.actions.JSActionContributor;
import com.aptana.ide.editors.unified.UnifiedMessagePage;
import com.aptana.ide.framework.jaxer.JaxerPlugin;
import com.aptana.ide.framework.jaxer.server.JaxerServer;
import com.aptana.ide.framework.jaxer.views.console.JaxerLogViewer;
import com.aptana.ide.framework.jaxer.views.console.Messages;
import com.aptana.ide.framework.jaxer.views.console.ProxyComboControl;
import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerManagerListener;
import com.aptana.ide.server.core.ServerManagerEvent;
import com.aptana.ide.server.ui.ServerImagesRegistry;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.EditorActionBars;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.preferences.IPropertyMap;
import org.eclipse.ui.internal.preferences.ThemeManagerAdapter;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultTabFolder;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultTabItem;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultThemeListener;
import org.eclipse.ui.internal.presentations.util.AbstractTabItem;
import org.eclipse.ui.internal.presentations.util.PartInfo;
import org.eclipse.ui.internal.presentations.util.TabFolderEvent;
import org.eclipse.ui.internal.presentations.util.TabFolderListener;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.presentations.IPartMenu;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.themes.IThemeManager;

public class JaxerConsoleView
extends ViewPart {
    public static final String ID = "com.aptana.ide.framework.jaxer.interactiveConsole";
    private static final int MAX_LENGTH_IN_HISTORY_COMBO = 30;
    JSActionContributor contributor = new JSActionContributor();
    private LinkedList<String> history = new LinkedList();
    private boolean clearOnSelection;
    static final String RUN_SELECTED_TITLE = Messages.JaxerConsoleView_RUN_SELECTED;
    static final String RUN_ALL_TITLE = Messages.JaxerConsoleView_RUN_ALL;
    private JSEditor jseditor;
    private DefaultTabFolder fld;
    private HashMap<AbstractTabItem, JaxerLogViewer> servers = new HashMap();
    private HashMap<JaxerServer, AbstractTabItem> serversMap = new HashMap();
    private HashMap<AbstractTabItem, JaxerServer> backMap = new HashMap();
    private UnifiedMessagePage page;
    private SashForm frm;
    private IThemeManager themeManager;
    private IPropertyChangeListener propertyChangeListener;
    private IServerManagerListener serverManagerListener;
    private Action rSelectedButton;
    private Action rAllButton;
    private Action ronall;
    private Action refreshStatusAction = new Action(){
        {
            this.setToolTipText(Messages.JaxerConsoleView_REFRESH_SERVER_STATUS);
            this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.aptana.ide.framework.jaxer", (String)"/icons/refresh_tab.gif"));
        }

        public void run() {
            JaxerConsoleView.this.getActiveViewer().refreshConnection();
        }
    };
    private Button clearEditor;
    private ProxyComboControl historyCombo;
    boolean traditionalStyleTabs;
    SelectServerAction selectServerAction = new SelectServerAction();
    private IPropertyChangeListener tabsChangeListener;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        if (memento != null) {
            Integer clear = memento.getInteger("clear");
            this.clearOnSelection = clear != null && clear == 1;
            Integer integer = memento.getInteger("size");
            int k = integer == null ? 0 : integer;
            int i = 0;
            while (i < k) {
                String item = JaxerPlugin.getDefault().getPreferenceStore().getString(StringUtils.format((String)"jaxerConsoleHistoryItem{0}", (String)String.valueOf(i)));
                if (item != null && item.length() > 0) {
                    this.history.add(item);
                }
                ++i;
            }
        }
        super.init(site, memento);
    }

    public void saveState(IMemento memento) {
        if (this.clearEditor.getSelection()) {
            memento.putInteger("clear", 1);
        } else {
            memento.putInteger("clear", 0);
        }
        memento.putInteger("size", this.history.size());
        int i = 0;
        for (String s : this.history) {
            JaxerPlugin.getDefault().getPreferenceStore().setValue(StringUtils.format((String)"jaxerConsoleHistoryItem{0}", (String)String.valueOf(i)), s);
            ++i;
        }
        super.saveState(memento);
    }

    public void dispose() {
        ServerCore.getServerManager().removeServerManagerListener(this.serverManagerListener);
        PlatformUI.getPreferenceStore().removePropertyChangeListener(this.tabsChangeListener);
        super.dispose();
    }

    private JaxerLogViewer getActiveViewer() {
        if (this.fld == null) {
            return null;
        }
        DefaultTabItem selection = (DefaultTabItem)this.fld.getSelection();
        return this.servers.get(selection);
    }

    public void createPartControl(final Composite parent) {
        this.tabsChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("SHOW_TRADITIONAL_STYLE_TABS")) {
                    Boolean newValue = (Boolean)event.getNewValue();
                    JaxerConsoleView.this.traditionalStyleTabs = newValue;
                    if (JaxerConsoleView.this.fld != null) {
                        JaxerConsoleView.this.fld.setSimpleTabs(JaxerConsoleView.this.traditionalStyleTabs);
                    }
                }
            }
        };
        this.traditionalStyleTabs = PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS");
        PlatformUI.getPreferenceStore().addPropertyChangeListener(this.tabsChangeListener);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        parent.setLayout((Layout)gridLayout);
        this.createControlBar(parent);
        this.frm = new SashForm(parent, 512);
        this.createEditor((Composite)this.frm);
        this.frm.setLayoutData((Object)new GridData(1808));
        this.page = new UnifiedMessagePage();
        this.serverManagerListener = new IServerManagerListener(){

            public void serversChanged(final ServerManagerEvent event) {
                DefaultTabItem abstractTabItem;
                if (event.getKind() == 2 && (abstractTabItem = (DefaultTabItem)JaxerConsoleView.this.serversMap.get(event.getServer())) != null) {
                    parent.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!abstractTabItem.getWidget().isDisposed()) {
                                abstractTabItem.getItem().setText(JaxerConsoleView.this.getServerTitle((JaxerServer)event.getServer()));
                            }
                        }
                    });
                }
                parent.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        (this).JaxerConsoleView.this.selectServerAction.refreshEnabled();
                    }
                });
            }
        };
        ServerCore.getServerManager().addServerManagerListener(this.serverManagerListener);
        this.createNoJaxer();
        IHandlerService service = (IHandlerService)this.getViewSite().getService(IHandlerService.class);
        service.activateHandler("com.aptana.ide.framework.jaxer.run", (IHandler)new AbstractHandler(){

            public Object execute(ExecutionEvent arg0) throws ExecutionException {
                JaxerConsoleView.this.runSelected();
                return null;
            }
        });
        this.internalSetStatus(false);
        parent.getDisplay().asyncExec(new Runnable(){

            public void run() {
                JaxerConsoleView.this.openInternalServer();
            }
        });
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext("com.aptana.ide.framework.jaxer.views.shell");
    }

    private void openInternalServer() {
        if (this.getActiveViewer() != null) {
            return;
        }
        IServer[] iServerArray = ServerCore.getServerManager().getServers();
        int n = 0;
        int n2 = iServerArray.length;
        while (n < n2) {
            JaxerServer sj;
            IServer s = iServerArray[n];
            if (s instanceof JaxerServer && (sj = (JaxerServer)s).getId().equals("jaxerInternalServer")) {
                if (sj.getServerState() == 2) {
                    this.connectToServer(sj);
                    break;
                }
                final long l0 = System.currentTimeMillis();
                final Display c = Display.getCurrent();
                Thread jaxerCheck = new Thread(){

                    public void run() {
                        while (System.currentTimeMillis() - l0 < 20000L) {
                            if (sj.getServerState() == 2) {
                                c.asyncExec(new Runnable(){

                                    public void run() {
                                        JaxerConsoleView.this.openInternalServer();
                                    }
                                });
                                return;
                            }
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException interruptedException) {
                                break;
                            }
                        }
                    }
                };
                jaxerCheck.setDaemon(true);
                jaxerCheck.start();
                break;
            }
            ++n;
        }
    }

    private void createNoJaxer() {
        Composite sm = new Composite((Composite)this.frm, 0);
        sm.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginTop = 0;
        gridLayout.marginHeight = 0;
        sm.setLayout((Layout)gridLayout);
        ToolBarManager tm = new ToolBarManager(0);
        tm.add((IAction)this.selectServerAction);
        ToolBar createControl = tm.createControl(sm);
        createControl.setLayoutData((Object)new GridData(131072, 128, true, false));
        this.page.createControl(sm);
        this.page.getControl().setLayoutData((Object)new GridData(1808));
        this.page.setMessage("No Jaxer Server is Connected");
    }

    private void createEditor(Composite parent) {
        File file = new File(JaxerPlugin.getDefault().getStateLocation().toFile(), "temp.js");
        file.deleteOnExit();
        try {
            if (!file.exists()) {
                file.createNewFile();
                FileWriter wr = new FileWriter(file);
                wr.write("//this sample input shows the properties of everything in the Jaxer namespace\r\n var tmp = [];\r\nfor (var p in Jaxer)\r\n{\r\n\ttmp.push(\"Jaxer.\" + p);\r\n}\r\nprint(tmp.sort().join(\"\\n\"));");
                wr.close();
            }
        }
        catch (IOException iOException) {}
        IEditorInput input = CoreUIUtils.createNonExistingFileEditorInput((File)file, (String)"temp.js");
        Composite editorComp = new Composite(parent, 2048);
        WorkbenchPage page = (WorkbenchPage)this.getViewSite().getPage();
        this.jseditor = new EmbeddableJSEditor();
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor("test.js");
        EditorReference ref = new EditorReference(page.getEditorManager(), input, (EditorDescriptor)descriptor);
        EditorSite site = new EditorSite((IEditorReference)ref, (IEditorPart)this.jseditor, page, (EditorDescriptor)descriptor){

            public IActionBars getActionBars() {
                return new EditorActionBars((WorkbenchPage)this.getPage(), JaxerConsoleView.this.getViewSite().getActionBars().getServiceLocator(), "");
            }
        };
        try {
            this.jseditor.init((IEditorSite)site, input);
        }
        catch (PartInitException e1) {
            IdeLog.log((Plugin)JaxerPlugin.getDefault(), (int)4, (String)"exception while initing js editor", (Throwable)e1);
        }
        this.jseditor.createPartControl(editorComp);
        this.contributor.init(this.getViewSite().getActionBars());
        this.contributor.setActiveEditor((IEditorPart)this.jseditor);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginTop = 0;
        gridLayout2.marginWidth = 0;
        editorComp.setLayout((Layout)gridLayout2);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 300;
        gridData.heightHint = 200;
        editorComp.setLayoutData((Object)gridData);
    }

    private void createControlBar(Composite parent) {
        Composite controlBar = new Composite(parent, 2048);
        controlBar.setLayout((Layout)new GridLayout(6, false));
        ToolBar tb = new ToolBar(controlBar, 0);
        ToolBarManager man = new ToolBarManager(tb);
        this.createActions();
        man.add((IAction)this.rAllButton);
        man.add((IAction)this.rSelectedButton);
        man.add((IAction)this.ronall);
        this.ronall.setEnabled(false);
        tb.setLayoutData((Object)new GridData(768));
        man.update(true);
        GridLayout gd2 = new GridLayout(3, false);
        Label label = new Label(controlBar, 0);
        label.setText(Messages.JaxerConsoleView_HISTORY);
        this.historyCombo = new ProxyComboControl(controlBar);
        this.historyCombo.getControl().setLayoutData((Object)new GridData(200, -1));
        this.clearEditor = new Button(controlBar, 32);
        this.clearEditor.setSelection(this.clearOnSelection);
        this.clearEditor.setText(Messages.JaxerConsoleView_CLEAR_EDITOR);
        gd2.marginHeight = 0;
        this.historyCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                JaxerConsoleView.this.jseditor.getViewer().getDocument().set((String)JaxerConsoleView.this.history.get(JaxerConsoleView.this.historyCombo.getSelectionIndex()));
            }
        });
        if (!this.history.isEmpty()) {
            this.refreshHistory();
        } else {
            this.historyCombo.add(Messages.JaxerConsoleView_HISTORY_CMB_TITLE);
            this.historyCombo.setEnabled(false);
        }
        controlBar.setLayoutData((Object)new GridData(768));
    }

    private void refreshHistory() {
        String[] ss = new String[this.history.size()];
        int a = 0;
        for (String s : this.history) {
            String sa;
            if (s.length() > 30) {
                sa = s.substring(0, 30);
                sa = sa.replace("\n\r", " ");
                sa = sa.replace("\r", " ");
                sa = sa.replace("\n", " ");
                sa = StringUtils.format((String)"{0}...", (String)sa);
                ss[a++] = sa;
                continue;
            }
            sa = s;
            sa = sa.replace("\n\r", " ");
            sa = sa.replace("\r", " ");
            sa = sa.replace("\n", " ");
            sa = sa.trim();
            ss[a++] = sa;
        }
        this.historyCombo.setItems(ss);
        this.historyCombo.setEnabled(true);
        this.historyCombo.redraw();
    }

    public void runSelected() {
        JaxerLogViewer activeViewer = this.getActiveViewer();
        if (activeViewer == null || !activeViewer.isConnected()) {
            return;
        }
        TextSelection ts = (TextSelection)this.jseditor.getViewer().getSelectionProvider().getSelection();
        if (ts.isEmpty() || ts.getText().length() == 0) {
            String string = this.jseditor.getViewer().getDocument().get();
            JaxerLogViewer l = this.getActiveViewer();
            this.doRun(string, l);
        } else {
            Point selectedRange = this.jseditor.getViewer().getSelectedRange();
            try {
                String string = this.jseditor.getViewer().getDocument().get(selectedRange.x, selectedRange.y);
                JaxerLogViewer l = this.getActiveViewer();
                if (l.isEnabled()) {
                    l.sendText(string);
                }
            }
            catch (BadLocationException badLocationException) {
                return;
            }
        }
    }

    private void createActions() {
        this.rAllButton = new Action(){

            public void run() {
                String string = JaxerConsoleView.this.jseditor.getViewer().getDocument().get();
                JaxerConsoleView.this.doRun(string, JaxerConsoleView.this.getActiveViewer());
            }
        };
        this.rSelectedButton = new Action(){

            public void run() {
                ISourceViewer viewer = JaxerConsoleView.this.jseditor.getViewer();
                IDocument document = viewer.getDocument();
                Point selectedRange = viewer.getSelectedRange();
                try {
                    String string = document.get(selectedRange.x, selectedRange.y);
                    JaxerConsoleView.this.doRun(string, JaxerConsoleView.this.getActiveViewer());
                }
                catch (BadLocationException badLocationException) {}
            }
        };
        this.rAllButton.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.aptana.ide.framework.jaxer", (String)"/icons/run_all.gif"));
        this.rSelectedButton.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.aptana.ide.framework.jaxer", (String)"/icons/run_selected.gif"));
        this.rSelectedButton.setText(RUN_SELECTED_TITLE);
        this.rAllButton.setText(RUN_ALL_TITLE);
        this.ronall = new Action(){

            public void run() {
                TextSelection ts = (TextSelection)JaxerConsoleView.this.jseditor.getViewer().getSelectionProvider().getSelection();
                if (ts.isEmpty() || ts.getText().length() == 0) {
                    String string = JaxerConsoleView.this.jseditor.getViewer().getDocument().get();
                    for (JaxerLogViewer l : JaxerConsoleView.this.servers.values()) {
                        if (!l.isEnabled()) continue;
                        JaxerConsoleView.this.doRun(string, l);
                    }
                } else {
                    Point selectedRange = JaxerConsoleView.this.jseditor.getViewer().getSelectedRange();
                    try {
                        String string = JaxerConsoleView.this.jseditor.getViewer().getDocument().get(selectedRange.x, selectedRange.y);
                        for (JaxerLogViewer l : JaxerConsoleView.this.servers.values()) {
                            if (!l.isEnabled()) continue;
                            JaxerConsoleView.this.doRun(string, l);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        return;
                    }
                }
            }
        };
        this.ronall.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.aptana.ide.framework.jaxer", (String)"/icons/run_on_all.gif"));
        this.ronall.setText(Messages.JaxerConsoleView_RUN_ONALL);
        this.ronall.setEnabled(false);
        this.getViewSite().getActionBars().getMenuManager().add((IAction)new Action(Messages.JaxerConsoleView_Clear_Command_History){

            public void run() {
                JaxerConsoleView.this.history.clear();
                JaxerConsoleView.this.refreshHistory();
                JaxerConsoleView.this.historyCombo.add(Messages.JaxerConsoleView_HISTORY_CMB_TITLE);
                JaxerConsoleView.this.historyCombo.select(0);
                JaxerConsoleView.this.historyCombo.setEnabled(false);
            }
        });
    }

    private void doRun(String string, JaxerLogViewer l) {
        if ("".equals(string.trim())) {
            return;
        }
        if (!this.historyCombo.isEnabled()) {
            this.historyCombo.remove(0);
            this.historyCombo.setEnabled(true);
        }
        if (!this.isLastHistoryItemEqual(string)) {
            this.history.add(string);
        }
        if (this.history.size() >= 20) {
            String next = (String)this.history.iterator().next();
            this.history.remove(next);
        }
        this.refreshHistory();
        l.sendText(string);
        if (this.clearEditor.getSelection()) {
            this.jseditor.getViewer().getDocument().set("");
        }
    }

    private boolean isLastHistoryItemEqual(String string) {
        if (this.history.isEmpty()) {
            return false;
        }
        String lastString = this.history.get(this.history.size() - 1);
        return lastString.equals(string);
    }

    public void setFocus() {
    }

    private boolean openServer(JaxerServer srv) {
        return this.connectToServer(srv) == null;
    }

    public JaxerServer connectToServer(JaxerServer srv) {
        JaxerLogViewer lv;
        JaxerServer js = srv;
        AbstractTabItem abstractTabItem = this.serversMap.get(js);
        if (abstractTabItem != null) {
            this.fld.setSelection(abstractTabItem);
            ViewForm contentParent = (ViewForm)this.fld.getContentParent();
            JaxerLogViewer jaxerLogViewer = this.servers.get(this.fld.getSelection());
            contentParent.setContent((Control)jaxerLogViewer);
            this.rSelectedButton.setEnabled(jaxerLogViewer.isConnected());
            this.rAllButton.setEnabled(jaxerLogViewer.isConnected());
            return js;
        }
        if (this.fld == null) {
            int[] weights = this.frm.getWeights();
            this.fld = new DefaultTabFolder((Composite)this.frm, 64, false, false);
            this.fld.setSimpleTabs(this.traditionalStyleTabs);
            ToolBar toolBar = new ToolBar(this.fld.getToolbarParent(), 0);
            this.fld.setToolbar((Control)toolBar);
            ToolBarManager man = new ToolBarManager(toolBar);
            Action clearConsole = new Action(){

                public void run() {
                    JaxerConsoleView.this.getActiveViewer().clear();
                }
            };
            clearConsole.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.aptana.ide.framework.jaxer", (String)"/icons/clear_co.gif"));
            clearConsole.setToolTipText(Messages.JaxerConsoleView_CLEAR_CONSOLE);
            Action saveAction = new Action(){

                public void run() {
                    JaxerConsoleView.this.getActiveViewer().doSave();
                }
            };
            saveAction.setToolTipText(Messages.JaxerConsoleView_SACE_SESSION);
            ImageDescriptor imageDescriptor2 = ActionFactory.SAVE.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getImageDescriptor();
            saveAction.setImageDescriptor(imageDescriptor2);
            man.add((IAction)this.selectServerAction);
            man.add((IContributionItem)new Separator());
            man.add((IAction)this.refreshStatusAction);
            man.add((IAction)clearConsole);
            man.add((IAction)saveAction);
            man.update(true);
            this.themeManager = PlatformUI.getWorkbench().getThemeManager();
            final DefaultThemeListener themeListener = new DefaultThemeListener(this.fld, (IPropertyMap)new ThemeManagerAdapter(this.themeManager));
            this.propertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    themeListener.update();
                }
            };
            this.themeManager.addPropertyChangeListener(this.propertyChangeListener);
            themeListener.update();
            this.page.getControl().getParent().dispose();
            this.frm.setWeights(weights);
            this.frm.layout(true, true);
            this.fld.setActive(1);
            this.fld.shellActive(false);
            this.fld.getControl().addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    JaxerConsoleView.this.fld.layout(true);
                }
            });
            this.fld.addListener(new TabFolderListener(){

                public void handleEvent(TabFolderEvent e) {
                    if (e.type == 8) {
                        ViewForm contentParent = (ViewForm)JaxerConsoleView.this.fld.getContentParent();
                        JaxerLogViewer jaxerLogViewer = (JaxerLogViewer)((Object)JaxerConsoleView.this.servers.get(JaxerConsoleView.this.fld.getSelection()));
                        contentParent.setContent((Control)jaxerLogViewer);
                        JaxerConsoleView.this.rSelectedButton.setEnabled(jaxerLogViewer.isConnected());
                        JaxerConsoleView.this.rAllButton.setEnabled(jaxerLogViewer.isConnected());
                        JaxerConsoleView.this.getActiveViewer();
                    }
                    if (e.type == 6) {
                        AbstractTabItem tab = e.tab;
                        JaxerConsoleView.this.closeTab(e, tab);
                    }
                }
            });
            Control[] childs = this.fld.getToolbarParent().getChildren();
            toolBar.moveAbove(childs[0]);
            this.fld.layout(true);
            this.frm.setRedraw(true);
            this.frm.redraw();
        }
        if ((lv = this.addTab(js)).initCommunicator(js)) {
            return js;
        }
        String format = StringUtils.format((String)Messages.JaxerConsoleView_UNABLE_TO_CONNECT, (String)js.getHostname());
        lv.appendError(format);
        if (this.fld.getItemCount() == 0) {
            this.closeTabFolder(this.themeManager, this.propertyChangeListener);
        }
        try {
            if (js.getServerState() == 2) {
                lv.printConnectionFailed();
            }
        }
        catch (IOException e) {
            lv.logIOException(e);
        }
        return null;
    }

    private void closeTabFolder(IThemeManager themeManager, IPropertyChangeListener propertyChangeListener) {
        this.createNoJaxer();
        this.fld.getControl().dispose();
        this.rAllButton.setEnabled(false);
        this.fld = null;
        this.ronall.setEnabled(false);
        this.rSelectedButton.setEnabled(false);
        int[] weights = this.frm.getWeights();
        this.frm.setWeights(weights);
        this.frm.layout(true, true);
        themeManager.removePropertyChangeListener(propertyChangeListener);
    }

    private JaxerLogViewer addTab(JaxerServer js) {
        DefaultTabItem add = (DefaultTabItem)this.fld.add(0, 0);
        this.serversMap.put(js, (AbstractTabItem)add);
        this.backMap.put((AbstractTabItem)add, js);
        ViewForm contentParent = (ViewForm)this.fld.getContentParent();
        JaxerLogViewer lv = new JaxerLogViewer((Composite)contentParent, 0, this);
        add.setInfo(new PartInfo((IPresentablePart)new CustomPresentablePart(js, lv)));
        this.fld.setSelection((AbstractTabItem)add);
        contentParent.setContent((Control)lv);
        this.servers.put((AbstractTabItem)add, lv);
        return lv;
    }

    private void closeTab(TabFolderEvent e, AbstractTabItem tab) {
        tab.dispose();
        JaxerLogViewer jaxerLogViewer = this.servers.get(e.tab);
        this.serversMap.remove(this.backMap.get(tab));
        this.backMap.remove(tab);
        jaxerLogViewer.dispose();
        this.servers.remove(e.tab);
        if (this.fld.getItemCount() == 0) {
            this.closeTabFolder(this.themeManager, this.propertyChangeListener);
        } else {
            ViewForm contentParent = (ViewForm)this.fld.getContentParent();
            contentParent.setContent((Control)this.servers.get(this.fld.getSelection()));
        }
    }

    private String getServerTitle(JaxerServer js) {
        IServer[] servers;
        String host = "";
        IServer[] iServerArray = servers = ServerCore.getServerManager().getServers();
        int n = 0;
        int n2 = iServerArray.length;
        while (n < n2) {
            IServer[] associations;
            IServer server = iServerArray[n];
            IServer[] iServerArray2 = associations = server.getAssociatedServers();
            int n3 = 0;
            int n4 = iServerArray2.length;
            while (n3 < n4) {
                IServer association = iServerArray2[n3];
                if (js == association && server.isWebServer()) {
                    host = server.getHost();
                    break;
                }
                ++n3;
            }
            ++n;
        }
        return StringUtils.format((String)"{0}({1})", (Object[])new Object[]{js.getName(), host});
    }

    final void internalSetStatus(boolean isRunning) {
        this.rSelectedButton.setEnabled(isRunning);
        this.rAllButton.setEnabled(isRunning);
        boolean found = false;
        for (JaxerLogViewer vr : this.servers.values()) {
            if (!vr.isConnected()) continue;
            found = true;
            break;
        }
        this.ronall.setEnabled(found);
    }

    private final class EmbeddableJSEditor
    extends JSEditor {
        public EmbeddableJSEditor() {
            super(false);
        }

        protected IVerticalRuler createVerticalRuler() {
            return new VerticalRuler(0);
        }

        protected IOverviewRuler createOverviewRuler(ISharedTextColors sharedColors) {
            OverviewRuler ruler = new OverviewRuler(this.getAnnotationAccess(), 0, sharedColors);
            return ruler;
        }

        protected IStatusLineManager getStatusLineManager() {
            return JaxerConsoleView.this.getViewSite().getActionBars().getStatusLineManager();
        }

        protected void editorContextMenuAboutToShow(IMenuManager menu) {
            super.editorContextMenuAboutToShow(menu);
            TextSelection ts = (TextSelection)JaxerConsoleView.this.jseditor.getViewer().getSelectionProvider().getSelection();
            boolean ll = ts.isEmpty() || ts.getText().length() == 0;
            Action action = new Action(ll ? Messages.JaxerConsoleView_RUN_ALL : Messages.JaxerConsoleView_RUN_SELECTED, 1){

                public void run() {
                    JaxerConsoleView.this.runSelected();
                }
            };
            action.setActionDefinitionId("com.aptana.ide.framework.jaxer.run");
            JaxerLogViewer activeViewer = JaxerConsoleView.this.getActiveViewer();
            action.setEnabled(activeViewer != null && activeViewer.isConnected());
            menu.add((IAction)action);
        }
    }

    private final class CustomPresentablePart
    implements IPresentablePart {
        private final JaxerServer js;
        private final JaxerLogViewer lv;

        private CustomPresentablePart(JaxerServer js, JaxerLogViewer lv) {
            this.js = js;
            this.lv = lv;
        }

        public void addPropertyListener(IPropertyListener listener) {
        }

        public Control getControl() {
            return this.lv;
        }

        public IPartMenu getMenu() {
            return null;
        }

        public String getName() {
            return JaxerConsoleView.this.getServerTitle(this.js);
        }

        public String getTitle() {
            return JaxerConsoleView.this.getServerTitle(this.js);
        }

        public Image getTitleImage() {
            return ServerImagesRegistry.getInstance().getImage((Object)this.js);
        }

        public String getTitleStatus() {
            return this.js.getDescription();
        }

        public String getTitleToolTip() {
            return this.js.getDescription();
        }

        public Control getToolBar() {
            return null;
        }

        public boolean isBusy() {
            return false;
        }

        public boolean isCloseable() {
            return true;
        }

        public boolean isDirty() {
            return false;
        }

        public void removePropertyListener(IPropertyListener listener) {
        }

        public void setBounds(Rectangle bounds) {
            this.lv.setBounds(bounds);
        }

        public void setFocus() {
            this.lv.setFocus();
        }

        public void setVisible(boolean isVisible) {
            this.lv.setVisible(isVisible);
        }

        public void addPartPropertyListener(IPropertyChangeListener listener) {
        }

        public String getPartProperty(String key) {
            return null;
        }

        public void removePartPropertyListener(IPropertyChangeListener listener) {
        }

        public int computePreferredSize(boolean width, int availableParallel, int availablePerpendicular, int preferredResult) {
            return 0;
        }

        public int getSizeFlags(boolean width) {
            return 0;
        }
    }

    class SelectServerAction
    extends Action
    implements IMenuCreator {
        public void refreshEnabled() {
            IServer[] servers;
            IServer[] iServerArray = servers = ServerCore.getServerManager().getServers();
            int n = 0;
            int n2 = iServerArray.length;
            while (n < n2) {
                JaxerServer js;
                IServer s = iServerArray[n];
                if (s.getServerType().getId().equals("com.aptana.ide.server.jaxer.jaxerHttpServer") && s instanceof JaxerServer && (js = (JaxerServer)s).getConsoleAddress() != null) {
                    this.setEnabled(true);
                    return;
                }
                ++n;
            }
            this.setEnabled(false);
        }

        public SelectServerAction() {
            super(Messages.JaxerConsoleView_OpenServerSELECT_SERVER_TITLE, 4);
            this.setImageDescriptor(JaxerPlugin.getImageDescriptor("/icons/jaxer_useragent_client.png"));
            this.setMenuCreator(this);
            this.refreshEnabled();
        }

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            MenuManager mn = new MenuManager();
            IServer[] servers = ServerCore.getServerManager().getServers();
            ArrayList<JaxerServer> items = new ArrayList<JaxerServer>();
            IServer[] iServerArray = servers;
            int n = 0;
            int n2 = iServerArray.length;
            while (n < n2) {
                JaxerServer js;
                IServer s = iServerArray[n];
                if (s.getServerType().getId().equals("com.aptana.ide.server.jaxer.jaxerHttpServer") && s instanceof JaxerServer && (js = (JaxerServer)s).getConsoleAddress() != null) {
                    items.add(js);
                }
                ++n;
            }
            Collections.sort(items, new Comparator<JaxerServer>(){

                @Override
                public int compare(JaxerServer arg0, JaxerServer arg1) {
                    return arg0.getName().compareTo(arg1.getName());
                }
            });
            JaxerLogViewer activeViewer = JaxerConsoleView.this.getActiveViewer();
            ImageDescriptor imageDescriptor2 = JaxerPlugin.getImageDescriptor("/icons/jaxer_useragent_client.png");
            for (JaxerServer s : items) {
                OpenServerAction ss = new OpenServerAction(s);
                ss.setImageDescriptor(imageDescriptor2);
                ss.setChecked(activeViewer != null && activeViewer.getServer() == s);
                mn.add((IAction)ss);
            }
            return mn.createContextMenu(parent);
        }

        public Menu getMenu(Menu parent) {
            return null;
        }
    }

    class OpenServerAction
    extends Action {
        JaxerServer srv;

        public OpenServerAction(JaxerServer s) {
            super(Messages.JaxerConsoleView_OpenServer1, 2);
            this.srv = s;
            this.setText(s.getName());
        }

        public void run() {
            JaxerConsoleView.this.openServer(this.srv);
        }
    }
}

