/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.extras.plugins;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.update.core.IFeatureReference;

public class CorePluginsViewerFilter
extends ViewerFilter {
    private static final String[] CORE_PLUGINS = new String[]{"org.eclipse.rcp", "org.eclipse.sdk", "com.aptana.ide.feature", "com.aptana.ide.feature.editors", "com.aptana.ide.feature.editor.css", "com.aptana.ide.feature.editor.html", "com.aptana.ide.feature.editor.js", "com.aptana.ide.feature.collaboration", "com.aptana.ide.feature.junit"};
    private static final String[] CORE_PLUGIN_PREFIXES = new String[]{"org.eclipse.rcp", "org.eclipse.platform", "org.eclipse.pde", "com.aptana.ide.feature.rcp"};

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IFeatureReference) {
            IFeatureReference ref = (IFeatureReference)element;
            try {
                String name = ref.getVersionedIdentifier().getIdentifier();
                if (this.isIn(name, CORE_PLUGINS) || this.matchesPrefix(name, CORE_PLUGIN_PREFIXES)) {
                    return false;
                }
            }
            catch (CoreException coreException) {}
        }
        return true;
    }

    private boolean matchesPrefix(String name, String[] prefixes) {
        if (prefixes == null) {
            return false;
        }
        int i = 0;
        while (i < prefixes.length) {
            if (name.startsWith(prefixes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isIn(String name, String[] plugins) {
        if (plugins == null) {
            return false;
        }
        int i = 0;
        while (i < plugins.length) {
            if (name.equals(plugins[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

