/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.extras.plugins;

import com.aptana.ide.extras.plugins.Plugin;
import com.aptana.ide.extras.plugins.PluginsManager;
import com.aptana.ide.server.jetty.comet.CometResponderClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.core.IFeatureReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPluginsClient
extends CometResponderClient {
    private static final String AIR_ID = "com.aptana.ide.feature.framework.air";
    private static final String IPHONE_ID = "com.aptana.ide.framework.iphone";
    private static final String PHP_ID = "com.aptana.ide.feature.editor.php";
    private static final String RADRAILS_ID = "org.radrails.rails_feature";
    private static final String NOKIA_ID = "com.nokia.wrt.feature";
    private static final String PYDEV_ID = "org.python.pydev.feature";
    private static Set<String> OFFICIAL = new HashSet<String>();
    public static final String LIST_PLUGINS = "/portal/plugins/list";

    static {
        OFFICIAL.add(RADRAILS_ID);
        OFFICIAL.add(PHP_ID);
        OFFICIAL.add(IPHONE_ID);
        OFFICIAL.add(AIR_ID);
        OFFICIAL.add(NOKIA_ID);
        OFFICIAL.add(PYDEV_ID);
    }

    protected Object getResponse(String toChannel, Object request) {
        if (LIST_PLUGINS.equals(toChannel)) {
            List<Plugin> remotes = PluginsManager.getRemotePlugins();
            List<IFeatureReference> installed = PluginsManager.getInstalledPlugins();
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            List<Map<String, Object>> pluginListing = this.createPluginListing(remotes, installed);
            for (Map<String, Object> map : pluginListing) {
                String category = (String)map.get("category");
                LinkedList<Map<String, Object>> listOfCategoryPlugins = (LinkedList<Map<String, Object>>)returnMap.get(category);
                if (listOfCategoryPlugins == null) {
                    listOfCategoryPlugins = new LinkedList<Map<String, Object>>();
                    returnMap.put(category, listOfCategoryPlugins);
                }
                listOfCategoryPlugins.add(map);
            }
            returnMap.put("response", "listPlugins");
            return returnMap;
        }
        return null;
    }

    private List<Plugin> filterToVendor(List<Plugin> remotes) {
        ArrayList<Plugin> vendor = new ArrayList<Plugin>();
        for (Plugin plugin : remotes) {
            try {
                if (OFFICIAL.contains(plugin.getVersionedIdentifier().getIdentifier())) continue;
                vendor.add(plugin);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return vendor;
    }

    private List<Plugin> filterToOfficial(List<Plugin> remotes) {
        ArrayList<Plugin> official = new ArrayList<Plugin>();
        for (Plugin plugin : remotes) {
            try {
                if (!OFFICIAL.contains(plugin.getVersionedIdentifier().getIdentifier())) continue;
                official.add(plugin);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return official;
    }

    private List<Map<String, Object>> createPluginListing(List<Plugin> remotes, List<IFeatureReference> installed) {
        ArrayList<Map<String, Object>> pluginListing = new ArrayList<Map<String, Object>>();
        for (Plugin plugin : remotes) {
            try {
                Map<String, Object> map = this.createMap(plugin, installed);
                pluginListing.add(map);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(pluginListing, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                Integer value = Integer.parseInt((String)o1.get("sortweight"));
                Integer value2 = Integer.parseInt((String)o2.get("sortweight"));
                if (value.intValue() == value2.intValue()) {
                    String name = (String)o1.get("name");
                    String name2 = (String)o2.get("name");
                    return name.compareTo(name2);
                }
                return value.compareTo(value2);
            }
        });
        return pluginListing;
    }

    private Map<String, Object> createMap(Plugin plugin, List<IFeatureReference> installed) throws CoreException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String id = plugin.getVersionedIdentifier().getIdentifier();
        map.put("id", id);
        map.put("more", plugin.getMore());
        map.put("name", plugin.getName());
        map.put("description", plugin.getDescription());
        map.put("link", plugin.getURL().toString());
        String category = plugin.getCategory();
        if (category == null) {
            category = "utilities";
        }
        if (OFFICIAL.contains(plugin.getVersionedIdentifier().getIdentifier())) {
            category = "platform";
        }
        map.put("category", category);
        String sortweight = plugin.getSortweight();
        if (sortweight == null) {
            sortweight = "9";
        }
        map.put("sortweight", sortweight);
        Boolean isInstalled = this.isInstalled(id, installed);
        map.put("installed", isInstalled);
        if (isInstalled.booleanValue()) {
            IFeatureReference installedFeature = this.getInstalled(id, installed);
            Boolean updateAvailable = plugin.getVersionedIdentifier().getVersion().isGreaterThan(installedFeature.getVersionedIdentifier().getVersion());
            map.put("update", updateAvailable);
        } else {
            map.put("update", Boolean.FALSE);
        }
        return map;
    }

    private IFeatureReference getInstalled(String id, List<IFeatureReference> installed) {
        for (IFeatureReference ref : installed) {
            try {
                String refId = ref.getVersionedIdentifier().getIdentifier();
                if (!refId.equals(id)) continue;
                return ref;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private Boolean isInstalled(String id, List<IFeatureReference> installed) {
        if (this.getInstalled(id, installed) != null) {
            return true;
        }
        return false;
    }

    protected String[] getSubscriptionIDs() {
        return new String[]{LIST_PLUGINS};
    }
}

