/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.extras.plugins;

import com.aptana.ide.extras.Activator;
import com.aptana.ide.extras.plugins.FeatureUtil;
import com.aptana.ide.extras.plugins.Plugin;
import com.aptana.ide.extras.plugins.PluginListener;
import com.aptana.ide.extras.plugins.PluginManagerContentHandler;
import com.aptana.ide.extras.plugins.PluginMessages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.UpdateSearchScope;
import org.eclipse.update.standalone.DisableCommand;
import org.eclipse.update.standalone.UninstallCommand;
import org.eclipse.update.ui.UpdateJob;
import org.eclipse.update.ui.UpdateManagerUI;
import org.osgi.framework.Bundle;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginsManager {
    private static final int DAY = 86400000;
    private static final String REMOTE_PLUGINS_XML_URL = "http://ide.aptana.com/content_ide/plugins1.2.6.xml";
    private static final String LOCAL_PLUGINS_XML_FILENAME = "plugins1.2.6.xml";
    private static final Set<PluginListener> listeners = new HashSet<PluginListener>();
    protected static long lastUpdated = -1L;
    private static List<IFeatureReference> pluginList = null;

    public static List<Plugin> getRemotePlugins() {
        ArrayList<Plugin> plugins = new ArrayList();
        try {
            InputStream xml = (InputStream)PluginsManager.getLocalURL().getContent();
            plugins = PluginsManager.parseXML(xml);
        }
        catch (IOException iOException) {
            plugins = new ArrayList();
        }
        if (PluginsManager.haventUpdatedInADay()) {
            Job job = new Job(PluginMessages.PluginsManager_update_job_title){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            InputStream xml = (InputStream)new URL(PluginsManager.REMOTE_PLUGINS_XML_URL).getContent();
                            PluginsManager.saveCache(xml);
                        }
                        catch (IOException iOException) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            lastUpdated = System.currentTimeMillis();
                            return iStatus;
                        }
                    }
                    finally {
                        lastUpdated = System.currentTimeMillis();
                    }
                    for (PluginListener listener : listeners) {
                        listener.remotePluginsRefreshed();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule(10000L);
        }
        return plugins;
    }

    private static boolean haventUpdatedInADay() {
        return lastUpdated < System.currentTimeMillis() - 86400000L;
    }

    protected static void saveCache(InputStream xml) {
        block26: {
            FileOutputStream writer;
            block25: {
                File file = PluginsManager.getLocalCacheFile();
                writer = null;
                try {
                    try {
                        writer = new FileOutputStream(file);
                        int b = -1;
                        while ((b = xml.read()) != -1) {
                            ((OutputStream)writer).write(b);
                        }
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        break block25;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (xml != null) {
                            xml.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (writer != null) {
                            ((OutputStream)writer).close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (xml != null) {
                        xml.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (writer != null) {
                        ((OutputStream)writer).close();
                    }
                    break block26;
                }
                catch (IOException iOException) {}
                break block26;
            }
            try {
                if (xml != null) {
                    xml.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (writer != null) {
                    ((OutputStream)writer).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static URL getLocalURL() {
        try {
            return PluginsManager.getLocalCacheURL();
        }
        catch (MalformedURLException malformedURLException) {
            return PluginsManager.getOriginalFileURL();
        }
    }

    private static URL getOriginalFileURL() {
        return FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(LOCAL_PLUGINS_XML_FILENAME), null);
    }

    private static URL getLocalCacheURL() throws MalformedURLException {
        return PluginsManager.getLocalCacheFile().toURI().toURL();
    }

    private static File getLocalCacheFile() {
        IPath statePath = Activator.getDefault().getStateLocation().append(LOCAL_PLUGINS_XML_FILENAME);
        File file = statePath.toFile();
        if (!file.exists()) {
            try {
                file.createNewFile();
                PluginsManager.copyOriginalToCache();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    private static void copyOriginalToCache() {
        try {
            InputStream in = (InputStream)PluginsManager.getOriginalFileURL().getContent();
            PluginsManager.saveCache(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Plugin> parseXML(InputStream xml) {
        block12: {
            List<Plugin> list;
            try {
                XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                PluginManagerContentHandler handler = new PluginManagerContentHandler();
                reader.setContentHandler(handler);
                reader.parse(new InputSource(xml));
                list = handler.getPlugins();
                if (xml == null) return list;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    break block12;
                    catch (SAXException e2) {
                        e2.printStackTrace();
                        break block12;
                    }
                    catch (ParserConfigurationException e3) {
                        e3.printStackTrace();
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    if (xml == null) throw throwable;
                    try {
                        xml.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                xml.close();
                return list;
            }
            catch (IOException iOException) {}
            return list;
        }
        if (xml == null) return new ArrayList<Plugin>();
        try {
            xml.close();
            return new ArrayList<Plugin>();
        }
        catch (IOException iOException) {}
        return new ArrayList<Plugin>();
    }

    public static List<IFeatureReference> getInstalledPlugins() {
        if (pluginList != null) {
            return pluginList;
        }
        ArrayList<IFeatureReference> plugins = new ArrayList<IFeatureReference>();
        try {
            ILocalSite localSite = SiteManager.getLocalSite();
            IInstallConfiguration config = localSite.getCurrentConfiguration();
            IConfiguredSite[] sites = config.getConfiguredSites();
            int i = 0;
            while (i < sites.length) {
                IFeatureReference[] refs = sites[i].getFeatureReferences();
                int j = 0;
                while (j < refs.length) {
                    IFeatureReference ref = refs[j];
                    plugins.add(ref);
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return Collections.emptyList();
        }
        pluginList = Collections.unmodifiableList(plugins);
        return pluginList;
    }

    public static void install(String pluginId) {
        IFeatureReference plugin = PluginsManager.findPlugin(pluginId);
        if (plugin == null) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Unable to find plugin", (String)("We were unable to find the information to download the plugin you have selected to install. Please file a bug report that we couldn't find information for the plugin: " + pluginId));
            return;
        }
        if (FeatureUtil.isInstalled(pluginId)) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Plugin already installed", (String)"The feature you have selected to install is already present in your configuration.");
            return;
        }
        String featureName = "Site providing " + plugin.getName();
        PluginsManager.doInstall(featureName, plugin.getURL());
    }

    private static IFeatureReference findPlugin(String pluginId) {
        List<Plugin> plugins = PluginsManager.getRemotePlugins();
        for (IFeatureReference iFeatureReference : plugins) {
            try {
                if (!iFeatureReference.getVersionedIdentifier().getIdentifier().equals(pluginId)) continue;
                return iFeatureReference;
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public static void disable(String pluginId) {
        try {
            DisableCommand dc = new DisableCommand(pluginId, null, null, null);
            dc.run(null);
            for (PluginListener listener : listeners) {
                listener.pluginDisabled();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void install(String name, URL url) {
        PluginsManager.doInstall(name, url);
    }

    public static void install(URL url) {
        PluginsManager.doInstall(url.toString(), url);
    }

    private static void doInstall(String siteName, URL url) {
        UpdateSearchScope scope = new UpdateSearchScope();
        scope.addSearchSite(siteName, url, new String[0]);
        UpdateSearchRequest request = new UpdateSearchRequest(UpdateSearchRequest.createDefaultSiteSearchCategory(), scope);
        UpdateJob job = new UpdateJob(PluginMessages.PluginsManager_install_job_title, request);
        job.setPriority(10);
        job.setSystem(false);
        Shell shell = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getShell();
        UpdateManagerUI.openInstaller((Shell)shell, (UpdateJob)job);
        for (PluginListener listener : listeners) {
            listener.pluginInstalled();
        }
    }

    public static void uninstall(String pluginId) {
        try {
            UninstallCommand uc = new UninstallCommand(pluginId, null, null, null);
            uc.run(null);
            for (PluginListener listener : listeners) {
                listener.pluginUninstalled();
            }
        }
        catch (Exception exception) {}
    }

    public static void addListener(PluginListener listener) {
        listeners.add(listener);
    }

    public static void removeListener(PluginListener listener) {
        listeners.remove(listener);
    }
}

