/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.DeleteConfigurationsDialog;
import com.aptana.ide.core.ui.INavigatorDecorator;
import com.aptana.ide.core.ui.IResourceChangeListener;
import com.aptana.ide.core.ui.PartListenerAdapter;
import com.aptana.ide.core.ui.PreferenceUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.search.internal.ui.OpenSearchDialogAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.navigator.ResourceNavigator;

public class AptanaNavigator
extends ResourceNavigator {
    public static final String ID = "com.aptana.ide.core.ui.AptanaNavigator";
    public static final String EXTENSION_NAME = "decorator";
    public static final String EXTENSION_POINT = String.valueOf(CoreUIPlugin.ID) + "." + "decorator";
    public static final String CLASS_ATTRIBUTE = "class";
    private Map<String, List<IResourceChangeListener>> naturesToListenerLists = null;
    private Map<IProject, String[]> projectsToNatureArrays = new HashMap<IProject, String[]>();
    private List<IResourceChangeListener> globalListeners = null;
    private IHandlerActivation searchHandlerActivation;
    private static final IPartListener partListener = new PartListenerAdapter(){

        public void partOpened(IWorkbenchPart part) {
            IViewPart viewPart;
            if (part instanceof IViewPart && AptanaNavigator.ID.equals((viewPart = (IViewPart)part).getSite().getId())) {
                IConfigurationElement[] elements;
                IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
                int n = 0;
                int n2 = iConfigurationElementArray.length;
                while (n < n2) {
                    String className;
                    IConfigurationElement element = iConfigurationElementArray[n];
                    if (AptanaNavigator.EXTENSION_NAME.equals(element.getName()) && (className = element.getAttribute(AptanaNavigator.CLASS_ATTRIBUTE)) != null) {
                        try {
                            Object client = element.createExecutableExtension(AptanaNavigator.CLASS_ATTRIBUTE);
                            if (client instanceof INavigatorDecorator) {
                                ((INavigatorDecorator)client).addDecorator(((AptanaNavigator)viewPart).getTreeViewer().getTree());
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    ++n;
                }
                viewPart.getSite().getWorkbenchWindow().getPartService().removePartListener(partListener);
            }
        }
    };

    public AptanaNavigator() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new org.eclipse.core.resources.IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                AptanaNavigator.this.notifyListeners(event);
            }
        });
    }

    private void notifyListeners(IResourceChangeEvent event) {
        IResourceDelta delta;
        if (this.naturesToListenerLists == null) {
            this.loadConfigurationExtensionPoints();
        }
        if ((delta = event.getDelta()) != null) {
            IResourceDelta[] deltas = delta.getAffectedChildren();
            int i = 0;
            while (i < deltas.length) {
                if (deltas[i].getKind() == 2 && deltas[i].getMovedToPath() == null && deltas[i].getResource() instanceof IProject) {
                    this.fireCollectDeletions((IProject)deltas[i].getResource(), event);
                } else {
                    IProject project = deltas[i].getResource().getProject();
                    if (project != null) {
                        this.fireResourceEvent(project, event);
                        this.projectsToNatureArrays.remove(project);
                    }
                }
                ++i;
            }
        } else if (event.getType() == 4 && event.getResource() instanceof IProject) {
            IProject project = (IProject)event.getResource();
            try {
                String[] natures = project.getDescription().getNatureIds();
                this.projectsToNatureArrays.put(project, natures);
            }
            catch (CoreException coreException) {}
        }
    }

    public void setFocus() {
        super.setFocus();
        IHandlerService serv = (IHandlerService)this.getViewSite().getService(IHandlerService.class);
        if (this.searchHandlerActivation != null) {
            serv.deactivateHandler(this.searchHandlerActivation);
        }
        ActionHandler searchHandler = new ActionHandler((IAction)new OpenSearchDialogAction());
        this.searchHandlerActivation = serv.activateHandler("org.eclipse.search.ui.openSearchDialog", (IHandler)searchHandler);
    }

    public void dispose() {
        if (this.searchHandlerActivation != null) {
            IHandlerService serv = (IHandlerService)this.getViewSite().getService(IHandlerService.class);
            serv.deactivateHandler(this.searchHandlerActivation);
        }
        super.dispose();
    }

    private void fireCollectDeletions(IProject project, IResourceChangeEvent event) {
        String[] natures;
        ArrayList configurations;
        block7: {
            configurations = new ArrayList();
            natures = new String[]{};
            try {
                natures = project.getDescription().getNatureIds();
            }
            catch (CoreException coreException) {
                if (!this.projectsToNatureArrays.containsKey(project)) break block7;
                natures = this.projectsToNatureArrays.remove(project);
            }
        }
        int i = 0;
        while (i < natures.length) {
            if (this.naturesToListenerLists.containsKey(natures[i])) {
                List<IResourceChangeListener> natureListeners = this.naturesToListenerLists.get(natures[i]);
                int j = 0;
                while (j < natureListeners.size()) {
                    configurations.addAll(Arrays.asList(natureListeners.get(j).getDeleteCandidates(project, event)));
                    ++j;
                }
            }
            int j = 0;
            while (j < this.globalListeners.size()) {
                configurations.addAll(Arrays.asList(this.globalListeners.get(j).getDeleteCandidates(project, event)));
                ++j;
            }
            ++i;
        }
        if (configurations.size() > 0) {
            UIJob dialogJob = new UIJob("Open delete candidates"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    DeleteConfigurationsDialog dialog = new DeleteConfigurationsDialog(AptanaNavigator.this.getViewSite().getShell(), configurations);
                    dialog.open();
                    return Status.OK_STATUS;
                }
            };
            dialogJob.schedule();
        }
    }

    private void fireResourceEvent(IProject project, IResourceChangeEvent event) {
        try {
            String[] natures = project.getDescription().getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if (this.naturesToListenerLists.containsKey(natures[i])) {
                    List<IResourceChangeListener> natureListeners = this.naturesToListenerLists.get(natures[i]);
                    int j = 0;
                    while (j < natureListeners.size()) {
                        natureListeners.get(j).resourceChanged(event);
                        ++j;
                    }
                }
                int j = 0;
                while (j < this.globalListeners.size()) {
                    this.globalListeners.get(j).resourceChanged(event);
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    private void loadConfigurationExtensionPoints() {
        this.naturesToListenerLists = new HashMap<String, List<IResourceChangeListener>>();
        this.globalListeners = new ArrayList<IResourceChangeListener>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint(String.valueOf(CoreUIPlugin.ID) + ".configuration");
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] ce = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < ce.length) {
                String nature = ce[j].getAttribute("nature");
                String listenerClass = ce[j].getAttribute("handler");
                if (listenerClass != null) {
                    try {
                        Object listener = ce[j].createExecutableExtension("handler");
                        if (listener instanceof IResourceChangeListener) {
                            if (nature != null) {
                                List<Object> natureListenerList = null;
                                if (this.naturesToListenerLists.containsKey(nature)) {
                                    natureListenerList = this.naturesToListenerLists.get(nature);
                                } else {
                                    natureListenerList = new ArrayList();
                                    this.naturesToListenerLists.put(nature, natureListenerList);
                                }
                                natureListenerList.add((IResourceChangeListener)listener);
                            } else {
                                this.globalListeners.add((IResourceChangeListener)listener);
                            }
                        }
                    }
                    catch (CoreException coreException) {}
                }
                ++j;
            }
            ++i;
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        Separator sep = new Separator("additions");
        manager.add((IContributionItem)sep);
        sep = new Separator("helpEnd");
        manager.add((IContributionItem)sep);
        Tree tree = this.getTreeViewer().getTree();
        PreferenceUtils.registerBackgroundColorPreference((Control)tree, "com.aptana.ide.core.ui.background.color.navigator");
        PreferenceUtils.registerForegroundColorPreference((Control)tree, "com.aptana.ide.core.ui.foreground.color.navigator");
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(partListener);
    }

    protected void restoreState(IMemento memento) {
    }
}

