/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import com.aptana.ide.core.AptanaAuthenticator;
import com.aptana.ide.core.licensing.ClientKey;
import com.aptana.ide.core.licensing.ClientKeyService;
import com.aptana.ide.core.online.OnlineDetectionService;
import com.aptana.ide.core.ui.AutoOpenPerspectivesJob;
import com.aptana.ide.core.ui.PartListenerAdapter;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.update.internal.ui.UpdateUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CoreUIPlugin
extends AbstractUIPlugin {
    private static CoreUIPlugin plugin;
    private ResourceBundle resourceBundle;
    private static Hashtable<String, Image> images;
    private AptanaAuthenticator aptanaAuth;
    public static String ID;
    public static final String WIZARD_EXTENSION_POINT;
    private final IPartListener partListener = new PartListenerAdapter(){

        public void partOpened(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                CoreUIPlugin.this.checkPortal((IEditorPart)part, false);
            }
        }

        public void partClosed(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                CoreUIPlugin.this.checkPortal((IEditorPart)part, true);
            }
        }
    };
    private final IWindowListener windowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            IPartService partService = window.getPartService();
            if (partService != null) {
                partService.removePartListener(CoreUIPlugin.this.partListener);
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
            IPartService partService = window.getPartService();
            if (partService != null) {
                partService.addPartListener(CoreUIPlugin.this.partListener);
            }
        }
    };

    static {
        images = new Hashtable();
        ID = "com.aptana.ide.core.ui";
        WIZARD_EXTENSION_POINT = String.valueOf(ID) + ".wizard";
    }

    public CoreUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        UpdateUI.getDefault();
        this.aptanaAuth = new AptanaAuthenticator();
        Authenticator.setDefault((Authenticator)this.aptanaAuth);
        AutoOpenPerspectivesJob job = new AutoOpenPerspectivesJob();
        job.setSystem(true);
        job.setPriority(50);
        job.schedule(5000L);
        this.addPartListener();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.removePartListener();
        }
        finally {
            super.stop(context);
            plugin = null;
        }
    }

    public static Image getImage(String path) {
        if (images.get(path) == null) {
            ImageDescriptor id = CoreUIPlugin.getImageDescriptor(path);
            if (id == null) {
                return null;
            }
            Image i = id.createImage();
            images.put(path, i);
            return i;
        }
        return images.get(path);
    }

    public static CoreUIPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)path);
    }

    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            try {
                this.resourceBundle = ResourceBundle.getBundle("com.aptana.ide.core.ui.update.UpdateSchedulerResources");
            }
            catch (MissingResourceException missingResourceException) {
                this.resourceBundle = null;
            }
        }
        return this.resourceBundle;
    }

    public static String getPluginId() {
        return CoreUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void logException(Throwable e) {
        CoreUIPlugin.logException(e, true);
    }

    public static void logException(Throwable e, boolean showErrorDialog) {
        Throwable exception = e;
        if (exception instanceof InvocationTargetException) {
            exception = ((InvocationTargetException)exception).getTargetException();
        }
        IStatus status = null;
        if (exception instanceof CoreException) {
            status = ((CoreException)exception).getStatus();
        } else {
            String message = exception.getMessage();
            if (message == null) {
                message = exception.toString();
            }
            status = new Status(4, CoreUIPlugin.getPluginId(), 0, message, exception);
        }
        CoreUIPlugin.log(status, showErrorDialog);
    }

    public static void log(IStatus status, boolean showErrorDialog) {
        if (status.getSeverity() != 1) {
            if (showErrorDialog) {
                ErrorDialog.openError((Shell)CoreUIPlugin.getActiveWorkbenchShell(), null, null, (IStatus)status);
            }
            Bundle bundle = Platform.getBundle((String)"org.eclipse.update.scheduler");
            Platform.getLog((Bundle)bundle).log(status);
        } else {
            MessageDialog.openInformation((Shell)CoreUIPlugin.getActiveWorkbenchShell(), null, (String)status.getMessage());
        }
    }

    public static IWorkbenchPage getActivePage() {
        CoreUIPlugin plugin = CoreUIPlugin.getDefault();
        IWorkbenchWindow window = plugin.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static final ClientKey getActivationKey() {
        return ClientKeyService.getClientKey();
    }

    public static boolean isKeyValid() {
        ClientKey key = ClientKeyService.getClientKey();
        return key != null ? key.isValid() : false;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = CoreUIPlugin.getActiveWorkbenchWindow();
        return window != null ? window.getShell() : null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return CoreUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    private void addPartListener() {
        IWorkbenchWindow[] workbenchWindows;
        IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = 0;
        int n2 = iWorkbenchWindowArray.length;
        while (n < n2) {
            IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n];
            IPartService partService = workbenchWindow.getPartService();
            if (partService != null) {
                partService.addPartListener(this.partListener);
            }
            ++n;
        }
        PlatformUI.getWorkbench().addWindowListener(this.windowListener);
    }

    private void removePartListener() {
        IWorkbenchWindow[] workbenchWindows;
        IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = 0;
        int n2 = iWorkbenchWindowArray.length;
        while (n < n2) {
            IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n];
            IPartService partService = workbenchWindow.getPartService();
            if (partService != null) {
                partService.removePartListener(this.partListener);
            }
            ++n;
        }
        PlatformUI.getWorkbench().removeWindowListener(this.windowListener);
    }

    private void checkPortal(IEditorPart part, boolean closed) {
        if ("com.aptana.ide.server.jetty.PortalEditor".equals(part.getSite().getId())) {
            OnlineDetectionService.getInstance().setDelay(closed);
        }
    }
}

