/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import java.util.Hashtable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class InitialTitleStartup
implements IStartup {
    protected IPerspectiveListener perpListener;
    protected Hashtable<IWorkbenchWindow, IPerspectiveListener> windows = new Hashtable();

    public void earlyStartup() {
        if (!CoreUIUtils.isInstalledAsPlugin()) {
            return;
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        this.perpListener = new IPerspectiveListener(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                InitialTitleStartup.this.changeWindowTitle();
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            }
        };
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow w = workbench.getActiveWorkbenchWindow();
                InitialTitleStartup.this.addListenerToWindow(w);
            }
        });
        this.addWindowListener(workbench);
    }

    private void addWindowListener(IWorkbench workbench) {
        workbench.addWindowListener(new IWindowListener(){

            public void windowActivated(IWorkbenchWindow window) {
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
                window.removePerspectiveListener(InitialTitleStartup.this.perpListener);
                if (InitialTitleStartup.this.windows.contains(window)) {
                    InitialTitleStartup.this.windows.remove(window);
                }
            }

            public void windowOpened(IWorkbenchWindow window) {
                if (!InitialTitleStartup.this.windows.contains(window)) {
                    InitialTitleStartup.this.addListenerToWindow(window);
                    InitialTitleStartup.this.windows.put(window, InitialTitleStartup.this.perpListener);
                }
            }
        });
    }

    private void addListenerToWindow(IWorkbenchWindow w) {
        if (w == null) {
            return;
        }
        IWorkbenchPage page = w.getActivePage();
        if (page != null) {
            this.changeWindowTitle();
            w.addPerspectiveListener(this.perpListener);
        }
    }

    private void changeWindowTitle() {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                String text = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getText();
                text = CoreUIPlugin.isKeyValid() && CoreUIUtils.isFeatureInstalled("com.aptana.ide.feature.professional") ? text.replaceAll("Aptana -", "Aptana Studio Professional -") : text.replaceAll("Aptana -", "Aptana Studio Community Edition -");
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setText(text);
            }
        });
    }
}

