/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.user;

import com.aptana.ide.core.model.IServiceProvider;
import com.aptana.ide.core.model.IServiceRequestBuilder;
import com.aptana.ide.core.model.RESTServiceProvider;
import com.aptana.ide.core.model.ServiceError;
import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.core.model.user.User;
import com.aptana.ide.core.model.user.UserRequestBuilder;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AptanaSignInWidget
extends Window {
    public static final String FORGOT_PASSWORD = "http://id.aptana.com/reset_password";
    private Composite displayArea;
    private Link betaLabel;
    private Label signInIcon;
    private Label mainTitle;
    private Label subTitle;
    private Label errorIcon;
    private Label errorText;
    private Button existingUser;
    private Button newUser;
    private Link whatIsIt;
    private Label usernameLabel;
    private Text username;
    private Label passwordLabel;
    private Text password;
    private Label passwordAgainLabel;
    private Text passwordAgain;
    private Label emailLabel;
    private Text email;
    private Label emailAgainLabel;
    private Text emailAgain;
    private Label firstNameLabel;
    private Text firstName;
    private Label lastNameLabel;
    private Text lastName;
    private Link forgotPassword;
    private Button createId;
    private Button signIn;
    private Button cancel;
    private Font header;
    private boolean userCreated = false;
    private SelectionAdapter signInAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            User user = new User(AptanaSignInWidget.this.username.getText().toLowerCase(), AptanaSignInWidget.this.password.getText(), null, null, null, null, null);
            try {
                user.setDefaultLocation(new URL(AptanaUser.LOGINS));
                user.setServiceProvider((IServiceProvider)new RESTServiceProvider());
                user.setRequestBuilder((IServiceRequestBuilder)new UserRequestBuilder());
                AptanaUser.signOut();
                user.update();
                if (user.hasLocation()) {
                    user.update();
                    AptanaUser.signIn((String)AptanaSignInWidget.this.username.getText().toLowerCase(), (String)AptanaSignInWidget.this.password.getText(), (URL)user.getLocation(), (String)user.getId());
                    AptanaSignInWidget.this.close();
                } else if (user.getLastServiceErrors() != null && ((ServiceError[])user.getLastServiceErrors().getItems()).length > 0) {
                    String message = ((ServiceError[])user.getLastServiceErrors().getItems())[0].getMessage();
                    if (message.length() > 1) {
                        message = String.valueOf(message.substring(0, 1).toUpperCase()) + message.substring(1, message.length());
                    }
                    AptanaSignInWidget.this.errorText.setText(message);
                    AptanaSignInWidget.this.errorIcon.setVisible(true);
                } else {
                    AptanaSignInWidget.this.errorText.setText("Aptana ID could not be verified");
                    AptanaSignInWidget.this.errorIcon.setVisible(true);
                }
            }
            catch (MalformedURLException malformedURLException) {
                AptanaSignInWidget.this.errorText.setText("Aptana ID could not be verified");
                AptanaSignInWidget.this.errorIcon.setVisible(true);
            }
        }
    };
    private KeyAdapter signInKeyAdapter = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            if ((e.character == '\r' || e.character == '\n') && AptanaSignInWidget.this.existingUser.getSelection() && AptanaSignInWidget.this.signIn.getEnabled()) {
                AptanaSignInWidget.this.signInAdapter.widgetSelected(null);
            }
        }
    };

    public AptanaSignInWidget(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(AptanaSignInWidget.getDefaultOrientation() | 0x10 | 0x10000 | 0x860);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Aptana ID");
    }

    private void createFooter(Composite parent) {
        Composite bottom = new Composite(parent, 0);
        bottom.setLayout((Layout)new GridLayout(3, false));
        bottom.setLayoutData((Object)new GridData(4, 4, true, false));
        this.cancel = new Button(bottom, 8);
        this.cancel.setText("Cancel");
        this.cancel.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        this.cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AptanaSignInWidget.this.close();
            }
        });
        this.signIn = new Button(bottom, 8);
        this.signIn.setText("Sign In");
        this.signIn.setEnabled(false);
        parent.getShell().setDefaultButton(this.signIn);
        this.signIn.setLayoutData((Object)new GridData(0x1000008, 4, false, false));
        this.signIn.addSelectionListener((SelectionListener)this.signInAdapter);
    }

    private void createHeader(Composite parent) {
        final Composite top = new Composite(parent, 0);
        top.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.fillGradientRectangle(0, top.getSize().y - 5, top.getSize().x, 5, true);
            }
        });
        GridLayout tLayout = new GridLayout(2, false);
        top.setLayout((Layout)tLayout);
        top.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite left = new Composite(top, 0);
        left.setLayout((Layout)new GridLayout(1, true));
        left.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mainTitle = new Label(left, 16384);
        this.mainTitle.setFont(this.header);
        this.mainTitle.setText("Sign in to Aptana");
        this.mainTitle.setLayoutData((Object)new GridData(4, 128, true, true));
        this.signInIcon = new Label(top, 16384);
        this.signInIcon.setImage(CoreUIPlugin.getImage("icons/aptana_dialog_tag.png"));
        this.signInIcon.setLayoutData((Object)new GridData(0x1000008, 4, false, false));
        Composite bottom = new Composite(left, 0);
        bottom.setLayout((Layout)new GridLayout(3, false));
        bottom.setLayoutData((Object)new GridData(4, 4, true, false));
        this.subTitle = new Label(bottom, 16384);
        this.subTitle.setText("Sign in using your Aptana ID.");
        this.subTitle.setLayoutData((Object)new GridData(4, 0x1000008, false, false));
        this.errorIcon = new Label(bottom, 0);
        this.errorIcon.setImage(CoreUIPlugin.getImage("icons/error.png"));
        this.errorIcon.setVisible(false);
        this.errorText = new Label(bottom, 0);
        this.errorText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.errorText.setForeground(this.errorText.getDisplay().getSystemColor(4));
    }

    private void createBottom(Composite parent) {
        Composite threeColumns = new Composite(parent, 0);
        GridLayout tcLayout = new GridLayout(3, false);
        threeColumns.setLayout((Layout)tcLayout);
        threeColumns.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLeftColumn(threeColumns);
        this.createMiddleColumn(threeColumns);
        this.createRightColumn(threeColumns);
    }

    private void validate() {
        this.errorText.setText("");
        this.errorIcon.setVisible(false);
        if (this.newUser.getSelection()) {
            if (this.username.getText().trim().length() < 1) {
                this.errorText.setText("User name must be entered");
                this.errorIcon.setVisible(true);
                this.createId.setEnabled(false);
                return;
            }
            if (this.password.getText().trim().length() < 1) {
                this.errorText.setText("Password must be entered");
                this.errorIcon.setVisible(true);
                this.createId.setEnabled(false);
                return;
            }
            if (!this.password.getText().equals(this.passwordAgain.getText())) {
                this.errorText.setText("Passwords do not match");
                this.errorIcon.setVisible(true);
                this.createId.setEnabled(false);
                return;
            }
            if (this.email.getText().trim().length() < 1) {
                this.errorText.setText("Email address must be entered");
                this.errorIcon.setVisible(true);
                this.createId.setEnabled(false);
                return;
            }
            if (!this.email.getText().trim().equals(this.emailAgain.getText().trim())) {
                this.errorText.setText("Email addresses do not match");
                this.errorIcon.setVisible(true);
                this.createId.setEnabled(false);
                return;
            }
            this.createId.setEnabled(true);
        } else if (this.existingUser.getSelection()) {
            if (this.username.getText().trim().length() < 1) {
                this.errorText.setText("User name must be entered");
                this.errorIcon.setVisible(true);
                this.signIn.setEnabled(false);
                return;
            }
            if (this.password.getText().trim().length() < 1) {
                this.errorText.setText("Password must be entered");
                this.errorIcon.setVisible(true);
                this.signIn.setEnabled(false);
                return;
            }
            this.signIn.setEnabled(true);
        }
    }

    private void createLeftColumn(Composite parent) {
        Composite left = new Composite(parent, 0);
        left.setLayout((Layout)new GridLayout(1, true));
        GridData lData = new GridData(4, 4, true, true);
        lData.widthHint = 250;
        left.setLayoutData((Object)lData);
        this.existingUser = new Button(left, 16);
        this.existingUser.setSelection(true);
        this.existingUser.setText("I'm an existing user.");
        this.existingUser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AptanaSignInWidget.this.forgotPassword.setVisible(AptanaSignInWidget.this.existingUser.getSelection());
                AptanaSignInWidget.this.signIn.setEnabled(AptanaSignInWidget.this.existingUser.getSelection());
                AptanaSignInWidget.this.validate();
            }
        });
        this.newUser = new Button(left, 16);
        this.newUser.setText("Create a new Aptana ID");
        this.newUser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = AptanaSignInWidget.this.newUser.getSelection();
                GridData changing = (GridData)AptanaSignInWidget.this.email.getLayoutData();
                changing.exclude = !selected;
                AptanaSignInWidget.this.email.setVisible(selected);
                changing = (GridData)AptanaSignInWidget.this.emailAgain.getLayoutData();
                changing.exclude = !selected;
                AptanaSignInWidget.this.emailAgain.setVisible(selected);
                changing = (GridData)AptanaSignInWidget.this.passwordAgain.getLayoutData();
                changing.exclude = !selected;
                AptanaSignInWidget.this.passwordAgain.setVisible(selected);
                changing = (GridData)AptanaSignInWidget.this.firstName.getLayoutData();
                changing.exclude = !selected;
                AptanaSignInWidget.this.firstName.setVisible(selected);
                changing = (GridData)AptanaSignInWidget.this.lastName.getLayoutData();
                changing.exclude = !selected;
                AptanaSignInWidget.this.lastName.setVisible(selected);
                changing = (GridData)AptanaSignInWidget.this.createId.getLayoutData();
                changing.grabExcessVerticalSpace = selected;
                AptanaSignInWidget.this.createId.setVisible(selected);
                AptanaSignInWidget.this.passwordAgainLabel.setVisible(selected);
                changing = (GridData)AptanaSignInWidget.this.passwordAgainLabel.getLayoutData();
                changing.exclude = !selected;
                AptanaSignInWidget.this.emailAgainLabel.setVisible(selected);
                changing = (GridData)AptanaSignInWidget.this.emailAgainLabel.getLayoutData();
                changing.exclude = !selected;
                AptanaSignInWidget.this.emailLabel.setVisible(selected);
                changing = (GridData)AptanaSignInWidget.this.emailLabel.getLayoutData();
                changing.exclude = !selected;
                AptanaSignInWidget.this.firstNameLabel.setVisible(selected);
                changing = (GridData)AptanaSignInWidget.this.firstNameLabel.getLayoutData();
                changing.exclude = !selected;
                AptanaSignInWidget.this.lastNameLabel.setVisible(selected);
                changing = (GridData)AptanaSignInWidget.this.lastNameLabel.getLayoutData();
                changing.exclude = !selected;
                AptanaSignInWidget.this.displayArea.layout(true, true);
                AptanaSignInWidget.this.getShell().setSize(AptanaSignInWidget.this.getShell().computeSize(-1, -1));
            }
        });
        this.whatIsIt = new Link(left, 0);
        this.whatIsIt.setText("<a>What is an Aptana ID?</a>");
        this.whatIsIt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreUIUtils.openBrowserURL("http://www.aptana.com/aptana_id");
            }
        });
        this.betaLabel = new Link(left, 64);
        this.betaLabel.setText("\n**BETA USERS***\nWe're going to change this flow, but in the meantime, please go ahead and create a new Aptana ID.  While this is yet another username/password pair, <a>Aptana IDs</a> will eventually become the single sign-on system for Aptana.\n\nNote: To access forums, the bug database, and other Aptana services requiring logins, continue to use those separate usernames and passwords.");
        this.betaLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreUIUtils.openBrowserURL("http://www.aptana.com/aptana_id");
            }
        });
        this.betaLabel.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    private void createMiddleColumn(Composite parent) {
        Composite middle = new Composite(parent, 0);
        middle.setLayout((Layout)new GridLayout(2, false));
        middle.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData textData = new GridData(4, 4, true, false);
        textData.minimumWidth = 125;
        GridData hideData = new GridData(4, 4, true, false);
        hideData.minimumWidth = 125;
        hideData.exclude = true;
        GC gc = new GC((Drawable)middle);
        int x = gc.stringExtent((String)"Password Again:").x;
        gc.dispose();
        GridData firstData = new GridData(0x1000008, 4, false, false);
        firstData.widthHint = x + 10;
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AptanaSignInWidget.this.validate();
            }
        };
        this.usernameLabel = new Label(middle, 16384);
        this.usernameLabel.setText("Username:");
        this.usernameLabel.setLayoutData((Object)new GridData(0x1000008, 4, false, false));
        this.username = new Text(middle, 2052);
        this.username.setLayoutData((Object)textData);
        this.username.addKeyListener((KeyListener)this.signInKeyAdapter);
        this.username.forceFocus();
        if (AptanaUser.getSignedInUser().hasCredentials()) {
            this.username.setText(AptanaUser.getSignedInUser().getUsername());
        }
        this.username.addModifyListener(listener);
        this.passwordLabel = new Label(middle, 16384);
        this.passwordLabel.setText("Password:");
        this.passwordLabel.setLayoutData((Object)new GridData(0x1000008, 4, false, false));
        this.password = new Text(middle, 0x400804);
        this.password.setLayoutData((Object)textData);
        this.password.addModifyListener(listener);
        this.password.addKeyListener((KeyListener)this.signInKeyAdapter);
        GridData hideLabelData = new GridData(0x1000008, 4, false, false);
        hideLabelData.exclude = true;
        GridData elData = new GridData(0x1000008, 4, false, false);
        elData.verticalIndent = 10;
        elData.exclude = true;
        GridData palData = new GridData(0x1000008, 4, false, false);
        palData.exclude = true;
        this.passwordAgainLabel = new Label(middle, 16384);
        this.passwordAgainLabel.setText("Password Again:");
        this.passwordAgainLabel.setLayoutData((Object)palData);
        this.passwordAgain = new Text(middle, 0x400804);
        this.passwordAgain.setLayoutData((Object)hideData);
        this.passwordAgain.setVisible(false);
        this.passwordAgain.addModifyListener(listener);
        GridData eData = new GridData(4, 4, true, false);
        eData.verticalIndent = 10;
        eData.exclude = true;
        this.emailLabel = new Label(middle, 16384);
        this.emailLabel.setText("Email:");
        this.emailLabel.setLayoutData((Object)elData);
        this.email = new Text(middle, 2052);
        this.email.setLayoutData((Object)eData);
        this.email.setVisible(false);
        this.email.addModifyListener(listener);
        this.emailAgainLabel = new Label(middle, 16384);
        this.emailAgainLabel.setText("Email Again:");
        this.emailAgainLabel.setLayoutData((Object)hideLabelData);
        this.emailAgain = new Text(middle, 2052);
        this.emailAgain.setLayoutData((Object)hideData);
        this.emailAgain.setVisible(false);
        this.emailAgain.addModifyListener(listener);
        this.firstNameLabel = new Label(middle, 16384);
        this.firstNameLabel.setText("First Name:");
        this.firstNameLabel.setLayoutData((Object)hideLabelData);
        this.firstName = new Text(middle, 2052);
        this.firstName.setLayoutData((Object)hideData);
        this.firstName.setVisible(false);
        this.firstName.addModifyListener(listener);
        this.lastNameLabel = new Label(middle, 16384);
        this.lastNameLabel.setText("Last Name:");
        this.lastNameLabel.setLayoutData((Object)hideLabelData);
        this.lastName = new Text(middle, 2052);
        this.lastName.setLayoutData((Object)hideData);
        this.lastName.setVisible(false);
        this.lastName.addModifyListener(listener);
        new Label(middle, 16384).setLayoutData((Object)firstData);
        new Label(middle, 16384);
    }

    private void createRightColumn(Composite parent) {
        Composite right = new Composite(parent, 0);
        right.setLayout((Layout)new GridLayout(1, true));
        right.setLayoutData((Object)new GridData(4, 4, true, true));
        this.forgotPassword = new Link(right, 0);
        this.forgotPassword.setText("<a>Forgot Password?</a>");
        this.forgotPassword.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        this.forgotPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreUIUtils.openBrowserURL(AptanaSignInWidget.FORGOT_PASSWORD);
            }
        });
        GridData bData = new GridData(0x1000008, 0x1000008, false, true);
        this.createId = new Button(right, 8);
        this.createId.setEnabled(false);
        this.createId.setLayoutData((Object)bData);
        this.createId.setText("Create Aptana ID");
        this.createId.setVisible(false);
        this.createId.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    User user = new User(AptanaSignInWidget.this.username.getText().toLowerCase(), AptanaSignInWidget.this.password.getText(), AptanaSignInWidget.this.email.getText(), AptanaSignInWidget.this.firstName.getText(), AptanaSignInWidget.this.lastName.getText(), null, null);
                    user.setDefaultLocation(new URL(AptanaUser.USERS));
                    user.setServiceProvider((IServiceProvider)new RESTServiceProvider());
                    user.setRequestBuilder((IServiceRequestBuilder)new UserRequestBuilder());
                    user.commit();
                    if (user.hasLocation() && user.getLastServiceErrors() == null) {
                        user.update();
                        AptanaUser.signIn((String)AptanaSignInWidget.this.username.getText().toLowerCase(), (String)AptanaSignInWidget.this.password.getText(), (URL)user.getLocation(), (String)user.getId());
                        AptanaSignInWidget.this.userCreated = true;
                        AptanaSignInWidget.this.close();
                    } else if (user.getLastServiceErrors() != null && ((ServiceError[])user.getLastServiceErrors().getItems()).length > 0) {
                        String message = ((ServiceError[])user.getLastServiceErrors().getItems())[0].getMessage();
                        if (message.length() > 1) {
                            message = String.valueOf(message.substring(0, 1).toUpperCase()) + message.substring(1, message.length());
                        }
                        AptanaSignInWidget.this.errorText.setText(message);
                        AptanaSignInWidget.this.errorIcon.setVisible(true);
                    } else {
                        AptanaSignInWidget.this.errorText.setText("Aptana ID could not be created");
                        AptanaSignInWidget.this.errorIcon.setVisible(true);
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
        });
    }

    protected Control createContents(Composite parent) {
        this.header = new Font((Device)parent.getDisplay(), "Arial", 13, 1);
        this.displayArea = new Composite(parent, 0);
        this.displayArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AptanaSignInWidget.this.header != null && !AptanaSignInWidget.this.header.isDisposed()) {
                    AptanaSignInWidget.this.header.dispose();
                }
            }
        });
        GridLayout daLayout = new GridLayout(1, true);
        this.displayArea.setLayout((Layout)daLayout);
        GridData daData = new GridData(4, 4, true, true);
        this.displayArea.setLayoutData((Object)daData);
        this.createHeader(this.displayArea);
        this.createBottom(this.displayArea);
        this.createFooter(this.displayArea);
        return this.displayArea;
    }

    public boolean isUserCreated() {
        return this.userCreated;
    }
}

