/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.user;

import com.aptana.ide.core.ui.IValidator;
import com.aptana.ide.core.ui.widgets.IEnableWidget;
import com.aptana.ide.core.ui.widgets.IValidatedWidget;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AptanaUserCreateWidget
implements IValidatedWidget,
IEnableWidget {
    private Composite displayArea;
    private Label usernameLabel;
    private Text usernameText;
    private Label passwordLabel;
    private Text passwordText;
    private Label emailLabel;
    private Text emailText;
    private StringBuffer username = new StringBuffer();
    private StringBuffer password = new StringBuffer();
    private StringBuffer email = new StringBuffer();
    private String error;
    private IValidator validator;
    private boolean canStartValidation = false;

    public void setBackground(Color color) {
        this.displayArea.setBackground(color);
        this.usernameLabel.setBackground(color);
        this.passwordLabel.setBackground(color);
        this.emailLabel.setBackground(color);
    }

    public void setForeground(Color color) {
        this.usernameLabel.setForeground(color);
        this.passwordLabel.setForeground(color);
        this.emailLabel.setForeground(color);
    }

    public void setEnabled(boolean enabled) {
        this.usernameText.setEnabled(enabled);
        this.passwordText.setEnabled(enabled);
        this.emailText.setEnabled(enabled);
    }

    public void setValidator(IValidator validator) {
        this.validator = validator;
        if (this.validator != null) {
            this.validate();
            if (this.validator != null && this.canStartValidation) {
                this.validator.validate();
            }
        }
    }

    private void attachListener(final Text field, final StringBuffer data) {
        field.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                data.delete(0, data.length());
                data.append(field.getText());
                AptanaUserCreateWidget.this.validate();
                if (AptanaUserCreateWidget.this.validator != null && AptanaUserCreateWidget.this.canStartValidation) {
                    AptanaUserCreateWidget.this.validator.validate();
                }
            }
        });
    }

    public String getErrorMessage() {
        return this.error;
    }

    private void validate() {
        if (this.username.toString().trim().length() == 0) {
            this.error = "User name cannot be empty";
            return;
        }
        if (this.password.toString().trim().length() == 0) {
            this.error = "Password cannot be empty";
            return;
        }
        if (this.email.toString().trim().length() == 0) {
            this.error = "Email address cannot be empty";
            return;
        }
        this.error = null;
    }

    public void createControl(Composite parent) {
        GridData textData = new GridData(1, 4, true, false);
        textData.widthHint = 150;
        GridData data = new GridData(4, 4, true, true);
        this.displayArea = new Composite(parent, 0);
        this.displayArea.setLayout((Layout)new GridLayout(2, false));
        this.displayArea.setLayoutData((Object)data);
        this.usernameLabel = new Label(this.displayArea, 131072);
        this.usernameLabel.setText("Username:");
        this.usernameLabel.setLayoutData((Object)new GridData(0x1000008, 4, false, false));
        this.usernameText = new Text(this.displayArea, 2052);
        this.usernameText.setLayoutData((Object)textData);
        this.attachListener(this.usernameText, this.username);
        this.passwordLabel = new Label(this.displayArea, 16384);
        this.passwordLabel.setText("Password:");
        this.passwordLabel.setLayoutData((Object)new GridData(0x1000008, 4, false, false));
        this.passwordText = new Text(this.displayArea, 0x400804);
        this.passwordText.setLayoutData((Object)textData);
        this.attachListener(this.passwordText, this.password);
        this.emailLabel = new Label(this.displayArea, 16384);
        this.emailLabel.setText("Email Address:");
        this.emailLabel.setLayoutData((Object)new GridData(0x1000008, 4, false, false));
        this.emailText = new Text(this.displayArea, 2052);
        this.emailText.setLayoutData((Object)textData);
        this.attachListener(this.emailText, this.email);
        this.canStartValidation = true;
    }

    public String getEmail() {
        return this.email.toString();
    }

    public String getPassword() {
        return this.password.toString();
    }

    public String getUsername() {
        return this.username.toString();
    }
}

