/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.user;

import com.aptana.ide.core.model.IModelListener;
import com.aptana.ide.core.model.IModifiableObject;
import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.core.model.user.User;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.WebPerspectiveFactory;
import com.aptana.ide.core.ui.user.AptanaSignInWidget;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.menus.AbstractWorkbenchTrimWidget;
import org.eclipse.ui.progress.UIJob;

public class AptanaUserTrimWidget
extends AbstractWorkbenchTrimWidget {
    private Composite displayArea;
    private Label cloudIcon;
    private Link accountNameLabel;
    private User user = AptanaUser.getSignedInUser();

    public AptanaUserTrimWidget() {
        this.user.addListener(new IModelListener(){

            public void modelChanged(IModifiableObject object) {
                UIJob job = new UIJob("Updating label"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        AptanaUserTrimWidget.this.updateLabel();
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        });
        CoreUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)new PerspectiveAdapter(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                if (AptanaUserTrimWidget.this.displayArea != null && !AptanaUserTrimWidget.this.displayArea.isDisposed()) {
                    AptanaUserTrimWidget.this.displayArea.setVisible(WebPerspectiveFactory.isSameOrDescendantPerspective(perspective));
                }
            }
        });
    }

    private void updateLabel() {
        if (this.accountNameLabel == null || this.accountNameLabel.isDisposed()) {
            return;
        }
        if (this.user.getUsername() != null && this.user.getUsername().length() > 0) {
            this.accountNameLabel.setText("<a>" + this.user.getUsername() + "</a>");
        } else {
            this.accountNameLabel.setText("<a>Sign In</a>");
        }
    }

    public void dispose() {
        if (this.displayArea != null && !this.displayArea.isDisposed()) {
            this.displayArea.dispose();
        }
    }

    public void fill(Composite parent, int oldSide, int newSide) {
        if (this.displayArea == null || this.displayArea.isDisposed()) {
            this.displayArea = new Composite(parent, 0);
            GridLayout daLayout = new GridLayout(2, false);
            daLayout.marginHeight = 2;
            daLayout.marginWidth = 0;
            daLayout.marginLeft = 5;
            this.displayArea.setLayout((Layout)daLayout);
            this.cloudIcon = new Label(this.displayArea, 16384);
            this.cloudIcon.setImage(CoreUIPlugin.getImage("icons/aptana_id.png"));
            this.accountNameLabel = new Link(this.displayArea, 0);
            GridData anlData = new GridData(4, 4, true, true);
            anlData.widthHint = 125;
            this.accountNameLabel.setLayoutData((Object)anlData);
            this.accountNameLabel.setText("<a>Sign In</a>");
            this.accountNameLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AptanaSignInWidget dialog = new AptanaSignInWidget(AptanaUserTrimWidget.this.accountNameLabel.getShell());
                    dialog.open();
                }
            });
            this.updateLabel();
            IWorkbenchPage page = CoreUIPlugin.getActivePage();
            if (page != null && page.getPerspective() != null) {
                this.displayArea.setVisible(WebPerspectiveFactory.isSameOrDescendantPerspective(page.getPerspective()));
            }
        }
    }
}

