/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.wizards;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.EclipseUIUtils;
import com.aptana.ide.core.ui.wizards.BaseProjectCreationPage;
import com.aptana.ide.core.ui.wizards.IBaseWizardPage;
import com.aptana.ide.core.ui.wizards.IProjectCreationWizardPage;
import com.aptana.ide.core.ui.wizards.WizardPageExtensionLoader;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class BaseWizard
extends Wizard
implements INewWizard {
    protected boolean includeProjectPage = true;
    protected IProjectCreationWizardPage projectPage;
    protected IProject project;
    protected IProgressMonitor monitor;
    protected Object initializationData;
    protected boolean creatingHostedSite;
    protected HashSet<String> filteredWizardPages;

    public BaseWizard() {
        this.setNeedsProgressMonitor(true);
        this.initializationData = null;
        this.filteredWizardPages = new HashSet();
    }

    public boolean includeProjectPage() {
        return this.includeProjectPage;
    }

    public void setIncludeProjectPage(boolean include) {
        this.includeProjectPage = include;
    }

    public void setFilteredPages(String[] classes) {
        this.filteredWizardPages.clear();
        this.filteredWizardPages.addAll((Collection<String>)Arrays.asList(classes));
    }

    public String[] getFilteredPages() {
        return this.filteredWizardPages.toArray(new String[this.filteredWizardPages.size()]);
    }

    protected IProject getProjectHandle() {
        IProject projectHandle = null;
        if (this.includeProjectPage) {
            projectHandle = this.projectPage.getProjectHandle();
        }
        return projectHandle;
    }

    protected IPath getProjectPath() {
        IPath path = null;
        if (this.includeProjectPage && !this.projectPage.useDefaults()) {
            path = this.projectPage.getLocationPath();
        }
        return path;
    }

    protected IProjectDescription createProjectDescription(String name, IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(name);
        description.setLocation(path);
        return description;
    }

    public abstract IFile getFileToOpenOnFinish();

    private IProject createNewProject() {
        if (this.project != null) {
            return this.project;
        }
        final IProject newProjectHandle = this.getProjectHandle();
        if (newProjectHandle == null) {
            return null;
        }
        IPath newPath = this.getProjectPath();
        final IProjectDescription description = this.createProjectDescription(newProjectHandle.getName(), newPath);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                if (monitor != null) {
                    monitor.beginTask("Creating project", 2000);
                }
                newProjectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                newProjectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                if (monitor != null) {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)EclipseUIUtils.ResourceMessages_NewProject_errorMessage, (String)NLS.bind((String)EclipseUIUtils.ResourceMessages_NewProject_caseVariantExistsError, (Object)newProjectHandle.getName()));
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)EclipseUIUtils.ResourceMessages_NewProject_errorMessage, null, (IStatus)((CoreException)t).getStatus());
                }
            } else {
                EclipseUIUtils.getIDEWorkbenchPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.ui.ide", 0, t.toString(), t));
                MessageDialog.openError((Shell)this.getShell(), (String)EclipseUIUtils.ResourceMessages_NewProject_errorMessage, (String)NLS.bind((String)EclipseUIUtils.ResourceMessages_NewProject_internalError, (Object)t.getMessage()));
            }
            return null;
        }
        this.project = newProjectHandle;
        return this.project;
    }

    public void setProjectPage(IProjectCreationWizardPage projectPage) {
        this.projectPage = projectPage;
    }

    public void addPages() {
        super.addPages();
        if (this.includeProjectPage) {
            this.projectPage = new BaseProjectCreationPage("projectPage");
            this.projectPage.setInitialProjectName(null);
            this.projectPage.setTitle(EclipseUIUtils.ResourceMessages_NewProject_title);
            this.projectPage.setDescription(EclipseUIUtils.ResourceMessages_NewProject_description);
            this.projectPage.setWizard((IWizard)this);
            this.projectPage.setPageComplete(false);
            this.addPage(this.projectPage);
        }
        this.addExtensionPages();
    }

    protected void addExtensionPages() {
        IWizardPage[] pages;
        IWizardPage[] iWizardPageArray = pages = WizardPageExtensionLoader.createWizardPages(this, this.getID());
        int n = 0;
        int n2 = iWizardPageArray.length;
        while (n < n2) {
            IWizardPage page = iWizardPageArray[n];
            if (!this.filteredWizardPages.contains(page.getClass().getName())) {
                this.addPage(page);
            }
            ++n;
        }
    }

    public abstract void finishProjectCreation();

    public boolean performFinish() {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    BaseWizard.this.createNewProject();
                    try {
                        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                            protected void execute(IProgressMonitor monitor) {
                                IWizardPage[] pages = BaseWizard.this.getPages();
                                int i = 0;
                                while (i < pages.length) {
                                    Object object = (this).BaseWizard.this.monitor = monitor != null ? monitor : new NullProgressMonitor();
                                    if (pages[i] instanceof IBaseWizardPage) {
                                        ((IBaseWizardPage)pages[i]).performFinish();
                                    }
                                    ++i;
                                }
                            }
                        };
                        BaseWizard.this.getContainer().run(false, true, (IRunnableWithProgress)op);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (InterruptedException interruptedException) {}
                    if (monitor != null) {
                        monitor.done();
                    }
                    BaseWizard.this.monitor = monitor != null ? monitor : new NullProgressMonitor();
                    BaseWizard.this.finishProjectCreation();
                    IFile file = BaseWizard.this.getFileToOpenOnFinish();
                    if (file != null) {
                        BaseWizard.this.openFileInEditor(file);
                    }
                    if (BaseWizard.this.project != null) {
                        try {
                            BaseWizard.this.project.refreshLocal(2, monitor);
                        }
                        catch (CoreException e) {
                            IdeLog.logInfo((Plugin)CoreUIPlugin.getDefault(), (String)"Error refreshing newly created project", (Throwable)e);
                        }
                        IProject resource = null;
                        String[] files = BaseWizard.this.getFileNamesToSelect();
                        if (files != null) {
                            int i = 0;
                            while (i < files.length) {
                                resource = BaseWizard.this.project.getFile(files[i]);
                                if (resource != null && resource.exists()) break;
                                ++i;
                            }
                        }
                        if (resource == null || !resource.exists()) {
                            resource = BaseWizard.this.project;
                        }
                        BasicNewResourceWizard.selectAndReveal((IResource)resource, (IWorkbenchWindow)CoreUIPlugin.getActiveWorkbenchWindow());
                    }
                }
            }, null);
        }
        catch (CoreException coreException) {}
        return true;
    }

    private void openFileInEditor(IFile f) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.getEditorDescriptor((String)f.getName());
        }
        catch (PartInitException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)"Error getting editor descriptor", (Throwable)e);
        }
        try {
            IDE.openEditor((IWorkbenchPage)page, (IFile)f, (boolean)true);
        }
        catch (PartInitException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)"Error opening editor", (Throwable)e);
        }
    }

    public IProgressMonitor getFinishProgressMonitor() {
        return this.monitor;
    }

    public IProject getCreatedProject() {
        return this.project;
    }

    public abstract String getID();

    public abstract String[] getFileNamesToSelect();

    public void setInitializationData(Object initializationData) {
        this.initializationData = initializationData;
    }

    public boolean isCreatingHostedSite() {
        return this.creatingHostedSite;
    }

    public void setCreatingHostedSite(boolean creatingHostedSite) {
        this.creatingHostedSite = creatingHostedSite;
    }
}

