/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.core;

import com.aptana.ide.server.IServerListener;
import com.aptana.ide.server.IServerRunnable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ui.PlatformUI;

public final class ServerManager
implements IServerListener {
    private static ServerManager instance;
    private ArrayList serverList = new ArrayList();
    private HashMap serverTable = new HashMap();
    public ArrayList listeners = new ArrayList();

    private ServerManager() {
    }

    public static ServerManager getInstance() {
        if (instance == null) {
            instance = new ServerManager();
        }
        return instance;
    }

    public void launchServer(IServerRunnable server, ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) {
        server.addServerListener(this);
        server.start(configuration, mode, launch, monitor);
    }

    public IServerRunnable[] getRunningServers() {
        return this.serverList.toArray(new IServerRunnable[this.serverList.size()]);
    }

    public IServerRunnable getServer(String serverName) {
        return (IServerRunnable)this.serverTable.get(serverName);
    }

    public void addServerListener(IServerListener listener) {
        this.listeners.add(listener);
    }

    public void removeServerListener(IServerListener listener) {
        this.listeners.add(listener);
    }

    private void fireServerStarted(IServerRunnable server) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((IServerListener)it.next()).serverStarted(server);
        }
    }

    private void fireServerStopped(IServerRunnable server) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((IServerListener)it.next()).serverStopped(server);
        }
    }

    private void fireServerChanged(IServerRunnable server) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((IServerListener)it.next()).serverChanged(server);
        }
    }

    public void serverStarted(final IServerRunnable server) {
        this.serverList.add(server);
        this.serverTable.put(server.getLaunchConfiguration().getName(), server);
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                ServerManager.this.fireServerStarted(server);
            }
        });
    }

    public void serverStopped(final IServerRunnable server) {
        server.removeServerListener(this);
        this.serverList.remove(server);
        this.serverTable.remove(server.getLaunchConfiguration().getName());
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                ServerManager.this.fireServerStopped(server);
            }
        });
    }

    public void serverChanged(final IServerRunnable server) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                ServerManager.this.fireServerChanged(server);
            }
        });
    }
}

