/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.http;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.server.IServerListener;
import com.aptana.ide.server.IServerRunnable;
import com.aptana.ide.server.core.HttpServerLaunchConfiguration;
import com.aptana.ide.server.core.ServerCorePlugin;
import com.aptana.ide.server.core.ServerManager;
import com.aptana.ide.server.http.HttpServer;
import com.aptana.ide.server.http.HttpServerException;
import com.aptana.ide.server.http.RequestLineParser;
import com.aptana.ide.server.logging.IHttpLog;
import com.aptana.ide.server.resolvers.IHttpResourceResolver;
import com.aptana.ide.server.resources.IHttpResource;
import com.aptana.ide.server.resources.WorkspaceHttpFolderResource;
import com.aptana.ide.server.resources.WorkspaceHttpResource;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class HttpServerRunnable
implements IServerRunnable,
IHttpResourceResolver,
IHttpLog {
    private ILaunchConfiguration _launchConfiguration;
    private HttpServerLaunchConfiguration _httpConfiguration;
    private ArrayList _listeners = new ArrayList();
    private HttpServer _httpServer;
    private String _myAddress = this.getFirstNonLocalhostIP();

    public String getBaseURL() {
        return "http://" + this._myAddress + ":" + this._httpServer.getPort() + "/";
    }

    public HttpServerLaunchConfiguration getServerLaunchConfiguration() {
        return this._httpConfiguration;
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return this._launchConfiguration;
    }

    /*
     * Unable to fully structure code
     */
    private String getFirstNonLocalhostIP() {
        try {
            e1 = NetworkInterface.getNetworkInterfaces();
            if (true) ** GOTO lbl16
        }
        catch (SocketException e) {
            IdeLog.logError((Plugin)ServerCorePlugin.getDefault(), (String)("getFirstNonLocalhostIP: " + e.getMessage()), (Throwable)e);
            return "127.0.0.1";
        }
        do {
            ni = e1.nextElement();
            e2 = ni.getInetAddresses();
            while (e2.hasMoreElements()) {
                ia = e2.nextElement();
                addr = ia.getHostAddress();
                parts = addr.split("\\.");
                if (addr.equals("127.0.0.1") || parts.length != 4) continue;
                return addr;
            }
lbl16:
            // 2 sources

        } while (e1.hasMoreElements());
        return "127.0.0.1";
    }

    public void addServerListener(IServerListener listener) {
        this._listeners.add(listener);
    }

    private void fireServerStarted() {
        IServerListener[] listenerArray = this._listeners.toArray(new IServerListener[0]);
        int i = 0;
        while (i < listenerArray.length) {
            listenerArray[i].serverStarted(this);
            ++i;
        }
    }

    private void fireServerStopped() {
        IServerListener[] listenerArray = this._listeners.toArray(new IServerListener[0]);
        int i = 0;
        while (i < listenerArray.length) {
            listenerArray[i].serverStopped(this);
            ++i;
        }
    }

    private static IHttpResource getHttpResourceFromWorkpace(IPath path, IWorkspaceRoot workspace) {
        IResource resource = workspace.findMember(path);
        IHttpResource result = null;
        if (resource != null) {
            result = resource instanceof IFile ? new WorkspaceHttpResource((IFile)resource) : (resource instanceof IContainer ? new WorkspaceHttpFolderResource((IContainer)resource) : new WorkspaceHttpFolderResource((IContainer)workspace));
        }
        return result;
    }

    public IHttpResource getResource(RequestLineParser requestLine) throws HttpServerException {
        Path resourcePath = new Path(requestLine.getUri());
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        return HttpServerRunnable.getHttpResourceFromWorkpace((IPath)resourcePath, workspaceRoot);
    }

    public void logError(String message) {
        this.logError(message, null);
    }

    public void logError(String message, Throwable th) {
        ServerCorePlugin.logError(message, th);
    }

    public void logTrace(String message) {
        IdeLog.logInfo((Plugin)ServerCorePlugin.getDefault(), (String)message);
    }

    public void removeServerListener(IServerListener listener) {
        this._listeners.remove(listener);
    }

    public void start(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) {
        this._launchConfiguration = configuration;
        this._httpConfiguration = new HttpServerLaunchConfiguration(configuration);
        if (this.startHttpServer()) {
            this.fireServerStarted();
        }
    }

    private boolean startHttpServer() {
        String name = this._launchConfiguration.getName();
        IServerRunnable server = ServerManager.getInstance().getServer(name);
        if (server != null) {
            if (!(server instanceof HttpServerRunnable)) {
                throw new IllegalStateException("unexpected launch type");
            }
            this._httpServer = ((HttpServerRunnable)server)._httpServer;
        } else {
            this._httpServer = new HttpServer(this, 8000, 8500);
            try {
                this._httpServer.start();
            }
            catch (IOException e) {
                this.logError(e.getMessage(), e);
            }
        }
        return server == null;
    }

    public void stop() {
        try {
            this._httpServer.stop();
        }
        catch (Exception e) {
            this.logError("Error stopping server", e);
        }
        this.fireServerStopped();
    }
}

