/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.http;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.core.ServerCorePlugin;
import com.aptana.ide.server.http.HttpResponse;
import com.aptana.ide.server.http.HttpResponseUtils;
import com.aptana.ide.server.http.HttpServer;
import com.aptana.ide.server.http.HttpServerException;
import com.aptana.ide.server.http.RequestLineParser;
import com.aptana.ide.server.http.ServerThreadRunnable;
import com.aptana.ide.server.logging.IHttpLog;
import com.aptana.ide.server.resolvers.IHttpResourceResolver;
import com.aptana.ide.server.resources.IHttpFolderResource;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Worker
implements Runnable {
    static final int BUF_SIZE = 2048;
    static final byte[] EOL = new byte[]{13, 10};
    private Socket s = null;
    private ServerThreadRunnable _serverThreadRunnable;
    private HttpServer _server;
    private IHttpResourceResolver _resourceResolver;
    private IHttpLog _logger;
    byte[] buf = new byte[2048];

    Worker() {
    }

    synchronized void setSocket(ServerThreadRunnable serverThreadRunnable, Socket s, HttpServer server, IHttpResourceResolver resourceResolver, IHttpLog logger) {
        this._serverThreadRunnable = serverThreadRunnable;
        this.s = s;
        this._server = server;
        this._resourceResolver = resourceResolver;
        this._logger = logger;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        while (true) {
            Vector pool;
            if (this.s == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            try {
                this.processRequest();
            }
            catch (Exception exception) {}
            this.s = null;
            Vector vector = pool = this._serverThreadRunnable.threads;
            synchronized (vector) {
                if (pool.size() >= this._serverThreadRunnable.workers) {
                    return;
                }
                pool.addElement(this);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processRequest() throws IOException {
        block26: {
            uri = null;
            try {
                is = new BufferedInputStream(this.s.getInputStream());
                this.s.setSoTimeout(this._serverThreadRunnable.timeout);
                this.s.setTcpNoDelay(true);
                i = 0;
                while (true) {
                    block27: {
                        if (i < 2048) break block27;
                        nread = 0;
                        r = 0;
                        if (true) ** GOTO lbl39
                    }
                    this.buf[i] = 0;
                    ++i;
                }
            }
            catch (Exception e) {
                this.sendError(this.s, new HttpServerException(500, "Internal error", uri, null, e));
                IdeLog.logError((Plugin)ServerCorePlugin.getDefault(), (String)"Error", (Throwable)e);
            }
            catch (Throwable var13_19) {
                if (this.s == null) throw var13_19;
                if (this.s.isClosed() != false) throw var13_19;
                this.s.close();
                throw var13_19;
            }
lbl-1000:
            // 2 sources

            {
                while (true) {
                    if (this.s == null) return;
                    if (this.s.isClosed() != false) return;
                    this.s.close();
                    return;
                }
            }
            {
                block25: {
                    while (true) {
                        if (r == -1) ** GOTO lbl-1000
                        i = nread;
                        nread += r;
                        while (i < nread) {
                            if (this.buf[i] != 10 && this.buf[i] != 13) {
                                ++i;
                                continue;
                            }
                            break block25;
                        }
lbl39:
                        // 2 sources

                        if (nread >= 2048) break block25;
                        try {
                            r = is.read(this.buf, nread, 2048 - nread);
                            continue;
                        }
                        catch (SocketException v0) {}
                        break;
                    }
                    ** continue;
                }
                if ((uri = (reqLineParser = new RequestLineParser(reqLine = new String(this.buf))).getUri()) != null && uri.length() > 0) {
                    try {
                        resource = this._resourceResolver.getResource(reqLineParser);
                        if (resource == null) throw new HttpServerException(404, "file not found", uri, "file not found: " + uri);
                        if (resource instanceof IHttpFolderResource) {
                            folderResource = (IHttpFolderResource)resource;
                            if (!uri.endsWith("/")) {
                                this.sendRedirect(this.s, String.valueOf(uri) + "/");
                                break block26;
                            }
                            fileNames = folderResource.getFileNames();
                            folderNames = folderResource.getFolderNames();
                            folderHTML = HttpResponseUtils.createBrowseFolderHTML((IPath)new Path(uri), fileNames, folderNames);
                            if (reqLineParser.getMethod().equals("GET")) {
                                this.sendContent(this.s, folderHTML, "text/html");
                                break block26;
                            }
                            if (reqLineParser.getMethod().equals("HEAD")) {
                                this.sendHeaders(this.s, "text/html");
                            }
                            break block26;
                        }
                        contentInput = resource.getContentInputStream(this._server);
                        length = resource.getContentLength();
                        type = resource.getContentType();
                        try {
                            if (reqLineParser.getMethod().equals("GET")) {
                                this.sendFile(this.s, contentInput, length, type);
                                break block26;
                            }
                            if (reqLineParser.getMethod().equals("HEAD")) {
                                this.sendHeaders(this.s, type);
                            }
                            break block26;
                        }
                        finally {
                            if (contentInput != null) {
                                contentInput.close();
                            }
                        }
                    }
                    catch (HttpServerException e) {
                        this._logger.logTrace(String.valueOf(e.getStatusMessage()) + "-" + e.getRequestUri());
                        this.sendError(this.s, e);
                    }
                    break block26;
                }
                this._logger.logTrace("bad request detected: " + reqLine != null ? reqLine : "request line was empty");
                this.sendError(this.s, new HttpServerException(400, "bad request", uri, null));
            }
        }
        if (this.s == null) return;
        if (this.s.isClosed() != false) return;
        this.s.close();
        return;
        if (this.s == null) return;
        if (this.s.isClosed() != false) return;
        this.s.close();
    }

    private Hashtable<String, String> makeHeaders() {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        headers.put("Server", "Aptana v0.2.7");
        headers.put("Expires", "Mon, 26 Jul 1997 05:00:00 GMT");
        headers.put("Cache-Control", "no-store, no-cache, must-revalidate");
        headers.put("Pragma", "no-cache");
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zZ");
        headers.put("Last-Modified", format.format(new Date()));
        return headers;
    }

    private void sendContent(Socket s, String content, String contentType) throws IOException {
        OutputStream output = s.getOutputStream();
        HttpResponse response = new HttpResponse(output);
        response.sendResponseContent(content);
    }

    private void sendHeaders(Socket s, String contentType) throws IOException {
        OutputStream output = s.getOutputStream();
        HttpResponse response = new HttpResponse(output);
        response.sendReponseHeader(200, "OK", 0L, contentType, this.makeHeaders());
    }

    private void sendFile(Socket s, InputStream fileInput, long contentLength, String contentType) throws IOException {
        OutputStream output = s.getOutputStream();
        HttpResponse response = new HttpResponse(output);
        response.sendFileContent(fileInput, contentLength, contentType, this.makeHeaders());
    }

    private void sendError(Socket s, HttpServerException e) throws IOException {
        OutputStream output = s.getOutputStream();
        HttpResponse response = new HttpResponse(output);
        response.sendError(e);
    }

    private void sendRedirect(Socket s, String newURL) throws IOException {
        OutputStream output = s.getOutputStream();
        HttpResponse response = new HttpResponse(output);
        Hashtable<String, String> headers = new Hashtable<String, String>();
        headers.put("location", StringUtils.urlEncodeForSpaces((char[])newURL.toCharArray()));
        response.sendReponseHeader(307, "redirect", 1L, "text/html", headers);
    }
}

