/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.jetty;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.http.HttpServer;
import com.aptana.ide.server.logging.IHttpLog;
import com.aptana.ide.server.logging.SystemHttpLog;
import com.aptana.ide.server.resolvers.FolderResourceResolver;
import com.aptana.ide.server.resolvers.IHttpResourceResolver;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerList;
import org.mortbay.jetty.handler.ResourceHandler;

public class JettyHttpServer {
    private ServerSocket _socketServer;
    private int _portStart;
    private int portUsed;
    private int _portEnd;
    private IHttpResourceResolver _resourceResolver;
    private IHttpLog _logger;
    private int _timeout = 5000;
    private String path;
    private Server jettyServer;

    public IHttpLog getLogger() {
        return this._logger;
    }

    public void setLogger(IHttpLog log) {
        this._logger = log;
    }

    public IHttpResourceResolver getResourceResolver() {
        return this._resourceResolver;
    }

    public ServerSocket getSocketServer() {
        return this._socketServer;
    }

    public int getPort() {
        return this.portUsed;
    }

    public JettyHttpServer(String path, int port) {
        this(new FolderResourceResolver(new File(path)), port, port);
        this.path = path;
    }

    public JettyHttpServer(String path, int port, int endPort) {
        this(new FolderResourceResolver(new File(path)), port, endPort);
        this.path = path;
    }

    public JettyHttpServer(IHttpResourceResolver resourceResolver, int port) {
        this(resourceResolver, port, port);
    }

    public JettyHttpServer(IHttpResourceResolver resourceResolver, int portStartRange, int portEndRange) {
        this(resourceResolver, portStartRange, portEndRange, 5000);
    }

    public JettyHttpServer(IHttpResourceResolver resourceResolver, int portStartRange, int portEndRange, int timeout) {
        this._resourceResolver = resourceResolver;
        this._portStart = portStartRange;
        this._portEnd = portEndRange;
        this._logger = SystemHttpLog.getInstance();
        this._timeout = timeout;
        this.portUsed = -1;
    }

    public void start() throws IOException {
        int i = this._portStart;
        if (i <= this._portEnd) {
            try {
                this.jettyServer = new Server(i);
                this.jettyServer.getConnectors()[0].setHost(HttpServer.getServerAddress());
                HandlerList handlers = new HandlerList();
                ResourceHandler resource_handler = new ResourceHandler();
                resource_handler.setResourceBase(this.path);
                handlers.setHandlers(new Handler[]{resource_handler, new DefaultHandler()});
                this.jettyServer.setHandler((Handler)handlers);
                this.jettyServer.setStopAtShutdown(true);
                this.jettyServer.start();
                this.portUsed = i;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        this._logger.logTrace(StringUtils.format((String)"HttpServer listening on port {0}", (int)this.getPort()));
    }

    public void stop() throws IOException {
        if (this.jettyServer != null) {
            try {
                this.jettyServer.stop();
                int i = 0;
                while (i < 10) {
                    if (this.jettyServer.isStopping()) {
                        Thread.sleep(500L);
                    }
                    if (!this.jettyServer.isStopped()) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.jettyServer.destroy();
        }
    }
}

