Dim FileName, Find, ReplaceWith, FileContents, dFileContents
Find         = "site"
FileName     = "policy.xml"

'Read source text file
FileContents = GetFile(FileName)
ReplaceWith  = "file:///" + GetFilePath(FileName) + "/"
ReplaceWith = replace(ReplaceWith, "\", "/", 1, -1, 1)
ReplaceWith = replace(ReplaceWith, " ", "%20", 1, -1, 1)

'replace all string In the source file
dFileContents = replace(FileContents, Find, ReplaceWith + "site", 1, -1, 1)

'Compare source And result
if dFileContents <> FileContents Then
  'write result If different
  WriteFile FileName, dFileContents
  WriteFile "policy_url.txt", ReplaceWith + "policy.xml"

  Wscript.Echo "Replace done. Open up the newly-created policy_url.txt to find the policy url to paste into your update preferences"
Else
  Wscript.Echo "Unable to replace site.xml"
End If

'Read text file
function GetFile(FileName)
  If FileName<>"" Then
    Dim FS, FileStream
    Set FS = CreateObject("Scripting.FileSystemObject")
      on error resume Next
      Set FileStream = FS.OpenTextFile(FileName)
      GetFile = FileStream.ReadAll
  End If
End Function

'Read text file
function GetFilePath(FileName)
  If FileName<>"" Then
    Dim FS, FileStream
    Set FS = CreateObject("Scripting.FileSystemObject")
      on error resume Next
      Set FileObject = FS.GetFile(FileName)
      GetFilePath = FileObject.ParentFolder.Path
  End If
End Function

'Write string As a text file.
function WriteFile(FileName, Contents)
  Dim OutStream, FS

  on error resume Next
  Set FS = CreateObject("Scripting.FileSystemObject")
    Set OutStream = FS.OpenTextFile(FileName, 2, True)
    OutStream.Write Contents
End Function