var ChannelsClass = Class.create(
{
	initialize: function initialize()
	{
		this.loading 	= true;
		this.channels 	= new Hash();
	},
	
	finishInit: function finishInit()
	{
		EventManager.subscribe('/portal/cloud/channelTypes/', 
        {
            channelHook: 'channels',
			onComplete: function()
			{
				EventManager.publish('/portal/cloud/channelTypes', 
	            {
	                request: 'listChannelTypes'
	            });
			}
        });
		
		this.notify('startupHookComplete');
	},
	
	dispatchEvent: function dispatchEvent(msg)
	{
		if(msg.data.response == 'listChannelTypes')
		{
			this.update(msg.data);
		}
	},
	
	update: function update(data)
	{
        data.types.each(function(item)
        {
			if(!this.channels.get(item.id))
			{
				var tempChannel = new ChannelClass(item);
			}
			else
			{
				var tempChannel = this.channels.get(item.id);
				tempChannel.update(item);
			}
			
			this.channels.set(item.id, tempChannel);
			
        }.bind(this));
		
		if(this.loading == true)
		{
			this.loading = false;
		}
	},
	
	getName: function getName(channelId)
	{
		var channel = this.channels.get(channelId);
		return channel.name;
	}
});

Object.Event.extend(ChannelsClass);

Portal.API.startup.registerStartupItem(8, 
{
	onInit: function()
	{
		Portal.API.models.loadModel('channels', ChannelsClass, true);
	}
});

var ChannelClass = Class.create(
{
	initialize: function initialize(data)
	{
		this.id		= '';
		this.name	= '';
		
		this.update(data);
	},
	
	update: function update(data)
	{
		if('id' in data)
		{
			this.id = data.id;
		}
		
		if('name' in data)
		{
			this.name = data.name;
		}
	}
});
