var ChannelsClass = Class.create(
{
	initialize: function initialize()
	{
		this.loading	= true;
		this.channels	= new Hash();
	},
	
	finishInit: function finishInit()
	{
        EventManager.subscribe('/portal/cloud/channel_types', 
        {
            channelHook: 'channels',
			onComplete: function()
			{
                EventManager.publish('/portal/cloud/model', 
                {
					url: 'channel_types',
					request: 'describe',
					returnChannel: '/portal/cloud/channel_types'
				});
			}
        });
		
        Portal.Modules.OnlineStatus.observe('onlineStatusChanged', function(isOnline)
        {
			if(!isOnline)
			{
				return;
			}
			
			this.loading = true;
			EventManager.publish('/portal/cloud/model', 
            {
				url: 'channel_types',
				request: 'describe',
				returnChannel: '/portal/cloud/channel_types'
			});
			
        }.bind(this));
	},
	
	dispatchEvent: function dispatchEvent(msg)
	{
		if(msg.data.response == 'describe')
		{
			this.update(msg.data);
		}
	},
	
	update: function update(data)
	{
		if(!('xmlData' in data) || !('channel_types' in data.xmlData))
		{
			if(this.loading)
			{
				this.loading = false;
				this.notify('startupHookComplete');
				return;
			}
		}
		
		// everything's here, let's start iterating...
        data.xmlData.channel_types.each(function(item)
        {
			if(!this.channels.get(item.id))
			{
				var tempChannel = new ChannelClass(item);
			}
			else
			{
				var tempChannel = this.channels.get(item.id);
				tempChannel.update(item);
			}
			
			this.channels.set(item.id, tempChannel);
			
        }.bind(this));
		
		if(this.loading == true)
		{
			this.loading = false;
			this.notify('startupHookComplete');
		}
	},
	
	getName: function getName(channelId)
	{
		return this.channels.get(channelId).name;
	}
});

var ChannelClass = Class.create(
{
	initialize: function initialize(data)
	{
		this.id			= 0;
		this.name		= '';
		this.is_push	= false;
		
		this.update(data);
	},
	
	update: function update(data)
	{
		if('id' in data)
		{
			this.id = data.id;
		}
		
		if('name' in data)
		{
			this.name = data.name;
		}
		
		if('is_push' in data)
		{
			this.is_push = data.is_push;
		}
	}
});


Object.Event.extend(ChannelsClass);

Portal.API.startup.registerStartupItem(8, 
{
	onInit: function()
	{
		Portal.API.models.loadModel('channels', ChannelsClass, true);
	}
});