var CloudProductsClass = Class.create(
{
	initialize: function initialize()
	{
		this.loading	= true;
		this.error		= false;
		this.plans 		= new Hash();
		this.options	= new Hash();
	},
	
	finishInit: function finishInit()
	{
        EventManager.subscribe('/portal/cloud/products', 
        {
			channelHook: 'cloudProducts',
			onComplete: function()
			{
				this.fetchProducts();
			}.bind(this)
		});
		
		Portal.Modules.OnlineStatus.observe('onlineStatusChanged', function(isOnline)
        {
			if(!isOnline)
			{
				return;
			}
			
			this.loading = true;
			this.fetchProducts();
			
        }.bind(this));
	},
	
	dispatchEvent: function dispatchEvent(msg)
	{
		if(msg.channel == '/portal/cloud/products' && msg.data.response == 'describe')
		{
			this.updateProducts(msg);
		}
	},
	
	updateProducts: function updateProducts(msg)
	{	
		if(!('products' in msg.data.xmlData) || msg.data.status.toString() != '200')
		{
			this.error		= true;
			this.loading 	= false;
		
			if(!Portal.Vars.preloadComplete)
			{
				this.notify('startupHookComplete');
			}
			
			return;
		}
	
		// set the plans
		if(typeof(msg.data.xmlData.products.plans) != 'undefined')
		{
            msg.data.xmlData.products.plans.each(function(item)
            {
				if(!this.plans.get(item.plan.id))
				{
					var tempPlan = new CloudProductPlanClass(item.plan);
				}
				else
				{
					var tempPlan = this.plans.get(item.plan.id);
					tempPlan.update(item.plan);
				}
				
				
				this.plans.set(tempPlan.id, tempPlan);
				
            }.bind(this));
		}
		
		// set the options
		if(typeof(msg.data.xmlData.products.option_groups) != 'undefined')
		{
            msg.data.xmlData.products.option_groups.each(function(item)
            {
				
				if(!this.options.get(item.option_group.name))
				{
					var tempOption = new CloudProductOptionsClass(item.option_group);
				}
				else
				{
					var tempOption = this.options.get(item.option_group.name);
					tempOption.update(item.option_group);
				}
				
				this.options.set(tempOption.name, tempOption);
				
            }.bind(this));
		}
		
		this.loading = false;
		
		if(!Portal.Vars.preloadComplete)
		{
			this.notify('startupHookComplete');
		}
		
	},
	
	findOption: function findOption(planId)
	{
		var returnItem = false;
		
        this.options.each(function(option)
        {
            option.value.plans.each(function(item)
            {
				if(item.option.id == planId)
				{
					var newItem = Object.clone(item.option);
					
					newItem.parentName = option.value.name;
					
					returnItem = newItem;
				}
            });
        });
		
		return returnItem;
	},
	
	fetchProducts: function fetchProducts()
	{
		this.loading = true;
		this.error = false;
		
        EventManager.publish('/portal/cloud/model', 
        {
			url: 'products',
			request: 'describe',
			returnChannel: '/portal/cloud/products'
		})
	}
	
});

var CloudProductPlanClass = Class.create(
{
	initialize: function initialize(data)
	{
		this.id				= 0;
		this.name			= '';
		this.description 	= '';
		this.price			= '';
		this.priceUnit		= 'hour';
		this.bandwidth		= '';
		this.disk			= '';
		this.cpu			= '';
		this.ram			= '';
		
		this.update(data);
	},
	
	update: function update(data)
	{
		if('id' in data)
		{
			this.id = data.id;
		}
		
		if('name' in data)
		{
			this.name = data.name;
		}
		
		if('description' in data)
		{
			this.description = data.description;
		}
		
		if('unit_price' in data)
		{
			this.price = data.unit_price;
		}
		
		if('bandwidth' in data)
		{
			this.bandwidth = data.bandwidth;
		}
		
		if('disk' in data)
		{
			this.disk = data.disk;
		}
		
		if('cpu' in data)
		{
			this.cpu = data.cpu;
		}
		
		if('ram' in data)
		{
			this.ram = data.ram;
		}
	}
});

var CloudProductOptionsClass = Class.create(
{
	initialize: function initialize(data)
	{
		this.id		    = 0;
		this.name	    = 0;
		this.options    = new Array();        
        
		this.update(data);
	},
	
	update: function update(data)
	{
		if('id' in data)
		{
			this.id = data.id
		}
		
		if('name' in data)
		{
			this.name = data.name;
		}
        
        if('options' in data)
        {
            this.plans = data.options;
        }
	}
});

Object.Event.extend(CloudProductsClass);

Portal.API.startup.registerStartupItem(9, 
{
	startupMessage: 'Loading catalog...',
	onInit: function()
	{
		Portal.API.models.loadModel('cloudProducts', CloudProductsClass, true);
	}
});