var CloudProjectsClass = Class.create(
{
	initialize: function initialize()
	{
		this.loading 			= true;
		this.undeployedProjects	= new Hash();
		this.deployedProjects	= new Hash();
		this.projects			= new Hash();
		
		this.totalProjects		= 0;
		this.totalUndeployed	= 0;
		this.totalDeployed		= 0;
		this.notCloudCompatible = ['rails'];
		this.hasDeployed		= false;
		this.PREF_HASDEPLOYED	= 'portal.cloud.deployment.hasdeployed';
	},
	
	finishInit: function()
	{
        EventManager.subscribe('/portal/cloud/projects', 
        {
            channelHook: 'cloudProjects',
            onComplete: function()
            {
				this.requestProjectsList();
            }.bind(this)
        });
		
        Portal.Modules.OnlineStatus.observe('onlineStatusChanged', function(isOnline)
        {
			if(!isOnline)
			{
				return;
			}
			
			this.loading = true;
			this.requestProjectsList();
			
        }.bind(this));
	},
	
	dispatchEvent: function(msg)
	{
		if(msg.data.response == 'listProjects')
		{
			this.updateProjectList(msg);
		}
		else if(msg.data.response == 'get' && msg.data.name == this.PREF_HASDEPLOYED)
		{
			this.hasDeployed = (msg.data.value == 'true') ? true : false;
		}
	},
	
	requestProjectsList: function()
	{
        EventManager.publish('/portal/cloud/projects', 
        {
            request: 'listProjects'
        });
	},
	
	updateProjectList: function(msg)
	{
		var _totalProjects		= 0;
		var _totalDeployed		= 0;
		var _totalUndeployed		= 0;
		var _undeployedProjects	= new Hash();
		var _deployedProjects	= new Hash();
		
		var _undeployedSortArray	= new Array();
		var _deployedSortArray	= new Array();
		var _undeployedTempHash	= new Hash();
		var _deployedTempHash	= new Hash();
		
        msg.data.projects.each(function(project)
        {
			var tempProject = new CloudProject(project);
			
			if(tempProject.deployed == false)
			{
				_undeployedSortArray.push(tempProject.name);
				_undeployedTempHash.set(tempProject.name, tempProject);
			}
			else
			{
				_deployedSortArray.push(tempProject.name);
				_deployedTempHash.set(tempProject.name, tempProject);
			}
        });
		
        _undeployedSortArray.sort(function(x, y)
        {
			var a = String(x).toUpperCase();
			var b = String(y).toUpperCase();
			
			if(a > b)
			{
				return 1;
			}
			
			if(a < b)
			{
				return -1;
			}
			
			return 0;
        });
		
		_deployedSortArray.sort(function(x, y)
        {
			var a = String(x).toUpperCase();
			var b = String(y).toUpperCase();
			
			if(a > b)
			{
				return 1;
			}
			
			if(a < b)
			{
				return -1;
			}
			
			return 0;
        });
		
        _undeployedSortArray.each(function(item)
        {
			_undeployedProjects.set(item, _undeployedTempHash.get(item));
        });
		
		_deployedSortArray.each(function(item)
        {
			_deployedProjects.set(item, _deployedTempHash.get(item));
        });
		
		_totalDeployed = _deployedProjects.size();
		_totalUndeployed = _undeployedProjects.size();
		_totalProjects = _totalDeployed + _totalUndeployed;
		
		var notified = false;
		
		if(_totalProjects != this.totalProjects)
		{
			notified = true;
			this.notify('projectListChanged');
		}
		
		if(_totalDeployed != this.deployedProjects.size())
		{
			notified = true;
			this.notify('deployedListChanged');
		}
		
		if(_totalUndeployed != this.undeployedProjects.size())
		{
			notified = true;
			this.notify('undeployedListChanged');
		}
		
		this.totalProjects = _totalProjects;
		this.totalUndeployed = _totalUndeployed;
		this.totalDeployed = _totalDeployed;
		
		this.undeployedProjects = null;
		this.undeployedProjects = _undeployedProjects;
		this.deployedProjects = null;
		this.deployedProjects = _deployedProjects;
		
		if(this.loading)
		{
			this.loading = false;
			this.notify('startupHookComplete');
		}

		this.notify('projectListUpdated');
	}
});

Object.Event.extend(CloudProjectsClass);

Portal.API.startup.registerStartupItem(4, 
{
	startupMessage: 'Loading deployed projects...',
	onInit: function()
	{
		Portal.API.models.loadModel('cloudProjects', CloudProjectsClass, true);
		
        EventManager.subscribe('/portal/preferences/', 
        {
            channelHook: 'cloudProjects',
            onComplete: function()
            {
				Portal.API.utils.getPref(Portal.Data.cloudProjects.PREF_HASDEPLOYED);
            }
        });
	}
})

var CloudProject = Class.create(
{
	initialize: function initialize(data)
	{
		this.name		= '';
		this.type		= 'unknown';
		this.deployed	= false;
		this.siteId		= 0;
		
		this.update(data);
	},
	
	update: function(data)
	{
		if('name' in data)
		{
			this.name = data.name;
		}
		if('type' in data)
		{
			this.type = data.type;
		}
		if('deployed' in data)
		{
			this.deployed = data.deployed;
		}
		if('siteId' in data)
		{
			this.siteId = parseInt(data.siteId);
		}
	}
})
