var SiteListClass = Class.create(
{
	initialize: function initialize()
	{
		this.loading				= true;
		this.activeResizes			= new Hash();  // site id: polling location
		this.siteManagerAvailable	= true;
		this.sites					= new Hash();
		this.totalSites				= 0;
		this.totalSitesLoaded		= 0;
		this.siteListRequested		= false;
		this.siteListReceived		= false;
		this.firstFetch				= false;
		this.deployingSite			= 0;
		
        this.statusInfo = new Hash(
        {
			deleted:	0,
			running:	0,
			error:		0,
			warning:	0,
			suspended:	0
		});
		
		Portal.Channels.team 			= '/portal/cloud/team';
		Portal.Channels.events 			= '/portal/cloud/site/events';
		Portal.Channels.services 		= '/portal/cloud/services';
		Portal.Channels.serviceVersions = '/portal/cloud/services/versions/';
		Portal.Channels.sites 			= '/portal/cloud/sites';
	},
	
	finishInit: function finishInit()
	{
        EventManager.subscribe('/portal/cloud/available/', 
        {
            channelHook: 'siteList',
            onComplete: function()
            {
				EventManager.publish('/portal/cloud/available', { request: 'cloudStatus' });
            }
        });
		EventManager.subscribe(Portal.Channels.events, { channelHook: 'siteList' });
		EventManager.subscribe(Portal.Channels.team, { channelHook: 'siteList' });
		EventManager.subscribe(Portal.Channels.services, { channelHook: 'siteList' });
		EventManager.subscribe('/portal/cloud/services/versions/', { channelHook: 'siteList' });
		EventManager.subscribe('/portal/cloud/sync/', { channelHook: 'siteList' });
		EventManager.subscribe('/portal/cloud/sync', { channelHook: 'siteList' });
		EventManager.subscribe('/portal/cloud/sites/resize', { channelHook: 'siteList' });
        EventManager.subscribe(Portal.Channels.sites, 
        {
            channelHook: 'siteList',
            onComplete: function()
            {
				this.fetchSiteList();
            }.bind(this)
        });
		
		
        Portal.Modules.AptanaIdManager.observe('userLoggedIn', function()
        {
			this.firstFetch = true;
			this.fetchSiteList();
        }.bind(this));
		
        Portal.Modules.AptanaIdManager.observe('userLoggedOut', function()
        {
			this.clearModel();
        }.bind(this));
		
        Portal.Modules.OnlineStatus.observe('onlineStatusChanged', function(isOnline)
        {
			if(!isOnline)
			{
				return;
			}
			
			this.loading = true;
			this.fetchSiteList();
			
        }.bind(this));
	},
	
	dispatchEvent: function dispatchEvent(msg)
	{
		if(msg.data.response == 'listSites')
		{
			this.updateSiteList(msg);
		}
		else if (msg.channel == '/portal/cloud/sites/resize' && msg.data.response == 'describe')
		{
			this.handlePollerUpdate(msg);
		}
		else if (msg.data.response == 'getEndpoint')
		{
			this.updateSiteEndpoint(msg);
		}
		// site data events should be ignored until we've received the full site list
		// TODO: determine if this is a necessary restriction
		else if(msg.data.response == 'siteInfo' && this.siteListReceived)
		{
			this.updateSiteInfo(msg);
		}
		// refresh events should also be ignored until we've received the full site list
		else if(msg.data.response == 'siteInfoRefresh' && this.siteListReceived)
		{
			this.updateSiteInfo(msg);
		}
		else if(msg.data.response == 'listEvents')
		{
			this.updateSiteEvents(msg);
		}
		else if(msg.data.response == 'listVersions')
		{
			this.updateSiteServicesVersions(msg);
		}
		else if(msg.channel == Portal.Channels.services && msg.data.response == 'describe')
		{
			this.updateSiteServices(msg);
		}
		else if(msg.data.response == 'cloudStatus')
		{
			this.setCloudStatus(msg);
		}
		else if (msg.channel = Portal.Channels.team && msg.data.response == 'describe')
		{
			this.updateSiteTeam(msg);
		}
	},
	
	setCloudStatus: function setCloudStatus(msg)
	{
		this.siteManagerAvailable = msg.data.available;
		
		this.notify('siteManagerStatus', this.siteManagerAvailable);
	},
	
	fetchSiteList: function fetchSiteList()
	{
		if(Portal.Modules.AptanaIdManager.isLoggedIn == false && Portal.Vars.preloadComplete == false)
		{
			this.loading = false;
			
			this.notify('startupHookComplete');
			
			return;
		}
		
		this.siteListRequested = true;
		this.siteListReceived = false;
		
		EventManager.publish('/portal/cloud/sites', { request: 'listSites' });
	},
	
	updateSiteList: function updateSiteList(msg)
	{
        msg.data.sites.each(function(site)
        {
			if(!site.name && site.domain)
			{
				site.name = site.domain.substr(0, site.domain.indexOf('.'));
			}
			
			if(!this.sites.get(site.id))
			{
				var newSite = new Site(site);
				this.sites.set(site.id, newSite);
			}
        }.bind(this));
		
		this.sortSiteList();
		
		this.siteListRequested = false;
		this.siteListReceived = true;
		
		if(this.totalSites == 0 && Portal.Vars.preloadComplete == false)
		{
			Portal.API.tabs.unregisterTab('my_cloud');
			this.notify('startupHookComplete');
			this.loading = false;
			
			return;
		}
		else if (this.totalSites == 0 && Portal.Vars.preloadComplete == true)
		{
			this.loading = false;
			this.notify('siteModelLoaded');
			return;
		}
		else if (this.totalSites > 0 && this.firstFetch)
		{
			this.firstFetch = false;
			Portal.API.tabs.reRegisterTab('my_cloud');
		}
		
        this.sites.each(function(item)
        {
			EventManager.publish('/portal/cloud/sync', { request: 'getEndpoint', id: item.value.id });
			EventManager.publish('/portal/cloud/sites', { request: 'siteInfo', id: item.value.id });
        });
	},
	
	updateSiteEndpoint: function updateSiteEndpoint(msg)
	{
		var siteId = msg.data.id;
		
		if(this.sites.get(siteId))
		{
			var tempSite = this.sites.get(siteId);
			tempSite.update(msg.data);
			
			this.sites.set(siteId, tempSite);
			
			this.notify('syncEndpointUpdated', siteId);
		}
	},
	
	updateSiteInfo: function updateSiteInfo(msg)
	{
		var siteId = msg.data.id;
		
		if(!this.sites.get(siteId))
		{
			if(!msg.data.name && msg.data.domain)
			{
				msg.data.name = msg.data.domain.substr(0, msg.data.domain.indexOf('.'));
			}
			var tempSite = new Site(msg.data);
			
			this.sites.set(siteId, tempSite);
			
			this.sortSiteList();
			
			// we don't want to notify a new site if we're still loading...
			if(!this.loading && this.siteListReceived)
			{
				this.notify('siteAdded', siteId);
			}
		}
		else
		{
			var currentSite = this.sites.get(siteId);
			
			if(Portal.Vars.newSite == true && ['pending','provisioning', 'provisioned', 'initializing', 'initialized'].indexOf(currentSite.status.toLowerCase()) != -1)
			{
				this.deployingSite = siteId;
			}
			
			if(currentSite.status != msg.data.status)
			{
				this.notify('siteStatusChanged', siteId);
			}
			
			currentSite.update(msg.data);
			
			this.sites.set(siteId, currentSite);
			
			this.notify('siteUpdated', siteId);
		}
		
		this.totalSitesLoaded = 0;
        this.sites.each(function(item)
        {
			if(!item.value.loading)
			{
				this.totalSitesLoaded ++;
			}
        }.bind(this));
		
		if(this.totalSitesLoaded == this.sites.size() && this.loading && this.siteListReceived)
		{
			this.loading = false;
			
			this.notify('siteModelLoaded');
			
			if(Portal.Vars.preloadComplete == false)
			{
				this.notify('startupHookComplete');
			}
		}
	},
	
	updateSiteEvents: function updateSiteEvents(msg)
	{
		var tempSite = this.sites.get(msg.data.id);
		
		if(!tempSite)
		{
			return;
		}
		
		tempSite.events.update(msg.data);
		
		this.sites.set(tempSite.id, tempSite);
		this.notify('siteEventsUpdated', tempSite.id);
	},
	
	updateSiteTeam: function updateSiteTeam(msg)
	{
		if(!('team' in msg.data.xmlData))
		{
			return;
		}
		
		var tempSite = ('memberships' in msg.data.xmlData.team) ? this.sites.get(msg.data.xmlData.team.memberships[0].membership.site_id.toString()) : false;
		
		if(!tempSite)
		{
			return;
		}

		tempSite.memberships.update(msg.data.xmlData);

		this.notify('siteTeamUpdated', tempSite.id);
	},
	
	fetchSiteServices: function fetchSiteServices(siteId)
	{
		var tempSite = this.sites.get(siteId);
		
		if(!tempSite)
		{
			return;
		}
		
		tempSite.services.fetchServices();
	},
	
	updateSiteServices: function updateSiteServices(msg)
	{
		if(!('xmlData' in msg.data) || !('services' in msg.data.xmlData))
		{
			return;
		}
		
		if('status' in msg.data && msg.data.status == 404)
		{
			return;
		}
		
		var siteId = msg.data.xmlData.services[0].service.site_id;
		
		var tempSite = this.sites.get(siteId);
		
		if(!tempSite)
		{
			return;
		}
		
        Portal.Pollers.register('siteServices', siteId, 
        {
            object: Portal.Data.siteList,
            method: 'fetchSiteServices',
            frequency: 180,
            args: [siteId],
            notifyEvent: 'siteServicesUpdated'
        });
		
		tempSite.services.update(msg.data.xmlData);
		
		// if anything is not running or stopped, we need a fast poll		
		var frequency = 180;
        tempSite.services.servicesList.each(function(service)
        {
			if(['running', 'stopped', 'error'].indexOf(service.value.status.toLowerCase()) == -1 && service.value.status != '')
			{
				frequency = 5;
			}
			
			if(typeof(Portal.Modules.SiteServices) != 'undefined' && Portal.Modules.SiteServices.upgrading && service.value.name.toLowerCase() == 'jaxer')
			{
				if(['running', 'stopped', 'error'].indexOf(service.value.status.toLowerCase()) != -1)
				{
					Portal.Modules.SiteServices.upgrading = false;
					
					var updateText = function()
					{
						$('upgrade_label_' + service.value.name.toLowerCase()).replace('<span class="left10 size10 gray5" style="font-weight: normal;"><img src="images_global/img_bullet_check.png" align="absmiddle" class="inline" />This is the latest version</span>');

						var tempService = Portal.Data.siteList.sites.get(Portal.Modules.MyCloudPortal.currentSiteId).services.servicesList.get('jaxer');
						tempService.currentVersion = tempService.newestVersion;
					}
					
					if($('upgrade_label_' + service.value.name.toLowerCase()))
					{
						setTimeout(updateText, 1000);
					}
					
				}
			}
			
        });
		
		Portal.Pollers.siteServices[siteId.toString()].changeIntervalLength(frequency);
		
		this.sites.set(tempSite.id, tempSite);
		this.notify('siteServicesUpdated', tempSite.id);
	},
	
	updateSiteServicesVersions: function updateSiteServicesVersions(msg)
	{
        this.sites.each(function(site)
        {
			if (site.value.services.loading) 
			{
				site.value.services.update(msg.data);
				site.value.services.loading = false;
				
				this.notify('siteServicesLoaded', site.value.id);
				
				this.sites.set(site.key, site.value);
			}
        }.bind(this));
	},
	
	sortSiteList: function sortSiteList()
	{
		var nameArray 		= new Array();
		var tempSiteList 	= new Hash();
		var idToNameList	= new Hash();
		
        this.sites.each(function(item)
        {
			idToNameList.set(item.value.name, item.key);
			nameArray.push(item.value.name);
        });
		
        nameArray.sort(function(x, y)
        {
			var a = String(x).toUpperCase();
			var b = String(y).toUpperCase();
			
			if( a > b)
			{
				return 1;
			}
			
			if(a < b)
			{
				return -1;
			}
			
			return 0;
        });
		
		this.resetStatusInfo();
		
        nameArray.each(function(item)
        {
			var siteId = idToNameList.get(item);
			var tempSite = this.sites.get(siteId);
			
			switch(tempSite.status)
			{
				case 'Deleted':
				case 'Deleting':
					this.statusInfo.set('deleted', this.statusInfo.get('deleted') + 1);
					break;
				case 'Running':
					this.statusInfo.set('running', this.statusInfo.get('running') + 1);
					break;
				case 'Error':
					this.statusInfo.set('error', this.statusInfo.get('error') + 1);
					break;
				case 'Warning':
					this.statusInfo.set('warning', this.statusInfo.get('warning') + 1);
					break;
				case 'Suspended':
					this.statusInfo.set('suspended', this.statusInfo.get('suspended') + 1);
					break;
				default:
					this.statusInfo.set('running', this.statusInfo.get('running') + 1);
			}
			
			// don't actually add these to the list
			if(['Deleted', 'Deleting'].indexOf(tempSite.status) != -1)
			{
				return;
			}
			
			tempSiteList.set(tempSite.id, tempSite);
			
        }.bind(this));
		
		this.sites = new Hash();
		this.sites = tempSiteList;
		this.totalSites	= this.sites.size();
	},
	
	resetStatusInfo: function resetStatusInfo()
	{
		this.statusInfo = new Hash(
        {
			deleted:	0,
			running:	0,
			error:		0,
			warning:	0,
			suspended:	0
		});
	},
	
	clearModel: function clearModel()
	{
		this.loading			= true;
		this.sites				= new Hash();
		this.totalSites			= 0;
		this.totalSitesLoaded	= 0;
		this.siteListRequested	= false;
		this.siteListReceived	= false;
		
        this.statusInfo = new Hash(
        {
			deleted:	0,
			running:	0,
			error:		0,
			warning:	0,
			suspended:	0
		});
	},
	
	removeSiteFromModel: function removeSiteFromModel(siteId)
	{
		if(typeof(Portal.Modules.MyCloudPortal) != 'undefined' && Portal.Modules.MyCloudPortal.currentSiteId == siteId)
		{
			Portal.Modules.MyCloudPortal.currentSiteId = 0;
		}
		
		this.sites.unset(siteId);
		this.sortSiteList();
		
		this.notify('siteDeleted', siteId);
	},
	
	handlePollerUpdate: function handlePollerUpdate(msg)
	{
		// dump the polling if the site has transitioned into a resizing state
		var site = Portal.Data.siteList.sites.get(msg.data.xmlData.job.site_id);
		if(site.status.toLowerCase() == 'resizing')
		{
			this.notify('resizePollerUpdated', true);
			
			var site = Portal.Data.siteList.sites.get(msg.data.xmlData.job.site_id);
			site.resizing = false;
			
			return;
		}
		
		// show the appropriate UI depending on the job status
		
		// success
		if(msg.data.xmlData.job.success == true)
		{
			Portal.API.dialogs.alert('<strong>Requested site changes complete!</strong><br /><div class="size11">Note: The resources charts may take up to a minute to reflect your settings.</div><br />Your settings have been applied successfully and are ready for use.', 'Site Settings Changed Successfully')
		}
		// failure
		else if (msg.data.xmlData.job.success == false)
		{
			Portal.API.dialogs.alert('<strong>Requested site changes failed.</strong><br /><br />We\'re sorry, but the requested changes did not succeed.  You may try again, or contact <a href="javascript: Portal.API.utils.openUrl(\'http://support.aptana.com/\');">support</a> if you have any questions.', 'Site Settings Changes Failed')
		}
		// in progress
		else
		{
			this.notify('resizePollerUpdated');
			return;
		}
		
		// resets all the flags, and re-draws the UI for the configurator if they're still on the screen
		this.notify('resizePollerUpdated', true);
			
		var site = Portal.Data.siteList.sites.get(msg.data.xmlData.job.site_id);
		site.resizing = false;
		
		if($('configurator_site_cage') && Portal.Modules.MyCloudPortal.currentSiteId == msg.data.xmlData.job.site_id)
		{
			Portal.Modules.SiteConfigurator._init();
		}
	},
	
	pollResizeStatus: function pollResizeStatus(siteId)
	{
		// get the polling location
		var location = this.activeResizes.get(siteId);
		
		EventManager.publish('/portal/cloud/model', 
        {
			url: location,
			request: 'describe',
			returnChannel: '/portal/cloud/sites/resize'
		});
	}
});

Object.Event.extend(SiteListClass);

Portal.API.startup.registerStartupItem(5, 
{
	startupMessage: 'Loading site list...',
	onInit: function()
	{
		Portal.API.models.loadModel('siteList', SiteListClass, true);
	}
});