var SiteNotificationListClass = Class.create(
{
	initialize: function(siteId)
	{
		this.siteId 		= siteId;
		this.messageList	= new Array();
		this.severities		= new Hash(
		{
			'1':	'info',
			'2':	'warning',
			'3':	'error',
			'4':	'debug'
		});
	},
	
	finishInit: function()
	{
		EventManager.publish('/portal/cloud/site/events', 
        {
            id: this.siteId,
            request: 'listEvents'
        });
	},
	
	update: function(data)
	{
		// reset the messages
		this.messageList = new Array();
		
        data.events.each(function(message)
        {
			var newMessage = new SiteNotification(message);
			this.messageList.push(newMessage);
        }.bind(this));
	},
	
	getSeverity: function(severity)
	{
		return this.severities.get(severity);
	}
});

var SiteNotification = Class.create(
{
	initialize: function(data)
	{
		this.id			= 0;
		this.severity	= 1;
		this.time		= '';
		this.body		= '';
		
		if('id' in data)
		{
			this.id = data.id;
		}
		
		if('severity' in data)
		{
			this.severity = data.severity;
		}
		
		if('time' in data)
		{
			this.time = data.time
		}
		
		if('value' in data)
		{
			this.body = data.value;
		}
	}
});
