var CloudTrialStatusModule = Class.create(
{
    initialize: function intialize ()
    {
		this.loading		= true;
		this.timeLeft		= 0;
		this.daysLeft		= 0;
		this.endTime		= true;
		this.endDay			= false;
		this.canDeploy		= true;
		this.timerRunning	= false;
    },
	
	finishInit: function finishInit()
	{
		this.extendSelf();
		this.registerObservers();
	},
	
	dispatchEvent: function dispatchEvent (msg)
	{
		this.handleTrialUpdate(msg);
	},
	
	extendSelf: function extendSelf()
	{
		Object.extend(this, CloudTrialStatusControllers);
		Object.extend(this, CloudTrialStatusViews);
	},
	
	registerObservers: function registerObservers()
	{
        EventManager.subscribe('/portal/cloud/trialstatus', 
        {
            channelHook: 'CloudTrialStatus',
            onComplete: function()
            {
				this._init();
            }.bind(this)
        });
		Portal.Modules.AptanaIdManager.observe('userLoggedIn', function()
		{
			this.fetchTrialUpdate();
		}.bind(this));
	}
});

var CloudTrialStatusControllers = 
{
	_init: function _init()
	{
		this.fetchTrialUpdate();
	},
	
	fetchTrialUpdate: function fetchTrialUpdate()
	{
		// don't fetch if we're loaded, but they can't deploy and they have no time left (expired)
		if(this.endTime == 0 && !this.loading && !this.canDeploy)
		{
			return;
		}
		
		// make sure the user is logged in as well
		if(!Portal.Modules.AptanaIdManager.isLoggedIn)
		{
			return;
		}
		
        EventManager.publish('/portal/cloud/model', 
		{
			returnChannel: '/portal/cloud/trialstatus',
			url: 'users/' + Portal.Modules.AptanaIdManager.userId + '/trial',
			request: 'describe'
		});
	},
	
	handleTrialUpdate: function handleTrialUpdate(msg)
	{
		try
		{
			// make sure we've even got data (no user id could cause this return)
			if(!('trial' in msg.data.xmlData))
			{
				return;
			}
			
			// set our member vars
			if ('ends_in' in msg.data.xmlData.trial) 
			{
				var previousTimeLeft = this.timeLeft;
				
				this.timeLeft = parseInt(msg.data.xmlData.trial.ends_in);
				
				if(previousTimeLeft == 0 && this.timeLeft != 0)
				{
					this.endDay = false;
				}
			}
			if ('can_deploy_trial' in msg.data.xmlData.trial) 
			{
				this.canDeploy = msg.data.xmlData.trial.can_deploy_trial;
			}
			
			// figure out how much time is left
			this.calcDaysLeft();
			
			// show the message if we've got time left
			if (this.endTime > 0) 
			{
				this._initViews();
			}
			
			// set the loading flag
			if(this.loading)
			{
				this.loading = false;
			}
			
			// start the periodical executer if its not running
			if(!this.timerRunning)
			{
				new PeriodicalExecuter (function(pe)
		        {
					try
					{
						this.calcDaysLeft();
						this._initViews();
						
						if(this.endTime == 0 && this.canDeploy == false)
						{
							pe.stop();
						}
					}
					catch (e)
					{
						console.warn('Error with trial poll: ' + e);
						pe.stop();
					}
					
		        }.bind(this), 60);
				
				this.timerRunning = true;
			}
		}
		catch (e)
		{
			console.warn(e);
		}
	},
	
	calcDaysLeft: function calcDaysLeft()
	{
		// nothing to calculate
		if(this.endTime == 0 && this.timeLeft == 0)
		{
			return;
		}
		
		var d = new Date();
		
		var time = this.timeLeft;
		var startDate = d.getTime();
		
		// store this the first time
		if (!this.endDay) 
		{
			this.endDay = time + d.getTime();
		} 
			
		// update the end time
		this.endTime = this.endDay - startDate;

		// do some math... keeping separate variables in case we 
		// ever want to add greater resolution of time to the message
		var sec = Math.floor(this.endTime / 1000);
		var min = Math.floor(sec / 60);
		var hr = Math.floor(min / 60);
		var day = Math.floor(hr / 24);
		
		// update the days left
		this.daysLeft = day;
	}
}

var CloudTrialStatusViews = 
{
	_initViews: function _initViews()
	{
		if(!this.canDeploy && this.daysLeft == 0 && this.timeLeft == 0)
		{
			$('cloud_trial_cage').update('');
			return;	
		}
		
		if(this.canDeploy)
		{
			// remove plural
			if(this.daysLeft == 1)
			{
				$('cloud_trial_cage').update(this.daysLeft + ' day left to deploy a trial site');
			}
			else if (this.daysLeft == 0 && this.timeLeft != 0)
			{
				$('cloud_trial_cage').update('Less than a day left to deploy a trial site');
			}
			// only show if they can deploy, and the time left isn't 0
			else if(this.timeLeft != 0)
			{
				$('cloud_trial_cage').update(this.daysLeft + ' days left to deploy a trial site');
			}
		}
		else
		{
			// remove plural
			if(this.daysLeft == 1)
			{
				$('cloud_trial_cage').update(this.daysLeft + ' day left on your trial site');
			}
			else if (this.daysLeft == 0 && this.timeLeft != 0)
			{
				$('cloud_trial_cage').update('Less than a day left on your trial site');
			}
			// plural
			else
			{
				$('cloud_trial_cage').update(this.daysLeft + ' days left on your trial site');
			}
		}
        
		$('cloud_trial_cage').setStyle({ height: $('cloud_trial_cage').getHeight() + 'px' });
	}
}

Object.Event.extend(CloudTrialStatusModule);