var ConfiguratorClass = Class.create(
{
	initialize: function initialize()
	{
		this.domElement = 'configuratorCage';
		this.context	= 'wizard';
		this.hostingProductsIndex = 0;
		
		this.hostingProducts = new Hash( 
		{
			0:
				{
					id:				14,
					monthlyPrice:	30,
					dailyPrice:		0.99,
					cpu:			'1/16th',
					disk:			'5 GB',
					ram:			'256 MB',
					bandwidth:		'10 TB/month',
					description:	'256 MB of RAM is ideal for getting started with your next great Web app or site.',
					name:			'Cloud Hosting - Small'
				},
			1:
				{
					id:				15,
					monthlyPrice:	75,
					dailyPrice:		2.47,
					cpu:			'1/16th',
					disk:			'10 GB',
					ram:			'512 MB',
					bandwidth:		'10 TB/month',
					description:	'512 MB of RAM is great for apps than run multiple services or mid-sized databases.',
					name:			'Cloud Hosting - Medium'
				},
			2:
				{
					id:				16,
					monthlyPrice:	125,
					dailyPrice:		4.11,
					cpu:			'1/16th',
					disk:			'15 GB',
					ram:			'1024 MB',
					bandwidth:		'10 TB/month',
					description:	'1 GB of RAM and more CPU for Web-tier applications that need to scale horizontally.',
					name:			'Cloud Hosting - Large'
				},
			3:
				{
					id:				17,
					monthlyPrice:	250,
					dailyPrice:		8.22,
					cpu:			'1/16th',
					disk:			'25 GB',
					ram:			'2048 MB',
					bandwidth:		'10 TB/month',
					description:	'2 GB of RAM is better for high use apps requiring more database and other services.',
					name:			'Cloud Hosting - Jumbo'
				}
		});
		
		this.hostingOptions = new Hash (
		{
			9:
				{
					id: 	9,
					name:	'Support Options',
					options:
					[
						{
							id: 			0,
							monthlyPrice:	0,
							dailyPrice:		0,
							name:			'Standard Support',
							description:	'Standard 1 hour response to critical issues during business hours'
						},
						{
							id: 			13,
							monthlyPrice:	30,
							dailyPrice:		0.99,
							name:			'24/7 Support',
							description:	'24/7/365 1 hour response to critical issues all the time'
						}
					]
				},
			8:
				{
					id:		8,
					name:	'Team Options',
					options:
					[
						{
							id:				0,
							monthlyPrice:	0,
							dailyPrice:		0,
							name:			'Standard Team',
							description:	'1 Admin and 1 Developer'
						},
						{
							id:				12,
							monthlyPrice:	10,
							dailyPrice:		0.33,
							name:			'Unlimited Team',
							description:	'Unlimited Admins and Developers'
						}
					]
				}
		});
		
		this.defaultData = 
		{
			hostingProductId:	8,
			options: new Hash()			
		};
		
		this.currentData = 
		{
			hostingProductId: 	8,
            options: 			new Hash(),
			couponCode: 		'',
			discountType:		'',
			discountNumber:		0,
			discountAmount:		0,
			monthlyTotal:		0
		}
			
		this.hostingOptionTemplate 	= new Template('<table width="100%" cellspacing="0" cellpadding="0" border="0" class="borderBottom darkGray">'
									+ '<tr><td class="pad3"><div class="bold">#{optionTitle}</div>'
									+ '<div class="size11 line14">#{options}</div><td>'
									+ '<td class="configuratorRightCol"><div id="price_#{optionId}"></div></td>'
									+ '</tr></table>');
		this.hostingOptionItemTemplate	= new Template('<div class="size11"><input type="radio" name="option_#{optionId}" id="option_#{optionId}_plan_#{planId}" onclick="Portal.Modules.Configurator.updateOptions(#{optionId}, #{planId});" />&nbsp;<label for="option_#{optionId}_plan_#{planId}">#{description}</label></div>');
		
		if ($('wizardCage')) 
		{
			this.domElement = 'configuratorCageWizard';
		}
	},
	
	finishInit: function finishInit()
	{
        new Ajax.Updater(this.domElement, 'portlets/cloud/templates/configurator/configurator.html', 
        {
            onComplete: function()
            {
                this.hostingOptions.each(function(item)
                {
					this.defaultData.options.set(item.key, 0);
					this.currentData.options.set(item.key, 0);
                }.bind(this));
				
				if($('wizardCage'))
				{
					var currentHostingData = Portal.Modules.DeploymentWizard.newSiteData.hostingInfo; 
					
					if(currentHostingData && currentHostingData.hostingProductId)
					{
						this.defaultData = currentHostingData; 
						this.currentData = this.defaultData;
					}
					
					$('coupon_code_cage').show();
					
					if(this.currentData.couponCode != '')
					{
						var newHtml = 'You will receive a ';
				
						switch(this.currentData.discountType.toLowerCase())
						{
							case 'percent':
								newHtml += parseInt(this.currentData.discountNumber) + '% monthly discount';
								break;
						}
						
						$('coupon_code_result').update(newHtml + ' when you submit your order');
						
						$('coupon_code_form').hide();
						$('coupon_code_result').show();
						
						$('coupon_code_cage').setStyle({ height: $('coupon_code_cage').getHeight() + 'px' });
					}
				}
				else if (Portal.Data.siteList.sites.get(Portal.Modules.MyCloudPortal.currentSiteId).hostingPlanId != 0 && !$('wizardCage'))
				{
					this.context = 'site';
					
					if (!Portal.Modules.MyCloudPortal.siteUpgrading) 
					{
						this.initDefaultsFromSiteModel();
					}
					
					Portal.Data.siteList.observe('siteUpdated', function(siteId)
			        {
						if(Portal.Modules.MyCloudPortal.siteUpgradeInfo && Portal.Modules.MyCloudPortal.siteUpgradeInfo.siteId == siteId)
						{
							var currentSiteInfo = Portal.Data.siteList.sites.get(Portal.Modules.MyCloudPortal.currentSiteId);
							var siteUpgradeInfo = Portal.Modules.MyCloudPortal.siteUpgradeInfo;
							
							var options = new Hash();
                            siteUpgradeInfo.options.each(function(item)
                            {
								options.set(item.id, item.plan);
                            });
							
							if(currentSiteInfo.hostingPlanId == siteUpgradeInfo.plan && currentSiteInfo.hostingOptions.inspect() == options.inspect())
							{
								Portal.Modules.MyCloudPortal.siteUpgrading = false;
								Portal.Modules.MyCloudPortal.siteUpgradeInfo = {}
							}							
						}
						
						this.initDefaultsFromSiteModel();
						
						this.initDisplay();
			        }.bind(this));
				}
				
				this.initDisplay();
				
            }.bind(this)
        });
	},
	
	initDefaultsFromSiteModel: function initDefaultsFromSiteModel()
	{
		this.defaultData.hostingProductId = Portal.Data.siteList.sites.get(Portal.Modules.MyCloudPortal.currentSiteId).hostingPlanId;
		this.defaultData.options = Portal.Data.siteList.sites.get(Portal.Modules.MyCloudPortal.currentSiteId).hostingOptions.clone();
		this.currentData.hostingProductId = this.defaultData.hostingProductId;
		this.currentData.options = Portal.Data.siteList.sites.get(Portal.Modules.MyCloudPortal.currentSiteId).hostingOptions.clone();
	},
	
	dispatchEvent: function dispatchEvent(msg)
	{
		if(msg.data.response == 'describeCoupon')
		{
			this.processCouponCode(msg);
		}
		else if (msg.data.response == 'updatePlan')
		{
			if(this.context == 'site' && $('configurator_update_error'))
			{
				this.handleUpdate(msg);
			}
		}
	},
	
	initDisplay: function initDisplay()
	{
		if(typeof(Portal.Modules.MyCloudPortal) != 'undefined' && Portal.Modules.MyCloudPortal.siteUpgrading)
		{
			if($('new_plan_summary'))
			{
				$('new_plan_summary').remove();
			}
			
			$('configurator_processing').show();
			$('configurator_interface').hide();
			
			$('configurator_processing').insert({ bottom: '<div id="new_plan_summary" class="top10 clean-gray">Your new service plan and options package will be:<div class="top10 bottom10 line16">' + Portal.Modules.MyCloudPortal.siteUpgradeInfo.newPlanSummary + '</div>'});
		}
		else
		{
			// build up the hosting product data
			var currentProduct 	= 1;
			var minId 			= -1;
			var maxId 			= 0;
			var values 			= [];
			var defaultProduct 	= 0;
			
			if (typeof(Portal.Modules.MyCloudPortal) != 'undefined') 
			{
				Portal.Modules.MyCloudPortal.siteUpgrading = false;
				Portal.Modules.MyCloudPortal.siteUpgradeInfo = {}
			}
			
			if ($('configurator_processing')) 
			{
				$('configurator_processing').hide();
			}
			if ($('configurator_interface')) 
			{
				$('configurator_interface').show();
			}
			
	        this.hostingProducts.each(function(product)
	        {
				var element = 'product_' + currentProduct;
				
				newHtml = '<span class="gray7">RAM </span>' + product.value.ram + '<br />';
				newHtml += '<span class="gray7">DISK </span>' + product.value.disk;
				
				if(product.value.id == this.defaultData.hostingProductId)
				{
					defaultProduct = product.key;
				}
				
				if($(element))
				{
					$(element).update(newHtml);
				}
				
				if(minId == -1)
				{
					minId = product.key;
				}
				
				if(product.key > maxId)
				{
					maxId = product.key;
				}
				
				values.push(product.key);
				
				currentProduct ++;
	        }.bind(this));
			
			// init the slider
	        new Control.Slider('handle', 'track', 
	        {
				range: $R(minId, maxId),
				values: values,
				sliderValue: minId,
				sliderValue: defaultProduct,
				onChange: function(newValue)
				{
					this.handleSliderUpdate(newValue);
				}.bind(this),
				onSlide: function(newValue)
				{
					this.handleSliderUpdate(newValue);
				}.bind(this)
			});
			
			$('hosting_options').update('');
			
			// build all the options
	        this.hostingOptions.each(function(option)
	        {
				var newHtml = '';
				var items = '';
				
				var optionTemplate = this.hostingOptionItemTemplate;
				var optionId = option.value.id;
				
	            option.value.options.each(function(item)
	            {
	                items += optionTemplate.evaluate(
	                {
						optionId: optionId,
						planId: item.id,
						description: item.description
					});
					
	            });
				
	            newHtml = this.hostingOptionTemplate.evaluate(
	            {
					optionTitle: option.value.name + ':',
					options: items,
					optionId: option.value.id
				});
				
				$('hosting_options').insert({ bottom: newHtml });
				
	        }.bind(this));
			
			// set some defaults...
	        this.hostingOptions.each(function(item)
	        {
				if(!this.defaultData.options.get(item.key))
				{
					this.defaultData.options.set(item.key, 0);
				}
	        }.bind(this));
			
	        this.defaultData.options.each(function(option)
	        {
				var currentItem = this.hostingOptions.get(option.key);
				
	            currentItem.options.each(function(item)
	            {
					if(item.id == option.value)
					{
						$('price_' + option.key).update((item.dailyPrice == 0) ? 'Included' : '$' + item.dailyPrice + ' / day<br />average');
						$('option_' + option.key + '_plan_' + item.id).checked = true;
					}
	            });
				
	        }.bind(this));
			
			this.currentData.options = this.defaultData.options.clone();
			
			this.handleSliderUpdate(defaultProduct);
		}
		
		this.fixDisplay();
	},
	
	handleSliderUpdate: function handleSliderUpdate(newValue)
	{
		var currentItem = this.hostingProducts.get(newValue);
				
		if(!currentItem)
		{
			return;
		}
		
		this.hostingProductsIndex = newValue;
		
		$('planInfoCage').update(currentItem.description);
		
		var newOffset = (newValue * 80);
		
		$('serverStacks').setStyle({ backgroundPosition: 'left -' + newOffset + 'px' });
		
		$('hosting_price_cage').update('$' + currentItem.dailyPrice + ' / day<br />average');
		
		this.currentData.hostingProductId = currentItem.id;
		
		this.checkForChanges();
		
		this.calcMonthlyPrice();
	},
	
	updateOptions: function updateOptions(optionId, planId)
	{
		this.currentData.options.set(optionId, planId);
		
		var currentItem = this.hostingOptions.get(optionId);
		
        currentItem.options.each(function(item)
        {
			if(item.id == planId)
			{
				$('price_' + optionId).update((item.dailyPrice == 0) ? 'Included' : '$' + item.dailyPrice + ' / day<br />average');
			}
        });		
		
		this.checkForChanges();
		
		this.calcMonthlyPrice();
	},
	
	checkForChanges: function checkForChanges()
	{
		if(this.context != 'site')
		{
			return;
		}
		
		if(this.defaultData.options.inspect() != this.currentData.options.inspect() || this.defaultData.hostingProductId != this.currentData.hostingProductId)
		{
			$('apply_changes_cage').show();
		}	
		else
		{
			$('apply_changes_cage').hide();
		}
	},
	
	calcMonthlyPrice: function calcMonthlyPrice()
	{
		var subTotal = 0;
		var discount = 0;
		
		// get the hosting price (easy)
        this.hostingProducts.each(function(item)
        {
			if(item.value.id == this.currentData.hostingProductId)
			{
				subTotal += item.value.monthlyPrice;
			}
        }.bind(this));
		
		// get the options
        this.currentData.options.each(function(item)
        {
			var price = 0;
			
            this.hostingOptions.get(item.key).options.each(function(option)
            {
				if(item.value == option.id)
				{
					price = option.monthlyPrice;
				}
            });
			
			subTotal += price;
			
        }.bind(this));
		
		if(this.currentData.couponCode != '')
		{
			switch(this.currentData.discountType.toLowerCase())
			{
				case 'percent':
					var discountPercent = this.currentData.discountNumber / 100;
					var discountAmount = subTotal * discountPercent;
					this.currentData.discountAmount = discountAmount;
					
					subTotal -= discountAmount;
					break;
			}
		}
		
		this.currentData.monthlyTotal = subTotal.toFixed(2);
		
		$('totalPriceCage').update('Monthly: $' + subTotal.toFixed(2));
		
		this.fixDisplay();
	},
	
	fetchFormValues: function fetchFormValues()
	{
		return this.currentData;
	},
	
	processCouponCode: function processCouponCode(msg)
	{
		if(!msg)
		{
			var couponCode = $F('promoCode');
			
			if(!couponCode)
			{
				if ($('coupon_code_error').style.display == 'none') 
				{
					$('coupon_code_error').show();
					$('coupon_code_form').setStyle(
					{
						height: $('coupon_code_form').getHeight() + 5 + 'px'
					});
				}
				
				return;
			}
			
			$('coupon_code_error').hide();
			
			Portal.Modules.DeploymentWizard.messagePending = true;
			
			new Effect.Fade('coupon_code_form', { duration: 0.25, queue: 'front' });
			
            new Effect.Appear('coupon_code_activity', 
            {
                duration: 0.25,
                queue: 'end',
                afterFinish: function()
                {
		            EventManager.subscribe('/portal/cloud/coupon/', 
		            {
		                channelHook: 'Configurator',
		                onComplete: function()
		                {
							EventManager.publish('/portal/cloud/coupon', { code: $F('promoCode') });
		                }
		            });
                }
            });
		}
		else
		{
			Portal.Modules.DeploymentWizard.messagePending = false;
			
			if(msg.data.discount == null)
			{
				$('coupon_code_result').update('Sorry, the product code you entered is not valid.  <a href="javascript: Portal.Modules.Configurator.resetCouponCode();">Try again.</a>');
				
				new Effect.Fade('coupon_code_activity', { duration: 0.25, queue: 'front' });
				new Effect.Appear('coupon_code_result', { duration: 0.25, queue: 'end' });
			}
			else
			{
				this.currentData.couponCode = msg.data.code;
				this.currentData.discountType = msg.data.type;
				this.currentData.discountNumber = msg.data.discount;
				
				var newHtml = 'Good News!  The product code was valid, and we\'ve applied a ';
				
				switch(this.currentData.discountType.toLowerCase())
				{
					case 'percent':
						newHtml += parseInt(this.currentData.discountNumber) + '% monthly discount';
						break;
				}
				
				$('coupon_code_result').update(newHtml + ' to your order');
				
				this.calcMonthlyPrice();
				
				new Effect.Fade('coupon_code_activity', { duration: 0.25, queue: 'front' });
				new Effect.Appear('coupon_code_result', { duration: 0.25, queue: 'end' });
			}
		}
	},
	
	resetCouponCode: function resetCouponCode()
	{
		$('promoCode').value = '';
		
		new Effect.Fade('coupon_code_result', { duration: 0.25, queue: 'front' });
		
        new Effect.Appear('coupon_code_form', 
        {
            duration: 0.25,
            queue: 'end',
            afterFinish: function()
            {
                $('coupon_code_result').focus()
            }
        });
	},
	
	fixDisplay: function fixDisplay()
	{
		$(this.domElement).setStyle({ height: $(this.domElement).getHeight() + 'px' });
	},
	
	generatePlanSummary: function generatePlanSummary()
	{
		var newHtml = '';
		
		var hostingInfo = this.hostingProducts.get(this.hostingProductsIndex);
		
		newHtml += '<strong>Hosting Plan:</strong><br />';
		newHtml += '<span class="gray7">RAM: </span>' + hostingInfo.ram + '<br />';
		newHtml += '<span class="gray7">DISK: </span>' + hostingInfo.disk + '<br />';
		
		var hasOptions = false;
		
        this.currentData.options.each(function(option)
        {
			if(option.value != 0)
			{
				if(!hasOptions)
				{
					newHtml += '<strong>Plan Options:</strong><br />';
					
					hasOptions = true;
				}
				
				optionData = this.hostingOptions.get(option.key);
                optionData.options.each(function(item)
                {
					if(item.id == option.value)
					{
						newHtml += ' &bull; ' + item.name + '<br />';
					}
                });
			}
        }.bind(this));
		
		return newHtml;
	},
	
	applySiteChanges: function appySiteChanges()
	{
		var options = [];
		
        this.currentData.options.each(function(option)
        {
			if(option.value != 0)
			{
				options.push({ id: option.key, plan: option.value });
			}
        });
		
		
        Portal.API.dialogs.confirm(
        {
			title: 		'Please confirm.',
			message: 	'Your new service plan and options package will be:<div class="top10 bottom10 line16">' + this.generatePlanSummary() + '</div>'
						+ 'Your new rate will be <strong>$' + this.currentData.monthlyTotal + '</strong> per month'
						+ '<div class="size11 top10">Note: If you are changing your service plan, your new billing cycle will start immediately at the above rate.  Charges for any changes to options will be '
						+ 'pro-rated to coincide with the billing cycle set by the service plan.  Any charges will be applied to the current billing account associated with this site.</div>',
			onConfirm: function()
			{
                EventManager.subscribe('/portal/cloud/sites', 
                {
                    channelHook: 'Configurator',
                    onComplete: function()
                    {
						EventManager.publish('/portal/cloud/sites', 
		                {
							request: 	'updatePlan',
							id:			Portal.Modules.MyCloudPortal.currentSiteId,
							plan:		this.currentData.hostingProductId,
							options:	options
						});
						
						if ($('configurator_update_error')) 
						{
							$('configurator_update_error').hide();
						}
						
						var showThankYou = function()
						{
							Portal.API.dialogs.alert('Your changes are being processed now.  You\'ll receive an email notification when they are complete.', 'Thank You');
						}
						
						Portal.Modules.MyCloudPortal.siteUpgrading = true;
						Portal.Modules.MyCloudPortal.siteUpgradeInfo = 
						{
							siteId: Portal.Modules.MyCloudPortal.currentSiteId,
							plan: this.currentData.hostingProductId,
							options: options,
							newPlanSummary: this.generatePlanSummary()
						}
						
						if($('new_plan_summary'))
						{
							$('new_plan_summary').remove();
						}
						
						$('configurator_processing').show();
						$('configurator_interface').hide();
						
						$('configurator_processing').insert({ bottom: '<div id="new_plan_summary" class="top10 clean-gray">Your new service plan and options package will be:<div class="top10 bottom10 line16">' + this.generatePlanSummary() + '</div>'});
						
						setTimeout(showThankYou, 500);
                    }.bind(this)
                });
				
			}.bind(this)
		});
	},
	
	handleUpdate: function handleUpdate(msg)
	{
		if(msg.data.success == false)
		{
			Portal.API.utils.setContent('configurator_update_error', 'There was an error making changes to your site configuration:<br /><span class="size11">&bull; ' + msg.data.errors.join('</span><br /><span class="size11">&bull; ') + '</span>');
			if($('configurator_update_error'))
			{
				$('configurator_update_error').show();
				Portal.Modules.MyCloudPortal.siteUpgrading = false;
				Portal.Modules.MyCloudPortal.siteUpgradeInfo = {};
				
				this.initDisplay();
			}
		}
	}
});
