var WizardConfiguratorModule = Class.create(
{
	initialize: function initialize()
	{
		this.templates		= {};
		this.planMap		= { 0: 1, 1: 2, 2: 3, 3: 4 },
		this.hostingPlanId	= 0;
		this.jaxerEnabled	= false;
		this.optionIds		= [];
	},
	
	finishInit: function finishInit()
	{
		this.extendSelf();
		this.registerObservers();
		
		this._init();
	},
	
	dispatchEvent: function dispatchEvent()
	{
		// nothing here yet...
	},
	
	registerObservers: function registerObservers()
	{
		// nothing here yet...
	},
	
	extendSelf: function extendSelf()
	{
		Object.extend(this, WizardConfiguratorControllers);
		Object.extend(this, WizardConfiguratorViews);
	}
});

var WizardConfiguratorControllers = 
{
	_init: function _init()
	{
		this._initViews();
	},
	
	updateUsageDisplay: function updateUsageDisplay(currentValue)
	{
		var backgroundOffset = 120 * currentValue;
								
		$('cloud_size_image').setStyle({ backgroundPosition: '0px -' + backgroundOffset + 'px' });
		
        $$('td.hostingPlan').each(function(item)
        {
			$(item).setStyle({ fontWeight: 'normal' });
        });
		
		$('hosting_plan_' + currentValue).setStyle({ fontWeight: 'bold' });
		
		// get the current plan info..
		var currentPlan = Portal.Data.cloudProducts.plans.get(this.planMap[currentValue].toString());
		
		$('wizard_plan_description').update(currentPlan.description);
		
		if(currentPlan.description.indexOf('1/4') != -1)
		{
			$('wizard_plan_description').setStyle({ backgroundColor: '#caface' });
		}
		else
		{
			$('wizard_plan_description').setStyle({ backgroundColor: 'transparent' });
		}
		
		$('wizard_plan_price').update('$' + currentPlan.price.toFixed(2) + '/hour');
		// $('wizard_usage_cost').update('$' + currentPlan.price.toFixed(2) + '/hour');
		
		this.hostingPlanId = currentPlan.id;
		
		$('wizard_configurator_table').setStyle({ height: $('wizard_configurator_table').getHeight() + 'px' });
	},
	
	handleOptionSelect: function handleOptionSelect(event)
	{
		var element = Event.element(event);
		var plans = Portal.Data.cloudProducts.options;
		
		this.optionIds = [];
		
        $$('input.optionRadio').each(function(item)
        {
			if(item.checked)
			{
				this.optionIds.push(parseInt(item.value));
			}
        }.bind(this));
		
		var total = 0;
		var itemTotal = 0;
		
        plans.each(function(item)
        {
            item.value.plans.each(function(plan)
            {
				if(this.optionIds.indexOf(plan.option.id) != -1)
				{
					total += plan.option.unit_price;
				}
				
				if(plan.option.id == element.value)
				{
					itemTotal = plan.option.unit_price;
				}
            }.bind(this))
        }.bind(this));
		
		$('price_' + element.name).hide();
		$('total_service_cost').hide();
		
		$('price_' + element.name).update('$' + itemTotal.toFixed(2) + ' / month').show();
		$('total_service_cost').update('$' + total.toFixed(2)).show();
		
		$('wizard_configurator_table').setStyle({ height: $('wizard_configurator_table').getHeight() + 'px' });
	},
	
	fetchUsageOptions: function fetchUsageOptions()
	{
		return { hostingPlanId: this.hostingPlanId }
	},
	
	fetchOptionIds: function fetchOptionIds()
	{
		return { optionIds: this.optionIds, jaxerEnabled: this.jaxerEnabled }
	}
}

var WizardConfiguratorViews =
{
	_initViews: function _initViews()
	{
        View.load(
        {
			main:
			{
				file: 'portlets/cloud/templates/configurator_wizard/configurator_main.html',
				binding: function()
				{
					return $('configurator_wizard_cage');
				},
				behaviors: function()
				{
					if(Portal.Modules.DeploymentWizard.currentStep == 2)
					{
	                    this.slider = new Control.Slider('configurator_handle', 'configurator_track', 
	                    {
							range: $R(0, 3),
							values: $R(0, 3),
							onSlide: function(currentValue)
							{
								this.updateUsageDisplay(currentValue)
							}.bind(this),
							onChange: function(currentValue)
							{
								this.updateUsageDisplay(currentValue)
							}.bind(this)
						});
						
	                    $$('td.hostingPlan').each(function(item)
	                    {
	                        $(item).observe('click', function(event)
	                        {
								var value = Event.element(event).id.replace('hosting_plan_', '');
								
								value = parseInt(value);
								
								this.slider.setValue(value);
	                        }.bind(this));
	                    }.bind(this));
						
						// now that we've got all our observers, we can set up the defaults...
						var hostingData = Portal.Modules.DeploymentWizard.newSiteData.hostingData;
						
						if('hostingPlanId' in hostingData)
						{
							this.slider.setValue(parseInt(hostingData.hostingPlanId) - 1);
						}
						else
						{
							this.updateUsageDisplay(0);
						}
						
						$('configurator_wizard_cage').setStyle({ height: $('configurator_wizard_cage').getHeight() + 'px' });
						
					}
					else if (Portal.Modules.DeploymentWizard.currentStep == 3)
					{
                        $$('input.optionRadio').each(function(element)
                        {
							$(element).stopObserving('click');
                            $(element).observe('click', this.handleOptionSelect.bindAsEventListener(this));
                        }.bind(this));
						
						this.optionIds = [];
		
				        $$('input.optionRadio').each(function(item)
				        {
							if(item.checked)
							{
								this.optionIds.push(parseInt(item.value));
							}
				        }.bind(this));
						
						$('enable_jaxer').observe('click', function(event)
                        {
							if ($('enable_jaxer').checked) 
							{
								this.jaxerEnabled = true;
							}
							else 
							{
								this.jaxerEnabled = false;
							}
							
                        }.bind(this));
						
                        $('enable_rails').observe('click', function(event)
                        {
							if($('enable_rails').checked)
							{
								Portal.Modules.DeploymentWizard.newSiteData.projectType = 'rails';
							}
							else
							{
								Portal.Modules.DeploymentWizard.newSiteData.projectType = 'web';
							}
                        });
						
						// now that we've got all our observers, we can set up the defaults...
						var hostingData = Portal.Modules.DeploymentWizard.newSiteData.hostingData;
						
						if('jaxerEnabled' in hostingData && hostingData.jaxerEnabled !== false)
						{
							$('enable_jaxer').checked = true;
							this.jaxerEnabled = true;
						}
						
						if(Portal.Modules.DeploymentWizard.newSiteData.projectType == 'rails' && $('enable_rails'))
						{
							$('enable_rails').checked = true;
						}
						
						$('configurator_wizard_cage').setStyle({ height: $('configurator_wizard_cage').getHeight() + 'px' });
						
					}	
					
				}.bind(this),
				scope:
				{
					currentStep: Portal.Modules.DeploymentWizard.currentStep
				}
			},
			
			cloudSize:
			{
				file: 'portlets/cloud/templates/configurator_wizard/cloud_size.html'
			},
			
			planOptions:
			{
				file: 'portlets/cloud/templates/configurator_wizard/plan_options.html'
			}
		}, 
		function(templates)
        {
			this.templates = templates;
			
			var subTemplates = 
			{
				cloudSize: this.templates.cloudSize,
				planOptions: this.templates.planOptions,
				options: Portal.Data.cloudProducts.options,
				hostingData: Portal.Modules.DeploymentWizard.newSiteData.hostingData
			}
			
			this.templates.main.set('subTemplates', subTemplates);
			
        }.bind(this));
	}
}