/*
 --------------------------------------------------
|          DEPLOYMENT WIZARD BREAD CRUMBS          |
 --------------------------------------------------
*/
var DeploymentWizardBreadCrumbs = 
{
	/**
	 * Builds the actual bread crumbs
	 * 
	 * This function actually determines the template values that 
	 * will be set on the bread crumb template (declared in the views)
	 * and will trigger the actual rendering of the breadcrumbs
	 */
    buildBreadCrumbs: function buildBreadCrumbs()
    {
        this.totalSteps = 0;
        var html = '<ul class="crumbs" style="clear: both;">';
        var count = 0;
        var templateValues = '';
        var breadCrumbs = new Array();
        
		var breadCrumbsHash = this.breadCrumbs;
		
		if(this.isTrial)
		{
			breadCrumbsHash = this.trialBreadCrumbs;
		}
		
        breadCrumbsHash.each(function(breadCrumb)
        {
            var itemClass = 'crumb';
            var linkClass = '';
            
            if (count == 0) 
            {
                itemClass += ' first';
            }
            if (count == breadCrumbsHash.size() - 1) 
            {
                itemClass += ' last';
            }
            if (breadCrumb.key == this.currentStep) 
            {
				if (this.isTrial && this.currentStep == 4 && parseInt(breadCrumb.key) == 1) 
				{
					itemClass += ' current_next';
				}
				else 
				{
					itemClass += ' current';
				}
            }
			if (this.isTrial && (this.currentStep == 4) && (parseInt(breadCrumb.key) == 1)) 
			{
				itemClass += ' current_next';
			}
			if (this.isTrial && (this.currentStep == 6) && (parseInt(breadCrumb.key) == 4)) 
			{
				itemClass += ' current_next';
			}
            if ((parseInt(breadCrumb.key) + 1) == this.currentStep) 
            {
				itemClass += ' current_next';
            }
            if (breadCrumb.key > this.currentStep && breadCrumb.key > this.currentStepRunning) 
            {
                linkClass = 'inactive';
            }
            
            templateValues = 
            {
                itemClass: itemClass,
                linkClass: linkClass,
                step: breadCrumb.key,
                value: breadCrumb.value
            }
            
            breadCrumbs.push(templateValues);
            
            count++;
            this.totalSteps++;
        }.bind(this));
        
        this.templates.breadCrumbs.set('breadCrumbs', breadCrumbs);
        
        this.injectCrumbBehavior();
    },
    
	/**
	 * Injects the "click" behavior on all bread crumbs
	 * 
	 */
    injectCrumbBehavior: function injectCrumbBehavior()
    {
        this.boundCrumbClick = this.crumbClick.bindAsEventListener(this);
        
        $$('a.bread_crumb').each(function(item)
        {
            var linkId = parseInt(item.id.replace('bread_crumb_step_', ''));
            
            if (linkId > this.currentStep && linkId > this.currentStepRunning) 
            {
                return;
            }
            
			$(item).stopObserving('click', this.boundCrumbClick);
			$(item).observe('click', this.boundCrumbClick);
        }.bind(this));
    },
    
	/**
	 * Handles the crumb click event
	 * 
	 * Essentially just gets the step number from the clicked crumb, and 
	 * passes that on to the current step processor function
	 * 
	 * @param {Object} event
	 */
    crumbClick: function crumbClick(event)
    {
        var elementId = Event.element(event).id;
        elementId = elementId.replace('bread_crumb_step_', '');
        
        if (elementId != this.currentStep) 
        {
            this.processCurrentStep(parseInt(elementId));
        }
    }
};
