
/*
 ---------------------------------------------
|          DEPLOYMENT WIZARD HELPERS          |
 ---------------------------------------------
*/
var DeploymentWizardHelpers = 
{
	setTrialState: function setTrialState(state)
	{
		if(this.currentStep != 1)
		{
			return;
		}

		// ------
        
		var tempData = this.newSiteData;
		
        this.currentStep 		= 1;
        this.totalSteps 		= 0;
        this.currentStepRunning = 0;
        this.newSiteData 		= new UndeployedProject();
		
		this.newSiteData.projectName = tempData.projectName;
		this.newSiteData.projectType = tempData.projectType;
		this.newSiteData.siteName = tempData.siteName;
		this.newSiteData.username = tempData.username;
		
		// ------
		
		if($('jaxer_enabled_step_1') && $('jaxer_enabled_step_1').checked == true)
		{
			this.newSiteData.hostingData.jaxerEnabled = true;
		}
		
		if(state == 'true' || state == true)
		{
			this.isTrial = true;
		}
		else
		{
			this.isTrial = false;
		}
		
		this.buildBreadCrumbs();
	},
	
	/**
	 * Helps validate the site name (as either used or available, as well as syntactically correct)
	 * 
	 * @param {Object} msg
	 */
    preValidateSiteName: function preValidateSiteName(msg)
    {
        if (!msg) 
        {
            this.validatingSiteName = true;
			
            var siteName = $F('site_name');
            var re = /^[a-z0-9]((([\-a-z0-9]?[a-z0-9])*)|([a-z0-9]*[\-a-z0-9]?[a-z0-9]))$/i;
            if (siteName.length < 2 || !siteName.match(re)) 
            {
                $('site_name_activity').hide();
                $('site_name_error').update('Please enter a valid site name').show();
                this.validatingSiteName = false;
                return;
            }
            
            EventManager.publish('/portal/cloud/deploy', 
            {
                request: 'checkSiteName',
                siteName: $F('site_name') + '.aptanacloud.com'
            });
            
            $('site_name').disable();
            return;
        }
        else 
        {
            if (!$('site_name')) 
            {
                return;
            }
			
            this.validatingSiteName = false;
			
            $('site_name').enable();
            new Effect.Fade('site_name_activity', 
            {
                duration: 0.25,
                queue: 'front',
                afterFinish: function()
                {
                    $('site_name_form').setStyle(
                    {
                        height: $('site_name_form').getHeight() + 0 + 'px'
                    });
                }
            });
            
            if (msg.data.siteName == null && $('site_name_error')) 
            {
                this.newSiteData.siteName = '';
                
                if (msg.data.errors.length == 0) 
                {
                    msg.data.errors.push('An unknown error has occurred.  Please try again in a few minutes.  If the problem persists, please contact us for support.');
                }
                
                $('site_name_error').update(Portal.API.templates.parseErrors('There is a problem with your site name.', msg.data.errors));
                
                new Effect.Appear('site_name_error', 
                {
                    duration: 0.25,
                    queue: 'end',
                    afterFinish: function()
                    {
                        $('site_name_form').setStyle(
                        {
                            height: $('site_name_form').getHeight() + 0 + 'px'
                        });
						
						$('site_name').focus();
                    }
                });
                
                return false;
            }
            else 
            {
                this.siteNameValid = true;
            }
            
            $('site_name').focus();
        }
    },
    
	/**
	 * Makes sure the logged in user has the correct credentials
	 * 
	 * @param {Object} msg
	 */
    validateCurrentUser: function validateCurrentUser(msg)
    {
        if (!msg) 
        {
            // validate the form
            var formValid = true;
            var username = $F('wizard_username');
            var password = $F('wizard_password');
            
                       
            if (!formValid) 
            {
                $('wizard_user_error').update('Please fill out the form correctly to continue.');
                new Effect.Appear('wizard_user_error', 
                {
                    duration: 0.25,
                    queue: 'end',
                    afterFinish: function()
                    {
                        $('wizard_user_form_cage').setStyle(
                        {
                            height: $('wizard_user_form_cage').getHeight() + 0 + 'px'
                        });
                    }
                });
                $('wizard_user_message').hide();
                return false;
            }
            
            this.newSiteData.update(
            {
                username: $F('wizard_username'),
                password: $F('wizard_password')
            });
            
            this.usernameAction = 'current';
            
            $('wizard_user_activity').update('Validating your credentials...');
            
            $('wizard_username').disable();
            $('wizard_password').disable();
            
            if ($('user_current')) 
            {
                $('user_current').disable();
                
                if ($('user_new')) 
                {
                    $('user_new').disable();
                }
            }
            
            this.messagePending = true;
            
            new Effect.Fade('wizard_user_message', 
            {
                duration: 0.25,
                queue: 'front'
            });
            
            new Effect.Appear('wizard_user_activity', 
            {
                duration: 0.25,
                queue: 'end',
                afterFinish: function()
                {
                    EventManager.publish('/portal/cloud/deploy', 
                    {
                        request: 'validateUser',
                        username: username,
                        password: password
                    });
                    
                    $('wizard_user_form_cage').setStyle(
                    {
                        height: $('wizard_user_form_cage').getHeight() + 0 + 'px'
                    });
                }
            });
            
            return false;
        }
        else 
        {
            this.messagePending = false;
            
            // don't pay attention if the user is creating a username elsewhere
            if (!$('wizardCage')) 
            {
                return;
            }
            
            if (msg.data.userValid == true) 
            {
                if (Portal.Modules.AptanaIdManager.isLoggedIn == false) 
                {
                    Portal.Modules.AptanaIdManager.logInExternal(this.newSiteData.username, this.newSiteData.password);
                }
                
                this.usernameValid = true;
                
                if (this.nextStepOverride != '') 
                {
                    this.doNextStep(this.nextStepOverride);
                    return false;
                }
                
                this.doNextStep();
                return false;
            }
            else 
            {
                new Effect.Fade('wizard_user_activity', 
                {
                    duration: 0.25,
                    afterFinish: function()
                    {
                        $('wizard_username').enable();
                        $('wizard_password').enable();
                        
                        if ($('user_current')) 
                        {
                            $('user_current').enable();
                            $('user_new').enable();
                        }
                        
                        $('wizard_user_error').update('Verification failed, please try again.');
                        $('wizard_user_error').show();
                        
                        $('wizard_user_form_cage').setStyle(
                        {
                            height: $('wizard_user_form_cage').getHeight() + 0 + 'px'
                        });
                        
                    }.bind(this)
                });
                
                return false;
            }
        }
    },
    
	/**
	 * Creates a new user
	 * 
	 * @param {Object} msg
	 */
    createNewUser: function createNewUser(msg)
    {
        if (!msg) 
        {
            EventManager.subscribe('/portal/user/create', 
            {
                channelHook: 'DeploymentWizard'
            });
            
            var username = $F('wizard_username');
            var password = $F('wizard_password');
            
            var email = $F('wizard_email');
            var emailRegex = new RegExp(/^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,}$/i);
            var formValid = true;
            
            if (username.length < 3 || username.length > 16) 
            {
                $('wizard_username_error').show();
                formValid = false;
            }
            
            if (password.length < 5) 
            {
                $('wizard_password_error').show();
                formValid = false;
            }
			            
            if (!email || !emailRegex.test(email)) 
            {
                $('wizard_email_error').show();
                formValid = false;
            }
            
            if (formValid && password != $F('wizard_password_confirm')) 
            {
                $('wizard_password_error').update('Your passwords do not match');
                $('wizard_password_error').show();
                formValid = false;
            }
            
            if (!formValid) 
            {
                $('wizard_user_error').update('Please complete the form in full and fix any errors');
                
                new Effect.Appear('wizard_user_error', 
                {
                    duration: 0.25,
                    queue: 'end',
                    afterFinish: function()
                    {
                        $('wizard_user_form_cage').setStyle(
                        {
                            height: $('wizard_user_form_cage').getHeight() + 0 + 'px'
                        });
                    }
                });
                
                $('wizard_user_message').hide();
                
                return false;
            }
            
            this.newSiteData.update(
            {
                username: $F('wizard_username'),
                password: $F('wizard_password')
            });
            
            this.usernameAction = 'new';
            
            $('wizard_user_activity').update('Creating your account...');
            
            $('wizard_username').disable();
            $('wizard_password').disable();
            $('user_current').disable();
            $('user_new').disable();
            $('wizard_password_confirm').disable();
            $('wizard_email').disable();
            
            this.messagePending = true;
            
            new Effect.Fade('wizard_user_message', 
            {
                duration: 0.25,
                queue: 'front'
            });
            
            new Effect.Appear('wizard_user_activity', 
            {
                duration: 0.25,
                queue: 'end',
                afterFinish: function()
                {
                    EventManager.publish('/portal/user/create', 
                    {
                        request: 'createUser',
                        username: username,
                        password: password,
                        email: email,
                        first_name: '',
                        last_name: '',
						captcha_token: 'bogus',
						captcha_response: 'bogus'
                    });
                    
                    $('wizard_user_form_cage').setStyle(
                    {
                        height: $('wizard_user_form_cage').getHeight() + 0 + 'px'
                    });
                }
            });
            
            return false;
        }
        else 
        {
            this.messagePending = false;
            
            if (!$('wizardCage')) 
            {
                return;
            }
            
            if (msg.data.success == true) 
            {
                // do this since the module ignores this message due to the wizard being open...
                Portal.Modules.AptanaIdManager.username = this.newSiteData.username;
                Portal.Modules.AptanaIdManager.isLoggedIn = true;
                Portal.Modules.AptanaIdManager.parseLoginHtml();
                this.usernameValid = true;
                
                this.purchaseCredentialsSaved = false;
                
                if (this.nextStepOverride != '') 
                {
                    this.doNextStep(this.nextStepOverride);
                    return false;
                }
                
                this.doNextStep();
                return false;
            }
            else 
            {
                new Effect.Fade('wizard_user_activity', 
                {
                    duration: 0.25,
                    afterFinish: function()
                    {
						CloudCaptcha.reload();
						
                        $('wizard_username').enable();
                        $('wizard_password').enable();
                        $('user_current').enable();
                        $('user_new').enable();
                        $('wizard_password_confirm').enable();
                        $('wizard_email').enable();
                        
                        $('wizard_user_error').update('Account creation failed.  Please try again.<br /><span class="size11">&bull; ' + msg.data.errors.join('</span><br /><span class="size11">&bull; ') + '</span>');
                        $('wizard_user_error').show();
                        
                        $('wizard_user_form_cage').setStyle(
                        {
                            height: $('wizard_user_form_cage').getHeight() + 0 + 'px'
                        });
                        
                    }.bind(this)
                });
                
                return false;
            }
        }
    },
	
	sendTrackingData: function sendTrackingData(id)
	{
		var newId;
		
		if (!id) 
		{
			newId = 'c.dw.' + this.currentStep.toString();
		}
		else
		{
			newId = id;
		}
		
		if(newId == 'c.dw.8')
		{
			return;
		}
		
		var isAStep = /^c\.dw(\.(\d|cncl|dpl|dpl_com|dpl_fail))?$/.test(newId);
		
		if(isAStep)
		{
			if(newId == this.lastStepEvent)
			{
				return;
			}
			
			this.lastStepEvent = newId;
		}
		
		Portal.API.logging.logEvent('TRACKING DATA', 'ID: ' + newId);
		
		var data = (this.isTrial) ? 'true' : 'false';
		
		EventManager.publish('/portal/cloud/eventtracker', { request: 'submitEvent', id: newId, data: 'Trial: ' + data });
	},
	
	fetchOrderPreview: function fetchOrderPreview()
	{
		this.messagePending = true;
		
		var optiondata = [];
	        
        this.newSiteData.hostingData.optionIds.each(function(item)
        {
            optiondata.push(
            {
                option: 
                {
                    id: item.toString()
                }
            });
        })
        
        EventManager.publish('/portal/cloud/model', 
        {
            url: 'orders/preview',
            request: 'xmlRest',
			method: 'POST',
            returnChannel: '/portal/orders/preview',
            xmlData: 
            {
                order: 
                {
                    plan: this.newSiteData.hostingData.hostingPlanId.toString(),
                    options: optiondata,
                    coupon: this.newSiteData.couponCode
                }
            }
        });
	},
	
	showBillingOrderPreview: function showBillingOrderPreview(msg)
	{
		try
		{
			var amount = (Number(msg.data.xmlData.quote.invoice.amount * 100) / 100).toFixed(2);
			$('total_service_cost').update('$' + amount);
			
			if(this.couponCodeApply)
			{
				if(this.newSiteData.couponCode != '' && msg.data.xmlData.quote.coupons.length == 0)
				{
					this.couponCodeApply = false;
					this.messagePending = false;
					this.newSiteData.couponCode = '';
					this.newSiteData.couponValid = false;
					
					$('coupon_code_error').show();
					$('coupon_code_error').update('The coupon code you entered is invalid.  Please try again.');
					$('coupon_code_form').show();
					$('coupon_code_processing').hide();
					$('coupon_code').focus();
					
					return false;
				}
				else if (this.newSiteData.couponCode != '' && msg.data.xmlData.quote.coupons[0].coupon.errors.length > 0) 
				{
					this.couponCodeApply = false;
					this.messagePending = false;
					this.newSiteData.couponCode = '';
					this.newSiteData.couponValid = false;
					
					$('coupon_code_error').show();
					$('coupon_code_error').update(msg.data.xmlData.quote.coupons[0].coupon.errors[0].error);
					$('coupon_code_form').show();
					$('coupon_code_processing').hide();
					$('coupon_code').focus();
					
					return false;
				}
				else
				{
					this.newSiteData.couponValid = true;
					this.newSiteData.couponTitle = msg.data.xmlData.quote.coupons[0].coupon.title;
					this.newSiteData.couponDescription = msg.data.xmlData.quote.coupons[0].coupon.description;
					
					$('coupon_code_processing').hide();
					$('coupon_code_form').hide();
					$('coupon_code_name').update(this.newSiteData.couponCode);
					$('coupon_code_title').update('<strong>Details:</strong> ' + this.newSiteData.couponTitle);
					$('coupon_code_valid').show();
				}
				
				this.couponCodeApply = false;
			}
			else if (this.messagePending && this.validateCouponCode)
			{
				if(this.newSiteData.couponCode != '' && msg.data.xmlData.quote.coupons.length == 0)
				{
					this.couponCodeApply = false;
					this.messagePending = false;
					this.newSiteData.couponCode = '';
					this.newSiteData.couponValid = false;
					
					$('coupon_code_error').show();
					$('coupon_code_error').update('The coupon code you entered is invalid.  Please try again.');
					$('coupon_code_form').show();
					$('coupon_code_processing').hide();
					$('coupon_code').focus();
					
					return false;
				}
				else if (this.newSiteData.couponCode != '' && msg.data.xmlData.quote.coupons[0].coupon.errors.length > 0) 
				{
					this.couponCodeApply = false;
					this.messagePending = false;
					this.newSiteData.couponCode = '';
					this.newSiteData.couponValid = false;
					
					$('coupon_code_error').show();
					$('coupon_code_error').update(msg.data.xmlData.quote.coupons[0].coupon.errors[0].error);
					$('coupon_code_form').show();
					$('coupon_code_processing').hide();
					$('coupon_code').focus();
					
					return false;
				}
				else
				{
					this.newSiteData.couponValid = true;
					this.newSiteData.couponTitle = msg.data.xmlData.quote.coupons[0].coupon.title;
					this.newSiteData.couponDescription = msg.data.xmlData.quote.coupons[0].coupon.description;
					
					this.validateCouponCode = false;
					this.messagePending = false;
					
					this.processStep5(msg);
				}
			}
			
		}
		catch (e)
		{
			console.warn(e);			
		}
	}
}
