
/*
 --------------------------------------------------------
|          DEPLOYMENT WIZARD DEPLOYMENT MANAGER          |
 --------------------------------------------------------
*/
var DeploymentWizardDeploymentManager = 
{
	/**
	 * Starts teh deployment process
	 * 
	 * This function does three things:
	 * 
	 * 1. Build the message to be sent that will trigger the start of deployment
	 * 2. Update the UI to reflect the deployment mode of things
	 * 3. Display any errors with billing to the user and reset the UI if needed
	 * 
	 * If a site is successfully created (which means deployment has started), this function
	 * then subscribes to appropriate channels, and other functionality in this object takes overs
	 * 
	 * @param {Object} msg
	 */
    doDeployment: function doDeployment(msg)
    {
		if(Portal.Data.siteList.sites.size() == 0)
		{
			this.addTabOnSuccess = true;
		}
		
        this.changingState = false;
		this.messagePending = false;
        this.deploymentInProgress = true;
        
        if (!msg) 
        {
			
			
            // our base msg template
            // we will extend this as we parse the collected data from the wizard
            var msg = 
            {
                request: 'deployProject',
                project: '',
                type: '',
                userId: '',
                password: '',
                siteName: '',
                servicePlanId: '',
                options: '',
                enableJaxer: '',
                billingInfo: 
                {
                    billingInfoId: '',
                    firstName: '',
                    lastName: '',
                    address1: '',
                    address2: '',
                    city: '',
                    state: '',
                    country: '',
                    zip: '',
                    phone: '',
                    billingName: '',
                    creditCardNumber: '',
                    expiration: '',
                    cvv2: '',
                    coupon: ''
                }
            }
            
            // just a convenience variable...
            var data = this.newSiteData;
            
			if(this.isTrial)
			{
				data.hostingData.hostingPlanId = 0;
				data.hostingData.optionIds = [];
				data.createNewAccount = true;
				data.billingAccountId = "-1";
			}
			
            // figure out the selected options...
            var options = [];
            data.hostingData.optionIds.each(function(optionId)
            {
                options.push(
                {
                    id: optionId.toString(),
                    plan: optionId.toString()
                });
            })
            
			if(this.newSiteData.couponValid && this.newSiteData.couponCode)
			{
				msg.billingInfo.coupon = this.newSiteData.couponCode;
			}
			
            // the base stuff for the deployment
            var baseInfo = 
            {
                project: 		data.projectName,
                type: 			data.projectType,
                userId: 		data.username,
                password:		data.password,
                siteName: 		data.siteName + '.aptanacloud.com',
                servicePlanId:	data.hostingData.hostingPlanId.toString(),
                enableJaxer: 	data.hostingData.jaxerEnabled,
                options: 		options
            }
            
            Object.extend(msg, baseInfo);
            
            if (data.createNewAccount) 
            {
				if(this.isTrial)
				{
					var billingData = 
	                {
	                    address1: 			"TRIAL_MODE",
	                    address2:			"TRIAL_MODE",
	                    city: 				"TRIAL_MODE",
	                    state: 				"TRIAL_MODE",
	                    country: 			"TRIAL_MODE",
	                    zip: 				"TRIAL_MODE",
	                    phone: 				"TRIAL_MODE",
	                    billingName: 		"TRIAL_MODE",
	                    creditCardNumber: 	"4111111111111111",
	                    expiration: 		"12/10",
	                    cvv2: 				"123",
						cardType:			"MC"
	                }
				}
				else
				{
	                var billingData = 
	                {
	                    address1: 			data.newBillingData.wizard_address_1,
	                    address2:			data.newBillingData.wizard_address_2,
	                    city: 				data.newBillingData.wizard_city,
	                    state: 				data.newBillingData.wizard_state,
	                    country: 			data.newBillingData.wizard_country,
	                    zip: 				data.newBillingData.wizard_zip,
	                    phone: 				data.newBillingData.wizard_phone,
	                    billingName: 		data.newBillingData.wizard_cardholder_name,
	                    creditCardNumber: 	data.newBillingData.wizard_card_number,
	                    expiration: 		data.newBillingData.wizard_card_expiry_month + '/' + data.newBillingData.wizard_card_expiry_year,
	                    cvv2: 				data.newBillingData.wizard_card_cvv2,
						cardType:			data.newBillingData.wizard_card_type
	                }
				}
                
                Object.extend(msg.billingInfo, billingData);
            }
            else 
            {
                msg.billingInfo.billingInfoId = data.billingAccountId;
            }
			
			if(this.isTrial)
			{
				msg.isTrial = true;
			}
			
			// store this for the template (when it renders)
			this.deploymentMessage = msg;
            
			// set up the progress bar dom
            $('wizardBreadCrumbs').update('<div>Deploying "' + baseInfo.project + '" to "http://' + baseInfo.siteName + '"</div>');
            
			// hide all current buttons
			$('wizardPlaceOrder').hide();
			$('wizardPlaceTrialOrder').hide();
            $('wizardBack').hide();
            $('wizardCancel').hide();
            
			if (this.isTrial) 
			{
				this.templates.deploymentScreen.set('data', 
				{
					title: 'Submitting your request...',
					mode: 'payment'
				});
			}
			else
			{
                this.templates.deploymentScreen.set('data', 
                {
                    title: 'Verifying your payment information...',
                    mode: 'payment'
                });
			}
			
			EventManager.publish('/portal/cloud/deploy', this.deploymentMessage);
        }
        else 
        {
			if(!('siteCreated' in msg.data))
			{
				return;
			}
			
			// deployment has started, let's wire everything up for the process
            if (msg.data.siteCreated == true) 
            {
				if (this.addTabOnSuccess)
				{
					this.addTabOnSuccess = false;
					Portal.API.tabs.reRegisterTab('my_cloud');
				}
				
				
				this.sendTrackingData('c.dw.dpl');
				
				// update the billing model, we may have a new account
                Portal.Data.currentUser.fetchBillingAccounts();
                
				// subscribe to the events for this site...
                EventManager.subscribe('/portal/cloud/site/events/' + msg.data.id, 
                {
                    channelHook: 'DeploymentWizard'
                });
				
				// set the "has deployed" pref (prevents display of intro content)
                Portal.API.utils.setPref('portal.cloud.deployment.hasdeployed', true);
                
				// set up some vars up, and move the progress bar along...
                this.newSiteData.siteId = msg.data.id;
                this.deploymentComplete = true;
                this.progressBarInterval = 10;
                this.incrementProgressBar();
				this.currentLogMessage = 'Provisioning site...'
                
				
				var templateData = 
				{
					title: 					'Setting up your site...',
					mode: 					'deployment',
					deploymentInProgress: 	this.templates.deploymentInProgress,
					logMessage:				this.currentLogMessage,
					lastLogMessage:			this.lastLogMessage
				}
                
				this.templates.deploymentScreen.set('data', templateData);
                
				EventManager.subscribe('/portal/cloud/site/console/' + msg.data.id, 
                {
                    channelHook: 'DeploymentWizard'
                });
                
                Portal.Data.siteList.fetchSiteList();
                
                new Effect.Appear('wizardBackground', 
                {
                    duration: 0.5
                });
            }
            else 
            {
				// this could end up here instead of the other error handler, so we need to handle post cloudmanager deployment errors here as well...
				if(this.newSiteData.siteId != 0)
				{
					this.deploymentStarted = false;
					this.deploymentInProgress = false;
		            this.deploymentComplete = false;
		            
		            EventManager.unsubscribe('/portal/cloud/site/events/' + this.newSiteData.siteId);
		            EventManager.unsubscribe('/portal/cloud/site/console/' + this.newSiteData.siteId);
					
		            if ($('progress_title')) 
		            {
		                $('progress_title').update('An error has occurred.');
		                $('deployment_extra').hide();
						
						
		                if (!('errors' in msg.data)) 
		                {
		                    msg.data.errors = [];
		                }
		                
		                if (msg.data.errors.length == 0) 
		                {
		                    msg.data.errors.push('An unknown error has occurred.  Please try again in a few minutes.  If the problem persists, please contact us for support.');
		                }
		                
		                var errorPrefix = 'Sorry, there was a problem deploying your site:';
						$('deployment_error').update(Portal.API.templates.parseErrors(errorPrefix, msg.data.errors));
						
		                new Ajax.Updater('deploymentStatusCage', '/portlets/cloud/templates/deployment_wizard/deployment_failed.html');
		                
						new Effect.Appear('deployment_error', 
		                {
		                    duration: 0.25
		                });
						
		                new Effect.Fade('wizardBackground', 
		                {
		                    duration: 0.5
		                });
		                new Effect.Appear('wizardFinish', 
		                {
		                    duration: 0.5
		                });
		            }
					
					if(!this.deploymentCompleteSent)
					{
						this.deploymentCompleteSent	= true;
						this.sendTrackingData('c.dw.dpl_fail');
					}
					
					return;
				}
				
				
				// handles error messages, and restores the UI
				// COULD move this to templates, but its really not necessary, this dom stuff is pretty straight-forward
                
                // $('progress_text').update('Error.');
                
                $('deploymentStatusCage').hide();
                
                if (!('errors' in msg.data)) 
                {
                    msg.data.errors = [];
                }
                
                if (msg.data.errors.length == 0) 
                {
                    msg.data.errors.push('An unknown error has occurred.  Please try again in a few minutes.  If the problem persists, please contact us for support.');
                }
                
                var errorPrefix = 'Sorry, there was a problem with your order:';
				$('deployment_error').update(Portal.API.templates.parseErrors(errorPrefix, msg.data.errors));
                $('deployment_error').insert(
                {
                    after: '<div class="top10">Please correct any errors that you can, and try again.  If the error(s) continue, please <a href="javascript: Portal.API.utils.openUrl(\'http://support.aptana.com/asap/browse/ACL\');">contact us</a> for support.</div>'
                });
                
                new Effect.Appear('deployment_error', 
                {
                    duration: 0.25
                });
                new Effect.Appear('wizardCancel', 
                {
                    duration: 0.25
                });
                new Effect.Appear('wizardBack', 
                {
                    duration: 0.25
                });
				
				this.deploymentStarted = false;
            }
        }
        
    },
    
    updateProvisioningStatus: function(msg)
    {
        var status = msg.data.status;
		
        if (status == 'Running') 
        {
			Portal.Modules.CloudTrialStatus.fetchTrialUpdate();
			
			if (!this.deploymentCompleteSent) 
			{
				this.deploymentCompleteSent = true;
				this.sendTrackingData('c.dw.dpl_com');
			}
			
            this.deploymentComplete = true;
            this.deploymentInProgress = false;
			this.deploymentStarted = false;
            
            // refresh the site model
            EventManager.publish('/portal/cloud/sites', 
            {
                request: 'listSites'
            });
			
			// update the site services
			Portal.Data.siteList.fetchSiteServices(this.newSiteData.siteId);
            
            if ($('progress_title')) 
            {
				var showComplete = function()
				{
	                $('progress_title').innerHTML = 'Your site is running!';
					
					var file = '/portlets/cloud/templates/deployment_wizard/deployment_complete.html';
					
					if(this.newSiteData.projectType == 'rails')
					{
						file = '/portlets/cloud/templates/deployment_wizard/deployment_complete_rails.html'
					}
					
	                new Ajax.Updater('deploymentStatusCage', file, 
	                {
	                    onComplete: function()
	                    {
							$('deployment_extra').hide();
	                    }
	                });
					
	                new Effect.Fade('wizardBackground', 
	                {
	                    duration: 0.5
	                });
	                new Effect.Appear('wizardFinish', 
	                {
	                    duration: 0.5
	                });
				}.bind(this);
				
				setTimeout(showComplete, 1000);
            }
            else 
            {
                this.showModalSiteComplete();
            }
			
            EventManager.unsubscribe('/portal/cloud/site/events/' + this.newSiteData.siteId);
            EventManager.unsubscribe('/portal/cloud/site/console/' + this.newSiteData.siteId);
        }
        else if (status == 'Error') 
        {
			Portal.Modules.CloudTrialStatus.fetchTrialUpdate();
            this.deploymentInProgress = false;
            this.deploymentComplete = false;
			this.deploymentStarted = false;
            
            EventManager.unsubscribe('/portal/cloud/site/events/' + this.newSiteData.siteId);
            EventManager.unsubscribe('/portal/cloud/site/console/' + this.newSiteData.siteId);
			
            if ($('progress_title')) 
            {
                $('progress_title').update('An error has occurred.');
                $('deployment_extra').hide();
				
				if (!('errors' in msg.data)) 
                {
                    msg.data.errors = [];
                }
                
                if (msg.data.errors.length == 0) 
                {
                    msg.data.errors.push('An unknown error has occurred.  Please try again in a few minutes.  If the problem persists, please contact us for support.');
                }
                
                var errorPrefix = 'Sorry, there was a problem deploying your site:';
				$('deployment_error').update(Portal.API.templates.parseErrors(errorPrefix, msg.data.errors));
				
                new Ajax.Updater('deploymentStatusCage', '/portlets/cloud/templates/deployment_wizard/deployment_failed.html');
                
				new Effect.Appear('deployment_error', 
                {
                    duration: 0.25
                });
                new Effect.Fade('wizardBackground', 
                {
                    duration: 0.5
                });
                new Effect.Appear('wizardFinish', 
                {
                    duration: 0.5
                });
            }
            
        }
        else 
        {
            if ($('progress_bar_main')) 
            {
				var templateData = 
				{
					title: 					'Setting up your site...',
					mode: 					'deployment',
					deploymentInProgress: 	this.templates.deploymentInProgress,
					status:					status,
					logMessage:				this.currentLogMessage,
					lastLogMessage:			this.lastLogMessage
				}

				this.templates.deploymentScreen.set('data', templateData);
            }
        }
    },
    
    updateProvisioningLog: function(msg)
    {
		/**
		 * Example set of log messages...
		 * 
		 * Requesting zone to spin up at provider
		 * Firing off job to spin up site at provider
		 * Creating admin account on site for user
		 * Asking provider for data about site iantest0907j.aptanacloud.com
		 * Initializing site. Try #1
		 * Connecting via SSH to grab Jaxer version
		 * Set up SFTP Roots for domains on site iantest0907j.aptanacloud.com
		 * Recording external IP (207.7.124.109) for iantest0907j.aptanacloud.com
		 * Set Jaxer version (1.0.0.3674) on site iantest0907j.aptanacloud.com
		 * Executing post-install init script
		 * Init script ready on site iantest0907j.aptanacloud.com
		 * Uploading post-install init script to site iantest0907j.aptanacloud.com
		 * Took 12169ms to complete initialization of iantest0907j.aptanacloud.com
		 * Executed init script on site iantest0907j.aptanacloud.com
		 * Asking provider for data about site iantest0907j.aptanacloud.com
		 * Adding unix user account for iselby on iantest0907j.aptanacloud.com
		 * Adding private domain account for iselby on iantest0907j.aptanacloud.com
		 * Adding MySQL user account for iselby on iantest0907j.aptanacloud.com
		 */
		
        if (!$('provisioningConsole')) 
        {
            return;
        }
        
		if(typeof(this.lastLogMessage) == 'undefined')
		{
			this.lastLogMessage = '';
		}
		
        var logMessage = msg.data.log.split('\n');
        logMessage = logMessage.without('');
        
		var lastLogMessage = logMessage[logMessage.length - 1];
		
		this.lastLogMessage = (this.lastLogMessage.indexOf(lastLogMessage) == -1) ? lastLogMessage : this.lastLogMessage + '.';
		
		logMessage = logMessage.join('<br />');
        
		this.currentLogMessage = logMessage;
		
		var templateData = 
		{
			title: 					'Setting up your site...',
			mode: 					'deployment',
			deploymentInProgress: 	this.templates.deploymentInProgress,
			logMessage:				this.currentLogMessage,
			lastLogMessage:			this.lastLogMessage
		}
		
		this.templates.deploymentScreen.set('data', templateData);
		
        // $('provisioningConsole').update(logMessage);
        // var objDiv = document.getElementById("provisioningConsole");
        // objDiv.scrollTop = objDiv.scrollHeight;
    },
    
    showSyncDialog: function()
    {
        if ($('uploadProjectCage')) 
        {
            new Effect.BlindUp('uploadProjectCage', 
            {
                duration: 0.25
            });
        }
        
        EventManager.publish('/portal/cloud/sync', 
        {
            request: 'syncSite',
            id: this.newSiteData.siteId
        });
    },
    
    showSiteInCloud: function showSiteInCloud()
    {
        if (typeof(Portal.Modules.MyCloudPortal) != 'undefined' && Portal.API.tabs.currentTab == 'tab_my_cloud') 
        {
            Portal.Modules.MyCloudPortal.showSiteInCloud(this.newSiteData.siteId);
        }
        else 
        {
            Portal.Vars.siteToLoad = this.newSiteData.siteId;
            Portal.API.tabs.loadTabManually('tab_my_cloud');
        }
        
        if (this.siteCompleteDialog && this.siteCompleteDialog.isOpen) 
        {
            this.closeModalSiteComplete();
        }
        else 
        {
            this.finishDeployment();
        }
        
    },
    
    openSite: function()
    {
        Portal.API.utils.openUrl('http://' + this.newSiteData.siteName + '.aptanacloud.com');
    },
    
    incrementProgressBar: function()
    {
		return;
		
        this.progressBarInterval = this.progressBarInterval + 4;
        
        $('progress_bar_main').update('');
        
        this.progress_bar = new Control.ProgressBar('progress_bar_main');
        this.progress_bar.step(this.progressBarInterval);
    },
    
    showModalSiteComplete: function showModalSiteComplete()
    {
		// don't show this if a wizard window is open, or another confirmation is...
		if($('wizardCage') || $('modalDeploymentComplete') || Control.Window.windows.size() > 0)
		{
			return;
		}
		
		var file = 'portlets/cloud/templates/deployment_wizard/modal_deployment_complete.html';
		
		if(this.newSiteData.projectType == 'rails')
		{
			file = 'portlets/cloud/templates/deployment_wizard/modal_deployment_complete_rails.html';
		}
		
        new Ajax.Request(file, 
        {
            onComplete: function(response)
            {
                this.siteCompleteDialog = new Control.Modal(response.responseText, 
                {
                    closeOnClick: false,
                    className: 'modal',
                    width: 400,
                    overlayOpacity: 0.5,
                    fade: true,
                    height: null,
                    fadeDuration: 0.25,
                    iframeshim: false,
                    afterOpen: Prototype.emptyFunction
                });
                
                this.siteCompleteDialog.open();
            }.bind(this)
        });
    },
    
    closeModalSiteComplete: function closeModalSiteComplete()
    {
        this.siteCompleteDialog.close();
        this.siteCompleteDialog.destroy();
    }
}