/*
 -------------------------------------------
|          DEPLOYMENT WIZARD VIEWS          |
 -------------------------------------------
*/
var DeploymentWizardViews = 
{
    _initViews: function _initViews()
    {
        // fetch all the templates and get them ready to go...
        View.load(
        {
            // the bread crumbs template
            breadCrumbs: 
            {
                file: '/portlets/cloud/templates/deployment_wizard/breadcrumbs.html',
                binding: function()
                {
                    return $('wizardBreadCrumbs');
                }
            },
            // step 1 of the wizard
            step1: 
            {
                file: '/portlets/cloud/templates/deployment_wizard/step_1_new.html',
                binding: function()
                {
                    return $('dynamicWizardContentCage');
                },
                behaviors: function()
                {
                    this.fadeInContent(function()
                    {
                        // validate teh site name
						this.validatingSiteName = true;
                        this.preValidateSiteName();
                    }.bind(this));
                }.bind(this)
            },
            // step 2 of the wizard
            step2: 
            {
                file: '/portlets/cloud/templates/deployment_wizard/step_2_new.html',
                binding: function()
                {
                    return $('dynamicWizardContentCage');
                },
                behaviors: function()
                {
                    this.fadeInContent(function()
                    {
                        Portal.API.modules.loadModule('WizardConfigurator', WizardConfiguratorModule, false);
                    });
                }.bind(this)
            },
			// step 3 of the wizard
            step3: 
            {
                file: '/portlets/cloud/templates/deployment_wizard/step_3_new.html',
                binding: function()
                {
                    return $('dynamicWizardContentCage');
                },
                behaviors: function()
                {
                    this.fadeInContent(function()
                    {
                        Portal.API.modules.loadModule('WizardConfigurator', WizardConfiguratorModule, false);
                    });
                }.bind(this)
            },
            // step 4 of the wizard
            step4: 
            {
                file: '/portlets/cloud/templates/deployment_wizard/step_4_new.html',
                binding: function()
                {
                    return $('dynamicWizardContentCage');
                },
                behaviors: function()
                {
					
                    this.fadeInContent(function()
                    {
                        // set up the click listeners for the radio buttons
                        $$('input.user_type').each(function(item)
                        {
							$(item).stopObserving('click');
							
                            $(item).observe('click', function(event)
                            {
                                switch (Event.element(event).id)
                                {
                                    case 'user_current':
                                        $$('*.newUserForm').each(function(item)
                                        {
                                            $(item).hide();
                                        });
                                        $$('*.currentUserForm').each(function(item)
                                        {
                                            $(item).show();
                                        });
                                        
                                        $('wizard_forgotPassword').show();
                                        
                                        $('username_create_notes').hide();
                                        $('password_create_notes').hide();
                                        
                                        break;
                                    case 'user_new':
                                        $$('*.newUserForm').each(function(item)
                                        {
                                            $(item).show();
                                        });
                                        $$('*.currentUserForm').each(function(item)
                                        {
                                            $(item).hide();
                                        });
                                        
                                        $('wizard_forgotPassword').hide();
                                        
                                        $('username_create_notes').show();
                                        $('password_create_notes').show();
                                        
                                        break;
                                }
                            });
							
                        });
						if(!Portal.Modules.AptanaIdManager.isLoggedIn)
						{
							$$('*.newUserForm').each(function(item)
                            {
                                $(item).show();
                            });
                            $$('*.currentUserForm').each(function(item)
                            {
                                $(item).hide();
                            });
                            
                            $('wizard_forgotPassword').hide();
                            
                            $('username_create_notes').show();
                            $('password_create_notes').show();
						}
                        
                        if (this.usernameValid || Portal.Modules.AptanaIdManager.isLoggedIn) 
                        {
							this.newSiteData.username = Portal.Data.currentUser.username;
							this.newSiteData.password = Portal.Data.currentUser.password;
							
                            $('wizard_username').disable();
                            $('wizard_password').disable();
                        }
						else if (!Portal.Modules.AptanaIdManager.isLoggedIn)
						{
							$('wizard_username').focus();
						}
                    }.bind(this));
                }.bind(this)
            },
            // step 5 of the wizard
            step5: 
            {
                file: '/portlets/cloud/templates/deployment_wizard/step_5_new.html',
                binding: function()
                {
                    return $('dynamicWizardContentCage');
                },
                behaviors: function()
                {
                    this.fadeInContent(function()
                    {
						$('wizard_billingInfo').onSubmit = function() { return false; }
			
						$('wizard_billingInfo').observe('submit', function(event)
						{
							Event.stop(event);
							return false;
						});
						
						Validation.add('wizard-card-number', 'Please enter a valid card number', { minLength: 13 });
						
                        // set up the validator
                        this.validator = new Validation('wizard_billingInfo', 
                        {
                            onSubmit: false,
                            immediate: true
                        });
                        
                        this.validator.reset();
                        
                        if (Portal.Data.currentUser.billingAccounts.size() > 0) 
                        {
                            $$('input.billingAccountSelect').each(function(element)
                            {
                                $(element).stopObserving('click');
                                $(element).observe('click', function(event)
                                {
                                    if (Event.element(event).checked && Event.element(event).value != 0) 
                                    {
                                        $('wizard_new_account').hide();
                                    }
                                    else 
                                    {
                                        $('wizard_new_account').show();
                                    }
                                });
                            });
                            
                        }
                        
						// pre-fill the form...
                        try 
                        {
                            $H(this.newSiteData.newBillingData).each(function(item)
                            {
                                if ($(item.key)) 
                                {
                                    $(item.key).value = item.value;
                                }
                            });
                        } 
                        catch (e) 
                        {
                            // we don't want to re-throw this error, as it could (in theory) happen
							// and this would be OK if there wasn't a form or values for the form
							console.warn(e);
                        }
						
						$('apply_code').stopObserving('click');
                        $('apply_code').observe('click', function()
                        {
							if($F('coupon_code') == '')
							{
								return;
							}
							
							this.newSiteData.couponCode = $F('coupon_code').escapeHTML();
							this.couponCodeApply = true;
							$('coupon_code_error').hide();
							$('coupon_code_form').hide();
							$('coupon_code_processing').show();
							
							this.fetchOrderPreview();
							
                        }.bind(this));
                        
                    }.bind(this));
                    
                }.bind(this)
            },
			// step 6 of the wizard
            step6: 
            {
                file: '/portlets/cloud/templates/deployment_wizard/step_6_new.html',
                binding: function()
                {
                    return $('dynamicWizardContentCage');
                },
                behaviors: function()
                {
                    this.fadeInContent(function()
                    {
                        if ($('terms_box')) 
                        {
                            $('terms_box').setStyle(
                            {
                                height: $('wizardCage').getHeight() - 305 + 'px'
                            });
                        }
                        
                        $('terms').setStyle(
                        {
                            height: $('terms').getHeight() + 'px'
                        });
                    });
                    
                }.bind(this)
            },
			// step 7 of the wizard (confirmation screen)
			step7:
			{
				file: '/portlets/cloud/templates/deployment_wizard/step_7.html',
				binding: function()
				{
					return $('dynamicWizardContentCage');
				},
				behaviors: function()
				{
                    this.fadeInContent(function()
                    {
						this.messagePending = false;
                    });
				}.bind(this)
			},
			orderSection:
			{
				file: '/portlets/cloud/templates/deployment_wizard/confirmation/order_section.html'
			},
			// new billing account form
            billingAccountNew: 
            {
                file: '/portlets/cloud/templates/deployment_wizard/billing_new_account.html',
                behaviors: function()
                {
                    $('cardholder_name').focus();
                }
            },
			deploymentScreen:
			{
				file: '/portlets/cloud/templates/deployment_wizard/deployment_screen.html',
				binding: function()
				{
					return $('dynamicWizardContentCage');
				},
				behaviors: function()
				{
                    this.fadeInContent(function()
                    {
						// nothing here..
							
                    }.bind(this));
				}.bind(this)
			},
			deploymentInProgress:
			{
				file: '/portlets/cloud/templates/deployment_wizard/deployment_in_progress.html'
			}
        }, function(templates)
        {
            this.templates = templates;
            
            this.showWizardDialog();
            
        }.bind(this));
    },
    
    /**
     * Simple little wrapper for the steps to use to fade in the content area
     *
     * @param {Function} callback
     */
    fadeInContent: function fadeInContent(callback)
    {
        new Effect.Appear('dynamicWizardContentCage', 
        {
            duration: 0.25,
            afterFinish: function()
			{
				var fixDisplay = function()
                {
                    $('dynamicWizardContentCage').setStyle({ height: $('dynamicWizardContentCage').getHeight() + 'px' });
					callback();
					
					this.changingState = false;	
                }.bind(this)
                
                setTimeout(fixDisplay, 0);
				
			}.bind(this)
        });
    },
    
    /**
     * Actually fetches the modal window content and opens it.
     *
     */
    showWizardDialog: function showWizardDialog()
    {
        // show the window...
        new Ajax.Request('/portlets/cloud/templates/deployment_wizard/wizard_wrapper.html', 
        {
            onComplete: function(response)
            {
                this.wizardDialog = new Control.Modal(response.responseText, 
                {
                    closeOnClick: false,
                    className: 'modal',
                    width: 650,
                    height: (document.viewport.getHeight() - 50 > 575) ? 575 : document.viewport.getHeight() - 50,
                    overlayOpacity: 0.75,
                    fade: false,
                    fadeDuration: 0.25,
                    iframeshim: false,
                    afterOpen: function()
                    {
                        // Firefox 2 caret bug fix stuff
                        $('wizardCage').style.display = 'none';
                        $('control_overlay').style.position = 'absolute';
                        
                        var fixDisplay = function()
                        {
                            $('wizardCage').style.display = 'block';
                            
                            // continue the init process of the wizard
                            this.initWizard();
                            
                        }.bind(this);
                        
                        setTimeout(fixDisplay, 0);
                        
                        // set up the hotkey listener that allows "RETURN" to advance the wizard
                        Portal.Modules.DeploymentWizard.hotKeyReturn = new HotKey('RETURN', function(event)
                        {
                            Portal.Modules.DeploymentWizard.processCurrentStep();
                        }, 
                        {
                            ctrlKey: false
                        });
                        
                    }.bind(this)
                });
                
                if ($('deploy_project_button')) 
                {
                    $('deploy_project_button').show();
                    $('loading_wizard_cage').hide();
                }
				
				if(typeof(Portal.Modules.CloudWelcomeMat) != 'undefined')
				{
					Portal.Modules.CloudWelcomeMat.loadingWizard = false;
				}
				
				this.sendTrackingData('c.dw');
				// also register step 1 for the first time
				this.sendTrackingData();
                
                this.wizardDialog.open();
                
            }.bind(this)
        });
    },
    
	/**
	 * Renders the first step
	 */
    renderStep1: function renderStep1()
    {
        this.templates.step1.set('newSiteData', this.newSiteData);
    },
    
	/**
	 * Renders teh second step
	 */
    renderStep2: function renderStep2()
    {
        this.templates.step2.render();
    },
    
	/**
	 * Renders the third step
	 */
    renderStep3: function renderStep3()
    {
        this.templates.step3.render();
    },
    
	/**
	 * Renders the fourth step
	 */
    renderStep4: function renderStep4()
    {
		if(Portal.Modules.AptanaIdManager.isLoggedIn)
		{
			this.newSiteData.username = Portal.Data.currentUser.username;
			this.newSiteData.password = Portal.Data.currentUser.password;
		}
		
        var templateData = 
        {
            usernameValid: this.usernameValid,
            purchaseCredentialsSaved: this.purchaseCredentialsSaved,
            isLoggedIn: Portal.Modules.AptanaIdManager.isLoggedIn,
            newSiteData: this.newSiteData
        }
        
        this.templates.step4.set('data', templateData);
    },
    
	/**
	 * Renders the fifth step
	 */
    renderStep5: function renderStep5()
    {
		// empty coupon codes sometimes return as valid
		if(this.newSiteData.couponCode == '')
		{
			this.newSiteData.couponValid = false;
		}
		
        var templateData = 
        {
            loading: false,
            billingAccountNew: this.templates.billingAccountNew,
            billingErrors: Portal.Data.currentUser.billingErrors,
            billingAccounts: Portal.Data.currentUser.billingAccounts,
            newSiteData: this.newSiteData
        }
        
        if (Portal.Data.currentUser.billingLoading) 
        {
            templateData.loading = true;
            
            this.templates.step5.set('data', templateData);
            return;
        }
        
		this.fetchOrderPreview();
		
        this.templates.step5.set('data', templateData);
    },
    
	/**
	 * Renders the sixth step
	 */
    renderStep6: function renderStep6()
    {
        this.templates.step6.set('agreeToTerms', this.newSiteData.agreeToTerms);
    },
    
	/**
	 * Renders the seventh step
	 */
    renderStep7: function renderStep7(msg)
    {
		if(!msg)
		{
			this.fetchOrderPreview();
		}
		else
		{
			var idSequence = 0;
	
	        // collect the line items into a more consise structure
	        var lineItems = msg.data.xmlData.quote.invoice.line_items.collect(function(lineItem)
	        {
	            var item = lineItem.line_item;
	            return {
	                name: item.name,
	                description: item.description,
	                quantity: item.quantity,
	                price: parseFloat(item.total_amount),
					unitPrice: parseFloat(item.price),
	                id: idSequence++,
	                productId: item.product_id,
	                couponId: item.coupon_id
	            }
	        });
			
	        // remove the coupon specific line items since we are not dispalying them
	        // individually but rather the effects of the coupon as a whole
	        lineItems = lineItems.select(function(item){ return !item.couponId});
      
            // partition the usage line items from the service line items
	        var usageProductIds = Portal.Data.cloudProducts.plans.keys();
	        var usageLineItems = lineItems.select(function(li)
	        {
	            return usageProductIds.member(li.productId)
	        });
	        var serviceLineItems = lineItems.select(function(li)
	        {
	            return !usageProductIds.member(li.productId)
	        });
      
            // now build the coupon line items from the actual coupons
	        var couponLineItems = msg.data.xmlData.quote.coupons.collect(function(coupon)
	        {
	      	  var data = coupon.coupon;
	      	  
	      	  // flatten the errors
	      	  var flattenedErrors = [];
	      	  if (data.errors)
	      	  {
	      	      flattenedErrors = data.errors.collect(function(error){ return error.error; });
	      	  }
	      	  
	      	  return {
	      		  name: data.title,
	      		  description: data.description,
	      		  price: -parseFloat(data.total_discount_amount),
	      		  couponId: data.id,
	      		  id: idSequence++,
	      		  errors: flattenedErrors
	      	  }
	        });
			
	        var billingAccount = null;
	        var billingAccountId = this.newSiteData.billingAccountId;
			
			if (billingAccountId && billingAccountId != 0)
			{
				billingAccount = Portal.Data.currentUser.billingAccounts.get(billingAccountId)
			}
			else
			{
				var newBillingData = this.newSiteData.newBillingData
				billingAccount = {
					name:	newBillingData.wizard_cardholder_name,
					number: newBillingData.wizard_card_number,
					expiry: newBillingData.wizard_card_expiry_month + "/" + newBillingData.wizard_card_expiry_year 
				}
			}
		
			var projectedMonthlyCost = parseFloat(msg.data.xmlData.quote.invoice.amount);
		
			// data
			var data =
			{
				usageLineItems: 		usageLineItems,
				serviceLineItems: 		serviceLineItems,
				couponLineItems: 		couponLineItems,
				projectedMonthlyCost:	projectedMonthlyCost,
				billingAccount: 		billingAccount,
				orderSection:			this.templates.orderSection
			}
			
			this.messagePending = false;
			this.templates.step7.set('data', data);
		}
    }
}