var LocalProjectSwitcherModule = Class.create(
{
	finishInit: function finishInit()
	{
        Portal.Data.siteList.observe('siteUpdated', function(siteId)
        {
			if(siteId == Portal.Modules.MyCloudPortal.currentSiteId)
			{
				this.initDisplay();
			}
        }.bind(this));
		
        Portal.Data.cloudProjects.observe('undeployedListChanged', function()
        {
			this.initDisplay();
        }.bind(this));
		
		Portal.Data.cloudProjects.observe('projectListUpdated', function()
        {
			this.initDisplay();
        }.bind(this));
		
		this.initDisplay();
	},
	
	initDisplay: function initDisplay()
	{
		if(!$('site_local_project'))
		{
			return;
		}
		
		if(!Portal.Data.siteList.sites.get(Portal.Modules.MyCloudPortal.currentSiteId).project)
		{
			$('site_local_project').update('None');
		}
		else
		{
			$('site_local_project').update(Portal.Data.siteList.sites.get(Portal.Modules.MyCloudPortal.currentSiteId).project);
		}
		
		if (Portal.Data.cloudProjects.undeployedProjects.size() == 0)
		{
			$('local_project_create').show();
			$('local_project_chooser').hide();
		}
		else
		{
			$('local_project_create').hide();
			$('local_project_chooser').show();
			
			this.parseProjectDrop();
		}
	},
	
	parseProjectDrop: function parseProjectDrop()
	{
		var projectItemTemplate = new Template('<option value="#{name}">#{name}</option>');
		var newHtml = '';
		
        Portal.Data.cloudProjects.undeployedProjects.each(function(project)
        {
			if (Portal.Data.cloudProjects.notCloudCompatible.indexOf(project.value.type) != -1)
			{
				return;
			}
			
			newHtml += projectItemTemplate.evaluate(project.value);
        });
		
		if($('project_drop_cage'))
		{
			$('project_drop_cage').update('<select name="new_local_project" id="new_local_project" class="text" style="width: 150px;">'  + newHtml + '</select>');
		}
	},
	
	switchProject: function switchProject()
	{
		var newProject = $F('new_local_project');
	
        Portal.API.dialogs.confirm(
        {
			message: 'Are you sure you want to use "' + newProject + '" as the local project for this site?',
			onConfirm: function()
			{
                EventManager.publish('/portal/cloud/projects', 
                {
                    request: 'changeProject',
                    project: newProject,
                    site: Portal.Modules.MyCloudPortal.currentSiteId
                });
				
				this.showSyncWindow.delay(0.45);
				
			}.bind(this),
			title: 'Confirm Project Association Change'
		});
	},
	
	showSyncWindow: function showSyncWindow()
	{
		if (Portal.Modules.MyCloudPortal.currentSite.type == 'rails' || Portal.Modules.MyCloudPortal.currentSite.type == 'java') 
		{
			Portal.API.dialogs.alert('Now that you have changed your local project, would you like to deploy? <div class="top10 center"><a href="javascript: Portal.Modules.MyCloudPortal.doSync();"><img src="images_global/button_deploynow.png" align="absmiddle" class="inline link" /></a></div>', 'Would you like to deploy?');
		}
		else
		{
			Portal.API.dialogs.alert('Now that you have changed your local project, would you like to sync? <div class="top10 center"><a href="javascript: Portal.Modules.MyCloudPortal.doSync();"><img src="images_global/button_syncnow.png" align="absmiddle" class="inline link" /></a></div>', 'Would you like to sync?');
		}
	},
	
	importSiteToProject: function importSiteToProject()
	{
		EventManager.publish('/portal/wizard', 
        {
            request: 'import',
            id: 'com.aptana.ide.server.cloud.ui.ImportApplicationWizard',
			data: Portal.Modules.MyCloudPortal.currentSiteId
        });
	},
	
	newProject: function newProject()
    {
        EventManager.publish('/portal/wizard', 
        {
            id: 'com.aptana.ide.wizards.WebProjectWizard',
            request: 'new'
        });
    }
});