var LogsManagerModule = Class.create(
{
	initialize: function initialize()
	{
		this.siteId			= Portal.Modules.MyCloudPortal.currentSiteId;
		this.servicesList	= {};
		this.templates		= {};
		
		Object.extend(this, LogsManagerControllers);
		Object.extend(this, LogsManagerViews);
	},
	
	finishInit: function finishInit()
	{
		Portal.Data.siteList.observe('siteServicesUpdated', function(siteId)
        {
			if(siteId == this.siteId)
			{
				this._init();
			}
        }.bind(this));
		
		this._init();
	}
});

var LogsManagerControllers = 
{
	_init: function _init()
	{
		this.servicesList = Portal.Data.siteList.sites.get(this.siteId).services.servicesList;
		
		// we don't want pulse (for now...)
		this.servicesList.unset('pulse');
		
		this.setServerTypes();
		
		this._initViews();
	},
	
	setServerTypes: function setServerTypes()
	{
        this.servicesList.each(function(service)
        {
			var serverType = "";
			var serverImage = "";
			
			switch(service.value.name)
			{
				case 'apache':
					serverType = 'web server';
					serverImage = 'img_icon_apache.png';
					break;
				case 'jaxer':
					serverType = 'ajax server';
					serverImage = 'img_icon_jaxer.png';
					break;
				case 'mysql':
					serverType = 'database server';
					serverImage = 'img_icon_mysql.png';
					break;
				case 'postfix':
					serverType = 'mail server';
					serverImage = 'img_icon_postfix.png';
					break;
			}
			
			service.value.serverType = serverType;
			service.value.serverImage = serverImage;
			
			this.servicesList.set(service.key, service.value);
			
        }.bind(this));
	},
	
	logAction: function logAction(event)
	{
		var element = $(Event.element(event));
		var location = element.rel;
		var name = element.id;
		var action = 'view';
		
		if (element.hasClassName('tail'))
		{
			action = 'tail';	
		}
		else if (element.hasClassName('browse'))
		{
			action = 'browse';
		}
		else if (element.hasClassName('download'))
		{
			action = 'download';
		}
		
		
		switch(action)
		{
			case 'view':
				Portal.Modules.MyCloudPortal.openRemoteFile(location);
				break;
			case 'browse':
				Portal.Modules.MyCloudPortal.browseRemoteFile(location);
				break;
			case 'tail':
				Portal.Modules.MyCloudPortal.tailRemoteFile(location, name.replace('tail_', '').replace('_', ' '));
				break;
			case 'download':
				Portal.Modules.MyCloudPortal.downloadRemoteFile(location);
				break;
			default:
				Portal.API.dialogs.alert('This feature not yet implemented...', 'Coming soon');
		}
				
		Portal.API.logging.logEvent('LOG ACTION (' + action + ')', location);		
		
		event.stop();
	}
}

var LogsManagerViews = 
{
	_initViews: function _initViews()
	{
		this.renderLogsList();
	},
	
	renderLogsList: function renderLogsList()
	{
		this.boundLogAction = this.logAction.bindAsEventListener(this);
		
        View.load(
        {
			main: 
			{
				file: 'portlets/cloud/templates/logs/logs_main.html',
				binding: function()
				{
					return $('site_logs');
				},
				scope:
				{
					servicesList: this.servicesList,
					siteId: this.siteId
				},
				behaviors: function()
				{
					var that = this;
					
                    $$('a.log_link').each(function(item)
                    {
						$(item).observe('click', that.boundLogAction);
						
                    });
				}.bind(this)
			},
			serviceItem:
			{
				file: 'portlets/cloud/templates/logs/log_item.html'
			}
		},
		function (templates)
		{
			this.templates = templates;
			
			this.templates.main.set('serviceItem', this.templates.serviceItem);
			
			this.templates.main.render();
			
		}.bind(this));
	}
}
