var SiteStatsModule = Class.create(
{
	initialize: function() {
		this.chartElement = 'chartCage';
		this.chartGroups = new Hash();
		this.currentChartItem = '';
		this.currentChartGroup = '';
	},
	
	finishInit: function()
	{
        EventManager.subscribe('/portal/cloud/statistics/', 
        {
            channelHook: 'SiteStats',
            onComplete: function()
            {
                this.fetchStatData('resources');
            }.bind(this)
        });
		
		this.chartGroups.set('resources', { items: ['CPU', 'Swap', 'Memory'] });
		this.chartGroups.set('web', { items: ['bytesTransferred', 'successfulHits', 'successfulPages', 'pagesWithReferrers'] });
		
	},
	
	dispatchEvent: function(msg)
	{
		if(msg.data.response == 'getStats')
		{
			this.fetchStats(msg);
		}
	},
	
	showGroupItemData: function(groupItem, forceRefresh)
	{
		var group = $F('chartGroups');
		this.currentChartItem = groupItem;
		
		if(forceRefresh && forceRefresh == true)
		{
			this.fetchStatData(group, true);
		}
		else
		{
			this.fetchStatData(group, false);	
		}
	},
	
	fetchStatData: function(dataType, forceRefresh)
	{
		if(this.currentChartGroup != dataType)
		{
			this.currentChartItem = '';
		}
		
		this.currentChartGroup = dataType;
		
		Portal.API.utils.setContent('chartWrapper', '<div class="working" style="width: 175px; margin: 0px auto;">Loading Stats, Please Wait...</div>');
		
		if(!forceRefresh)
		{
			var forceRefresh = true;
		}
		
        EventManager.publish('/portal/cloud/statistics', 
        {
            request: 'getStats',
            type: dataType,
            id: Portal.Modules.MyCloudPortal.currentSiteId,
            force: forceRefresh
        });
		
		if(forceRefresh == true)
		{
			EventManager.publish('/portal/cloud/sites', { request: 'siteInfo', id: Portal.Modules.MyCloudPortal.currentSiteId, refresh: true });
		}
	},
	
	fetchStats: function(msg)
	{
		if(!$('site_overview'))
		{
			return;
		}
		
		// these can take a while to load, and we don't want errors if people head away from this page...
		// this element will be present on the page, but it will be hidden if we're in another tab
		if($('site_overview').style.display == 'none')
		{
			return;
		}
		
		switch(msg.data.type)
		{
			case 'resources':
				this.processResourceStats(msg.data);
				break;
			case 'web':
				this.processWebStats(msg.data);
				break;
		}
	},
	
	processWebStats: function(data)
	{
        if(data.id != Portal.Modules.MyCloudPortal.currentSiteId || !$('chartWrapper'))
		{
			return;
		}
		
		var groups = [];
		var chartHTML = '';
		
		/**
		 * We need to build the following items:
		 *  - The chart title container
		 *  - The chart container
		 *  - The chart switcher container
		 */
		// first, let's get the group, and set the title...
		var groupToShow = (this.currentChartItem != '') ? this.currentChartItem : this.chartGroups.get('web').items[0];
		chartHTML += '<div id="chartTitle" style="width: 275px; margin: 5px; text-align: center;"><strong>' + groupToShow.underscore().gsub('_', ' ').capitalize() + ' (24 hours)</strong></div>';
		
		// we can just toss the container for the chart here for now...
		chartHTML += '<div id="chart" style="width: 260px; height: 213px;"></div>';
		
		// and we can parse the switcher before we display anything...
		var chartGroups = '<select name="chartGroups" id="chartGroups" style="width: 105px;" class="text" onChange="Portal.Modules.SiteStats.fetchStatData(this.value);">';
		this.chartGroups.each(function(item)
		{
			chartGroups += '<option value="' + item.key + '"';
			chartGroups += (item.key == 'web') ? ' selected' : '';
			chartGroups += '>' + item.key.capitalize() + '</option>';
		});
		chartGroups += '</select>';
		var chartGroupItems = '<select name="chartGroupItems" id="chartGroupItems" style="width: 115px;" class="text" onChange="Portal.Modules.SiteStats.showGroupItemData(this.value);">';
		this.chartGroups.get('web').items.each(function(item)
		{
			chartGroupItems += '<option value="' + item + '"';
			chartGroupItems += (item == groupToShow) ? ' selected' : '';
			chartGroupItems += '>' + item.underscore().gsub('_', ' ').capitalize() + '</option>';
		});
		chartGroupItems += '</select>';
				
		chartHTML += '<div id="chartSwitcher" class="clean-gray" style="margin: 10px 0 5px 0;">' + chartGroups + '&nbsp;' + chartGroupItems + 
		'&nbsp;&nbsp;<a href="javascript: Portal.Modules.SiteStats.showGroupItemData($F(\'chartGroupItems\'), true);" title="Refresh Stats"><img src="images_global/img_icon_refresh_small.png" align="absmiddle" style="margin-top: -2px;" /></a></div>';
		
		// and now we can finally show this stuff...
		Portal.API.utils.setContent('chartWrapper', chartHTML);
		
		if(data.groups.length == 0)
		{
			if($('chart'))
			{
                $('chart').setStyle(
                {
					background: 'url(images_global/bg_nostats.png) no-repeat center center',
					width: '260px',
					height: '215px'
				});
				
				$('chartWrapper').setStyle({ height: $('chartWrapper').getHeight() + 'px' });
			}
			
			
			return;
		}		
		
		// now that all the groundwork's done, we can go ahead and actually fetch the data and show the chart...
		data.groups.each(function(group)
		{
			if(!group.date || group.date == 'undefined')
			{
				group.date = 'Never';
			}
			Portal.API.utils.setContent('chartTitle', '<strong>' + groupToShow.underscore().gsub('_', ' ').capitalize() + '<br /><span style="font-size: 11px;">(24 hours - Last Update: ' + group.date + ')</span></strong>');
			var dataItemsTemp = [];
			
			group.dataItems.each(function(item)
			{
				// there's only one group in web stats, so we do it by data types...
				if(item.label != groupToShow)
				{
					return;
				}
				
				item.label = item.label.substr(item.label.indexOf('_') + 1).underscore().gsub('_', ' ').capitalize();
				
				if(item.label != 'created')
				{
					dataItemsTemp.push(item);
				}
				
			});
			
			this.drawDailyGraph('chart', dataItemsTemp, { startHour: group.startHour, startMinute: group.startMinute });
		}.bind(this));
	},
	
	processResourceStats: function(data)
	{
		if(data.id != Portal.Modules.MyCloudPortal.currentSiteId || !$('chartWrapper'))
		{
			return;
		}
		
		var groups = [];
		var chartHTML = '';
		
		/**
		 * We need to build the following items:
		 *  - The chart title container
		 *  - The chart container
		 *  - The chart switcher container
		 */
		// first, let's get the group, and set the title...
		var groupToShow = (this.currentChartItem != '') ? this.currentChartItem : this.chartGroups.get('resources').items[0];
		chartHTML += '<div id="chartTitle" style="width: 275px; margin: 5px; text-align: center;"><strong>' + groupToShow + '</strong><br />&nbsp;</div>';
		
		// we can just toss the container for the chart here for now...
		chartHTML += '<div id="chart" style="width: 260px; height: 213px;"></div>';
		
		// and we can parse the switcher before we display anything...
		var chartGroups = '<select name="chartGroups" id="chartGroups" style="width: 105px;" class="text" onChange="Portal.Modules.SiteStats.fetchStatData(this.value);">';
		this.chartGroups.each(function(item)
		{
			chartGroups += '<option value="' + item.key + '"';
			chartGroups += (item.key == 'resources') ? ' selected' : '';
			chartGroups += '>' + item.key.capitalize() + '</option>';
		});
		chartGroups += '</select>';
		var chartGroupItems = '<select name="chartGroupItems" id="chartGroupItems" style="width: 115px;" class="text" onChange="Portal.Modules.SiteStats.showGroupItemData(this.value);">';
		this.chartGroups.get('resources').items.each(function(item)
		{
			chartGroupItems += '<option value="' + item + '"';
			chartGroupItems += (item == groupToShow) ? ' selected' : '';
			chartGroupItems += '>' + item + '</option>';
		});
		chartGroupItems += '</select>';
				
		chartHTML += '<div id="chartSwitcher" class="clean-gray" style="margin: 10px 0 5px 0;">' + chartGroups + '&nbsp;' + chartGroupItems + 
		'&nbsp;&nbsp;<a href="javascript: Portal.Modules.SiteStats.showGroupItemData($F(\'chartGroupItems\'), true);" title="Refresh Stats"><img src="images_global/img_icon_refresh_small.png" align="absmiddle" style="margin-top: -2px;" /></a></div>';
		
		// and now we can finally show this stuff...
		Portal.API.utils.setContent('chartWrapper', chartHTML);
		
		if(data.groups.length == 0)
		{
			if($('chart'))
			{
                $('chart').setStyle(
                {
					background: 'url(images_global/bg_nostats.png) no-repeat center center',
					width: '260px',
					height: '215px'
				});
				
				$('chartWrapper').setStyle({ height: $('chartWrapper').getHeight() + 'px' });
			}
			
			
			return;
		}		
		
		// now that all the groundwork's done, we can go ahead and actually fetch the data and show the chart...
		data.groups.each(function(group)
		{
			var dataItemsTemp = [];
			
			group.dataItems.each(function(item)
			{
				item.label = item.label.substr(item.label.indexOf('_') + 1).underscore().gsub('_', ' ').capitalize();
				
				if(item.label != 'Percent above')
				{
					switch(item.label)
					{
						case 'Median':
							item.lines = { fill: true }
							item.color = '#005bb1';
							dataItemsTemp[0] = item;
							break;
						case 'Peak':
							item.color = '#cb4b4b';
							dataItemsTemp[1] = item;
							break;
						case 'Mean':
							item.color = '#84b638';
							dataItemsTemp[2] = item;
							break;
					}
				}
				
			});
			
			// we can just skip this iteration if this isn't the relevant chart... returning here is essentially the same thing as a 
			// break since we're using a prototype iterator function
			if(group.groupName != groupToShow)
			{
				return;
			}
			
			switch(group.groupName)
			{
				case 'CPU':
					this.drawHourlyGraph('chart', dataItemsTemp, { startHour: group.startHour, startMinute: group.startMinute }, { legend: { position: 'se' }});
					break;
				case 'Swap':
					this.drawHourlyGraph('chart', dataItemsTemp, { startHour: group.startHour, startMinute: group.startMinute }, { legend: { position: 'se' }});
					break;
				case 'Memory':
					this.drawHourlyGraph('chart', dataItemsTemp, { startHour: group.startHour, startMinute: group.startMinute }, { legend: { position: 'se' }});
					break;
			}			
		}.bind(this));
	},
	
	drawHourlyGraph: function(container, data, offsetData, opts)
	{
		if(!$(container))
		{
			return;
		}
		
		this.offsetData = offsetData;
		var options = 
		{
			legend: 
			{
				position: 'ne'
			},
			lines:
			{
				lineWidth: 2
			},
			yaxis: 
			{
				min: 0,
				max: 100,
				tickFormatter: function(number)
				{
					if(number == 0)
					{
						return '';
					}
					
					return number + '% '
				},
				noTicks: 5
			},
			xaxis:
			{
				min: 0,
				max: 60,
				tickFormatter: function(number)
				{
					if(number % 4 != 0)
					{
						return '';
					}
					
					var today = new Date();
					var offsetMinutes = 60-number;
					
					today.setMinutes(this.offsetData.startMinute);
					today.setHours(this.offsetData.startHour + 1);
					
					today.setMinutes(today.getMinutes() - offsetMinutes);
					
					var hour = today.getHours();
					var minutes = today.getMinutes();
					
					if(minutes < 10)
					{
						minutes = '0' + minutes;
					}
					
					if(hour == 0)
					{
						hour = 12;
					}
					if(hour > 12)
					{
						hour = hour - 12;
					}
					
					return hour + ':' + minutes;
					
				}.bind(this),
				noTicks: 5
			},
			shadowSize: 2
		}
		var o = Object.extend(Object.clone(options), opts || {});
		
		if(!$(container))
		{
			return;
		}
		
		return Flotr.draw
		(
			$(container),
			data,
			o
		);
			
	},
	
	drawDailyGraph: function(container, data, offsetData, opts)
	{
		if(!$(container))
		{
			return;
		}
		
		this.offsetData = offsetData;
		var options = 
		{
			legend: 
			{
				position: 'ne'
			},
			lines:
			{
				lineWidth: 4
			},
			yaxis: 
			{
				tickFormatter: function(number)
				{
					return number;
				},
				tickDecimals: 0
			},
			xaxis:
			{
				tickFormatter: function(number)
				{
					if(number % 4 != 0)
					{
						return '';
					}
					
					var today = new Date();
					var offsetHours = 23 - number;
					
					today.setMinutes(this.offsetData.startMinute);
					today.setHours(this.offsetData.startHour + offsetHours);
					
					var hour = today.getHours();
					var minutes = today.getMinutes();
					
					if(minutes < 10)
					{
						minutes = '0' + minutes;
					}
					
					if(hour == 0)
					{
						hour = 12;
						minutes = minutes + ' am';
					}
					else if(hour > 12)
					{
						hour = hour - 12;
						minutes = minutes + ' pm';
					}
					else
					{
						minutes = minutes + ' am';
					}
					
					if(number != 0 && number != 24)
					{
						minutes = minutes.substr(0, minutes.length-3);
					}
					
					if(isNaN(hour) || isNaN(minutes))
					{
						return '';
					}
					
					return hour + ':' + minutes;
					
				}.bind(this),
				noTicks: 12,
				min: 0,
				max: 24
			},
			shadowSize: 2
		}
		var o = Object.extend(Object.clone(options), opts || {});
		
		if(!$(container))
		{
			return;
		}
		
		return Flotr.draw
		(
			$(container),
			data,
			o
		);
			
	},
	
	loadDebugChart: function()
	{
		var d1 = [];
		var d2 = [];
		var d3 = [];
	    for(var i = 0; i < 20; i += 0.5){
			d1.push([i, 2*i]);
			d2.push([i, i*1.5+1.5*Math.sin(i)]);
	        d3.push([i, 3*Math.cos(i)+10]);
		}
		
		var f = Flotr.draw
		(
			$(this.chartElement), 
			[{data:d1,mouse:{track:false}}, d2, d3 ],
			{
				xaxis: 
				{
					noTicks: 7,
					tickDecimals: 0
				},
				yaxis:
				{
					noTicks: 7,
					tickDecimals: 0
				},
				legend:
				{
					position: 'ne'
				},
				mouse:
				{
					track: true,
					lineColor: 'purple',
					sensibility: 1, // => The smaller this value, the more precise you've to point
					trackDecimals: 2,
					trackFormatter: function(obj){ return 'x = ' + obj.x +', y = ' + obj.y; }
				}
			}
		);
	}
});