var SiteStatsModule = Class.create(
{
	initialize: function initialize()
	{
		this.currentSite		= Portal.Modules.MyCloudPortal.currentSite;
		this.gaugeUrl 			= this.currentSite.urls.privateUrl + '/aptana/charts/index.php';
		this.chartUrl			= this.currentSite.urls.privateUrl + '/aptana/charts/charts.php';
		this.templates			= {};
		this.loaded				= false;
		this.currentChartGroup	= 'resources';
		this.currentResolution	= 'fine';
		this.chartGroupSize		= 'large';
		this.currentChartItem	= 'CPU';
		this.dataRequestFailure	= false;
		
		Object.extend(this, SiteStatsControllers);
		Object.extend(this, SiteStatsViews);
	},
	
	finishInit: function finishInit()
	{
		this._init();
	}
});

var SiteStatsControllers = 
{
	_init: function _init()
	{
		this.fetchGaugeData();	
	},
	
	fetchGaugeData: function fetchGaugeData(siteId)
	{
		if(typeof(siteId) != 'undefined' && siteId != Portal.Modules.MyCloudPortal.currentSite.id)
		{
			return;
		}
		
		Portal.API.logging.logEvent('SITE STATS', 'Requesting gauge data from ' + this.gaugeUrl);
		
        new Ajax.Request('/proxy?url=' + encodeURIComponent(this.gaugeUrl), 
        {
			method: 'get',
			onFailure: function(response)
			{
				// should get a response like: {"cpu":"1","ram":"61","swap":"30","created":1218823994}
				// however, if network's down, script doesn't exist, whatever, we'll just put empty data in here...
				
				this.gaugeData = 
				{
					cpu: 			0,
					ram: 			0,
					swap: 			0,
					diskUsage: 		0,
					diskSize:		0,
					diskPercent:	0,
					created: 		0
				}
				
				this.dataRequestFailure = true;
				
				if (!this.loaded) 
				{
					this._initViews();
					this.loaded = true;
				}
				else
				{
					this.templates.chartGauges.set('gaugeData', this.gaugeData);
					this.templates.diskUsage.set('gaugeData', this.gaugeData);
				}
				
				this.notify('siteStatsUpdated');
				
			}.bind(this),
			onComplete: function(response)
			{
				this.gaugeData = response.responseText.evalJSON();
				this.calcGaugeOffsets();
				
				if (!this.loaded) 
				{
					this._initViews();
					this.loaded = true;
				}
				else
				{
					this.templates.chartGauges.set('gaugeData', this.gaugeData);
					this.templates.diskUsage.set('gaugeData', this.gaugeData);
				}
				
				this.notify('siteStatsUpdated');
				
			}.bind(this)
		})
	},
	
	calcGaugeOffsets: function calcGaugeOffsets()
	{
		this.gaugeData.cpuOffset = 1700 - (Math.round((this.gaugeData.cpu > 100) ? 1700 : this.gaugeData.cpu / 5) * 85); 
		this.gaugeData.ramOffset = 1700 - (Math.round((this.gaugeData.ram > 100) ? 1700 : this.gaugeData.ram / 5) * 85);
		this.gaugeData.swapOffset = 1700 - (Math.round((this.gaugeData.swap > 100) ? 1700 : this.gaugeData.swap / 5) * 85);
		
		this.gaugeData.diskOffset = Math.round(this.gaugeData.diskPercent / 5) * 17 - 17;
		
		// get the available disk space...
		this.gaugeData.diskAvailable = (this.gaugeData.diskSize - this.gaugeData.diskUsage).toFixed(2);
		
		// this.chartIncrement = Math.round(this.diskPercent / 5) * 17 - 17;
	},
	
	fetchChart: function fetchChart(siteId)
	{
		if(typeof(siteId) != 'undefined' && siteId != Portal.Modules.MyCloudPortal.currentSite.id)
		{
			return;
		}

		// if the gauges fail, this will as well... so we'll display something nice to the user
		if(this.dataRequestFailure)
		{
			$('chart_display').update('<div class="center" style="padding-top: 90px;"><strong>Charts Temporarily Unavailable.</strong></div>');
			
			this.notify('siteStatsUpdated');
			
			return;
		}
		
		var d = new Date();
		var timezoneOffset = d.getTimezoneOffset() / 60;
		
		var query_string = 's=' + this.chartGroupSize + '&r=' + this.currentChartItem + '&offset=' + timezoneOffset + '&cb=' + d.getTime() + '&t=' + this.currentResolution;
		
		Portal.API.logging.logEvent('SITE STATS', 'Requesting chart image from ' + this.chartUrl + '?' + query_string); 
		
		if(this.currentChartGroup == 'resources')
		{
			if(this.chartGroupSize == 'large')
			{
				$('chart_display').update('<img src="/proxy?nocache=true&url=' + encodeURIComponent(this.chartUrl + '?' + query_string) + '" />');
				$('resource_groups').show();
				$('web_groups').hide();
			}
			else
			{
				// convert to charting api variable
				if(this.chartGroupSize == 'quad')
				{
					this.chartGroupSize = 'small';
				}
				
				// this is a bit silly, but its the best way to build / display the UI easily... not everything has to be uber-elegant ;)
				query_string = 's=' + this.chartGroupSize + '&r=CPU&offset=' + timezoneOffset + '&cb=' + d.getTime() + '&t=' + this.currentResolution;
				var cpuImage = '<img src="/proxy?nocache=true&url=' + encodeURIComponent(this.chartUrl + '?' + query_string) + '" style="margin-right: 5px;" />';
				
				query_string = 's=' + this.chartGroupSize + '&r=Memory&offset=' + timezoneOffset + '&cb=' + d.getTime() + '&t=' + this.currentResolution;
				var memoryImage = '<img src="/proxy?nocache=true&url=' + encodeURIComponent(this.chartUrl + '?' + query_string) + '" />';
				
				query_string = 's=' + this.chartGroupSize + '&r=Swap&offset=' + timezoneOffset + '&cb=' + d.getTime() + '&t=' + this.currentResolution;
				var swapImage = '<img src="/proxy?nocache=true&url=' + encodeURIComponent(this.chartUrl + '?' + query_string) + '" style="margin-right: 5px;" />';
				
				query_string = 's=' + this.chartGroupSize + '&r=Disk&offset=' + timezoneOffset + '&cb=' + d.getTime() + '&t=' + this.currentResolution;
				var diskImage = '<img src="/proxy?nocache=true&url=' + encodeURIComponent(this.chartUrl + '?' + query_string) + '" />';
				
				// build our titles and output the new images
				if (this.currentResolution == 'fine') 
				{
					$('chart_display').update('<div class="center bottom5"><strong>Usage For the Last Hour (Percent)</strong></div>' + cpuImage + memoryImage + swapImage + diskImage);
				}
				else if (this.currentResolution == 'medium')
				{
					$('chart_display').update('<div class="center bottom5"><strong>Usage For the Last 24 Hours (Percent)</strong></div>' + cpuImage + memoryImage + swapImage + diskImage);	
				}
				
				$('resource_groups').hide();
				$('web_groups').hide();
			}
		}
		else
		{
			if(this.chartGroupSize == 'large')
			{
				$('chart_display').update('<img src="/proxy?nocache=true&url=' + encodeURIComponent(this.chartUrl + '?' + query_string) + '" />');
				
				$('resource_groups').hide();
				$('web_groups').show();
			}
			else
			{
				$('resource_groups').hide();
				$('web_groups').hide();

				// convert to charting api variable
				if(this.chartGroupSize == 'quad')
				{
					this.chartGroupSize = 'small';
				}
				
				// this is a bit silly, but its the best way to build / display the UI easily... not everything has to be uber-elegant ;)
				query_string = 's=' + this.chartGroupSize + '&r=pages&offset=' + timezoneOffset + '&cb=' + d.getTime() + '&t=' + this.currentResolution;
				var pagesImage = '<img src="/proxy?nocache=true&url=' + encodeURIComponent(this.chartUrl + '?' + query_string) + '" style="margin-right: 5px;" />';
				
				query_string = 's=' + this.chartGroupSize + '&r=hits&offset=' + timezoneOffset + '&cb=' + d.getTime() + '&t=' + this.currentResolution;
				var hitsImage = '<img src="/proxy?nocache=true&url=' + encodeURIComponent(this.chartUrl + '?' + query_string) + '" />';
				
				query_string = 's=' + this.chartGroupSize + '&r=visits&offset=' + timezoneOffset + '&cb=' + d.getTime() + '&t=' + this.currentResolution;
				var referrersImage = '<img src="/proxy?nocache=true&url=' + encodeURIComponent(this.chartUrl + '?' + query_string) + '" style="margin-right: 5px;" />';
				
				query_string = 's=' + this.chartGroupSize + '&r=bytes&offset=' + timezoneOffset + '&cb=' + d.getTime() + '&t=' + this.currentResolution;
				var bytesImage = '<img src="/proxy?nocache=true&url=' + encodeURIComponent(this.chartUrl + '?' + query_string) + '" />';
				
				// build our titles and output the new images
				$('chart_display').update('<div class="center bottom5"><strong>Web Stats For the Last 24 Hours</strong></div>' + pagesImage + hitsImage + referrersImage + bytesImage);	
			}
			
		}
		
		this.notify('siteStatsUpdated');
	},
	
	handleGroupSelect: function handleGroupSelect(event)
	{
		// could have clicked on the span, or the outer a element...
		var id = Event.element(event).id;
		
		// span click
		if(!id)
		{
			id = Event.element(event).up().id;
		}
		
        $$('a.chart_group').each(function(element)
        {
			if(element.id == id)
			{
				$(element.id).addClassName('selected');
			}
			else
			{
				$(element.id).removeClassName('selected');
			}
        });
		
		this.currentChartGroup = id.replace('chart_group_', '');
		
        $$('a.chart_type').each(function(element)
        {
			$(element.id).removeClassName('selected');
        });
		
		if(this.currentChartGroup == 'resources')
		{
			$('chart_CPU').addClassName('selected');
			$('resolution_fine').show();
			$('resolution_fine').addClassName('selected');
			$('resolution_medium').removeClassName('selected');
			
			this.currentChartItem = 'CPU';
			this.currentResolution = 'fine';
			
			$('resource_groups').show();
			$('web_groups').hide();
		}
		else
		{
			$('chart_pages').addClassName('selected');
			$('resolution_fine').hide();
			$('resolution_fine').removeClassName('selected');
			$('resolution_medium').addClassName('selected');
			
			this.currentChartItem = 'pages';
			this.currentResolution = 'medium';
			
			$('web_groups').show();
			$('resource_groups').hide();
		}
		
		this.fetchChart();
	},
	
	handleGrouSizeSelect: function handleGroupSizeSelect(event)
	{
        var id = Event.element(event).id;
		
		$$('a.chart_groupsize').each(function(element)
        {
			if(element.id == id)
			{
				$(element.id).addClassName('selected');
			}
			else
			{
				$(element.id).removeClassName('selected');
			}
        });
		
		this.chartGroupSize = id.replace('chart_groupsize_', '');
		
		this.fetchChart();
	},
	
	handleResolutionSelect: function handleResolutionSelect(event)
	{
       // could have clicked on the span, or the outer a element...
		var id = Event.element(event).id;
		
		// span click
		if(!id)
		{
			id = Event.element(event).up().id;
		}
		
		$$('a.chart_resolution').each(function(element)
        {
			if(element.id == id)
			{
				$(element.id).addClassName('selected');
			}
			else
			{
				$(element.id).removeClassName('selected');
			}
        });
		
		this.currentResolution = id.replace('resolution_', '');
		
		this.fetchChart();
	},
	
	handleChartTypeSelect: function handleChartTypeSelect(event)
	{
        // could have clicked on the span, or the outer a element...
		var id = Event.element(event).id;
		
		// span click
		if(!id)
		{
			id = Event.element(event).up().id;
		}
		
		$$('a.chart_type').each(function(element)
        {
			if(element.id == id)
			{
				$(element.id).addClassName('selected');
			}
			else
			{
				$(element.id).removeClassName('selected');
			}
        });
		
		this.currentChartItem = id.replace('chart_', '');
		
		this.fetchChart();
	}
}

var SiteStatsViews = 
{
	_initViews: function _initViews()
	{
        View.load(
        {
			chartGauges:
			{
				file: 'portlets/cloud/templates/stats/gauges.html',
				binding: function()
				{
					return $('site_gauges');	
				},
				scope:
				{
					gaugeData: this.gaugeData
				},
				behaviors: function()
				{
					Portal.Pollers.register('siteGauges', this.currentSite.id, 
			        {
			            object: Portal.Modules.SiteStats,
			            method: 'fetchGaugeData',
			            frequency: 60,
			            args: [this.currentSite.id],
			            notifyEvent: 'siteStatsUpdated'
			        });
					
				}.bind(this)
			},
			diskUsage:
			{
				file: 'portlets/cloud/templates/stats/disk_usage.html',
				binding: function()
				{
					return $('site_disk_usage');
				},
				scope:
				{
					gaugeData: this.gaugeData
				},
				behaviors: function()
				{
					$('diskUsage').setStyle(
		            {
		                backgroundPosition: '0 -' + this.gaugeData.diskOffset + 'px'
		            });
				}.bind(this)
			},
			chartWrapper:
			{
				file: 'portlets/cloud/templates/stats/charts.html',
				binding: function()
				{
					return $('site_charts');
				},
				behaviors: function()
				{
                    $$('a.chart_group').each(function(element)
                    {
						$(element).observe('click', this.handleGroupSelect.bindAsEventListener(this));
						
                    }.bind(this));
					
                    $$('a.chart_groupsize').each(function(element)
                    {
						$(element).observe('click', this.handleGrouSizeSelect.bindAsEventListener(this));
						
                    }.bind(this));
					
					$$('a.chart_type').each(function(element)
                    {
						$(element).observe('click', this.handleChartTypeSelect.bindAsEventListener(this));
						
                    }.bind(this));
					
					$$('a.chart_resolution').each(function(element)
                    {
						$(element).observe('click', this.handleResolutionSelect.bindAsEventListener(this));
						
                    }.bind(this));
					
					this.fetchChart();
					
					Portal.Pollers.register('siteCharts', this.currentSite.id, 
			        {
			            object: Portal.Modules.SiteStats,
			            method: 'fetchChart',
			            frequency: 60,
			            args: [this.currentSite.id],
			            notifyEvent: 'siteStatsUpdated'
			        });
					
				}.bind(this)
			}
		},
		function(templates)
		{
			this.templates = templates;
			
			this.templates.chartWrapper.render();
			this.templates.chartGauges.render();
			this.templates.diskUsage.render();
		}.bind(this));
	}
}
Object.Event.extend(SiteStatsModule);
