var StatsManagerModule = Class.create(
{
	initialize: function initalize()
	{
		this.templates			= {};
		this.currentChartItem	= 'CPU';
		this.currentResolution	= 'fine';
		this.chartUrl			= Portal.Modules.MyCloudPortal.currentSite.urls.privateUrl + '/aptana/charts/charts.php';
	},
	
	finishInit: function finishInit()
	{
		this.registerObservers();
		this.extendSelf();
		
		this._init();
	},
	
	dispatchEvent: function dispatchEvent(msg)
	{
		// nothing here yet
	},
	
	registerObservers: function registerObservers()
	{
		// nothing here yet
	},
	
	extendSelf: function extendSelf()
	{
		Object.extend(this, StatsManagerControllers);
		Object.extend(this, StatsManagerViews);
	}
});

var StatsManagerControllers = 
{
	_init: function _init()
	{
		this._initViews();
	},
	
	fetchChart: function fetchChart()
	{
		var d = new Date();
		var timezoneOffset = d.getTimezoneOffset() / 60;
		
		var resourceCharts = ['CPU', 'Memory', 'Swap', 'Disk'];
		
		if(resourceCharts.indexOf(this.currentChartItem) == -1)
		{
			if(this.currentResolution == 'fine')
			{
				this.currentResolution = 'medium';
				$('chart_resolution_medium').checked = true;
			}
			
			$('chart_resolution_fine').disable();
		}
		else
		{
			$('chart_resolution_fine').enable();
		}
	
		
		var query_string = 's=full&r=' + this.currentChartItem + '&offset=' + timezoneOffset + '&cb=' + d.getTime() + '&t=' + this.currentResolution;
		
		Portal.API.logging.logEvent('SITE STATS', 'Requesting chart image from ' + this.chartUrl + '?' + query_string);
		
		$('fullsize_chart_cage').update('<img src="/proxy?nocache=true&url=' + encodeURIComponent(this.chartUrl + '?' + query_string) + '" />');
	}
}

var StatsManagerViews = 
{
	_initViews: function _initViews()
	{
        View.load(
        {
			main:
			{
				file: '/portlets/cloud/templates/stats_manager/stats_manager_main.html',
				binding: function()
				{
					return $('site_stats')
				},
				behaviors: function()
				{
                    $$('input.chart_item').each(function(element)
                    {
						$(element).stopObserving('click');
                        $(element).observe('click', function(event)
                        {
							if(Event.element(event).value != this.currentChartItem)
							{
								this.currentChartItem = Event.element(event).value;
							}
							
							this.fetchChart();
							
                        }.bind(this));
						
                    }.bind(this));
					
                    $$('input.chart_resolution').each(function(element)
                    {
						$(element).stopObserving('click');
                        $(element).observe('click', function(event)
                        {
							if(Event.element(event).value == 'custom')
							{
								$$('tr.custom_range').each(function(item) { $(item).show(); });
							}
							else
							{
								$$('tr.custom_range').each(function(item) { $(item).hide(); });
								
								this.currentResolution = Event.element(event).value;
							}
							
							this.fetchChart();
							
                        }.bind(this));
						
                    }.bind(this));
					
					this.fetchChart();
					
				}.bind(this)
			}
		}, 
		function(templates)
        {
			this.templates = templates;
			
			this.templates.main.render();
			
        }.bind(this))
	}
}
