var TeamManagerModule = Class.create(
{
	initialize: function initialize()
	{
		Portal.Channels.invitations = '/portal/cloud/invitations';
		
		this.siteId			= Portal.Modules.MyCloudPortal.currentSiteId;
		this.currentUserId	= 0;
		this.isOwner		= false;
		this.isAdmin		= false;
		this.processing		= false;
		this.removingSelf	= false;
		this.hasUnlimited	= false;
		this.adminRoleId	= 1;
		this.normalRoleId	= 2;
		this.adminUsers		= new Hash();
		this.normalUsers	= new Hash();
		this.siteOwner		= {};
		this.memberships	= {};
		this.templates		= {};
		
		Object.extend(this, TeamManagerControllers);
		Object.extend(this, TeamManagerViews)
	},
	
	finishInit: function finishInit()
	{
		EventManager.subscribe(Portal.Channels.invitations, { channelHook: 'TeamManager' });
		EventManager.subscribe(Portal.Channels.team, { channelHook: 'TeamManager' });
		
        Portal.Data.currentUser.observe('userModelLoaded', function()
        {
			this._init();
        }.bind(this));
		
		Portal.Data.siteList.observe(['siteUpdated', 'siteTeamUpdated'], function(siteId)
		{
			if(siteId == this.siteId)
			{
				this._init();
			}
		}.bind(this));
		
		this._init();
	},
	
	dispatchEvent: function dispatchEvent(msg)
	{
		if (msg.channel == Portal.Channels.invitations && msg.data.response == 'commit') 
		{
			this.handleAddUser(msg);
		}
		else if (msg.channel == Portal.Channels.invitations && msg.data.response == 'xmlRest')
		{
			Portal.Data.siteList.sites.get(this.siteId).memberships.fetchMemberships();
		}
		else if (['commit', 'delete'].indexOf(msg.data.response) != -1)
		{
			this.handleTeamChange(msg);
		}
	}
});

var TeamManagerControllers =
{
	_init: function _init()
	{

		if(Portal.Data.siteList.sites.get(this.siteId).loading || Portal.Data.currentUser.loading)
		{
			return;
		}
		
		var siteData = Portal.Data.siteList.sites.get(this.siteId);
		
		if(siteData.memberships.loading)
		{
			return;
		}
		
		siteData.hostingOptions = $H(siteData.hostingOptions)
		
		if(siteData.hostingOptions.get('8') && siteData.hostingOptions.get('8').toString() == '8')
		{
			this.hasUnlimited = true;
			this.setViewData('hasUnlimited', this.hasUnlimited);
		}
		
		this.memberships = siteData.memberships;
		this.setViewData('totalUsers', this.memberships.memberships.size());
		
		this.currentUserId = Portal.Data.currentUser.userId;
		
		// determine if the user viewing this team is the site owner
		if(this.currentUserId == Portal.Data.siteList.sites.get(this.siteId).ownerId)
		{
			this.isOwner = true;
		}
		
        this.memberships.memberships.each(function(item)
        {
			if(item.value.user == this.currentUserId)
			{
				// see if the current user is an admin
				if(item.value.role == this.adminRoleId)
				{
					this.isAdmin = true;
				}
			}
			
			// see if this user object is the site owner
			if(item.value.user == Portal.Data.siteList.sites.get(this.siteId).ownerId)
			{
				this.siteOwner = item.value;
				this.setViewData('siteOwner', this.siteOwner);
			}
			
        }.bind(this));
		
		this.filterTeamMembers();
		
		this._initViews();
		
		var teamSize = this.memberships.memberships.size();
			
		if(teamSize == 0)
		{
			teamSize = 1;
		}
		
		try
		{
			$('tab_team').update('Team (' + teamSize + ')');
		}
		catch (e)
		{
			console.warn(e);
		}	
	},
	
	filterTeamMembers: function filterTeamMembers()
	{
		this.adminUsers = new Hash();
		this.normalUsers = new Hash();
		
        this.memberships.memberships.each(function(item)
        {
			item.value.currentUserId = this.currentUserId;
			
			if(item.value.role == this.adminRoleId)
			{
				if(item.key == this.siteOwner.id)
				{
					return;
				}
				
				this.adminUsers.set(item.key, item.value);
			}
			else
			{
				this.normalUsers.set(item.key, item.value);
			}
        }.bind(this));
		
		this.setViewData('adminUsers', this.adminUsers);
		this.setViewData('normalUsers', this.normalUsers);
	},
	
	changeRole: function changeRole(username, roleId, membershipId)
	{
		var roleString = (roleId == this.adminRoleId) ? 'promote the selected user (' + username + ') to an Admin user' : 'demote the selected user (' + username + ')';
		
        Portal.API.dialogs.confirm(
        {
			title:		'Confirm role change',
			message: 	'Are you sure you wish to ' + roleString + '?',
			onConfirm:	function()
			{
                EventManager.publish('/portal/cloud/model',
                {
					request: 'commit',
					url: 'sites/' + this.siteId + '/memberships/' + membershipId,
					xmlData:
					{
						membership:
						{
							user_name: username,
							role_id: roleId.toString()
						}
					},
					returnChannel: Portal.Channels.team
				});
			}.bind(this)
		});
	},
	
	doAddUser: function doAddUser()
	{
		try
		{
			if(!$('form_add_team_member'))
			{
				return;
			}
			var formData = $('form_add_team_member').serialize({ hash: true });
			
			formData.invitee_email = formData.invitee_email.gsub(' ', '');
			$('invitee_email').value = formData.invitee_email;
			
			if(!formData.invitee_name || !formData.invitee_email || !formData.invitee_message)
			{
				$('team_add_error').update('Please fill out the form completely to continue').show();
				return;
			}
			
			
			var emailRegex = new RegExp(/^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,}$/i);
			
			if(!emailRegex.test(formData.invitee_email))
			{
				$('team_add_error').update('Please enter a valid email address').show();
				$('invitee_email').focus();
				return;
			}
			
			
			$('team_add_error').update('').hide();
			$('team_add_activity').update('Inviting ' + formData.invitee_name + ' to the team...').show();
			
			$('form_add_team_member').disable();
			$('team_add_controls').hide();
			
			var msg = 
			{
				url: 'invitations/',
				request: 'commit',
				returnChannel: Portal.Channels.invitations,
				xmlData:
				{
					invitation:
					{
						email: 		formData.invitee_email,
						role_id:	formData.invitee_role,
						site_id:	this.siteId.toString(),
						name:		formData.invitee_name,
						content:	formData.invitee_message
					}
				}
			}
			
			this.processing = true;
			
			EventManager.publish('/portal/cloud/model', msg);
		}
		catch(e)
		{
			console.warn(e);
		}
		
	},
	
	handleAddUser: function handleAddUser(msg)
	{
		try
		{
			this.processing = false;
			
			// success
			if(msg.data.status.toString().substr(0,1) == '2')
			{
				$('team_add_activity').update('').hide();
				$('team_add').hide();
				$('form_add_team_member').enable();
				$('form_add_team_member').reset();
				$('new_user_user').removeClassName('inactive').addClassName('active');
				$('new_user_admin').removeClassName('active').addClassName('inactive');
				
				$('team_add_success').show();
				
                new Effect.Fade('team_add_success', 
                {
                    duration: 1.5
                });
				
				$('add_team_enabled').show();
				$('add_team_disabled').hide();
				
				Portal.Data.siteList.sites.get(this.siteId).memberships.fetchMemberships();
			}
			// errors
			else
			{
				var errorMessage = '';
				
				if(msg.data.errors.length != 0)
				{
					errorMessage = Portal.API.templates.parseErrors('There was a problem sending the invitation:', msg.data.errors);
				}
				else
				{
					if(msg.data.status.toString().substr(0,1) == 5)
					{
						errorMessage = Portal.API.templates.parseErrors('The invitation service is temporarily unavailable.  Please try again in a few minutes.', []);
					}
					else
					{
						errorMessage = Portal.API.templates.parseErrors('Sorry, we could not send the invitation at this time.  Please try again later.', []);
					}
					console.error('Status Code ' + msg.data.status + ' returned for createInvitation');
				}
				
				$('team_add_controls').show();
				$('team_add_activity').hide();
				$('form_add_team_member').enable();
				$('team_add_error').update(errorMessage).show();
			}
		}
		catch(e)
		{
			console.warn(e);
		}
	},
	
	refreshTeamList: function refreshTeamList(event)
	{
		$(Event.element(event)).up().update('<div style="font-size: 11px; font-style: italic; margin: 0; height: 15px; padding-top: 2px;"><img src="images_global/img_refreshing.gif" class="inline" align="absmiddle" /> Refreshing team list...&nbsp;&nbsp;</div>');
		
		Portal.Data.siteList.sites.get(this.siteId).memberships.fetchMemberships();
	},
	
	deleteMembership: function deleteMembership(membershipId)
	{
        Portal.API.dialogs.confirm(
        {
			title: 'Confirm delete',
			message: 'Are you sure you wish to remove the selected user from the team?',
			onConfirm: function()
			{
				var that = this;
				
				new Effect.Fade('membership_' + membershipId, 
				{
					afterFinish: function()
					{
						that.memberships.memberships.unset(membershipId);
						that._init();
					}
				})
				
                EventManager.publish('/portal/cloud/model', 
                {
					request: 'delete',
					url: 'sites/' + this.siteId + '/memberships/' + membershipId,
					returnChannel: Portal.Channels.team
				});
				
			}.bind(this)
		})
	},
	
	handleTeamChange: function handleTeamChange(msg)
	{
		if(!Portal.Data.siteList.sites.get(this.siteId))
		{
			return;
		}
		
		if ($('team_refresh_cage')) 
		{
			$('team_refresh_cage').update('<div style="font-size: 11px; font-style: italic; margin: 0; height: 15px; padding-top: 2px;"><img src="images_global/img_refreshing.gif" class="inline" align="absmiddle" /> Refreshing team list...&nbsp;&nbsp;</div>');
		}
		
		Portal.Data.siteList.sites.get(this.siteId).memberships.fetchMemberships();
	},
	
	leaveTeam: function leaveTeam(membershipId)
	{
		Portal.API.dialogs.confirm(
		{
			title: 'Confirm leave team',
			message: 'Are you sure you wish to leave this team?  You will immediately lose access to the site and any related services (such as FTP, SVN, etc.).',
			onConfirm: function()
			{
				EventManager.publish('/portal/cloud/model', 
                {
					request: 'delete',
					url: 'sites/' + this.siteId + '/memberships/' + membershipId,
					returnChannel: Portal.Channels.team
				});
				
				Portal.Data.siteList.sites.unset(this.siteId);
				
				Portal.Modules.MyCloudPortal.siteToDelete = 0;
				
				var totalRunning = 0;
				var siteToShow = 0;
				
	            Portal.Data.siteList.sites.each(function(site)
	            {
					if(site.value.id != this.siteId && siteToShow == 0 && ['deleting', 'deleted'].indexOf(site.value.status.toLowerCase()) == -1)
					{
						siteToShow = site.value.id;	
					}
					
					if(['deleted', 'deleting'].indexOf(site.value.status.toLowerCase) == -1)
					{
						totalRunning ++;
					}
	            }.bind(this));
				
				if(totalRunning == 0 || siteToShow == 0)
				{
					if ($('cloud_site_status')) 
					{
						$('cloud_site_status').hide();
						$('cloud_site_ip').update('');
						$('cloud_site_name').update('');
					}
					
					console.warn('SHOULD RENDER NO SITES');
					
					Portal.Modules.MyCloudPortal.renderNoSites();
					
					var showConfirmation = function()
					{
						Portal.API.dialogs.alert('You successfully left the team', 'Left team');
					}
					
					setTimeout(showConfirmation, 1000);
					
					return;
				}
				else if(Portal.Modules.MyCloudPortal.currentSiteId == this.siteId || Portal.Modules.MyCloudPortal.currentlyDisplayed == this.siteId)
				{
					Portal.Modules.MyCloudPortal.currentSiteId = 0;
					Portal.Modules.MyCloudPortal.currentlyDisplayed = 0;
					
					Portal.Modules.MyCloudPortal.showSiteInCloud(siteToShow);
				}
				
				// just to be sure...
				Portal.Modules.MyCloudPortal.fetchSiteList();
				
				var showConfirmation = function()
				{
					Portal.API.dialogs.alert('You successfully left the team', 'Left team');
				}
				
				setTimeout(showConfirmation, 1000);
				
			}.bind(this)
		});
	},
	
	setViewData: function setViewData(key, value)
	{
		if(typeof(this.templates.main) != 'undefined')
		{
			this.templates.main.set(key, value)
		}
	},
	
	getUserFromId: function getUserFromId(userId)
	{
		var memberships = Portal.Data.siteList.sites.get(this.siteId).memberships;
		var username = '';
		
		if(userId == Portal.Data.currentUser.userId)
		{
			return 'You';
		}
		 
		 
        memberships.each(function(item)
        {
			if(item.value.user == userId)
			{
				username = (item.value.firstName == '') ? item.value.username : item.value.firstName + ' ' + item.value.lastName;
			}
        });
		
		return username;
	},
	
	resendInvite: function resendInvite(key)
	{
        Portal.API.dialogs.confirm(
        {
			message: 'Are you sure you wish to resend the selected invitation?',
			title: 'Confirm invite resend...',
			onConfirm: function()
			{
                EventManager.publish('/portal/cloud/model', 
                {
					request: 'xmlRest',
					method: 'POST',
					url: 'invitations/' + key + '?resend',
					xmlData: {},
					returnChannel: ''
				});
			}
		})
	},
	
	deleteInvite: function deleteInvite(key)
	{
		Portal.API.dialogs.confirm(
        {
			message: 'Are you sure you wish to cancel the selected invitation?',
			title: 'Confirm invite cancellation...',
			onConfirm: function()
			{
                EventManager.publish('/portal/cloud/model', 
                {
					request: 'xmlRest',
					method: 'DELETE',
					url: 'invitations/' + key,
					xmlData: {},
					returnChannel: Portal.Channels.invitations
				});
			}
		});
	}
}


var TeamManagerViews = 
{
	_initViews: function _initViews()
	{
		this.renderAddUserForm();
		this.renderUserList();
	},
	
	renderAddUserForm: function renderAddUserForm()
	{
		this.boundHighlightRole = this.highlightRole.bindAsEventListener(this);
		this.boundDoAddUser = this.doAddUser.bindAsEventListener(this);
		
		if($('team_add').style.display != 'none')
		{
			return;
		}
		
		View.load(
		{
			main: 
			{
				file: 'portlets/cloud/templates/team/add_team_member.html',
				scope:
				{
					siteName: 		Portal.Data.siteList.sites.get(this.siteId).domain,
					adminRoleId:	this.adminRoleId,
					userRoleId:		this.normalRoleId
				},
				binding: function()
				{
					return $('team_add');
				},
				behaviors: function()
				{
                    $$('input.team_role').each(function(item)
                    {
						$(item).observe('click', this.boundHighlightRole);
                    }.bind(this));
					
					$('buttom_team_doadd').observe('click', this.boundDoAddUser);
					
					var that = this;
					
					$$('*.team_add', '*.team_cancel').each(function(item)
                    {
						$(item).observe('click', that.boundToggleAddForm);
                    });
					
				}.bind(this)
			}
		}, function(templates)
		{
			templates.main.render();
		});
	},
	
	renderUserList: function renderUserList()
	{
		this.siteOwner.currentUserId 	= this.currentUserId;
		this.boundToggleAddForm			= this.toggleAddForm.bindAsEventListener(this);
		this.boundRefreshTeamList		= this.refreshTeamList.bindAsEventListener(this);
		
        View.load(
        {
			main:
			{
				file: 'portlets/cloud/templates/team/team_list.html',
				binding: function()
				{
					return $('team_list');
				},
				scope:
				{
					siteOwner:		this.siteOwner,
					adminUsers: 	this.adminUsers,
					normalUsers: 	this.normalUsers,
					totalUsers: 	this.memberships.memberships.size(),
					hasUnlimited: 	this.hasUnlimited,
					isAdmin:		this.isAdmin,
					invitations:	this.memberships.invitations,
					numInvitations:	this.memberships.invitations.size(),
					adminRoleId:	this.adminRoleId,
					userRoleId:		this.normalRoleId
				},
				behaviors: function()
				{
					var that = this;
					
					if(!this.hasUnlimited || !this.isAdmin)
					{
						$('add_team_disabled').show();
						$('add_team_enabled').hide();
					}
					
                    $$('*.team_add', '*.team_cancel').each(function(item)
                    {
						$(item).observe('click', that.boundToggleAddForm);
                    });
					
					if ($('team_refresh_link')) 
					{
						$('team_refresh_link').observe('click', this.boundRefreshTeamList);
					}
					
					$('team_content_cage').setStyle({ height: $('team_content_cage').getHeight() + 'px' });

					$('form_add_team_member').onSubmit = function() { return false; }
			
					$('form_add_team_member').observe('submit', function(event)
					{
						Event.stop(event);
						return false;
					});

					
				}.bind(this)
			},
			owner:
			{
				file: 'portlets/cloud/templates/team/member_owner.html'
			},
			admin:
			{
				file: 'portlets/cloud/templates/team/member_admin.html',
				scope:
				{
					isAdmin:		this.isAdmin,
					normalRoleId:	this.normalRoleId
				}
			},
			user:
			{
				file: 'portlets/cloud/templates/team/member_user.html',
				scope:
				{
					isAdmin:		this.isAdmin,
					adminRoleId:	this.adminRoleId
				}
			}
		}, function(templates)
		{
			
			this.templates = templates;
			
			var data = 
			{
				ownerTemplate: this.templates.owner,
				adminTemplate: this.templates.admin,
				userTemplate: this.templates.user
			}
			
			this.templates.main.set('data', data);
			
		}.bind(this));
	},
	
	toggleAddForm: function toggleAddForm(event)
	{
		if(!$('team_add') || this.processing)
		{
			return;
		}
		
		try
		{
			var hide = Event.element(event).hasClassName('team_cancel');
			
			if(!hide)
			{
				$('form_add_team_member').enable();
				$('team_add').show();
				$('team_add_controls').show();
				$('invitee_name').focus();
				$('add_team_enabled').hide();
				$('add_team_disabled').show();
			}
			else
			{
				$('team_add_error').update('').hide();
				$('team_add').hide();
				$('form_add_team_member').reset();
				$('new_user_user').removeClassName('inactive').addClassName('active');
				$('new_user_admin').removeClassName('active').addClassName('inactive');
				$('add_team_enabled').show();
				$('add_team_disabled').hide();
			}
		}
		catch(e)
		{
			console.warn(e);
		}
		
	},
	
	highlightRole: function highlightRole(event)
	{
		try
		{
			var elementId = Event.element(event).id;
			
			if(elementId == 'invitee_role_user')
			{
				$('new_user_user').removeClassName('inactive').addClassName('active');
				$('new_user_admin').removeClassName('active').addClassName('inactive');
			}
			else
			{
				$('new_user_admin').removeClassName('inactive').addClassName('active');
				$('new_user_user').removeClassName('active').addClassName('inactive');
			}
		}
		catch(e)
		{
			console.warn(e);
		}
	}
}
