/*
	Copyright (c) 2004-2008, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is a compiled version of Dojo, built for deployment and not for
	development. To get an editable version, please visit:

		http://dojotoolkit.org

	for documentation and information on getting the source.
*/

if(!dojo._hasResource["dojox.storage.Provider"]){dojo._hasResource["dojox.storage.Provider"]=true;dojo.provide("dojox.storage.Provider");dojo.declare("dojox.storage.Provider",null,{constructor:function(){},SUCCESS:"success",FAILED:"failed",PENDING:"pending",SIZE_NOT_AVAILABLE:"Size not available",SIZE_NO_LIMIT:"No size limit",DEFAULT_NAMESPACE:"default",onHideSettingsUI:null,initialize:function(){console.warn("dojox.storage.initialize not implemented");},isAvailable:function(){console.warn("dojox.storage.isAvailable not implemented");},put:function(_1,_2,_3,_4){console.warn("dojox.storage.put not implemented");},get:function(_5,_6){console.warn("dojox.storage.get not implemented");},hasKey:function(_7,_8){return !!this.get(_7,_8);},getKeys:function(_9){console.warn("dojox.storage.getKeys not implemented");},clear:function(_a){console.warn("dojox.storage.clear not implemented");},remove:function(_b,_c){console.warn("dojox.storage.remove not implemented");},getNamespaces:function(){console.warn("dojox.storage.getNamespaces not implemented");},isPermanent:function(){console.warn("dojox.storage.isPermanent not implemented");},getMaximumSize:function(){console.warn("dojox.storage.getMaximumSize not implemented");},putMultiple:function(_d,_e,_f,_10){for(var i=0;i<_d.length;i++){dojox.storage.put(_d[i],_e[i],_f,_10);}},getMultiple:function(_12,_13){var _14=[];for(var i=0;i<_12.length;i++){_14.push(dojox.storage.get(_12[i],_13));}return _14;},removeMultiple:function(_16,_17){for(var i=0;i<_16.length;i++){dojox.storage.remove(_16[i],_17);}},isValidKeyArray:function(_19){if(_19===null||_19===undefined||!dojo.isArray(_19)){return false;}return !dojo.some(_19,function(key){return !this.isValidKey(key);},this);},hasSettingsUI:function(){return false;},showSettingsUI:function(){console.warn("dojox.storage.showSettingsUI not implemented");},hideSettingsUI:function(){console.warn("dojox.storage.hideSettingsUI not implemented");},isValidKey:function(_1b){if(_1b===null||_1b===undefined){return false;}return /^[0-9A-Za-z_]*$/.test(_1b);},getResourceList:function(){return [];}});}if(!dojo._hasResource["dojox.storage.manager"]){dojo._hasResource["dojox.storage.manager"]=true;dojo.provide("dojox.storage.manager");dojox.storage.manager=new function(){this.currentProvider=null;this.available=false;this.providers=[];this._initialized=false;this._onLoadListeners=[];this.initialize=function(){this.autodetect();};this.register=function(_1c,_1d){this.providers.push(_1d);this.providers[_1c]=_1d;};this.setProvider=function(_1e){};this.autodetect=function(){if(this._initialized){return;}var _1f=dojo.config["forceStorageProvider"]||false;var _20;for(var i=0;i<this.providers.length;i++){_20=this.providers[i];if(_1f&&_1f==_20.declaredClass){_20.isAvailable();break;}else{if(!_1f&&_20.isAvailable()){break;}}}if(!_20){this._initialized=true;this.available=false;this.currentProvider=null;console.warn("No storage provider found for this platform");this.loaded();return;}this.currentProvider=_20;dojo.mixin(dojox.storage,this.currentProvider);dojox.storage.initialize();this._initialized=true;this.available=true;};this.isAvailable=function(){return this.available;};this.addOnLoad=function(_22){this._onLoadListeners.push(_22);if(this.isInitialized()){this._fireLoaded();}};this.removeOnLoad=function(_23){for(var i=0;i<this._onLoadListeners.length;i++){if(_23==this._onLoadListeners[i]){this._onLoadListeners=this._onLoadListeners.splice(i,1);break;}}};this.isInitialized=function(){if(this.currentProvider!=null&&this.currentProvider.declaredClass=="dojox.storage.FlashStorageProvider"&&dojox.flash.ready==false){return false;}else{return this._initialized;}};this.supportsProvider=function(_25){try{var _26=eval("new "+_25+"()");var _27=_26.isAvailable();if(!_27){return false;}return _27;}catch(e){return false;}};this.getProvider=function(){return this.currentProvider;};this.loaded=function(){this._fireLoaded();};this._fireLoaded=function(){dojo.forEach(this._onLoadListeners,function(i){try{i();}catch(e){}});};this.getResourceList=function(){var _29=[];dojo.forEach(dojox.storage.manager.providers,function(_2a){_29=_29.concat(_2a.getResourceList());});return _29;};};}if(!dojo._hasResource["dojo.gears"]){dojo._hasResource["dojo.gears"]=true;dojo.provide("dojo.gears");dojo.gears._gearsObject=function(){var _2b;var _2c;var _2d=dojo.getObject("google.gears");if(_2d){return _2d;}if(typeof GearsFactory!="undefined"){_2b=new GearsFactory();}else{if(dojo.isIE){try{_2b=new ActiveXObject("Gears.Factory");}catch(e){}}else{if(navigator.mimeTypes["application/x-googlegears"]){_2b=document.createElement("object");_2b.setAttribute("type","application/x-googlegears");_2b.setAttribute("width",0);_2b.setAttribute("height",0);_2b.style.display="none";document.documentElement.appendChild(_2b);}}}if(!_2b){return null;}dojo.setObject("google.gears.factory",_2b);return dojo.getObject("google.gears");};dojo.gears.available=(!!dojo.gears._gearsObject())||0;}if(!dojo._hasResource["dojox.sql._crypto"]){dojo._hasResource["dojox.sql._crypto"]=true;dojo.provide("dojox.sql._crypto");dojo.mixin(dojox.sql._crypto,{_POOL_SIZE:100,encrypt:function(_2e,_2f,_30){this._initWorkerPool();var msg={plaintext:_2e,password:_2f};msg=dojo.toJson(msg);msg="encr:"+String(msg);this._assignWork(msg,_30);},decrypt:function(_32,_33,_34){this._initWorkerPool();var msg={ciphertext:_32,password:_33};msg=dojo.toJson(msg);msg="decr:"+String(msg);this._assignWork(msg,_34);},_initWorkerPool:function(){if(!this._manager){try{this._manager=google.gears.factory.create("beta.workerpool","1.0");this._unemployed=[];this._employed={};this._handleMessage=[];var _36=this;this._manager.onmessage=function(msg,_38){var _39=_36._employed["_"+_38];_36._employed["_"+_38]=undefined;_36._unemployed.push("_"+_38);if(_36._handleMessage.length){var _3a=_36._handleMessage.shift();_36._assignWork(_3a.msg,_3a.callback);}_39(msg);};var _3b="function _workerInit(){"+"gearsWorkerPool.onmessage = "+String(this._workerHandler)+";"+"}";var _3c=_3b+" _workerInit();";for(var i=0;i<this._POOL_SIZE;i++){this._unemployed.push("_"+this._manager.createWorker(_3c));}}catch(exp){throw exp.message||exp;}}},_assignWork:function(msg,_3f){if(!this._handleMessage.length&&this._unemployed.length){var _40=this._unemployed.shift().substring(1);this._employed["_"+_40]=_3f;this._manager.sendMessage(msg,parseInt(_40,10));}else{this._handleMessage={msg:msg,callback:_3f};}},_workerHandler:function(msg,_42){var _43=[99,124,119,123,242,107,111,197,48,1,103,43,254,215,171,118,202,130,201,125,250,89,71,240,173,212,162,175,156,164,114,192,183,253,147,38,54,63,247,204,52,165,229,241,113,216,49,21,4,199,35,195,24,150,5,154,7,18,128,226,235,39,178,117,9,131,44,26,27,110,90,160,82,59,214,179,41,227,47,132,83,209,0,237,32,252,177,91,106,203,190,57,74,76,88,207,208,239,170,251,67,77,51,133,69,249,2,127,80,60,159,168,81,163,64,143,146,157,56,245,188,182,218,33,16,255,243,210,205,12,19,236,95,151,68,23,196,167,126,61,100,93,25,115,96,129,79,220,34,42,144,136,70,238,184,20,222,94,11,219,224,50,58,10,73,6,36,92,194,211,172,98,145,149,228,121,231,200,55,109,141,213,78,169,108,86,244,234,101,122,174,8,186,120,37,46,28,166,180,198,232,221,116,31,75,189,139,138,112,62,181,102,72,3,246,14,97,53,87,185,134,193,29,158,225,248,152,17,105,217,142,148,155,30,135,233,206,85,40,223,140,161,137,13,191,230,66,104,65,153,45,15,176,84,187,22];var _44=[[0,0,0,0],[1,0,0,0],[2,0,0,0],[4,0,0,0],[8,0,0,0],[16,0,0,0],[32,0,0,0],[64,0,0,0],[128,0,0,0],[27,0,0,0],[54,0,0,0]];function Cipher(_45,w){var Nb=4;var Nr=w.length/Nb-1;var _49=[[],[],[],[]];for(var i=0;i<4*Nb;i++){_49[i%4][Math.floor(i/4)]=_45[i];}_49=AddRoundKey(_49,w,0,Nb);for(var _4b=1;_4b<Nr;_4b++){_49=SubBytes(_49,Nb);_49=ShiftRows(_49,Nb);_49=MixColumns(_49,Nb);_49=AddRoundKey(_49,w,_4b,Nb);}_49=SubBytes(_49,Nb);_49=ShiftRows(_49,Nb);_49=AddRoundKey(_49,w,Nr,Nb);var _4c=new Array(4*Nb);for(var i=0;i<4*Nb;i++){_4c[i]=_49[i%4][Math.floor(i/4)];}return _4c;};function SubBytes(s,Nb){for(var r=0;r<4;r++){for(var c=0;c<Nb;c++){s[r][c]=_43[s[r][c]];}}return s;};function ShiftRows(s,Nb){var t=new Array(4);for(var r=1;r<4;r++){for(var c=0;c<4;c++){t[c]=s[r][(c+r)%Nb];}for(var c=0;c<4;c++){s[r][c]=t[c];}}return s;};function MixColumns(s,Nb){for(var c=0;c<4;c++){var a=new Array(4);var b=new Array(4);for(var i=0;i<4;i++){a[i]=s[i][c];b[i]=s[i][c]&128?s[i][c]<<1^283:s[i][c]<<1;}s[0][c]=b[0]^a[1]^b[1]^a[2]^a[3];s[1][c]=a[0]^b[1]^a[2]^b[2]^a[3];s[2][c]=a[0]^a[1]^b[2]^a[3]^b[3];s[3][c]=a[0]^b[0]^a[1]^a[2]^b[3];}return s;};function AddRoundKey(_5c,w,rnd,Nb){for(var r=0;r<4;r++){for(var c=0;c<Nb;c++){_5c[r][c]^=w[rnd*4+c][r];}}return _5c;};function KeyExpansion(key){var Nb=4;var Nk=key.length/4;var Nr=Nk+6;var w=new Array(Nb*(Nr+1));var _67=new Array(4);for(var i=0;i<Nk;i++){var r=[key[4*i],key[4*i+1],key[4*i+2],key[4*i+3]];w[i]=r;}for(var i=Nk;i<(Nb*(Nr+1));i++){w[i]=new Array(4);for(var t=0;t<4;t++){_67[t]=w[i-1][t];}if(i%Nk==0){_67=SubWord(RotWord(_67));for(var t=0;t<4;t++){_67[t]^=_44[i/Nk][t];}}else{if(Nk>6&&i%Nk==4){_67=SubWord(_67);}}for(var t=0;t<4;t++){w[i][t]=w[i-Nk][t]^_67[t];}}return w;};function SubWord(w){for(var i=0;i<4;i++){w[i]=_43[w[i]];}return w;};function RotWord(w){w[4]=w[0];for(var i=0;i<4;i++){w[i]=w[i+1];}return w;};function AESEncryptCtr(_6f,_70,_71){if(!(_71==128||_71==192||_71==256)){return "";}var _72=_71/8;var _73=new Array(_72);for(var i=0;i<_72;i++){_73[i]=_70.charCodeAt(i)&255;}var key=Cipher(_73,KeyExpansion(_73));key=key.concat(key.slice(0,_72-16));var _76=16;var _77=new Array(_76);var _78=(new Date()).getTime();for(var i=0;i<4;i++){_77[i]=(_78>>>i*8)&255;}for(var i=0;i<4;i++){_77[i+4]=(_78/4294967296>>>i*8)&255;}var _79=KeyExpansion(key);var _7a=Math.ceil(_6f.length/_76);var _7b=new Array(_7a);for(var b=0;b<_7a;b++){for(var c=0;c<4;c++){_77[15-c]=(b>>>c*8)&255;}for(var c=0;c<4;c++){_77[15-c-4]=(b/4294967296>>>c*8);}var _7e=Cipher(_77,_79);var _7f=b<_7a-1?_76:(_6f.length-1)%_76+1;var ct="";for(var i=0;i<_7f;i++){var _81=_6f.charCodeAt(b*_76+i);var _82=_81^_7e[i];ct+=String.fromCharCode(_82);}_7b[b]=escCtrlChars(ct);}var _83="";for(var i=0;i<8;i++){_83+=String.fromCharCode(_77[i]);}_83=escCtrlChars(_83);return _83+"-"+_7b.join("-");};function AESDecryptCtr(_84,_85,_86){if(!(_86==128||_86==192||_86==256)){return "";}var _87=_86/8;var _88=new Array(_87);for(var i=0;i<_87;i++){_88[i]=_85.charCodeAt(i)&255;}var _8a=KeyExpansion(_88);var key=Cipher(_88,_8a);key=key.concat(key.slice(0,_87-16));var _8c=KeyExpansion(key);_84=_84.split("-");var _8d=16;var _8e=new Array(_8d);var _8f=unescCtrlChars(_84[0]);for(var i=0;i<8;i++){_8e[i]=_8f.charCodeAt(i);}var _90=new Array(_84.length-1);for(var b=1;b<_84.length;b++){for(var c=0;c<4;c++){_8e[15-c]=((b-1)>>>c*8)&255;}for(var c=0;c<4;c++){_8e[15-c-4]=((b/4294967296-1)>>>c*8)&255;}var _93=Cipher(_8e,_8c);_84[b]=unescCtrlChars(_84[b]);var pt="";for(var i=0;i<_84[b].length;i++){var _95=_84[b].charCodeAt(i);var _96=_95^_93[i];pt+=String.fromCharCode(_96);}_90[b-1]=pt;}return _90.join("");};function escCtrlChars(str){return str.replace(/[\0\t\n\v\f\r\xa0!-]/g,function(c){return "!"+c.charCodeAt(0)+"!";});};function unescCtrlChars(str){return str.replace(/!\d\d?\d?!/g,function(c){return String.fromCharCode(c.slice(1,-1));});};function encrypt(_9b,_9c){return AESEncryptCtr(_9b,_9c,256);};function decrypt(_9d,_9e){return AESDecryptCtr(_9d,_9e,256);};var cmd=msg.substr(0,4);var arg=msg.substr(5);if(cmd=="encr"){arg=eval("("+arg+")");var _a1=arg.plaintext;var _a2=arg.password;var _a3=encrypt(_a1,_a2);gearsWorkerPool.sendMessage(String(_a3),_42);}else{if(cmd=="decr"){arg=eval("("+arg+")");var _a4=arg.ciphertext;var _a2=arg.password;var _a3=decrypt(_a4,_a2);gearsWorkerPool.sendMessage(String(_a3),_42);}}}});}if(!dojo._hasResource["dojox.sql._base"]){dojo._hasResource["dojox.sql._base"]=true;dojo.provide("dojox.sql._base");dojo.mixin(dojox.sql,{dbName:null,debug:(dojo.exists("dojox.sql.debug")?dojox.sql.debug:false),open:function(_a5){if(this._dbOpen&&(!_a5||_a5==this.dbName)){return;}if(!this.dbName){this.dbName="dot_store_"+window.location.href.replace(/[^0-9A-Za-z_]/g,"_");if(this.dbName.length>63){this.dbName=this.dbName.substring(0,63);}}if(!_a5){_a5=this.dbName;}try{this._initDb();this.db.open(_a5);this._dbOpen=true;}catch(exp){throw exp.message||exp;}},close:function(_a6){if(dojo.isIE){return;}if(!this._dbOpen&&(!_a6||_a6==this.dbName)){return;}if(!_a6){_a6=this.dbName;}try{this.db.close(_a6);this._dbOpen=false;}catch(exp){throw exp.message||exp;}},_exec:function(_a7){try{this._initDb();if(!this._dbOpen){this.open();this._autoClose=true;}var sql=null;var _a9=null;var _aa=null;var _ab=dojo._toArray(_a7);sql=_ab.splice(0,1)[0];if(this._needsEncrypt(sql)||this._needsDecrypt(sql)){_a9=_ab.splice(_ab.length-1,1)[0];_aa=_ab.splice(_ab.length-1,1)[0];}if(this.debug){this._printDebugSQL(sql,_ab);}var _ac;if(this._needsEncrypt(sql)){_ac=new dojox.sql._SQLCrypto("encrypt",sql,_aa,_ab,_a9);return null;}else{if(this._needsDecrypt(sql)){_ac=new dojox.sql._SQLCrypto("decrypt",sql,_aa,_ab,_a9);return null;}}var rs=this.db.execute(sql,_ab);rs=this._normalizeResults(rs);if(this._autoClose){this.close();}return rs;}catch(exp){exp=exp.message||exp;if(this._autoClose){try{this.close();}catch(e){}}throw exp;}return null;},_initDb:function(){if(!this.db){try{this.db=google.gears.factory.create("beta.database","1.0");}catch(exp){dojo.setObject("google.gears.denied",true);if(dojox.off){dojox.off.onFrameworkEvent("coreOperationFailed");}throw "Google Gears must be allowed to run";}}},_printDebugSQL:function(sql,_af){var msg="dojox.sql(\""+sql+"\"";for(var i=0;i<_af.length;i++){if(typeof _af[i]=="string"){msg+=", \""+_af[i]+"\"";}else{msg+=", "+_af[i];}}msg+=")";},_normalizeResults:function(rs){var _b3=[];if(!rs){return [];}while(rs.isValidRow()){var row={};for(var i=0;i<rs.fieldCount();i++){var _b6=rs.fieldName(i);var _b7=rs.field(i);row[_b6]=_b7;}_b3.push(row);rs.next();}rs.close();return _b3;},_needsEncrypt:function(sql){return /encrypt\([^\)]*\)/i.test(sql);},_needsDecrypt:function(sql){return /decrypt\([^\)]*\)/i.test(sql);}});dojo.declare("dojox.sql._SQLCrypto",null,{constructor:function(_ba,sql,_bc,_bd,_be){if(_ba=="encrypt"){this._execEncryptSQL(sql,_bc,_bd,_be);}else{this._execDecryptSQL(sql,_bc,_bd,_be);}},_execEncryptSQL:function(sql,_c0,_c1,_c2){var _c3=this._stripCryptoSQL(sql);var _c4=this._flagEncryptedArgs(sql,_c1);var _c5=this;this._encrypt(_c3,_c0,_c1,_c4,function(_c6){var _c7=false;var _c8=[];var exp=null;try{_c8=dojox.sql.db.execute(_c3,_c6);}catch(execError){_c7=true;exp=execError.message||execError;}if(exp!=null){if(dojox.sql._autoClose){try{dojox.sql.close();}catch(e){}}_c2(null,true,exp.toString());return;}_c8=dojox.sql._normalizeResults(_c8);if(dojox.sql._autoClose){dojox.sql.close();}if(dojox.sql._needsDecrypt(sql)){var _ca=_c5._determineDecryptedColumns(sql);_c5._decrypt(_c8,_ca,_c0,function(_cb){_c2(_cb,false,null);});}else{_c2(_c8,false,null);}});},_execDecryptSQL:function(sql,_cd,_ce,_cf){var _d0=this._stripCryptoSQL(sql);var _d1=this._determineDecryptedColumns(sql);var _d2=false;var _d3=[];var exp=null;try{_d3=dojox.sql.db.execute(_d0,_ce);}catch(execError){_d2=true;exp=execError.message||execError;}if(exp!=null){if(dojox.sql._autoClose){try{dojox.sql.close();}catch(e){}}_cf(_d3,true,exp.toString());return;}_d3=dojox.sql._normalizeResults(_d3);if(dojox.sql._autoClose){dojox.sql.close();}this._decrypt(_d3,_d1,_cd,function(_d5){_cf(_d5,false,null);});},_encrypt:function(sql,_d7,_d8,_d9,_da){this._totalCrypto=0;this._finishedCrypto=0;this._finishedSpawningCrypto=false;this._finalArgs=_d8;for(var i=0;i<_d8.length;i++){if(_d9[i]){var _dc=_d8[i];var _dd=i;this._totalCrypto++;dojox.sql._crypto.encrypt(_dc,_d7,dojo.hitch(this,function(_de){this._finalArgs[_dd]=_de;this._finishedCrypto++;if(this._finishedCrypto>=this._totalCrypto&&this._finishedSpawningCrypto){_da(this._finalArgs);}}));}}this._finishedSpawningCrypto=true;},_decrypt:function(_df,_e0,_e1,_e2){this._totalCrypto=0;this._finishedCrypto=0;this._finishedSpawningCrypto=false;this._finalResultSet=_df;for(var i=0;i<_df.length;i++){var row=_df[i];for(var _e5 in row){if(_e0=="*"||_e0[_e5]){this._totalCrypto++;var _e6=row[_e5];this._decryptSingleColumn(_e5,_e6,_e1,i,function(_e7){_e2(_e7);});}}}this._finishedSpawningCrypto=true;},_stripCryptoSQL:function(sql){sql=sql.replace(/DECRYPT\(\*\)/ig,"*");var _e9=sql.match(/ENCRYPT\([^\)]*\)/ig);if(_e9!=null){for(var i=0;i<_e9.length;i++){var _eb=_e9[i];var _ec=_eb.match(/ENCRYPT\(([^\)]*)\)/i)[1];sql=sql.replace(_eb,_ec);}}_e9=sql.match(/DECRYPT\([^\)]*\)/ig);if(_e9!=null){for(i=0;i<_e9.length;i++){var _ed=_e9[i];var _ee=_ed.match(/DECRYPT\(([^\)]*)\)/i)[1];sql=sql.replace(_ed,_ee);}}return sql;},_flagEncryptedArgs:function(sql,_f0){var _f1=new RegExp(/([\"][^\"]*\?[^\"]*[\"])|([\'][^\']*\?[^\']*[\'])|(\?)/ig);var _f2;var _f3=0;var _f4=[];while((_f2=_f1.exec(sql))!=null){var _f5=RegExp.lastMatch+"";if(/^[\"\']/.test(_f5)){continue;}var _f6=false;if(/ENCRYPT\([^\)]*$/i.test(RegExp.leftContext)){_f6=true;}_f4[_f3]=_f6;_f3++;}return _f4;},_determineDecryptedColumns:function(sql){var _f8={};if(/DECRYPT\(\*\)/i.test(sql)){_f8="*";}else{var _f9=/DECRYPT\((?:\s*\w*\s*\,?)*\)/ig;var _fa=_f9.exec(sql);while(_fa){var _fb=new String(RegExp.lastMatch);var _fc=_fb.replace(/DECRYPT\(/i,"");_fc=_fc.replace(/\)/,"");_fc=_fc.split(/\s*,\s*/);dojo.forEach(_fc,function(_fd){if(/\s*\w* AS (\w*)/i.test(_fd)){_fd=_fd.match(/\s*\w* AS (\w*)/i)[1];}_f8[_fd]=true;});_fa=_f9.exec(sql);}}return _f8;},_decryptSingleColumn:function(_fe,_ff,_100,_101,_102){dojox.sql._crypto.decrypt(_ff,_100,dojo.hitch(this,function(_103){this._finalResultSet[_101][_fe]=_103;this._finishedCrypto++;if(this._finishedCrypto>=this._totalCrypto&&this._finishedSpawningCrypto){_102(this._finalResultSet);}}));}});(function(){var _104=dojox.sql;dojox.sql=new Function("return dojox.sql._exec(arguments);");dojo.mixin(dojox.sql,_104);})();}if(!dojo._hasResource["dojox.sql"]){dojo._hasResource["dojox.sql"]=true;dojo.provide("dojox.sql");}if(!dojo._hasResource["dojox.storage.GearsStorageProvider"]){dojo._hasResource["dojox.storage.GearsStorageProvider"]=true;dojo.provide("dojox.storage.GearsStorageProvider");if(dojo.gears.available){(function(){dojo.declare("dojox.storage.GearsStorageProvider",dojox.storage.Provider,{constructor:function(){},TABLE_NAME:"__DOJO_STORAGE",initialized:false,_available:null,_storageReady:false,initialize:function(){if(dojo.config["disableGearsStorage"]==true){return;}this.TABLE_NAME="__DOJO_STORAGE";this.initialized=true;dojox.storage.manager.loaded();},isAvailable:function(){return this._available=dojo.gears.available;},put:function(key,_106,_107,_108){this._initStorage();if(!this.isValidKey(key)){throw new Error("Invalid key given: "+key);}_108=_108||this.DEFAULT_NAMESPACE;if(!this.isValidKey(_108)){throw new Error("Invalid namespace given: "+key);}if(dojo.isString(_106)){_106="string:"+_106;}else{_106=dojo.toJson(_106);}try{dojox.sql("DELETE FROM "+this.TABLE_NAME+" WHERE namespace = ? AND key = ?",_108,key);dojox.sql("INSERT INTO "+this.TABLE_NAME+" VALUES (?, ?, ?)",_108,key,_106);}catch(e){_107(this.FAILED,key,e.toString(),_108);return;}if(_107){_107(dojox.storage.SUCCESS,key,null,_108);}},get:function(key,_10a){this._initStorage();if(!this.isValidKey(key)){throw new Error("Invalid key given: "+key);}_10a=_10a||this.DEFAULT_NAMESPACE;if(!this.isValidKey(_10a)){throw new Error("Invalid namespace given: "+key);}var _10b=dojox.sql("SELECT * FROM "+this.TABLE_NAME+" WHERE namespace = ? AND "+" key = ?",_10a,key);if(!_10b.length){return null;}else{_10b=_10b[0].value;}if(dojo.isString(_10b)&&(/^string:/.test(_10b))){_10b=_10b.substring("string:".length);}else{_10b=dojo.fromJson(_10b);}return _10b;},getNamespaces:function(){this._initStorage();var _10c=[dojox.storage.DEFAULT_NAMESPACE];var rs=dojox.sql("SELECT namespace FROM "+this.TABLE_NAME+" DESC GROUP BY namespace");for(var i=0;i<rs.length;i++){if(rs[i].namespace!=dojox.storage.DEFAULT_NAMESPACE){_10c.push(rs[i].namespace);}}return _10c;},getKeys:function(_10f){this._initStorage();_10f=_10f||this.DEFAULT_NAMESPACE;if(!this.isValidKey(_10f)){throw new Error("Invalid namespace given: "+_10f);}var rs=dojox.sql("SELECT key FROM "+this.TABLE_NAME+" WHERE namespace = ?",_10f);var _111=[];for(var i=0;i<rs.length;i++){_111.push(rs[i].key);}return _111;},clear:function(_113){this._initStorage();_113=_113||this.DEFAULT_NAMESPACE;if(!this.isValidKey(_113)){throw new Error("Invalid namespace given: "+_113);}dojox.sql("DELETE FROM "+this.TABLE_NAME+" WHERE namespace = ?",_113);},remove:function(key,_115){this._initStorage();if(!this.isValidKey(key)){throw new Error("Invalid key given: "+key);}_115=_115||this.DEFAULT_NAMESPACE;if(!this.isValidKey(_115)){throw new Error("Invalid namespace given: "+key);}dojox.sql("DELETE FROM "+this.TABLE_NAME+" WHERE namespace = ? AND"+" key = ?",_115,key);},putMultiple:function(keys,_117,_118,_119){this._initStorage();if(!this.isValidKeyArray(keys)||!_117 instanceof Array||keys.length!=_117.length){throw new Error("Invalid arguments: keys = ["+keys+"], values = ["+_117+"]");}if(_119==null||typeof _119=="undefined"){_119=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_119)){throw new Error("Invalid namespace given: "+_119);}this._statusHandler=_118;try{dojox.sql.open();dojox.sql.db.execute("BEGIN TRANSACTION");var _11a="REPLACE INTO "+this.TABLE_NAME+" VALUES (?, ?, ?)";for(var i=0;i<keys.length;i++){var _11c=_117[i];if(dojo.isString(_11c)){_11c="string:"+_11c;}else{_11c=dojo.toJson(_11c);}dojox.sql.db.execute(_11a,[_119,keys[i],_11c]);}dojox.sql.db.execute("COMMIT TRANSACTION");dojox.sql.close();}catch(e){if(_118){_118(this.FAILED,keys,e.toString(),_119);}return;}if(_118){_118(dojox.storage.SUCCESS,keys,null,_119);}},getMultiple:function(keys,_11e){this._initStorage();if(!this.isValidKeyArray(keys)){throw new ("Invalid key array given: "+keys);}if(_11e==null||typeof _11e=="undefined"){_11e=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_11e)){throw new Error("Invalid namespace given: "+_11e);}var _11f="SELECT * FROM "+this.TABLE_NAME+" WHERE namespace = ? AND "+" key = ?";var _120=[];for(var i=0;i<keys.length;i++){var _122=dojox.sql(_11f,_11e,keys[i]);if(!_122.length){_120[i]=null;}else{_122=_122[0].value;if(dojo.isString(_122)&&(/^string:/.test(_122))){_120[i]=_122.substring("string:".length);}else{_120[i]=dojo.fromJson(_122);}}}return _120;},removeMultiple:function(keys,_124){this._initStorage();if(!this.isValidKeyArray(keys)||!values instanceof Array){throw new Error("Invalid arguments: keys = ["+keys+"]");}if(_124==null||typeof _124=="undefined"){_124=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_124)){throw new Error("Invalid namespace given: "+_124);}dojox.sql.open();dojox.sql.db.execute("BEGIN TRANSACTION");var _125="DELETE FROM "+this.TABLE_NAME+" WHERE namespace = ? AND key = ?";for(var i=0;i<keys.length;i++){dojox.sql.db.execute(_125,[_124,keys[i]]);}dojox.sql.db.execute("COMMIT TRANSACTION");dojox.sql.close();},isPermanent:function(){return true;},getMaximumSize:function(){return this.SIZE_NO_LIMIT;},hasSettingsUI:function(){return false;},showSettingsUI:function(){throw new Error(this.declaredClass+" does not support a storage settings user-interface");},hideSettingsUI:function(){throw new Error(this.declaredClass+" does not support a storage settings user-interface");},_initStorage:function(){if(this._storageReady){return;}if(!google.gears.factory.hasPermission){var _127=null;var icon=null;var msg="This site would like to use Google Gears to enable "+"enhanced functionality.";var _12a=google.gears.factory.getPermission(_127,icon,msg);if(!_12a){throw new Error("You must give permission to use Gears in order to "+"store data");}}try{dojox.sql("CREATE TABLE IF NOT EXISTS "+this.TABLE_NAME+"( "+" namespace TEXT, "+" key TEXT, "+" value TEXT "+")");dojox.sql("CREATE UNIQUE INDEX IF NOT EXISTS namespace_key_index"+" ON "+this.TABLE_NAME+" (namespace, key)");}catch(e){throw new Error("Unable to create storage tables for Gears in "+"Dojo Storage");}this._storageReady=true;}});dojox.storage.manager.register("dojox.storage.GearsStorageProvider",new dojox.storage.GearsStorageProvider());})();}}if(!dojo._hasResource["dojox.storage.WhatWGStorageProvider"]){dojo._hasResource["dojox.storage.WhatWGStorageProvider"]=true;dojo.provide("dojox.storage.WhatWGStorageProvider");dojo.declare("dojox.storage.WhatWGStorageProvider",[dojox.storage.Provider],{initialized:false,_domain:null,_available:null,_statusHandler:null,_allNamespaces:null,_storageEventListener:null,initialize:function(){if(dojo.config["disableWhatWGStorage"]==true){return;}this._domain=this._getDomain();this.initialized=true;dojox.storage.manager.loaded();},isAvailable:function(){try{var _12b=globalStorage[this._getDomain()];}catch(e){this._available=false;return this._available;}this._available=true;return this._available;},put:function(key,_12d,_12e,_12f){if(this.isValidKey(key)==false){throw new Error("Invalid key given: "+key);}_12f=_12f||this.DEFAULT_NAMESPACE;key=this.getFullKey(key,_12f);this._statusHandler=_12e;if(dojo.isString(_12d)){_12d="string:"+_12d;}else{_12d=dojo.toJson(_12d);}var _130=dojo.hitch(this,function(evt){window.removeEventListener("storage",_130,false);if(_12e){_12e.call(null,this.SUCCESS,key,null,_12f);}});window.addEventListener("storage",_130,false);try{var _132=globalStorage[this._domain];_132.setItem(key,_12d);}catch(e){this._statusHandler.call(null,this.FAILED,key,e.toString(),_12f);}},get:function(key,_134){if(this.isValidKey(key)==false){throw new Error("Invalid key given: "+key);}_134=_134||this.DEFAULT_NAMESPACE;key=this.getFullKey(key,_134);var _135=globalStorage[this._domain];var _136=_135.getItem(key);if(_136==null||_136==""){return null;}_136=_136.value;if(dojo.isString(_136)&&(/^string:/.test(_136))){_136=_136.substring("string:".length);}else{_136=dojo.fromJson(_136);}return _136;},getNamespaces:function(){var _137=[this.DEFAULT_NAMESPACE];var _138={};var _139=globalStorage[this._domain];var _13a=/^__([^_]*)_/;for(var i=0;i<_139.length;i++){var _13c=_139.key(i);if(_13a.test(_13c)==true){var _13d=_13c.match(_13a)[1];if(typeof _138[_13d]=="undefined"){_138[_13d]=true;_137.push(_13d);}}}return _137;},getKeys:function(_13e){_13e=_13e||this.DEFAULT_NAMESPACE;if(this.isValidKey(_13e)==false){throw new Error("Invalid namespace given: "+_13e);}var _13f;if(_13e==this.DEFAULT_NAMESPACE){_13f=new RegExp("^([^_]{2}.*)$");}else{_13f=new RegExp("^__"+_13e+"_(.*)$");}var _140=globalStorage[this._domain];var _141=[];for(var i=0;i<_140.length;i++){var _143=_140.key(i);if(_13f.test(_143)==true){_143=_143.match(_13f)[1];_141.push(_143);}}return _141;},clear:function(_144){_144=_144||this.DEFAULT_NAMESPACE;if(this.isValidKey(_144)==false){throw new Error("Invalid namespace given: "+_144);}var _145;if(_144==this.DEFAULT_NAMESPACE){_145=new RegExp("^[^_]{2}");}else{_145=new RegExp("^__"+_144+"_");}var _146=globalStorage[this._domain];var keys=[];for(var i=0;i<_146.length;i++){if(_145.test(_146.key(i))==true){keys[keys.length]=_146.key(i);}}dojo.forEach(keys,dojo.hitch(_146,"removeItem"));},remove:function(key,_14a){key=this.getFullKey(key,_14a);var _14b=globalStorage[this._domain];_14b.removeItem(key);},isPermanent:function(){return true;},getMaximumSize:function(){return this.SIZE_NO_LIMIT;},hasSettingsUI:function(){return false;},showSettingsUI:function(){throw new Error(this.declaredClass+" does not support a storage settings user-interface");},hideSettingsUI:function(){throw new Error(this.declaredClass+" does not support a storage settings user-interface");},getFullKey:function(key,_14d){_14d=_14d||this.DEFAULT_NAMESPACE;if(this.isValidKey(_14d)==false){throw new Error("Invalid namespace given: "+_14d);}if(_14d==this.DEFAULT_NAMESPACE){return key;}else{return "__"+_14d+"_"+key;}},_getDomain:function(){return ((location.hostname=="localhost"&&dojo.isFF&&dojo.isFF<3)?"localhost.localdomain":location.hostname);}});dojox.storage.manager.register("dojox.storage.WhatWGStorageProvider",new dojox.storage.WhatWGStorageProvider());}if(!dojo._hasResource["dojo.AdapterRegistry"]){dojo._hasResource["dojo.AdapterRegistry"]=true;dojo.provide("dojo.AdapterRegistry");dojo.AdapterRegistry=function(_14e){this.pairs=[];this.returnWrappers=_14e||false;};dojo.extend(dojo.AdapterRegistry,{register:function(name,_150,wrap,_152,_153){this.pairs[((_153)?"unshift":"push")]([name,_150,wrap,_152]);},match:function(){for(var i=0;i<this.pairs.length;i++){var pair=this.pairs[i];if(pair[1].apply(this,arguments)){if((pair[3])||(this.returnWrappers)){return pair[2];}else{return pair[2].apply(this,arguments);}}}throw new Error("No match found");},unregister:function(name){for(var i=0;i<this.pairs.length;i++){var pair=this.pairs[i];if(pair[0]==name){this.pairs.splice(i,1);return true;}}return false;}});}if(!dojo._hasResource["dijit._base.place"]){dojo._hasResource["dijit._base.place"]=true;dojo.provide("dijit._base.place");dijit.getViewport=function(){var _159=dojo.global;var _15a=dojo.doc;var w=0,h=0;var de=_15a.documentElement;var dew=de.clientWidth,deh=de.clientHeight;if(dojo.isMozilla){var minw,minh,maxw,maxh;var dbw=_15a.body.clientWidth;if(dbw>dew){minw=dew;maxw=dbw;}else{maxw=dew;minw=dbw;}var dbh=_15a.body.clientHeight;if(dbh>deh){minh=deh;maxh=dbh;}else{maxh=deh;minh=dbh;}w=(maxw>_159.innerWidth)?minw:maxw;h=(maxh>_159.innerHeight)?minh:maxh;}else{if(!dojo.isOpera&&_159.innerWidth){w=_159.innerWidth;h=_159.innerHeight;}else{if(dojo.isIE&&de&&deh){w=dew;h=deh;}else{if(dojo.body().clientWidth){w=dojo.body().clientWidth;h=dojo.body().clientHeight;}}}}var _166=dojo._docScroll();return {w:w,h:h,l:_166.x,t:_166.y};};dijit.placeOnScreen=function(node,pos,_169,_16a){var _16b=dojo.map(_169,function(_16c){return {corner:_16c,pos:pos};});return dijit._place(node,_16b);};dijit._place=function(node,_16e,_16f){var view=dijit.getViewport();if(!node.parentNode||String(node.parentNode.tagName).toLowerCase()!="body"){dojo.body().appendChild(node);}var best=null;dojo.some(_16e,function(_172){var _173=_172.corner;var pos=_172.pos;if(_16f){_16f(node,_172.aroundCorner,_173);}var _175=node.style;var _176=_175.display;var _177=_175.visibility;_175.visibility="hidden";_175.display="";var mb=dojo.marginBox(node);_175.display=_176;_175.visibility=_177;var _179=(_173.charAt(1)=="L"?pos.x:Math.max(view.l,pos.x-mb.w)),_17a=(_173.charAt(0)=="T"?pos.y:Math.max(view.t,pos.y-mb.h)),endX=(_173.charAt(1)=="L"?Math.min(view.l+view.w,_179+mb.w):pos.x),endY=(_173.charAt(0)=="T"?Math.min(view.t+view.h,_17a+mb.h):pos.y),_17d=endX-_179,_17e=endY-_17a,_17f=(mb.w-_17d)+(mb.h-_17e);if(best==null||_17f<best.overflow){best={corner:_173,aroundCorner:_172.aroundCorner,x:_179,y:_17a,w:_17d,h:_17e,overflow:_17f};}return !_17f;});node.style.left=best.x+"px";node.style.top=best.y+"px";if(best.overflow&&_16f){_16f(node,best.aroundCorner,best.corner);}return best;};dijit.placeOnScreenAroundNode=function(node,_181,_182,_183){_181=dojo.byId(_181);var _184=_181.style.display;_181.style.display="";var _185=_181.offsetWidth;var _186=_181.offsetHeight;var _187=dojo.coords(_181,true);_181.style.display=_184;return dijit._placeOnScreenAroundRect(node,_187.x,_187.y,_185,_186,_182,_183);};dijit.placeOnScreenAroundRectangle=function(node,_189,_18a,_18b){return dijit._placeOnScreenAroundRect(node,_189.x,_189.y,_189.width,_189.height,_18a,_18b);};dijit._placeOnScreenAroundRect=function(node,x,y,_18f,_190,_191,_192){var _193=[];for(var _194 in _191){_193.push({aroundCorner:_194,corner:_191[_194],pos:{x:x+(_194.charAt(1)=="L"?0:_18f),y:y+(_194.charAt(0)=="T"?0:_190)}});}return dijit._place(node,_193,_192);};dijit.placementRegistry=new dojo.AdapterRegistry();dijit.placementRegistry.register("node",function(n,x){return typeof x=="object"&&typeof x.offsetWidth!="undefined"&&typeof x.offsetHeight!="undefined";},dijit.placeOnScreenAroundNode);dijit.placementRegistry.register("rect",function(n,x){return typeof x=="object"&&"x" in x&&"y" in x&&"width" in x&&"height" in x;},dijit.placeOnScreenAroundRectangle);dijit.placeOnScreenAroundElement=function(node,_19a,_19b,_19c){return dijit.placementRegistry.match.apply(dijit.placementRegistry,arguments);};}if(!dojo._hasResource["dojox.flash._base"]){dojo._hasResource["dojox.flash._base"]=true;dojo.provide("dojox.flash._base");dojox.flash=function(){};dojox.flash={ready:false,url:null,_visible:true,_loadedListeners:[],_installingListeners:[],setSwf:function(url,_19e){this.url=url;this._visible=true;if(_19e!==null&&typeof _19e!=="undefined"){this._visible=_19e;}this._initialize();},addLoadedListener:function(_19f){this._loadedListeners.push(_19f);},addInstallingListener:function(_1a0){this._installingListeners.push(_1a0);},loaded:function(){dojox.flash.ready=true;if(dojox.flash._loadedListeners.length>0){for(var i=0;i<dojox.flash._loadedListeners.length;i++){dojox.flash._loadedListeners[i].call(null);}}},installing:function(){if(dojox.flash._installingListeners.length>0){for(var i=0;i<dojox.flash._installingListeners.length;i++){dojox.flash._installingListeners[i].call(null);}}},_initialize:function(){var _1a3=new dojox.flash.Install();dojox.flash.installer=_1a3;if(_1a3.needed()){_1a3.install();}else{dojox.flash.obj=new dojox.flash.Embed(this._visible);dojox.flash.obj.write();dojox.flash.comm=new dojox.flash.Communicator();}}};dojox.flash.Info=function(){this._detectVersion();};dojox.flash.Info.prototype={version:-1,versionMajor:-1,versionMinor:-1,versionRevision:-1,capable:false,installing:false,isVersionOrAbove:function(_1a4,_1a5,_1a6){_1a6=parseFloat("."+_1a6);if(this.versionMajor>=_1a4&&this.versionMinor>=_1a5&&this.versionRevision>=_1a6){return true;}else{return false;}},_detectVersion:function(){var _1a7;for(var _1a8=25;_1a8>0;_1a8--){if(dojo.isIE){var axo;try{if(_1a8>6){axo=new ActiveXObject("ShockwaveFlash.ShockwaveFlash."+_1a8);}else{axo=new ActiveXObject("ShockwaveFlash.ShockwaveFlash");}if(typeof axo=="object"){if(_1a8==6){axo.AllowScriptAccess="always";}_1a7=axo.GetVariable("$version");}}catch(e){continue;}}else{_1a7=this._JSFlashInfo(_1a8);}if(_1a7==-1){this.capable=false;return;}else{if(_1a7!=0){var _1aa;if(dojo.isIE){var _1ab=_1a7.split(" ");var _1ac=_1ab[1];_1aa=_1ac.split(",");}else{_1aa=_1a7.split(".");}this.versionMajor=_1aa[0];this.versionMinor=_1aa[1];this.versionRevision=_1aa[2];var _1ad=this.versionMajor+"."+this.versionRevision;this.version=parseFloat(_1ad);this.capable=true;break;}}}},_JSFlashInfo:function(_1ae){if(navigator.plugins!=null&&navigator.plugins.length>0){if(navigator.plugins["Shockwave Flash 2.0"]||navigator.plugins["Shockwave Flash"]){var _1af=navigator.plugins["Shockwave Flash 2.0"]?" 2.0":"";var _1b0=navigator.plugins["Shockwave Flash"+_1af].description;var _1b1=_1b0.split(" ");var _1b2=_1b1[2].split(".");var _1b3=_1b2[0];var _1b4=_1b2[1];var _1b5=(_1b1[3]||_1b1[4]).split("r");var _1b6=_1b5[1]>0?_1b5[1]:0;var _1b7=_1b3+"."+_1b4+"."+_1b6;return _1b7;}}return -1;}};dojox.flash.Embed=function(_1b8){this._visible=_1b8;};dojox.flash.Embed.prototype={width:215,height:138,id:"flashObject",_visible:true,protocol:function(){switch(window.location.protocol){case "https:":return "https";break;default:return "http";break;}},write:function(_1b9){var _1ba;var _1bb=dojox.flash.url;var _1bc=_1bb;var _1bd=_1bb;var _1be=dojo.baseUrl;var _1bf=document.location.protocol+"//"+document.location.host;if(_1b9){var _1c0=escape(window.location);document.title=document.title.slice(0,47)+" - Flash Player Installation";var _1c1=escape(document.title);_1bc+="?MMredirectURL="+_1c0+"&MMplayerType=ActiveX"+"&MMdoctitle="+_1c1+"&baseUrl="+escape(_1be)+"&xdomain="+escape(_1bf);_1bd+="?MMredirectURL="+_1c0+"&MMplayerType=PlugIn"+"&baseUrl="+escape(_1be)+"&xdomain="+escape(_1bf);}else{_1bc+="?cachebust="+new Date().getTime();_1bc+="&baseUrl="+escape(_1be);_1bc+="&xdomain="+escape(_1bf);}if(_1bd.indexOf("?")==-1){_1bd+="?baseUrl="+escape(_1be);}else{_1bd+="&baseUrl="+escape(_1be);}_1bd+="&xdomain="+escape(_1bf);_1ba="<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" "+"codebase=\""+this.protocol()+"://fpdownload.macromedia.com/pub/shockwave/cabs/flash/"+"swflash.cab#version=8,0,0,0\"\n "+"width=\""+this.width+"\"\n "+"height=\""+this.height+"\"\n "+"id=\""+this.id+"\"\n "+"name=\""+this.id+"\"\n "+"align=\"middle\">\n "+"<param name=\"allowScriptAccess\" value=\"always\"></param>\n "+"<param name=\"movie\" value=\""+_1bc+"\"></param>\n "+"<param name=\"quality\" value=\"high\"></param>\n "+"<param name=\"bgcolor\" value=\"#ffffff\"></param>\n "+"<embed src=\""+_1bd+"\" "+"quality=\"high\" "+"bgcolor=\"#ffffff\" "+"width=\""+this.width+"\" "+"height=\""+this.height+"\" "+"id=\""+this.id+"Embed"+"\" "+"name=\""+this.id+"\" "+"swLiveConnect=\"true\" "+"align=\"middle\" "+"allowScriptAccess=\"always\" "+"type=\"application/x-shockwave-flash\" "+"pluginspage=\""+this.protocol()+"://www.macromedia.com/go/getflashplayer\" "+"></embed>\n"+"</object>\n";dojo.connect(dojo,"loaded",dojo.hitch(this,function(){var _1c2=this.id+"Container";if(dojo.byId(_1c2)){return;}var div=document.createElement("div");div.id=this.id+"Container";div.style.width=this.width+"px";div.style.height=this.height+"px";if(!this._visible){div.style.position="absolute";div.style.zIndex="10000";div.style.top="-1000px";div.style.left="-1000px";}div.innerHTML=_1ba;var body=document.getElementsByTagName("body");if(!body||!body.length){throw new Error("No body tag for this page");}body=body[0];body.appendChild(div);}));},get:function(){if(dojo.isIE||dojo.isSafari){return dojo.byId(this.id);}else{return document[this.id+"Embed"];}},setVisible:function(_1c5){var _1c6=dojo.byId(this.id+"Container");if(_1c5==true){_1c6.style.position="absolute";_1c6.style.visibility="visible";}else{_1c6.style.position="absolute";_1c6.style.x="-1000px";_1c6.style.y="-1000px";_1c6.style.visibility="hidden";}},center:function(){var _1c7=this.width;var _1c8=this.height;var _1c9=dijit.getViewport();var x=_1c9.l+(_1c9.w-_1c7)/2;var y=_1c9.t+(_1c9.h-_1c8)/2;var _1cc=dojo.byId(this.id+"Container");_1cc.style.top=y+"px";_1cc.style.left=x+"px";}};dojox.flash.Communicator=function(){};dojox.flash.Communicator.prototype={_addExternalInterfaceCallback:function(_1cd){var _1ce=dojo.hitch(this,function(){var _1cf=new Array(arguments.length);for(var i=0;i<arguments.length;i++){_1cf[i]=this._encodeData(arguments[i]);}var _1d1=this._execFlash(_1cd,_1cf);_1d1=this._decodeData(_1d1);return _1d1;});this[_1cd]=_1ce;},_encodeData:function(data){if(!data||typeof data!="string"){return data;}data=data.replace("\\","&custom_backslash;");data=data.replace(/\0/g,"&custom_null;");return data;},_decodeData:function(data){if(data&&data.length&&typeof data!="string"){data=data[0];}if(!data||typeof data!="string"){return data;}data=data.replace(/\&custom_null\;/g," ");data=data.replace(/\&custom_lt\;/g,"<");data=data.replace(/\&custom_gt\;/g,">");data=data.replace(/\&custom_backslash\;/g,"\\");return data;},_execFlash:function(_1d4,_1d5){var _1d6=dojox.flash.obj.get();_1d5=(_1d5)?_1d5:[];for(var i=0;i<_1d5;i++){if(typeof _1d5[i]=="string"){_1d5[i]=this._encodeData(_1d5[i]);}}var _1d8=function(){return eval(_1d6.CallFunction("<invoke name=\""+_1d4+"\" returntype=\"javascript\">"+__flash__argumentsToXML(_1d5,0)+"</invoke>"));};var _1d9=_1d8.call(_1d5);if(typeof _1d9=="string"){_1d9=this._decodeData(_1d9);}return _1d9;}};dojox.flash.Install=function(){};dojox.flash.Install.prototype={needed:function(){if(dojox.flash.info.capable==false){return true;}if(!dojox.flash.info.isVersionOrAbove(8,0,0)){return true;}return false;},install:function(){var _1da;dojox.flash.info.installing=true;dojox.flash.installing();if(dojox.flash.info.capable==false){_1da=new dojox.flash.Embed(false);_1da.write();}else{if(dojox.flash.info.isVersionOrAbove(6,0,65)){_1da=new dojox.flash.Embed(false);_1da.write(true);_1da.setVisible(true);_1da.center();}else{alert("This content requires a more recent version of the Macromedia "+" Flash Player.");window.location.href=+dojox.flash.Embed.protocol()+"://www.macromedia.com/go/getflashplayer";}}},_onInstallStatus:function(msg){if(msg=="Download.Complete"){dojox.flash._initialize();}else{if(msg=="Download.Cancelled"){alert("This content requires a more recent version of the Macromedia "+" Flash Player.");window.location.href=dojox.flash.Embed.protocol()+"://www.macromedia.com/go/getflashplayer";}else{if(msg=="Download.Failed"){alert("There was an error downloading the Flash Player update. "+"Please try again later, or visit macromedia.com to download "+"the latest version of the Flash plugin.");}}}}};dojox.flash.info=new dojox.flash.Info();}if(!dojo._hasResource["dojox.flash"]){dojo._hasResource["dojox.flash"]=true;dojo.provide("dojox.flash");}if(!dojo._hasResource["dojox.storage.FlashStorageProvider"]){dojo._hasResource["dojox.storage.FlashStorageProvider"]=true;dojo.provide("dojox.storage.FlashStorageProvider");dojo.declare("dojox.storage.FlashStorageProvider",dojox.storage.Provider,{initialized:false,_available:null,_statusHandler:null,_flashReady:false,_pageReady:false,initialize:function(){if(dojo.config["disableFlashStorage"]==true){return;}dojox.flash.addLoadedListener(dojo.hitch(this,function(){this._flashReady=true;if(this._flashReady&&this._pageReady){this._loaded();}}));var _1dc=dojo.moduleUrl("dojox","storage/Storage.swf").toString();dojox.flash.setSwf(_1dc,false);dojo.connect(dojo,"loaded",this,function(){this._pageReady=true;if(this._flashReady&&this._pageReady){this._loaded();}});},setFlushDelay:function(_1dd){if(_1dd===null||typeof _1dd==="undefined"||isNaN(_1dd)){throw new Error("Invalid argunment: "+_1dd);}dojox.flash.comm.setFlushDelay(String(_1dd));},getFlushDelay:function(){return Number(dojox.flash.comm.getFlushDelay());},flush:function(_1de){if(_1de==null||typeof _1de=="undefined"){_1de=dojox.storage.DEFAULT_NAMESPACE;}dojox.flash.comm.flush(_1de);},isAvailable:function(){return (this._available=!dojo.config["disableFlashStorage"]);},put:function(key,_1e0,_1e1,_1e2){if(!this.isValidKey(key)){throw new Error("Invalid key given: "+key);}if(!_1e2){_1e2=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_1e2)){throw new Error("Invalid namespace given: "+_1e2);}this._statusHandler=_1e1;if(dojo.isString(_1e0)){_1e0="string:"+_1e0;}else{_1e0=dojo.toJson(_1e0);}dojox.flash.comm.put(key,_1e0,_1e2);},putMultiple:function(keys,_1e4,_1e5,_1e6){if(!this.isValidKeyArray(keys)||!_1e4 instanceof Array||keys.length!=_1e4.length){throw new Error("Invalid arguments: keys = ["+keys+"], values = ["+_1e4+"]");}if(!_1e6){_1e6=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_1e6)){throw new Error("Invalid namespace given: "+_1e6);}this._statusHandler=_1e5;var _1e7=keys.join(",");var _1e8=[];for(var i=0;i<_1e4.length;i++){if(dojo.isString(_1e4[i])){_1e4[i]="string:"+_1e4[i];}else{_1e4[i]=dojo.toJson(_1e4[i]);}_1e8[i]=_1e4[i].length;}var _1ea=_1e4.join("");var _1eb=_1e8.join(",");dojox.flash.comm.putMultiple(_1e7,_1ea,_1eb,_1e6);},get:function(key,_1ed){if(!this.isValidKey(key)){throw new Error("Invalid key given: "+key);}if(!_1ed){_1ed=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_1ed)){throw new Error("Invalid namespace given: "+_1ed);}var _1ee=dojox.flash.comm.get(key,_1ed);if(_1ee==""){return null;}return this._destringify(_1ee);},getMultiple:function(keys,_1f0){if(!this.isValidKeyArray(keys)){throw new ("Invalid key array given: "+keys);}if(!_1f0){_1f0=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_1f0)){throw new Error("Invalid namespace given: "+_1f0);}var _1f1=keys.join(",");var _1f2=dojox.flash.comm.getMultiple(_1f1,_1f0);var _1f3=eval("("+_1f2+")");for(var i=0;i<_1f3.length;i++){_1f3[i]=(_1f3[i]=="")?null:this._destringify(_1f3[i]);}return _1f3;},_destringify:function(_1f5){if(dojo.isString(_1f5)&&(/^string:/.test(_1f5))){_1f5=_1f5.substring("string:".length);}else{_1f5=dojo.fromJson(_1f5);}return _1f5;},getKeys:function(_1f6){if(!_1f6){_1f6=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_1f6)){throw new Error("Invalid namespace given: "+_1f6);}var _1f7=dojox.flash.comm.getKeys(_1f6);if(_1f7==null||_1f7=="null"){_1f7="";}_1f7=_1f7.split(",");_1f7.sort();return _1f7;},getNamespaces:function(){var _1f8=dojox.flash.comm.getNamespaces();if(_1f8==null||_1f8=="null"){_1f8=dojox.storage.DEFAULT_NAMESPACE;}_1f8=_1f8.split(",");_1f8.sort();return _1f8;},clear:function(_1f9){if(!_1f9){_1f9=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_1f9)){throw new Error("Invalid namespace given: "+_1f9);}dojox.flash.comm.clear(_1f9);},remove:function(key,_1fb){if(!_1fb){_1fb=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_1fb)){throw new Error("Invalid namespace given: "+_1fb);}dojox.flash.comm.remove(key,_1fb);},removeMultiple:function(keys,_1fd){if(!this.isValidKeyArray(keys)){dojo.raise("Invalid key array given: "+keys);}if(!_1fd){_1fd=dojox.storage.DEFAULT_NAMESPACE;}if(!this.isValidKey(_1fd)){throw new Error("Invalid namespace given: "+_1fd);}var _1fe=keys.join(",");dojox.flash.comm.removeMultiple(_1fe,_1fd);},isPermanent:function(){return true;},getMaximumSize:function(){return dojox.storage.SIZE_NO_LIMIT;},hasSettingsUI:function(){return true;},showSettingsUI:function(){dojox.flash.comm.showSettings();dojox.flash.obj.setVisible(true);dojox.flash.obj.center();},hideSettingsUI:function(){dojox.flash.obj.setVisible(false);if(dojo.isFunction(dojox.storage.onHideSettingsUI)){dojox.storage.onHideSettingsUI.call(null);}},getResourceList:function(){return [];},_loaded:function(){this._allNamespaces=this.getNamespaces();this.initialized=true;dojox.storage.manager.loaded();},_onStatus:function(_1ff,key,_201){var ds=dojox.storage;var dfo=dojox.flash.obj;if(_1ff==ds.PENDING){dfo.center();dfo.setVisible(true);}else{dfo.setVisible(false);}if(ds._statusHandler){ds._statusHandler.call(null,_1ff,key,null,_201);}}});dojox.storage.manager.register("dojox.storage.FlashStorageProvider",new dojox.storage.FlashStorageProvider());}if(!dojo._hasResource["dojox.storage._common"]){dojo._hasResource["dojox.storage._common"]=true;dojo.provide("dojox.storage._common");dojox.storage.manager.initialize();}if(!dojo._hasResource["dojox.storage"]){dojo._hasResource["dojox.storage"]=true;dojo.provide("dojox.storage");}if(!dojo._hasResource["dojox.off.files"]){dojo._hasResource["dojox.off.files"]=true;dojo.provide("dojox.off.files");dojox.off.files={versionURL:"version.js",listOfURLs:[],refreshing:false,_cancelID:null,_error:false,_errorMessages:[],_currentFileIndex:0,_store:null,_doSlurp:false,slurp:function(){this._doSlurp=true;},cache:function(_204){if(dojo.isString(_204)){var url=this._trimAnchor(_204+"");if(!this.isAvailable(url)){this.listOfURLs.push(url);}}else{if(_204 instanceof dojo._Url){var url=this._trimAnchor(_204.uri);if(!this.isAvailable(url)){this.listOfURLs.push(url);}}else{dojo.forEach(_204,function(url){url=this._trimAnchor(url);if(!this.isAvailable(url)){this.listOfURLs.push(url);}},this);}}},printURLs:function(){dojo.forEach(this.listOfURLs,function(i){});},remove:function(url){for(var i=0;i<this.listOfURLs.length;i++){if(this.listOfURLs[i]==url){this.listOfURLs=this.listOfURLs.splice(i,1);break;}}},isAvailable:function(url){for(var i=0;i<this.listOfURLs.length;i++){if(this.listOfURLs[i]==url){return true;}}return false;},refresh:function(_20c){try{if(dojo.config.isDebug){this.printURLs();}this.refreshing=true;if(this.versionURL){this._getVersionInfo(function(_20d,_20e,_20f){if(dojo.config.isDebug||!_20e||_20f||!_20d||_20d!=_20e){console.warn("Refreshing offline file list");this._doRefresh(_20c,_20e);}else{console.warn("No need to refresh offline file list");_20c(false,[]);}});}else{console.warn("Refreshing offline file list");this._doRefresh(_20c);}}catch(e){this.refreshing=false;dojox.off.coreOpFailed=true;dojox.off.enabled=false;dojox.off.onFrameworkEvent("coreOperationFailed");}},abortRefresh:function(){if(!this.refreshing){return;}this._store.abortCapture(this._cancelID);this.refreshing=false;},_slurp:function(){if(!this._doSlurp){return;}var _210=dojo.hitch(this,function(url){if(this._sameLocation(url)){this.cache(url);}});_210(window.location.href);dojo.query("script").forEach(function(i){try{_210(i.getAttribute("src"));}catch(exp){}});dojo.query("link").forEach(function(i){try{if(!i.getAttribute("rel")||i.getAttribute("rel").toLowerCase()!="stylesheet"){return;}_210(i.getAttribute("href"));}catch(exp){}});dojo.query("img").forEach(function(i){try{_210(i.getAttribute("src"));}catch(exp){}});dojo.query("a").forEach(function(i){try{_210(i.getAttribute("href"));}catch(exp){}});dojo.forEach(document.styleSheets,function(_216){try{if(_216.cssRules){dojo.forEach(_216.cssRules,function(rule){var text=rule.cssText;if(text){var _219=text.match(/url\(\s*([^\) ]*)\s*\)/i);if(!_219){return;}for(var i=1;i<_219.length;i++){_210(_219[i]);}}});}else{if(_216.cssText){var _21b;var text=_216.cssText.toString();var _21d=text.split(/\f|\r|\n/);for(var i=0;i<_21d.length;i++){_21b=_21d[i].match(/url\(\s*([^\) ]*)\s*\)/i);if(_21b&&_21b.length){_210(_21b[1]);}}}}}catch(exp){}});},_sameLocation:function(url){if(!url){return false;}if(url.length&&url.charAt(0)=="#"){return false;}url=new dojo._Url(url);if(!url.scheme&&!url.port&&!url.host){return true;}if(!url.scheme&&url.host&&url.port&&window.location.hostname==url.host&&window.location.port==url.port){return true;}if(!url.scheme&&url.host&&!url.port&&window.location.hostname==url.host&&window.location.port==80){return true;}return window.location.protocol==(url.scheme+":")&&window.location.hostname==url.host&&(window.location.port==url.port||!window.location.port&&!url.port);},_trimAnchor:function(url){return url.replace(/\#.*$/,"");},_doRefresh:function(_221,_222){var _223;try{_223=google.gears.factory.create("beta.localserver","1.0");}catch(exp){dojo.setObject("google.gears.denied",true);dojox.off.onFrameworkEvent("coreOperationFailed");throw "Google Gears must be allowed to run";}var _224="dot_store_"+window.location.href.replace(/[^0-9A-Za-z_]/g,"_");if(_224.length>=64){_224=_224.substring(0,63);}_223.removeStore(_224);_223.openStore(_224);var _225=_223.createStore(_224);this._store=_225;var self=this;this._currentFileIndex=0;this._cancelID=_225.capture(this.listOfURLs,function(url,_228,_229){if(!_228&&self.refreshing){self._cancelID=null;self.refreshing=false;var _22a=[];_22a.push("Unable to capture: "+url);_221(true,_22a);return;}else{if(_228){self._currentFileIndex++;}}if(_228&&self._currentFileIndex>=self.listOfURLs.length){self._cancelID=null;self.refreshing=false;if(_222){dojox.storage.put("oldVersion",_222,null,dojox.off.STORAGE_NAMESPACE);}dojox.storage.put("justDebugged",dojo.config.isDebug,null,dojox.off.STORAGE_NAMESPACE);_221(false,[]);}});},_getVersionInfo:function(_22b){var _22c=dojox.storage.get("justDebugged",dojox.off.STORAGE_NAMESPACE);var _22d=dojox.storage.get("oldVersion",dojox.off.STORAGE_NAMESPACE);var _22e=null;_22b=dojo.hitch(this,_22b);dojo.xhrGet({url:this.versionURL+"?browserbust="+new Date().getTime(),timeout:5*1000,handleAs:"javascript",error:function(err){dojox.storage.remove("oldVersion",dojox.off.STORAGE_NAMESPACE);dojox.storage.remove("justDebugged",dojox.off.STORAGE_NAMESPACE);_22b(_22d,_22e,_22c);},load:function(data){if(data){_22e=data;}_22b(_22d,_22e,_22c);}});}};}if(!dojo._hasResource["dojox.off.sync"]){dojo._hasResource["dojox.off.sync"]=true;dojo.provide("dojox.off.sync");dojo.mixin(dojox.off.sync,{isSyncing:false,cancelled:false,successful:true,details:[],error:false,actions:null,autoSync:true,onSync:function(type){},synchronize:function(){if(this.isSyncing||dojox.off.goingOnline||(!dojox.off.isOnline)){return;}this.isSyncing=true;this.successful=false;this.details=[];this.cancelled=false;this.start();},cancel:function(){if(!this.isSyncing){return;}this.cancelled=true;if(dojox.off.files.refreshing){dojox.off.files.abortRefresh();}this.onSync("cancel");},finishedDownloading:function(_232,_233){if(typeof _232=="undefined"){_232=true;}if(!_232){this.successful=false;this.details.push(_233);this.error=true;}this.finished();},start:function(){if(this.cancelled){this.finished();return;}this.onSync("start");this.refreshFiles();},refreshFiles:function(){if(this.cancelled){this.finished();return;}this.onSync("refreshFiles");dojox.off.files.refresh(dojo.hitch(this,function(_234,_235){if(_234){this.error=true;this.successful=false;for(var i=0;i<_235.length;i++){this.details.push(_235[i]);}}this.upload();}));},upload:function(){if(this.cancelled){this.finished();return;}this.onSync("upload");dojo.connect(this.actions,"onReplayFinished",this,this.download);this.actions.replay();},download:function(){if(this.cancelled){this.finished();return;}this.onSync("download");},finished:function(){this.isSyncing=false;this.successful=(!this.cancelled&&!this.error);this.onSync("finished");},_save:function(_237){this.actions._save(function(){_237();});},_load:function(_238){this.actions._load(function(){_238();});}});dojo.declare("dojox.off.sync.ActionLog",null,{entries:[],reasonHalted:null,isReplaying:false,autoSave:true,add:function(_239){if(this.isReplaying){throw "Programming error: you can not call "+"dojox.off.sync.actions.add() while "+"we are replaying an action log";}this.entries.push(_239);if(this.autoSave){this._save();}},onReplay:function(_23a,_23b){},length:function(){return this.entries.length;},haltReplay:function(_23c){if(!this.isReplaying){return;}if(_23c){this.reasonHalted=_23c.toString();}if(this.autoSave){var self=this;this._save(function(){self.isReplaying=false;self.onReplayFinished();});}else{this.isReplaying=false;this.onReplayFinished();}},continueReplay:function(){if(!this.isReplaying){return;}this.entries.shift();if(!this.entries.length){if(this.autoSave){var self=this;this._save(function(){self.isReplaying=false;self.onReplayFinished();});return;}else{this.isReplaying=false;this.onReplayFinished();return;}}var _23f=this.entries[0];this.onReplay(_23f,this);},clear:function(){if(this.isReplaying){return;}this.entries=[];if(this.autoSave){this._save();}},replay:function(){if(this.isReplaying){return;}this.reasonHalted=null;if(!this.entries.length){this.onReplayFinished();return;}this.isReplaying=true;var _240=this.entries[0];this.onReplay(_240,this);},onReplayFinished:function(){},toString:function(){var _241="";_241+="[";for(var i=0;i<this.entries.length;i++){_241+="{";for(var j in this.entries[i]){_241+=j+": \""+this.entries[i][j]+"\"";_241+=", ";}_241+="}, ";}_241+="]";return _241;},_save:function(_244){if(!_244){_244=function(){};}try{var self=this;var _246=function(_247,key,_249){if(_247==dojox.storage.FAILED){dojox.off.onFrameworkEvent("save",{status:dojox.storage.FAILED,isCoreSave:true,key:key,value:_249,namespace:dojox.off.STORAGE_NAMESPACE});_244();}else{if(_247==dojox.storage.SUCCESS){_244();}}};dojox.storage.put("actionlog",this.entries,_246,dojox.off.STORAGE_NAMESPACE);}catch(exp){dojox.off.onFrameworkEvent("save",{status:dojox.storage.FAILED,isCoreSave:true,key:"actionlog",value:this.entries,namespace:dojox.off.STORAGE_NAMESPACE});_244();}},_load:function(_24a){var _24b=dojox.storage.get("actionlog",dojox.off.STORAGE_NAMESPACE);if(!_24b){_24b=[];}this.entries=_24b;_24a();}});dojox.off.sync.actions=new dojox.off.sync.ActionLog();}if(!dojo._hasResource["dojox.off._common"]){dojo._hasResource["dojox.off._common"]=true;dojo.provide("dojox.off._common");dojo.mixin(dojox.off,{isOnline:false,NET_CHECK:5,STORAGE_NAMESPACE:"_dot",enabled:true,availabilityURL:dojo.moduleUrl("dojox","off/network_check.txt"),goingOnline:false,coreOpFailed:false,doNetChecking:true,hasOfflineCache:null,browserRestart:false,_STORAGE_APP_NAME:window.location.href.replace(/[^0-9A-Za-z_]/g,"_"),_initializeCalled:false,_storageLoaded:false,_pageLoaded:false,onLoad:function(){},onNetwork:function(type){},initialize:function(){this._initializeCalled=true;if(this._storageLoaded&&this._pageLoaded){this._onLoad();}},goOffline:function(){if((dojox.off.sync.isSyncing)||(this.goingOnline)){return;}this.goingOnline=false;this.isOnline=false;},goOnline:function(_24d){if(dojox.off.sync.isSyncing||dojox.off.goingOnline){return;}this.goingOnline=true;this.isOnline=false;this._isSiteAvailable(_24d);},onFrameworkEvent:function(type,_24f){if(type=="save"){if(_24f.isCoreSave&&(_24f.status==dojox.storage.FAILED)){dojox.off.coreOpFailed=true;dojox.off.enabled=false;dojox.off.onFrameworkEvent("coreOperationFailed");}}else{if(type=="coreOperationFailed"){dojox.off.coreOpFailed=true;dojox.off.enabled=false;}}},_checkOfflineCacheAvailable:function(_250){this.hasOfflineCache=dojo.gears.available;_250();},_onLoad:function(){dojox.off.files.cache(dojo.moduleUrl("dojo","dojo.js"));this._cacheDojoResources();dojox.off.files.cache(dojox.storage.manager.getResourceList());dojox.off.files._slurp();this._checkOfflineCacheAvailable(dojo.hitch(this,"_onOfflineCacheChecked"));},_onOfflineCacheChecked:function(){if(this.hasOfflineCache&&this.enabled){this._load(dojo.hitch(this,"_finishStartingUp"));}else{if(this.hasOfflineCache&&!this.enabled){this._finishStartingUp();}else{this._keepCheckingUntilInstalled();}}},_keepCheckingUntilInstalled:function(){this._finishStartingUp();},_finishStartingUp:function(){if(!this.hasOfflineCache){this.onLoad();}else{if(this.enabled){this._startNetworkThread();this.goOnline(dojo.hitch(this,function(){dojox.off.onLoad();}));}else{if(this.coreOpFailed){this.onFrameworkEvent("coreOperationFailed");}else{this.onLoad();}}}},_onPageLoad:function(){this._pageLoaded=true;if(this._storageLoaded&&this._initializeCalled){this._onLoad();}},_onStorageLoad:function(){this._storageLoaded=true;if(!dojox.storage.manager.isAvailable()&&dojox.storage.manager.isInitialized()){this.coreOpFailed=true;this.enabled=false;}if(this._pageLoaded&&this._initializeCalled){this._onLoad();}},_isSiteAvailable:function(_251){dojo.xhrGet({url:this._getAvailabilityURL(),handleAs:"text",timeout:this.NET_CHECK*1000,error:dojo.hitch(this,function(err){this.goingOnline=false;this.isOnline=false;if(_251){_251(false);}}),load:dojo.hitch(this,function(data){this.goingOnline=false;this.isOnline=true;if(_251){_251(true);}else{this.onNetwork("online");}})});},_startNetworkThread:function(){if(!this.doNetChecking){return;}window.setInterval(dojo.hitch(this,function(){var d=dojo.xhrGet({url:this._getAvailabilityURL(),handleAs:"text",timeout:this.NET_CHECK*1000,error:dojo.hitch(this,function(err){if(this.isOnline){this.isOnline=false;try{if(typeof d.ioArgs.xhr.abort=="function"){d.ioArgs.xhr.abort();}}catch(e){}dojox.off.sync.isSyncing=false;this.onNetwork("offline");}}),load:dojo.hitch(this,function(data){if(!this.isOnline){this.isOnline=true;this.onNetwork("online");}})});}),this.NET_CHECK*1000);},_getAvailabilityURL:function(){var url=this.availabilityURL.toString();if(url.indexOf("?")==-1){url+="?";}else{url+="&";}url+="browserbust="+new Date().getTime();return url;},_onOfflineCacheInstalled:function(){this.onFrameworkEvent("offlineCacheInstalled");},_cacheDojoResources:function(){var _258=true;dojo.forEach(dojo.query("script"),function(i){var src=i.getAttribute("src");if(!src){return;}if(src.indexOf("_base/_loader/bootstrap.js")!=-1){_258=false;}});if(!_258){dojox.off.files.cache(dojo.moduleUrl("dojo","_base.js").uri);dojox.off.files.cache(dojo.moduleUrl("dojo","_base/_loader/loader.js").uri);dojox.off.files.cache(dojo.moduleUrl("dojo","_base/_loader/bootstrap.js").uri);dojox.off.files.cache(dojo.moduleUrl("dojo","_base/_loader/hostenv_browser.js").uri);}for(var i=0;i<dojo._loadedUrls.length;i++){dojox.off.files.cache(dojo._loadedUrls[i]);}},_save:function(){},_load:function(_25c){dojox.off.sync._load(_25c);}});dojox.storage.manager.addOnLoad(dojo.hitch(dojox.off,"_onStorageLoad"));dojo.addOnLoad(dojox.off,"_onPageLoad");}if(!dojo._hasResource["dojox.off"]){dojo._hasResource["dojox.off"]=true;dojo.provide("dojox.off");}if(!dojo._hasResource["dojox.off.ui"]){dojo._hasResource["dojox.off.ui"]=true;dojo.provide("dojox.off.ui");dojo.mixin(dojox.off.ui,{appName:"setme",autoEmbed:true,autoEmbedID:"dot-widget",runLink:window.location.href,runLinkTitle:"Run Application",learnHowPath:dojo.moduleUrl("dojox","off/resources/learnhow.html"),customLearnHowPath:false,htmlTemplatePath:dojo.moduleUrl("dojox","off/resources/offline-widget.html").uri,cssTemplatePath:dojo.moduleUrl("dojox","off/resources/offline-widget.css").uri,onlineImagePath:dojo.moduleUrl("dojox","off/resources/greenball.png").uri,offlineImagePath:dojo.moduleUrl("dojox","off/resources/redball.png").uri,rollerImagePath:dojo.moduleUrl("dojox","off/resources/roller.gif").uri,checkmarkImagePath:dojo.moduleUrl("dojox","off/resources/checkmark.png").uri,learnHowJSPath:dojo.moduleUrl("dojox","off/resources/learnhow.js").uri,_initialized:false,onLoad:function(){},_initialize:function(){if(this._validateAppName(this.appName)==false){alert("You must set dojox.off.ui.appName; it can only contain "+"letters, numbers, and spaces; right now it "+"is incorrectly set to '"+dojox.off.ui.appName+"'");dojox.off.enabled=false;return;}this.runLinkText="Run "+this.appName;dojo.connect(dojox.off,"onNetwork",this,"_onNetwork");dojo.connect(dojox.off.sync,"onSync",this,"_onSync");dojox.off.files.cache([this.htmlTemplatePath,this.cssTemplatePath,this.onlineImagePath,this.offlineImagePath,this.rollerImagePath,this.checkmarkImagePath]);if(this.autoEmbed){this._doAutoEmbed();}},_doAutoEmbed:function(){dojo.xhrGet({url:this.htmlTemplatePath,handleAs:"text",error:function(err){dojox.off.enabled=false;err=err.message||err;alert("Error loading the Dojo Offline Widget from "+this.htmlTemplatePath+": "+err);},load:dojo.hitch(this,this._templateLoaded)});},_templateLoaded:function(data){var _25f=dojo.byId(this.autoEmbedID);if(_25f){_25f.innerHTML=data;}this._initImages();this._updateNetIndicator();this._initLearnHow();this._initialized=true;if(!dojox.off.hasOfflineCache){this._showNeedsOfflineCache();return;}if(dojox.off.hasOfflineCache&&dojox.off.browserRestart){this._needsBrowserRestart();return;}else{var _260=dojo.byId("dot-widget-browser-restart");if(_260){_260.style.display="none";}}this._updateSyncUI();this._initMainEvtHandlers();this._setOfflineEnabled(dojox.off.enabled);this._onNetwork(dojox.off.isOnline?"online":"offline");this._testNet();},_testNet:function(){dojox.off.goOnline(dojo.hitch(this,function(_261){this._onNetwork(_261?"online":"offline");this.onLoad();}));},_updateNetIndicator:function(){var _262=dojo.byId("dot-widget-network-indicator-online");var _263=dojo.byId("dot-widget-network-indicator-offline");var _264=dojo.byId("dot-widget-title-text");if(_262&&_263){if(dojox.off.isOnline==true){_262.style.display="inline";_263.style.display="none";}else{_262.style.display="none";_263.style.display="inline";}}if(_264){if(dojox.off.isOnline){_264.innerHTML="Online";}else{_264.innerHTML="Offline";}}},_initLearnHow:function(){var _265=dojo.byId("dot-widget-learn-how-link");if(!_265){return;}if(!this.customLearnHowPath){var _266=dojo.config.baseRelativePath;this.learnHowPath+="?appName="+encodeURIComponent(this.appName)+"&hasOfflineCache="+dojox.off.hasOfflineCache+"&runLink="+encodeURIComponent(this.runLink)+"&runLinkText="+encodeURIComponent(this.runLinkText)+"&baseRelativePath="+encodeURIComponent(_266);dojox.off.files.cache(this.learnHowJSPath);dojox.off.files.cache(this.learnHowPath);}_265.setAttribute("href",this.learnHowPath);var _267=dojo.byId("dot-widget-learn-how-app-name");if(!_267){return;}_267.innerHTML="";_267.appendChild(document.createTextNode(this.appName));},_validateAppName:function(_268){if(!_268){return false;}return (/^[a-z0-9 ]*$/i.test(_268));},_updateSyncUI:function(){var _269=dojo.byId("dot-roller");var _26a=dojo.byId("dot-success-checkmark");var _26b=dojo.byId("dot-sync-messages");var _26c=dojo.byId("dot-sync-details");var _26d=dojo.byId("dot-sync-cancel");if(dojox.off.sync.isSyncing){this._clearSyncMessage();if(_269){_269.style.display="inline";}if(_26a){_26a.style.display="none";}if(_26b){dojo.removeClass(_26b,"dot-sync-error");}if(_26c){_26c.style.display="none";}if(_26d){_26d.style.display="inline";}}else{if(_269){_269.style.display="none";}if(_26d){_26d.style.display="none";}if(_26b){dojo.removeClass(_26b,"dot-sync-error");}}},_setSyncMessage:function(_26e){var _26f=dojo.byId("dot-sync-messages");if(_26f){while(_26f.firstChild){_26f.removeChild(_26f.firstChild);}_26f.appendChild(document.createTextNode(_26e));}},_clearSyncMessage:function(){this._setSyncMessage("");},_initImages:function(){var _270=dojo.byId("dot-widget-network-indicator-online");if(_270){_270.setAttribute("src",this.onlineImagePath);}var _271=dojo.byId("dot-widget-network-indicator-offline");if(_271){_271.setAttribute("src",this.offlineImagePath);}var _272=dojo.byId("dot-roller");if(_272){_272.setAttribute("src",this.rollerImagePath);}var _273=dojo.byId("dot-success-checkmark");if(_273){_273.setAttribute("src",this.checkmarkImagePath);}},_showDetails:function(evt){evt.preventDefault();evt.stopPropagation();if(!dojox.off.sync.details.length){return;}var html="";html+="<html><head><title>Sync Details</title><head><body>";html+="<h1>Sync Details</h1>\n";html+="<ul>\n";for(var i=0;i<dojox.off.sync.details.length;i++){html+="<li>";html+=dojox.off.sync.details[i];html+="</li>";}html+="</ul>\n";html+="<a href='javascript:window.close()' "+"style='text-align: right; padding-right: 2em;'>"+"Close Window"+"</a>\n";html+="</body></html>";var _277="height=400,width=600,resizable=true,"+"scrollbars=true,toolbar=no,menubar=no,"+"location=no,directories=no,dependent=yes";var _278=window.open("","SyncDetails",_277);if(!_278){alert("Please allow popup windows for this domain; can't display sync details window");return;}_278.document.open();_278.document.write(html);_278.document.close();if(_278.focus){_278.focus();}},_cancel:function(evt){evt.preventDefault();evt.stopPropagation();dojox.off.sync.cancel();},_needsBrowserRestart:function(){var _27a=dojo.byId("dot-widget-browser-restart");if(_27a){dojo.addClass(_27a,"dot-needs-browser-restart");}var _27b=dojo.byId("dot-widget-browser-restart-app-name");if(_27b){_27b.innerHTML="";_27b.appendChild(document.createTextNode(this.appName));}var _27c=dojo.byId("dot-sync-status");if(_27c){_27c.style.display="none";}},_showNeedsOfflineCache:function(){var _27d=dojo.byId("dot-widget-container");if(_27d){dojo.addClass(_27d,"dot-needs-offline-cache");}},_hideNeedsOfflineCache:function(){var _27e=dojo.byId("dot-widget-container");if(_27e){dojo.removeClass(_27e,"dot-needs-offline-cache");}},_initMainEvtHandlers:function(){var _27f=dojo.byId("dot-sync-details-button");if(_27f){dojo.connect(_27f,"onclick",this,this._showDetails);}var _280=dojo.byId("dot-sync-cancel-button");if(_280){dojo.connect(_280,"onclick",this,this._cancel);}},_setOfflineEnabled:function(_281){var _282=[];_282.push(dojo.byId("dot-sync-status"));for(var i=0;i<_282.length;i++){if(_282[i]){_282[i].style.visibility=(_281?"visible":"hidden");}}},_syncFinished:function(){this._updateSyncUI();var _284=dojo.byId("dot-success-checkmark");var _285=dojo.byId("dot-sync-details");if(dojox.off.sync.successful==true){this._setSyncMessage("Sync Successful");if(_284){_284.style.display="inline";}}else{if(dojox.off.sync.cancelled==true){this._setSyncMessage("Sync Cancelled");if(_284){_284.style.display="none";}}else{this._setSyncMessage("Sync Error");var _286=dojo.byId("dot-sync-messages");if(_286){dojo.addClass(_286,"dot-sync-error");}if(_284){_284.style.display="none";}}}if(dojox.off.sync.details.length&&_285){_285.style.display="inline";}},_onFrameworkEvent:function(type,_288){if(type=="save"){if(_288.status==dojox.storage.FAILED&&!_288.isCoreSave){alert("Please increase the amount of local storage available "+"to this application");if(dojox.storage.hasSettingsUI()){dojox.storage.showSettingsUI();}}}else{if(type=="coreOperationFailed"){if(!this._userInformed){alert("This application will not work if Google Gears is not allowed to run");this._userInformed=true;}}else{if(type=="offlineCacheInstalled"){this._hideNeedsOfflineCache();if(dojox.off.hasOfflineCache==true&&dojox.off.browserRestart==true){this._needsBrowserRestart();return;}else{var _289=dojo.byId("dot-widget-browser-restart");if(_289){_289.style.display="none";}}this._updateSyncUI();this._initMainEvtHandlers();this._setOfflineEnabled(dojox.off.enabled);this._testNet();}}}},_onSync:function(type){switch(type){case "start":this._updateSyncUI();break;case "refreshFiles":this._setSyncMessage("Downloading UI...");break;case "upload":this._setSyncMessage("Uploading new data...");break;case "download":this._setSyncMessage("Downloading new data...");break;case "finished":this._syncFinished();break;case "cancel":this._setSyncMessage("Canceling Sync...");break;default:dojo.warn("Programming error: "+"Unknown sync type in dojox.off.ui: "+type);break;}},_onNetwork:function(type){if(!this._initialized){return;}this._updateNetIndicator();if(type=="offline"){this._setSyncMessage("You are working offline");var _28c=dojo.byId("dot-sync-details");if(_28c){_28c.style.display="none";}this._updateSyncUI();}else{if(dojox.off.sync.autoSync){if(dojo.isAIR){window.setTimeout(function(){dojox.off.sync.synchronize();},1000);}else{window.setTimeout(dojox._scopeName+".off.sync.synchronize()",1000);}}}}});dojo.connect(dojox.off,"onFrameworkEvent",dojox.off.ui,"_onFrameworkEvent");dojo.connect(dojox.off,"onLoad",dojox.off.ui,dojox.off.ui._initialize);}if(!dojo._hasResource["dojox.off.offline"]){dojo._hasResource["dojox.off.offline"]=true;dojo.provide("dojox.off.offline");}
