/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.util;

import java.io.Serializable;
import java.util.Arrays;

public class ExpiringStack
implements Serializable {
    private static final long serialVersionUID = 3546919169401434168L;
    private static final int DEFAULT_CAPACITY = 4;
    private Object[] items = new Object[4];
    private long[] timestamps = new long[4];
    private int size = 0;

    public void clear() {
        Arrays.fill(this.items, null);
        this.size = 0;
    }

    public Object pop() {
        if (this.size == 0) {
            return null;
        }
        int pos = this.size - 1;
        Object ret = this.items[pos];
        this.items[pos] = null;
        --this.size;
        return ret;
    }

    public void push(Object obj) {
        if (this.size == this.items.length) {
            int oldLen = this.items.length;
            Object[] tmpItems = new Object[oldLen * 2];
            System.arraycopy(this.items, 0, tmpItems, 0, this.size);
            long[] tmpTimestamps = new long[oldLen * 2];
            System.arraycopy(this.timestamps, 0, tmpTimestamps, 0, this.size);
            this.items = tmpItems;
            this.timestamps = tmpTimestamps;
        }
        this.items[this.size] = obj;
        this.timestamps[this.size] = System.currentTimeMillis();
        ++this.size;
    }

    public void remove(Object o) {
        int i = this.size - 1;
        while (i >= 0) {
            if (this.items[i] == o) {
                System.arraycopy(this.items, i + 1, this.items, i, this.size - i - 1);
                System.arraycopy(this.timestamps, i + 1, this.timestamps, i, this.size - i - 1);
                this.items[this.size - 1] = null;
                --this.size;
                break;
            }
            --i;
        }
    }

    public void expireBefore(long time) {
        int i = 0;
        while (i < this.size) {
            if (this.timestamps[i] >= time) break;
            ++i;
        }
        if (i > 0) {
            this.size -= i;
            System.arraycopy(this.items, i, this.items, 0, this.size);
            System.arraycopy(this.timestamps, i, this.timestamps, 0, this.size);
            Arrays.fill(this.items, this.size, this.items.length, null);
        }
    }

    public Object first() {
        if (this.size == 0) {
            return null;
        }
        return this.items[this.size - 1];
    }

    public Object last() {
        if (this.size == 0) {
            return null;
        }
        return this.items[0];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }
}

