/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.util;

import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionLog {
    public static final String PREFIX = String.valueOf(SessionLog.class.getName()) + ".prefix";
    public static final String LOGGER = String.valueOf(SessionLog.class.getName()) + ".logger";

    private static Class getClass(IoSession session) {
        return session.getHandler().getClass();
    }

    public static void debug(IoSession session, String message) {
        Logger log = SessionLog.getLogger(session);
        if (log.isDebugEnabled()) {
            log.debug(String.valueOf(String.valueOf(session.getAttribute(PREFIX))) + message);
        }
    }

    public static void debug(IoSession session, String message, Throwable cause) {
        Logger log = SessionLog.getLogger(session);
        if (log.isDebugEnabled()) {
            log.debug(String.valueOf(String.valueOf(session.getAttribute(PREFIX))) + message, cause);
        }
    }

    public static void info(IoSession session, String message) {
        Logger log = SessionLog.getLogger(session);
        if (log.isInfoEnabled()) {
            log.info(String.valueOf(String.valueOf(session.getAttribute(PREFIX))) + message);
        }
    }

    public static void info(IoSession session, String message, Throwable cause) {
        Logger log = SessionLog.getLogger(session);
        if (log.isInfoEnabled()) {
            log.info(String.valueOf(String.valueOf(session.getAttribute(PREFIX))) + message, cause);
        }
    }

    public static void warn(IoSession session, String message) {
        Logger log = SessionLog.getLogger(session);
        if (log.isWarnEnabled()) {
            log.warn(String.valueOf(String.valueOf(session.getAttribute(PREFIX))) + message);
        }
    }

    public static void warn(IoSession session, String message, Throwable cause) {
        Logger log = SessionLog.getLogger(session);
        if (log.isWarnEnabled()) {
            log.warn(String.valueOf(String.valueOf(session.getAttribute(PREFIX))) + message, cause);
        }
    }

    public static void error(IoSession session, String message) {
        Logger log = SessionLog.getLogger(session);
        if (log.isErrorEnabled()) {
            log.error(String.valueOf(String.valueOf(session.getAttribute(PREFIX))) + message);
        }
    }

    public static void error(IoSession session, String message, Throwable cause) {
        Logger log = SessionLog.getLogger(session);
        if (log.isErrorEnabled()) {
            log.error(String.valueOf(String.valueOf(session.getAttribute(PREFIX))) + message, cause);
        }
    }

    public static boolean isDebugEnabled(IoSession session) {
        return SessionLog.getLogger(session).isDebugEnabled();
    }

    public static boolean isInfoEnabled(IoSession session) {
        return SessionLog.getLogger(session).isInfoEnabled();
    }

    public static boolean isWarnEnabled(IoSession session) {
        return SessionLog.getLogger(session).isWarnEnabled();
    }

    public static boolean isErrorEnabled(IoSession session) {
        return SessionLog.getLogger(session).isErrorEnabled();
    }

    private static Logger getLogger(IoSession session) {
        Logger log = (Logger)session.getAttribute(LOGGER);
        if (log == null) {
            log = LoggerFactory.getLogger(SessionLog.getClass(session));
            String prefix = (String)session.getAttribute(PREFIX);
            if (prefix == null) {
                prefix = "[" + session.getRemoteAddress() + "] ";
                session.setAttribute(PREFIX, prefix);
            }
            session.setAttribute(LOGGER, log);
        }
        return log;
    }
}

