/*
 * Decompiled with CFR 0.152.
 */
package org.avis.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.avis.config.OptionType;
import org.avis.config.OptionTypeBoolean;
import org.avis.config.OptionTypeInt;
import org.avis.config.OptionTypeParam;
import org.avis.config.OptionTypeString;
import org.avis.config.Options;
import org.avis.util.IllegalConfigOptionException;
import org.avis.util.Pair;

public class OptionSet {
    public static final OptionSet EMPTY_OPTION_SET = new OptionSet();
    public final Options defaults = new Options(this);
    protected List<OptionSet> inherited = new ArrayList<OptionSet>();
    protected Map<String, OptionType> optionTypes = new TreeMap<String, OptionType>(String.CASE_INSENSITIVE_ORDER);

    public OptionSet() {
    }

    public OptionSet(OptionSet inheritedOptions) {
        this();
        this.inherited.add(inheritedOptions);
    }

    public void inheritFrom(OptionSet optionSet) {
        this.inherited.add(optionSet);
    }

    public Object peekDefaultValue(String option) {
        Object value = this.defaults.values.get(option);
        if (value == null) {
            for (OptionSet superSet : this.inherited) {
                value = superSet.defaults.values.get(option);
                if (value == null) continue;
                break;
            }
        }
        return value;
    }

    public void add(String option, int min, int defaultValue, int max) {
        this.add(option, new OptionTypeInt(min, max), defaultValue);
    }

    public void add(String option, boolean defaultValue) {
        this.add(option, OptionTypeBoolean.INSTANCE, defaultValue);
    }

    public void add(String option, String defaultValue) {
        this.add(option, new OptionTypeString(), (Object)defaultValue);
    }

    public void add(String option, String defaultValue, String ... values) {
        this.add(option, new OptionTypeString(defaultValue, values), (Object)defaultValue);
    }

    protected void add(String option, OptionType type, Object defaultValue) {
        this.optionTypes.put(option, type);
        this.set(this.defaults, option, defaultValue);
    }

    public final boolean isValid(String option, Object value) {
        return this.validate(option, value) == null;
    }

    public boolean isDefined(String option) {
        return this.findOptionType(option) != null;
    }

    public int getMaxValue(String name) throws IllegalConfigOptionException {
        return this.intOption((String)name).max;
    }

    public int getMinValue(String name) throws IllegalConfigOptionException {
        return this.intOption((String)name).min;
    }

    private OptionTypeInt intOption(String name) throws IllegalConfigOptionException {
        OptionType info = this.findOptionType(name);
        if (info instanceof OptionTypeInt) {
            return (OptionTypeInt)info;
        }
        throw new IllegalConfigOptionException(name, "Not an integer value");
    }

    public final String validate(String option, Object value) {
        String message = null;
        if (this.optionTypes.containsKey(option)) {
            message = this.testValid(option, value);
        } else {
            OptionSet inheritedSet;
            Iterator<OptionSet> i$ = this.inherited.iterator();
            while (i$.hasNext() && (message = (inheritedSet = i$.next()).testValid(option, value)) != null) {
            }
        }
        return message;
    }

    protected void validateAndSet(Options options, String option, Object value) {
        Pair<String, List<String>> optionItems = OptionTypeParam.splitOptionParam(option);
        OptionType type = this.optionTypeFor((String)optionItems.item1);
        if (type instanceof OptionTypeParam) {
            value = ((OptionTypeParam)type).updateValue(options, option, (String)optionItems.item1, (List)optionItems.item2, value);
        } else if (!((List)optionItems.item2).isEmpty()) {
            throw new IllegalConfigOptionException(option, "Cannot specify parameters for option");
        }
        value = type.convert(option, value);
        String message = type.validate(option, value);
        if (message != null) {
            throw new IllegalConfigOptionException(option, message);
        }
        this.set(options, (String)optionItems.item1, value);
    }

    protected final void set(Options options, String option, Object value) {
        options.values.put(option, value);
    }

    private String testValid(String option, Object value) {
        return this.optionTypeFor(option).validate(option, value);
    }

    public Object convert(String option, Object value) throws IllegalConfigOptionException {
        return this.optionTypeFor(option).convert(option, value);
    }

    protected OptionSet findOptionSetFor(String option) {
        if (this.peekOptionTypeFor(option) != null) {
            return this;
        }
        for (OptionSet superset : this.inherited) {
            OptionSet set = superset.findOptionSetFor(option);
            if (set == null) continue;
            return set;
        }
        return null;
    }

    protected OptionType peekOptionTypeFor(String option) {
        Pair<String, List<String>> optionItems = OptionTypeParam.splitOptionParam(option);
        return this.optionTypes.get(optionItems.item1);
    }

    public OptionType optionTypeFor(String option) throws IllegalConfigOptionException {
        OptionType type = this.findOptionType(option);
        if (type == null) {
            throw new IllegalConfigOptionException(option, "Undefined option");
        }
        return type;
    }

    private OptionType findOptionType(String option) {
        OptionType optionType;
        block1: {
            OptionSet inheritedSet;
            optionType = this.optionTypes.get(option);
            if (optionType != null) break block1;
            Iterator<OptionSet> i$ = this.inherited.iterator();
            while (i$.hasNext() && (optionType = (inheritedSet = i$.next()).findOptionType(option)) == null) {
            }
        }
        return optionType;
    }
}

