/*
 * Decompiled with CFR 0.152.
 */
package org.avis.config;

import org.avis.config.OptionType;
import org.avis.util.IllegalConfigOptionException;

public class OptionTypeInt
extends OptionType {
    protected int min;
    protected int max;

    public OptionTypeInt(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public Object convert(String option, Object value) {
        if (value instanceof Integer) {
            return value;
        }
        try {
            String text = value.toString().toLowerCase();
            int unit = 1;
            if (text.endsWith("m")) {
                unit = 0x100000;
                text = text.substring(0, text.length() - 1);
            } else if (text.endsWith("k")) {
                unit = 1024;
                text = text.substring(0, text.length() - 1);
            }
            return Integer.parseInt(text) * unit;
        }
        catch (NumberFormatException ex) {
            throw new IllegalConfigOptionException(option, "\"" + value + "\" is not a valid integer");
        }
    }

    public String validate(String option, Object value) {
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            if (intValue >= this.min && intValue <= this.max) {
                return null;
            }
            return "Value must be in range " + this.min + ".." + this.max;
        }
        return "Value is not an integer";
    }
}

