/*
 * Decompiled with CFR 0.152.
 */
package org.avis.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.avis.config.OptionType;
import org.avis.config.Options;
import org.avis.util.IllegalConfigOptionException;
import org.avis.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionTypeParam
extends OptionType {
    private static final List<String> EMPTY_STRING_LIST = Collections.emptyList();
    private OptionType subOption;
    private int paramCount;

    public OptionTypeParam(OptionType option) {
        this(option, 1);
    }

    public OptionTypeParam(OptionType subOption, int paramCount) {
        this.subOption = subOption;
        this.paramCount = paramCount;
    }

    @Override
    public Object convert(String option, Object value) throws IllegalConfigOptionException {
        return value;
    }

    @Override
    public String validate(String option, Object value) {
        return this.validateType(value, Map.class);
    }

    public Object updateValue(Options options, String option, String baseOption, List<String> params, Object value) {
        if (params.size() != this.paramCount) {
            throw new IllegalConfigOptionException(option, "Parameters required: " + this.paramCount);
        }
        String valid = this.subOption.validate(option, value = this.subOption.convert(option, value));
        if (valid != null) {
            throw new IllegalConfigOptionException(option, valid);
        }
        HashMap<String, Object> baseValue = (HashMap<String, Object>)options.get(baseOption);
        if (baseValue.isEmpty()) {
            baseValue = new HashMap<String, Object>();
        }
        Map<String, Object> map = baseValue;
        for (int i = 0; i < this.paramCount - 1; ++i) {
            map = OptionTypeParam.createEntry(map, params.get(i));
        }
        map.put(params.get(params.size() - 1), value);
        return baseValue;
    }

    public static Map<String, Object> getParamOption(Options options, String option) {
        OptionType type = options.optionSet().optionTypeFor(option);
        if (type instanceof OptionTypeParam) {
            return (Map)options.get(option);
        }
        throw new IllegalConfigOptionException(option, "Not a parameterised option");
    }

    public static Pair<String, List<String>> splitOptionParam(String option) {
        int index = option.indexOf(91);
        if (index == -1) {
            if (option.indexOf(93) == -1) {
                return new Pair<String, List<String>>(option, EMPTY_STRING_LIST);
            }
            throw new IllegalConfigOptionException(option, "Orphan ]");
        }
        String base = option.substring(0, index);
        ArrayList<String> params = new ArrayList<String>();
        while (index < option.length()) {
            int end = option.indexOf(93, index);
            if (end == -1) {
                throw new IllegalConfigOptionException(option, "Missing ]");
            }
            params.add(option.substring(index + 1, end));
            index = end + 1;
            if (index >= option.length() || option.charAt(index) == '[') continue;
            throw new IllegalConfigOptionException(option, "Junk in parameter list");
        }
        return new Pair<String, List<String>>(base, params);
    }

    private static Map<String, Object> createEntry(Map<String, Object> map, String key) {
        HashMap entry = (HashMap)map.get(key);
        if (entry == null) {
            entry = new HashMap();
            map.put(key, entry);
        }
        return entry;
    }
}

