/*
 * Decompiled with CFR 0.152.
 */
package org.avis.federation.io.messages;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.avis.federation.io.messages.FedConnRply;
import org.avis.io.XdrCoding;
import org.avis.io.messages.RequestMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FedConnRqst
extends RequestMessage<FedConnRply> {
    public static final int ID = 192;
    public int versionMajor;
    public int versionMinor;
    public String serverDomain;

    public FedConnRqst() {
    }

    public FedConnRqst(int versionMajor, int versionMinor, String serverDomain) {
        super(FedConnRqst.nextXid());
        this.versionMajor = versionMajor;
        this.versionMinor = versionMinor;
        this.serverDomain = serverDomain;
    }

    @Override
    public Class<FedConnRply> replyType() {
        return FedConnRply.class;
    }

    @Override
    public int typeId() {
        return 192;
    }

    @Override
    public void encode(ByteBuffer out) throws ProtocolCodecException {
        super.encode(out);
        out.putInt(this.versionMajor);
        out.putInt(this.versionMinor);
        XdrCoding.putString(out, this.serverDomain);
    }

    @Override
    public void decode(ByteBuffer in) throws ProtocolCodecException {
        super.decode(in);
        this.versionMajor = in.getInt();
        this.versionMinor = in.getInt();
        this.serverDomain = XdrCoding.getString(in);
    }
}

