/*
 * Decompiled with CFR 0.152.
 */
package org.avis.io;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class TLS {
    private TLS() {
    }

    public static char[] toPassphrase(String passphrase) {
        return passphrase.length() > 0 ? passphrase.toCharArray() : null;
    }

    public static SSLContext defaultSSLContext() throws IOException {
        return TLS.sslContextFor(null, null, false);
    }

    public static SSLContext sslContextFor(KeyStore keystore, String keystorePassphrase, boolean requireTrustedServer) throws IOException, IllegalArgumentException {
        if (keystore != null && keystorePassphrase == null) {
            throw new IllegalArgumentException("Passphrase must be set when using a keystore");
        }
        try {
            KeyManager[] keyManagers = null;
            if (keystore != null) {
                KeyManagerFactory keyFactory = KeyManagerFactory.getInstance("SunX509");
                keyFactory.init(keystore, TLS.toPassphrase(keystorePassphrase));
                keyManagers = keyFactory.getKeyManagers();
            }
            CustomTrustManager trustManager = new CustomTrustManager(keystore, requireTrustedServer, false);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, new TrustManager[]{trustManager}, null);
            return sslContext;
        }
        catch (Exception ex) {
            throw new IOException("Error initialising TLS: " + ex);
        }
    }

    private static class CustomTrustManager
    implements X509TrustManager {
        private X509TrustManager sunX509TrustManager;
        private boolean requireTrustedServer;
        private boolean requireTrustedClient;

        public CustomTrustManager(KeyStore keystore, boolean requireTrustedServer, boolean requireTrustedClient) throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException {
            this.requireTrustedServer = requireTrustedServer;
            this.requireTrustedClient = requireTrustedClient;
            this.sunX509TrustManager = this.initTrustManager(keystore);
        }

        private X509TrustManager initTrustManager(KeyStore keystore) throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException {
            TrustManagerFactory sunManagerFactories = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
            sunManagerFactories.init(keystore);
            for (TrustManager trustManager : sunManagerFactories.getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                return (X509TrustManager)trustManager;
            }
            throw new NoSuchProviderException("No default X509 trust manager");
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (this.requireTrustedClient) {
                this.sunX509TrustManager.checkClientTrusted(chain, authType);
            }
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (this.requireTrustedServer) {
                this.sunX509TrustManager.checkServerTrusted(chain, authType);
            }
        }

        public X509Certificate[] getAcceptedIssuers() {
            return this.sunX509TrustManager.getAcceptedIssuers();
        }
    }
}

