/*
 * Decompiled with CFR 0.152.
 */
package org.avis.io.messages;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.avis.io.XdrCoding;
import org.avis.io.messages.XidMessage;

public class Nack
extends XidMessage {
    public static final int ID = 48;
    public static final int PROT_INCOMPAT = 1;
    public static final int PROT_ERROR = 1001;
    public static final int NO_SUCH_SUB = 1002;
    public static final int IMPL_LIMIT = 2006;
    public static final int NOT_IMPL = 2007;
    public static final int PARSE_ERROR = 2101;
    public static final int EXP_IS_TRIVIAL = 2110;
    public static final Object[] EMPTY_ARGS = new Object[0];
    public int error;
    public String message;
    public Object[] args;

    public Nack() {
    }

    public Nack(XidMessage inReplyTo, int error, String message) {
        this(inReplyTo, error, message, EMPTY_ARGS);
    }

    public Nack(XidMessage inReplyTo, int error, String message, Object ... args) {
        super(inReplyTo);
        if (message == null) {
            throw new NullPointerException("Message cannot be null");
        }
        this.error = error;
        this.message = message;
        this.args = args;
    }

    public int typeId() {
        return 48;
    }

    public String errorCodeText() {
        return Nack.errorTextFor(this.error);
    }

    public String formattedMessage() {
        if (this.args.length == 0) {
            return this.message;
        }
        StringBuilder str = new StringBuilder(this.message);
        for (int i = 0; i < this.args.length; ++i) {
            Nack.replace(str, i + 1, this.args[i]);
        }
        return str.toString();
    }

    private static void replace(StringBuilder str, int argNumber, Object arg) {
        int index;
        String tag = "%" + argNumber;
        while ((index = str.indexOf(tag)) != -1) {
            str.replace(index, index + tag.length(), arg.toString());
        }
    }

    public static String errorTextFor(int error) {
        switch (error) {
            case 1: {
                return "Incompatible protocol";
            }
            case 1001: {
                return "Communication protocol error";
            }
            case 1002: {
                return "Unknown subscription ID";
            }
            case 2006: {
                return "Exceeded client connection resource limit";
            }
            case 2007: {
                return "Feature not implemented";
            }
            case 2101: {
                return "Subscription parse error";
            }
            case 2110: {
                return "Expression is trivial (constant)";
            }
        }
        return "Error code " + error;
    }

    public void encode(ByteBuffer out) throws ProtocolCodecException {
        super.encode(out);
        out.putInt(this.error);
        XdrCoding.putString(out, this.message);
        XdrCoding.putObjects(out, this.args);
    }

    public void decode(ByteBuffer in) throws ProtocolCodecException {
        super.decode(in);
        this.error = in.getInt();
        this.message = XdrCoding.getString(in);
        this.args = XdrCoding.getObjects(in);
    }
}

